/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.v2.JSON;
import io.tiledb.cloud.rest_api.v2.model.GenericTileOffsets;
import io.tiledb.cloud.rest_api.v2.model.NonEmptyDomainList;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Metadata of a fragment")
public class FragmentMetadata {
    public static final String SERIALIZED_NAME_FILE_SIZES = "fileSizes";
    @SerializedName(value="fileSizes")
    private List<BigDecimal> fileSizes = null;
    public static final String SERIALIZED_NAME_FILE_VAR_SIZES = "fileVarSizes";
    @SerializedName(value="fileVarSizes")
    private List<BigDecimal> fileVarSizes = null;
    public static final String SERIALIZED_NAME_FILE_VALIDITY_SIZES = "fileValiditySizes";
    @SerializedName(value="fileValiditySizes")
    private List<BigDecimal> fileValiditySizes = null;
    public static final String SERIALIZED_NAME_FRAGMENT_URI = "fragmentUri";
    @SerializedName(value="fragmentUri")
    private String fragmentUri;
    public static final String SERIALIZED_NAME_HAS_TIMESTAMPS = "hasTimestamps";
    @SerializedName(value="hasTimestamps")
    private Boolean hasTimestamps;
    public static final String SERIALIZED_NAME_HAS_DELETE_META = "hasDeleteMeta";
    @SerializedName(value="hasDeleteMeta")
    private Boolean hasDeleteMeta;
    public static final String SERIALIZED_NAME_SPARSE_TILE_NUM = "sparseTileNum";
    @SerializedName(value="sparseTileNum")
    private BigDecimal sparseTileNum;
    public static final String SERIALIZED_NAME_TILE_INDEX_BASE = "tileIndexBase";
    @SerializedName(value="tileIndexBase")
    private BigDecimal tileIndexBase;
    public static final String SERIALIZED_NAME_TILE_OFFSETS = "tileOffsets";
    @SerializedName(value="tileOffsets")
    private List<List<BigDecimal>> tileOffsets = null;
    public static final String SERIALIZED_NAME_TILE_VAR_OFFSETS = "tileVarOffsets";
    @SerializedName(value="tileVarOffsets")
    private List<List<BigDecimal>> tileVarOffsets = null;
    public static final String SERIALIZED_NAME_TILE_VAR_SIZES = "tileVarSizes";
    @SerializedName(value="tileVarSizes")
    private List<List<BigDecimal>> tileVarSizes = null;
    public static final String SERIALIZED_NAME_TILE_VALIDITY_OFFSETS = "tileValidityOffsets";
    @SerializedName(value="tileValidityOffsets")
    private List<List<BigDecimal>> tileValidityOffsets = null;
    public static final String SERIALIZED_NAME_TILE_MIN_BUFFER = "tileMinBuffer";
    @SerializedName(value="tileMinBuffer")
    private List<List<BigDecimal>> tileMinBuffer = null;
    public static final String SERIALIZED_NAME_TILE_MIN_VAR_BUFFER = "tileMinVarBuffer";
    @SerializedName(value="tileMinVarBuffer")
    private List<List<BigDecimal>> tileMinVarBuffer = null;
    public static final String SERIALIZED_NAME_TILE_MAX_BUFFER = "tileMaxBuffer";
    @SerializedName(value="tileMaxBuffer")
    private List<List<BigDecimal>> tileMaxBuffer = null;
    public static final String SERIALIZED_NAME_TILE_MAX_VAR_BUFFER = "tileMaxVarBuffer";
    @SerializedName(value="tileMaxVarBuffer")
    private List<List<BigDecimal>> tileMaxVarBuffer = null;
    public static final String SERIALIZED_NAME_TILE_SUMS = "tileSums";
    @SerializedName(value="tileSums")
    private List<List<BigDecimal>> tileSums = null;
    public static final String SERIALIZED_NAME_TILE_NULL_COUNTS = "tileNullCounts";
    @SerializedName(value="tileNullCounts")
    private List<List<BigDecimal>> tileNullCounts = null;
    public static final String SERIALIZED_NAME_FRAGMENT_MINS = "fragmentMins";
    @SerializedName(value="fragmentMins")
    private List<List<BigDecimal>> fragmentMins = null;
    public static final String SERIALIZED_NAME_FRAGMENT_MAXS = "fragmentMaxs";
    @SerializedName(value="fragmentMaxs")
    private List<List<BigDecimal>> fragmentMaxs = null;
    public static final String SERIALIZED_NAME_FRAGMENT_SUMS = "fragmentSums";
    @SerializedName(value="fragmentSums")
    private List<BigDecimal> fragmentSums = null;
    public static final String SERIALIZED_NAME_FRAGMENT_NULL_COUNTS = "fragmentNullCounts";
    @SerializedName(value="fragmentNullCounts")
    private List<BigDecimal> fragmentNullCounts = null;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_TIMESTAMP_RANGE = "timestampRange";
    @SerializedName(value="timestampRange")
    private List<BigDecimal> timestampRange = null;
    public static final String SERIALIZED_NAME_LAST_TILE_CELL_NUM = "lastTileCellNum";
    @SerializedName(value="lastTileCellNum")
    private Integer lastTileCellNum;
    public static final String SERIALIZED_NAME_NON_EMPTY_DOMAIN = "nonEmptyDomain";
    @SerializedName(value="nonEmptyDomain")
    private NonEmptyDomainList nonEmptyDomain;
    public static final String SERIALIZED_NAME_RTREE = "rtree";
    @SerializedName(value="rtree")
    private File rtree;
    public static final String SERIALIZED_NAME_HAS_CONSOLIDATED_FOOTER = "hasConsolidatedFooter";
    @SerializedName(value="hasConsolidatedFooter")
    private Boolean hasConsolidatedFooter;
    public static final String SERIALIZED_NAME_GT_OFFSETS = "gtOffsets";
    @SerializedName(value="gtOffsets")
    private GenericTileOffsets gtOffsets;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FragmentMetadata fileSizes(List<BigDecimal> fileSizes) {
        this.fileSizes = fileSizes;
        return this;
    }

    public FragmentMetadata addFileSizesItem(BigDecimal fileSizesItem) {
        if (this.fileSizes == null) {
            this.fileSizes = new ArrayList<BigDecimal>();
        }
        this.fileSizes.add(fileSizesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The size of each attribute file")
    public List<BigDecimal> getFileSizes() {
        return this.fileSizes;
    }

    public void setFileSizes(List<BigDecimal> fileSizes) {
        this.fileSizes = fileSizes;
    }

    public FragmentMetadata fileVarSizes(List<BigDecimal> fileVarSizes) {
        this.fileVarSizes = fileVarSizes;
        return this;
    }

    public FragmentMetadata addFileVarSizesItem(BigDecimal fileVarSizesItem) {
        if (this.fileVarSizes == null) {
            this.fileVarSizes = new ArrayList<BigDecimal>();
        }
        this.fileVarSizes.add(fileVarSizesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The size of each var attribute file")
    public List<BigDecimal> getFileVarSizes() {
        return this.fileVarSizes;
    }

    public void setFileVarSizes(List<BigDecimal> fileVarSizes) {
        this.fileVarSizes = fileVarSizes;
    }

    public FragmentMetadata fileValiditySizes(List<BigDecimal> fileValiditySizes) {
        this.fileValiditySizes = fileValiditySizes;
        return this;
    }

    public FragmentMetadata addFileValiditySizesItem(BigDecimal fileValiditySizesItem) {
        if (this.fileValiditySizes == null) {
            this.fileValiditySizes = new ArrayList<BigDecimal>();
        }
        this.fileValiditySizes.add(fileValiditySizesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The size of each validity attribute file")
    public List<BigDecimal> getFileValiditySizes() {
        return this.fileValiditySizes;
    }

    public void setFileValiditySizes(List<BigDecimal> fileValiditySizes) {
        this.fileValiditySizes = fileValiditySizes;
    }

    public FragmentMetadata fragmentUri(String fragmentUri) {
        this.fragmentUri = fragmentUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The uri of the fragment this metadata belongs to")
    public String getFragmentUri() {
        return this.fragmentUri;
    }

    public void setFragmentUri(String fragmentUri) {
        this.fragmentUri = fragmentUri;
    }

    public FragmentMetadata hasTimestamps(Boolean hasTimestamps) {
        this.hasTimestamps = hasTimestamps;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the fragment has timestamps")
    public Boolean getHasTimestamps() {
        return this.hasTimestamps;
    }

    public void setHasTimestamps(Boolean hasTimestamps) {
        this.hasTimestamps = hasTimestamps;
    }

    public FragmentMetadata hasDeleteMeta(Boolean hasDeleteMeta) {
        this.hasDeleteMeta = hasDeleteMeta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the fragment has delete metadata")
    public Boolean getHasDeleteMeta() {
        return this.hasDeleteMeta;
    }

    public void setHasDeleteMeta(Boolean hasDeleteMeta) {
        this.hasDeleteMeta = hasDeleteMeta;
    }

    public FragmentMetadata sparseTileNum(BigDecimal sparseTileNum) {
        this.sparseTileNum = sparseTileNum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of sparse tiles")
    public BigDecimal getSparseTileNum() {
        return this.sparseTileNum;
    }

    public void setSparseTileNum(BigDecimal sparseTileNum) {
        this.sparseTileNum = sparseTileNum;
    }

    public FragmentMetadata tileIndexBase(BigDecimal tileIndexBase) {
        this.tileIndexBase = tileIndexBase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used to track the tile index base between global order writes")
    public BigDecimal getTileIndexBase() {
        return this.tileIndexBase;
    }

    public void setTileIndexBase(BigDecimal tileIndexBase) {
        this.tileIndexBase = tileIndexBase;
    }

    public FragmentMetadata tileOffsets(List<List<BigDecimal>> tileOffsets) {
        this.tileOffsets = tileOffsets;
        return this;
    }

    public FragmentMetadata addTileOffsetsItem(List<BigDecimal> tileOffsetsItem) {
        if (this.tileOffsets == null) {
            this.tileOffsets = new ArrayList<List<BigDecimal>>();
        }
        this.tileOffsets.add(tileOffsetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tile offsets in their attribute files")
    public List<List<BigDecimal>> getTileOffsets() {
        return this.tileOffsets;
    }

    public void setTileOffsets(List<List<BigDecimal>> tileOffsets) {
        this.tileOffsets = tileOffsets;
    }

    public FragmentMetadata tileVarOffsets(List<List<BigDecimal>> tileVarOffsets) {
        this.tileVarOffsets = tileVarOffsets;
        return this;
    }

    public FragmentMetadata addTileVarOffsetsItem(List<BigDecimal> tileVarOffsetsItem) {
        if (this.tileVarOffsets == null) {
            this.tileVarOffsets = new ArrayList<List<BigDecimal>>();
        }
        this.tileVarOffsets.add(tileVarOffsetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Variable tile offsets in their attribute files")
    public List<List<BigDecimal>> getTileVarOffsets() {
        return this.tileVarOffsets;
    }

    public void setTileVarOffsets(List<List<BigDecimal>> tileVarOffsets) {
        this.tileVarOffsets = tileVarOffsets;
    }

    public FragmentMetadata tileVarSizes(List<List<BigDecimal>> tileVarSizes) {
        this.tileVarSizes = tileVarSizes;
        return this;
    }

    public FragmentMetadata addTileVarSizesItem(List<BigDecimal> tileVarSizesItem) {
        if (this.tileVarSizes == null) {
            this.tileVarSizes = new ArrayList<List<BigDecimal>>();
        }
        this.tileVarSizes.add(tileVarSizesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The sizes of the uncompressed variable tiles")
    public List<List<BigDecimal>> getTileVarSizes() {
        return this.tileVarSizes;
    }

    public void setTileVarSizes(List<List<BigDecimal>> tileVarSizes) {
        this.tileVarSizes = tileVarSizes;
    }

    public FragmentMetadata tileValidityOffsets(List<List<BigDecimal>> tileValidityOffsets) {
        this.tileValidityOffsets = tileValidityOffsets;
        return this;
    }

    public FragmentMetadata addTileValidityOffsetsItem(List<BigDecimal> tileValidityOffsetsItem) {
        if (this.tileValidityOffsets == null) {
            this.tileValidityOffsets = new ArrayList<List<BigDecimal>>();
        }
        this.tileValidityOffsets.add(tileValidityOffsetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Validity tile offests in their attribute files")
    public List<List<BigDecimal>> getTileValidityOffsets() {
        return this.tileValidityOffsets;
    }

    public void setTileValidityOffsets(List<List<BigDecimal>> tileValidityOffsets) {
        this.tileValidityOffsets = tileValidityOffsets;
    }

    public FragmentMetadata tileMinBuffer(List<List<BigDecimal>> tileMinBuffer) {
        this.tileMinBuffer = tileMinBuffer;
        return this;
    }

    public FragmentMetadata addTileMinBufferItem(List<BigDecimal> tileMinBufferItem) {
        if (this.tileMinBuffer == null) {
            this.tileMinBuffer = new ArrayList<List<BigDecimal>>();
        }
        this.tileMinBuffer.add(tileMinBufferItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="tile min buffers")
    public List<List<BigDecimal>> getTileMinBuffer() {
        return this.tileMinBuffer;
    }

    public void setTileMinBuffer(List<List<BigDecimal>> tileMinBuffer) {
        this.tileMinBuffer = tileMinBuffer;
    }

    public FragmentMetadata tileMinVarBuffer(List<List<BigDecimal>> tileMinVarBuffer) {
        this.tileMinVarBuffer = tileMinVarBuffer;
        return this;
    }

    public FragmentMetadata addTileMinVarBufferItem(List<BigDecimal> tileMinVarBufferItem) {
        if (this.tileMinVarBuffer == null) {
            this.tileMinVarBuffer = new ArrayList<List<BigDecimal>>();
        }
        this.tileMinVarBuffer.add(tileMinVarBufferItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="tile min buffers for var length data")
    public List<List<BigDecimal>> getTileMinVarBuffer() {
        return this.tileMinVarBuffer;
    }

    public void setTileMinVarBuffer(List<List<BigDecimal>> tileMinVarBuffer) {
        this.tileMinVarBuffer = tileMinVarBuffer;
    }

    public FragmentMetadata tileMaxBuffer(List<List<BigDecimal>> tileMaxBuffer) {
        this.tileMaxBuffer = tileMaxBuffer;
        return this;
    }

    public FragmentMetadata addTileMaxBufferItem(List<BigDecimal> tileMaxBufferItem) {
        if (this.tileMaxBuffer == null) {
            this.tileMaxBuffer = new ArrayList<List<BigDecimal>>();
        }
        this.tileMaxBuffer.add(tileMaxBufferItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="tile max buffers")
    public List<List<BigDecimal>> getTileMaxBuffer() {
        return this.tileMaxBuffer;
    }

    public void setTileMaxBuffer(List<List<BigDecimal>> tileMaxBuffer) {
        this.tileMaxBuffer = tileMaxBuffer;
    }

    public FragmentMetadata tileMaxVarBuffer(List<List<BigDecimal>> tileMaxVarBuffer) {
        this.tileMaxVarBuffer = tileMaxVarBuffer;
        return this;
    }

    public FragmentMetadata addTileMaxVarBufferItem(List<BigDecimal> tileMaxVarBufferItem) {
        if (this.tileMaxVarBuffer == null) {
            this.tileMaxVarBuffer = new ArrayList<List<BigDecimal>>();
        }
        this.tileMaxVarBuffer.add(tileMaxVarBufferItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="tile max buffers for var length data")
    public List<List<BigDecimal>> getTileMaxVarBuffer() {
        return this.tileMaxVarBuffer;
    }

    public void setTileMaxVarBuffer(List<List<BigDecimal>> tileMaxVarBuffer) {
        this.tileMaxVarBuffer = tileMaxVarBuffer;
    }

    public FragmentMetadata tileSums(List<List<BigDecimal>> tileSums) {
        this.tileSums = tileSums;
        return this;
    }

    public FragmentMetadata addTileSumsItem(List<BigDecimal> tileSumsItem) {
        if (this.tileSums == null) {
            this.tileSums = new ArrayList<List<BigDecimal>>();
        }
        this.tileSums.add(tileSumsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="tile sum values")
    public List<List<BigDecimal>> getTileSums() {
        return this.tileSums;
    }

    public void setTileSums(List<List<BigDecimal>> tileSums) {
        this.tileSums = tileSums;
    }

    public FragmentMetadata tileNullCounts(List<List<BigDecimal>> tileNullCounts) {
        this.tileNullCounts = tileNullCounts;
        return this;
    }

    public FragmentMetadata addTileNullCountsItem(List<BigDecimal> tileNullCountsItem) {
        if (this.tileNullCounts == null) {
            this.tileNullCounts = new ArrayList<List<BigDecimal>>();
        }
        this.tileNullCounts.add(tileNullCountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="tile null count values")
    public List<List<BigDecimal>> getTileNullCounts() {
        return this.tileNullCounts;
    }

    public void setTileNullCounts(List<List<BigDecimal>> tileNullCounts) {
        this.tileNullCounts = tileNullCounts;
    }

    public FragmentMetadata fragmentMins(List<List<BigDecimal>> fragmentMins) {
        this.fragmentMins = fragmentMins;
        return this;
    }

    public FragmentMetadata addFragmentMinsItem(List<BigDecimal> fragmentMinsItem) {
        if (this.fragmentMins == null) {
            this.fragmentMins = new ArrayList<List<BigDecimal>>();
        }
        this.fragmentMins.add(fragmentMinsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fragment min values")
    public List<List<BigDecimal>> getFragmentMins() {
        return this.fragmentMins;
    }

    public void setFragmentMins(List<List<BigDecimal>> fragmentMins) {
        this.fragmentMins = fragmentMins;
    }

    public FragmentMetadata fragmentMaxs(List<List<BigDecimal>> fragmentMaxs) {
        this.fragmentMaxs = fragmentMaxs;
        return this;
    }

    public FragmentMetadata addFragmentMaxsItem(List<BigDecimal> fragmentMaxsItem) {
        if (this.fragmentMaxs == null) {
            this.fragmentMaxs = new ArrayList<List<BigDecimal>>();
        }
        this.fragmentMaxs.add(fragmentMaxsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fragment max values")
    public List<List<BigDecimal>> getFragmentMaxs() {
        return this.fragmentMaxs;
    }

    public void setFragmentMaxs(List<List<BigDecimal>> fragmentMaxs) {
        this.fragmentMaxs = fragmentMaxs;
    }

    public FragmentMetadata fragmentSums(List<BigDecimal> fragmentSums) {
        this.fragmentSums = fragmentSums;
        return this;
    }

    public FragmentMetadata addFragmentSumsItem(BigDecimal fragmentSumsItem) {
        if (this.fragmentSums == null) {
            this.fragmentSums = new ArrayList<BigDecimal>();
        }
        this.fragmentSums.add(fragmentSumsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fragment sum values")
    public List<BigDecimal> getFragmentSums() {
        return this.fragmentSums;
    }

    public void setFragmentSums(List<BigDecimal> fragmentSums) {
        this.fragmentSums = fragmentSums;
    }

    public FragmentMetadata fragmentNullCounts(List<BigDecimal> fragmentNullCounts) {
        this.fragmentNullCounts = fragmentNullCounts;
        return this;
    }

    public FragmentMetadata addFragmentNullCountsItem(BigDecimal fragmentNullCountsItem) {
        if (this.fragmentNullCounts == null) {
            this.fragmentNullCounts = new ArrayList<BigDecimal>();
        }
        this.fragmentNullCounts.add(fragmentNullCountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fragment null count values")
    public List<BigDecimal> getFragmentNullCounts() {
        return this.fragmentNullCounts;
    }

    public void setFragmentNullCounts(List<BigDecimal> fragmentNullCounts) {
        this.fragmentNullCounts = fragmentNullCounts;
    }

    public FragmentMetadata version(Integer version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the format version of this metadata")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public FragmentMetadata timestampRange(List<BigDecimal> timestampRange) {
        this.timestampRange = timestampRange;
        return this;
    }

    public FragmentMetadata addTimestampRangeItem(BigDecimal timestampRangeItem) {
        if (this.timestampRange == null) {
            this.timestampRange = new ArrayList<BigDecimal>();
        }
        this.timestampRange.add(timestampRangeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A pair of timestamps for fragment")
    public List<BigDecimal> getTimestampRange() {
        return this.timestampRange;
    }

    public void setTimestampRange(List<BigDecimal> timestampRange) {
        this.timestampRange = timestampRange;
    }

    public FragmentMetadata lastTileCellNum(Integer lastTileCellNum) {
        this.lastTileCellNum = lastTileCellNum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of cells in the last tile")
    public Integer getLastTileCellNum() {
        return this.lastTileCellNum;
    }

    public void setLastTileCellNum(Integer lastTileCellNum) {
        this.lastTileCellNum = lastTileCellNum;
    }

    public FragmentMetadata nonEmptyDomain(NonEmptyDomainList nonEmptyDomain) {
        this.nonEmptyDomain = nonEmptyDomain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public NonEmptyDomainList getNonEmptyDomain() {
        return this.nonEmptyDomain;
    }

    public void setNonEmptyDomain(NonEmptyDomainList nonEmptyDomain) {
        this.nonEmptyDomain = nonEmptyDomain;
    }

    public FragmentMetadata rtree(File rtree) {
        this.rtree = rtree;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The RTree for the MBRs serialized as a blob")
    public File getRtree() {
        return this.rtree;
    }

    public void setRtree(File rtree) {
        this.rtree = rtree;
    }

    public FragmentMetadata hasConsolidatedFooter(Boolean hasConsolidatedFooter) {
        this.hasConsolidatedFooter = hasConsolidatedFooter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="if the fragment metadata footer appears in a consolidated file")
    public Boolean getHasConsolidatedFooter() {
        return this.hasConsolidatedFooter;
    }

    public void setHasConsolidatedFooter(Boolean hasConsolidatedFooter) {
        this.hasConsolidatedFooter = hasConsolidatedFooter;
    }

    public FragmentMetadata gtOffsets(GenericTileOffsets gtOffsets) {
        this.gtOffsets = gtOffsets;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public GenericTileOffsets getGtOffsets() {
        return this.gtOffsets;
    }

    public void setGtOffsets(GenericTileOffsets gtOffsets) {
        this.gtOffsets = gtOffsets;
    }

    public FragmentMetadata putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentMetadata fragmentMetadata = (FragmentMetadata)o;
        return Objects.equals(this.fileSizes, fragmentMetadata.fileSizes) && Objects.equals(this.fileVarSizes, fragmentMetadata.fileVarSizes) && Objects.equals(this.fileValiditySizes, fragmentMetadata.fileValiditySizes) && Objects.equals(this.fragmentUri, fragmentMetadata.fragmentUri) && Objects.equals(this.hasTimestamps, fragmentMetadata.hasTimestamps) && Objects.equals(this.hasDeleteMeta, fragmentMetadata.hasDeleteMeta) && Objects.equals(this.sparseTileNum, fragmentMetadata.sparseTileNum) && Objects.equals(this.tileIndexBase, fragmentMetadata.tileIndexBase) && Objects.equals(this.tileOffsets, fragmentMetadata.tileOffsets) && Objects.equals(this.tileVarOffsets, fragmentMetadata.tileVarOffsets) && Objects.equals(this.tileVarSizes, fragmentMetadata.tileVarSizes) && Objects.equals(this.tileValidityOffsets, fragmentMetadata.tileValidityOffsets) && Objects.equals(this.tileMinBuffer, fragmentMetadata.tileMinBuffer) && Objects.equals(this.tileMinVarBuffer, fragmentMetadata.tileMinVarBuffer) && Objects.equals(this.tileMaxBuffer, fragmentMetadata.tileMaxBuffer) && Objects.equals(this.tileMaxVarBuffer, fragmentMetadata.tileMaxVarBuffer) && Objects.equals(this.tileSums, fragmentMetadata.tileSums) && Objects.equals(this.tileNullCounts, fragmentMetadata.tileNullCounts) && Objects.equals(this.fragmentMins, fragmentMetadata.fragmentMins) && Objects.equals(this.fragmentMaxs, fragmentMetadata.fragmentMaxs) && Objects.equals(this.fragmentSums, fragmentMetadata.fragmentSums) && Objects.equals(this.fragmentNullCounts, fragmentMetadata.fragmentNullCounts) && Objects.equals(this.version, fragmentMetadata.version) && Objects.equals(this.timestampRange, fragmentMetadata.timestampRange) && Objects.equals(this.lastTileCellNum, fragmentMetadata.lastTileCellNum) && Objects.equals(this.nonEmptyDomain, fragmentMetadata.nonEmptyDomain) && Objects.equals(this.rtree, fragmentMetadata.rtree) && Objects.equals(this.hasConsolidatedFooter, fragmentMetadata.hasConsolidatedFooter) && Objects.equals(this.gtOffsets, fragmentMetadata.gtOffsets) && Objects.equals(this.additionalProperties, fragmentMetadata.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.fileSizes, this.fileVarSizes, this.fileValiditySizes, this.fragmentUri, this.hasTimestamps, this.hasDeleteMeta, this.sparseTileNum, this.tileIndexBase, this.tileOffsets, this.tileVarOffsets, this.tileVarSizes, this.tileValidityOffsets, this.tileMinBuffer, this.tileMinVarBuffer, this.tileMaxBuffer, this.tileMaxVarBuffer, this.tileSums, this.tileNullCounts, this.fragmentMins, this.fragmentMaxs, this.fragmentSums, this.fragmentNullCounts, this.version, this.timestampRange, this.lastTileCellNum, this.nonEmptyDomain, this.rtree, this.hasConsolidatedFooter, this.gtOffsets, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FragmentMetadata {\n");
        sb.append("    fileSizes: ").append(this.toIndentedString(this.fileSizes)).append("\n");
        sb.append("    fileVarSizes: ").append(this.toIndentedString(this.fileVarSizes)).append("\n");
        sb.append("    fileValiditySizes: ").append(this.toIndentedString(this.fileValiditySizes)).append("\n");
        sb.append("    fragmentUri: ").append(this.toIndentedString(this.fragmentUri)).append("\n");
        sb.append("    hasTimestamps: ").append(this.toIndentedString(this.hasTimestamps)).append("\n");
        sb.append("    hasDeleteMeta: ").append(this.toIndentedString(this.hasDeleteMeta)).append("\n");
        sb.append("    sparseTileNum: ").append(this.toIndentedString(this.sparseTileNum)).append("\n");
        sb.append("    tileIndexBase: ").append(this.toIndentedString(this.tileIndexBase)).append("\n");
        sb.append("    tileOffsets: ").append(this.toIndentedString(this.tileOffsets)).append("\n");
        sb.append("    tileVarOffsets: ").append(this.toIndentedString(this.tileVarOffsets)).append("\n");
        sb.append("    tileVarSizes: ").append(this.toIndentedString(this.tileVarSizes)).append("\n");
        sb.append("    tileValidityOffsets: ").append(this.toIndentedString(this.tileValidityOffsets)).append("\n");
        sb.append("    tileMinBuffer: ").append(this.toIndentedString(this.tileMinBuffer)).append("\n");
        sb.append("    tileMinVarBuffer: ").append(this.toIndentedString(this.tileMinVarBuffer)).append("\n");
        sb.append("    tileMaxBuffer: ").append(this.toIndentedString(this.tileMaxBuffer)).append("\n");
        sb.append("    tileMaxVarBuffer: ").append(this.toIndentedString(this.tileMaxVarBuffer)).append("\n");
        sb.append("    tileSums: ").append(this.toIndentedString(this.tileSums)).append("\n");
        sb.append("    tileNullCounts: ").append(this.toIndentedString(this.tileNullCounts)).append("\n");
        sb.append("    fragmentMins: ").append(this.toIndentedString(this.fragmentMins)).append("\n");
        sb.append("    fragmentMaxs: ").append(this.toIndentedString(this.fragmentMaxs)).append("\n");
        sb.append("    fragmentSums: ").append(this.toIndentedString(this.fragmentSums)).append("\n");
        sb.append("    fragmentNullCounts: ").append(this.toIndentedString(this.fragmentNullCounts)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    timestampRange: ").append(this.toIndentedString(this.timestampRange)).append("\n");
        sb.append("    lastTileCellNum: ").append(this.toIndentedString(this.lastTileCellNum)).append("\n");
        sb.append("    nonEmptyDomain: ").append(this.toIndentedString(this.nonEmptyDomain)).append("\n");
        sb.append("    rtree: ").append(this.toIndentedString(this.rtree)).append("\n");
        sb.append("    hasConsolidatedFooter: ").append(this.toIndentedString(this.hasConsolidatedFooter)).append("\n");
        sb.append("    gtOffsets: ").append(this.toIndentedString(this.gtOffsets)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FragmentMetadata is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FILE_SIZES) != null && !jsonObj.get(SERIALIZED_NAME_FILE_SIZES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `fileSizes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FILE_SIZES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FILE_VAR_SIZES) != null && !jsonObj.get(SERIALIZED_NAME_FILE_VAR_SIZES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `fileVarSizes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FILE_VAR_SIZES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FILE_VALIDITY_SIZES) != null && !jsonObj.get(SERIALIZED_NAME_FILE_VALIDITY_SIZES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `fileValiditySizes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FILE_VALIDITY_SIZES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FRAGMENT_URI) != null && !jsonObj.get(SERIALIZED_NAME_FRAGMENT_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fragmentUri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FRAGMENT_URI).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_OFFSETS) != null && !jsonObj.get(SERIALIZED_NAME_TILE_OFFSETS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileOffsets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_OFFSETS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_VAR_OFFSETS) != null && !jsonObj.get(SERIALIZED_NAME_TILE_VAR_OFFSETS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileVarOffsets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_VAR_OFFSETS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_VAR_SIZES) != null && !jsonObj.get(SERIALIZED_NAME_TILE_VAR_SIZES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileVarSizes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_VAR_SIZES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_VALIDITY_OFFSETS) != null && !jsonObj.get(SERIALIZED_NAME_TILE_VALIDITY_OFFSETS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileValidityOffsets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_VALIDITY_OFFSETS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_MIN_BUFFER) != null && !jsonObj.get(SERIALIZED_NAME_TILE_MIN_BUFFER).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileMinBuffer` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_MIN_BUFFER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_MIN_VAR_BUFFER) != null && !jsonObj.get(SERIALIZED_NAME_TILE_MIN_VAR_BUFFER).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileMinVarBuffer` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_MIN_VAR_BUFFER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_MAX_BUFFER) != null && !jsonObj.get(SERIALIZED_NAME_TILE_MAX_BUFFER).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileMaxBuffer` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_MAX_BUFFER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_MAX_VAR_BUFFER) != null && !jsonObj.get(SERIALIZED_NAME_TILE_MAX_VAR_BUFFER).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileMaxVarBuffer` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_MAX_VAR_BUFFER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_SUMS) != null && !jsonObj.get(SERIALIZED_NAME_TILE_SUMS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileSums` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_SUMS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_NULL_COUNTS) != null && !jsonObj.get(SERIALIZED_NAME_TILE_NULL_COUNTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileNullCounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_NULL_COUNTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FRAGMENT_MINS) != null && !jsonObj.get(SERIALIZED_NAME_FRAGMENT_MINS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `fragmentMins` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FRAGMENT_MINS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FRAGMENT_MAXS) != null && !jsonObj.get(SERIALIZED_NAME_FRAGMENT_MAXS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `fragmentMaxs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FRAGMENT_MAXS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FRAGMENT_SUMS) != null && !jsonObj.get(SERIALIZED_NAME_FRAGMENT_SUMS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `fragmentSums` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FRAGMENT_SUMS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FRAGMENT_NULL_COUNTS) != null && !jsonObj.get(SERIALIZED_NAME_FRAGMENT_NULL_COUNTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `fragmentNullCounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FRAGMENT_NULL_COUNTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TIMESTAMP_RANGE) != null && !jsonObj.get(SERIALIZED_NAME_TIMESTAMP_RANGE).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `timestampRange` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIMESTAMP_RANGE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_NON_EMPTY_DOMAIN) != null) {
            NonEmptyDomainList.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NON_EMPTY_DOMAIN));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_GT_OFFSETS) != null) {
            GenericTileOffsets.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_GT_OFFSETS));
        }
    }

    public static FragmentMetadata fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, FragmentMetadata.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FILE_SIZES);
        openapiFields.add(SERIALIZED_NAME_FILE_VAR_SIZES);
        openapiFields.add(SERIALIZED_NAME_FILE_VALIDITY_SIZES);
        openapiFields.add(SERIALIZED_NAME_FRAGMENT_URI);
        openapiFields.add(SERIALIZED_NAME_HAS_TIMESTAMPS);
        openapiFields.add(SERIALIZED_NAME_HAS_DELETE_META);
        openapiFields.add(SERIALIZED_NAME_SPARSE_TILE_NUM);
        openapiFields.add(SERIALIZED_NAME_TILE_INDEX_BASE);
        openapiFields.add(SERIALIZED_NAME_TILE_OFFSETS);
        openapiFields.add(SERIALIZED_NAME_TILE_VAR_OFFSETS);
        openapiFields.add(SERIALIZED_NAME_TILE_VAR_SIZES);
        openapiFields.add(SERIALIZED_NAME_TILE_VALIDITY_OFFSETS);
        openapiFields.add(SERIALIZED_NAME_TILE_MIN_BUFFER);
        openapiFields.add(SERIALIZED_NAME_TILE_MIN_VAR_BUFFER);
        openapiFields.add(SERIALIZED_NAME_TILE_MAX_BUFFER);
        openapiFields.add(SERIALIZED_NAME_TILE_MAX_VAR_BUFFER);
        openapiFields.add(SERIALIZED_NAME_TILE_SUMS);
        openapiFields.add(SERIALIZED_NAME_TILE_NULL_COUNTS);
        openapiFields.add(SERIALIZED_NAME_FRAGMENT_MINS);
        openapiFields.add(SERIALIZED_NAME_FRAGMENT_MAXS);
        openapiFields.add(SERIALIZED_NAME_FRAGMENT_SUMS);
        openapiFields.add(SERIALIZED_NAME_FRAGMENT_NULL_COUNTS);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_TIMESTAMP_RANGE);
        openapiFields.add(SERIALIZED_NAME_LAST_TILE_CELL_NUM);
        openapiFields.add(SERIALIZED_NAME_NON_EMPTY_DOMAIN);
        openapiFields.add(SERIALIZED_NAME_RTREE);
        openapiFields.add(SERIALIZED_NAME_HAS_CONSOLIDATED_FOOTER);
        openapiFields.add(SERIALIZED_NAME_GT_OFFSETS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FragmentMetadata.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<FragmentMetadata> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(FragmentMetadata.class));
            return new TypeAdapter<FragmentMetadata>(){

                @Override
                public void write(JsonWriter out, FragmentMetadata value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public FragmentMetadata read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FragmentMetadata.validateJsonObject(jsonObj);
                    FragmentMetadata instance = (FragmentMetadata)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

