/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.v2.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Credential information to access Google Cloud. using well knows key/secret pair to access storage.")
public class GCPInteroperabilityCredential {
    public static final String SERIALIZED_NAME_ACCESS_KEY_ID = "access_key_id";
    @SerializedName(value="access_key_id")
    private String accessKeyId;
    public static final String SERIALIZED_NAME_SECRET_ACCESS_KEY = "secret_access_key";
    @SerializedName(value="secret_access_key")
    private String secretAccessKey;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public GCPInteroperabilityCredential accessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the access key")
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public GCPInteroperabilityCredential secretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The access key's secret. Never returned in responses.")
    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public void setSecretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
    }

    public GCPInteroperabilityCredential putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GCPInteroperabilityCredential gcPInteroperabilityCredential = (GCPInteroperabilityCredential)o;
        return Objects.equals(this.accessKeyId, gcPInteroperabilityCredential.accessKeyId) && Objects.equals(this.secretAccessKey, gcPInteroperabilityCredential.secretAccessKey) && Objects.equals(this.additionalProperties, gcPInteroperabilityCredential.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.accessKeyId, this.secretAccessKey, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GCPInteroperabilityCredential {\n");
        sb.append("    accessKeyId: ").append(this.toIndentedString(this.accessKeyId)).append("\n");
        sb.append("    secretAccessKey: ").append(this.toIndentedString(this.secretAccessKey)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in GCPInteroperabilityCredential is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS_KEY_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS_KEY_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `access_key_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESS_KEY_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECRET_ACCESS_KEY) != null && !jsonObj.get(SERIALIZED_NAME_SECRET_ACCESS_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `secret_access_key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECRET_ACCESS_KEY).toString()));
        }
    }

    public static GCPInteroperabilityCredential fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, GCPInteroperabilityCredential.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCESS_KEY_ID);
        openapiFields.add(SERIALIZED_NAME_SECRET_ACCESS_KEY);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!GCPInteroperabilityCredential.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<GCPInteroperabilityCredential> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(GCPInteroperabilityCredential.class));
            return new TypeAdapter<GCPInteroperabilityCredential>(){

                @Override
                public void write(JsonWriter out, GCPInteroperabilityCredential value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public GCPInteroperabilityCredential read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    GCPInteroperabilityCredential.validateJsonObject(jsonObj);
                    GCPInteroperabilityCredential instance = (GCPInteroperabilityCredential)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

