/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.v2.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The key to a Google Cloud Platform service account.")
public class GCPServiceAccountKey {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_KEY_ID = "key_id";
    @SerializedName(value="key_id")
    private String keyId;
    public static final String SERIALIZED_NAME_KEY_TEXT = "key_text";
    @SerializedName(value="key_text")
    private String keyText;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public GCPServiceAccountKey accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="identity-data-reader@cinco-research.iam.gserviceaccount.com", value="The ID of the service account (i.e., its email address).  This is ignored when uploading key information, and is only provided by the server when downloading metadata about an existing key. ")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public GCPServiceAccountKey keyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="b85b7bac16fabf44fd9cd6885d4d1b444f07e9ab", value="The ID of the particular key. This identifies it among other keys issued for this service account.  This is ignored when uploading key information, and is only provided by the server when downloading metadata about an existing key. ")
    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public GCPServiceAccountKey keyText(String keyText) {
        this.keyText = keyText;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{   \"type\": \"service_account\",   \"project_id\": \"cinco-research\",   \"private_key_id\": \"b85b7bac16fabf44fd9cd6885d4d1b444f07e9ab\",   \"private_key\": \"-----BEGIN PRIVATE KEY-----\\n[lots of data goes here]\\n-----END PRIVATE KEY-----\\n\",   \"client_email\": \"identity-data-reader@cinco-research.iam.gserviceaccount.com\",   \"client_id\": \"105800434159734259879\",   \"auth_uri\": \"https://accounts.google.com/o/oauth2/auth\",   \"token_uri\": \"https://oauth2.googleapis.com/token\",   \"auth_provider_x509_cert_url\": \"https://www.googleapis.com/oauth2/v1/certs\",   \"client_x509_cert_url\": \"https://www.googleapis.com/robot/v1/metadata/x509/identity-data-reader%40cinco-research.iam.gserviceaccount.com\",   \"universe_domain\": \"googleapis.com\" } ", value="The full file provided by Google Cloud. This is usually in the form of a JSON document, but TileDB Cloud treats it as opaque (except to attempt to extract the service account ID and the key ID). ")
    public String getKeyText() {
        return this.keyText;
    }

    public void setKeyText(String keyText) {
        this.keyText = keyText;
    }

    public GCPServiceAccountKey putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GCPServiceAccountKey gcPServiceAccountKey = (GCPServiceAccountKey)o;
        return Objects.equals(this.accountId, gcPServiceAccountKey.accountId) && Objects.equals(this.keyId, gcPServiceAccountKey.keyId) && Objects.equals(this.keyText, gcPServiceAccountKey.keyText) && Objects.equals(this.additionalProperties, gcPServiceAccountKey.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.keyId, this.keyText, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GCPServiceAccountKey {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    keyId: ").append(this.toIndentedString(this.keyId)).append("\n");
        sb.append("    keyText: ").append(this.toIndentedString(this.keyText)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in GCPServiceAccountKey is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY_ID) != null && !jsonObj.get(SERIALIZED_NAME_KEY_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY_TEXT) != null && !jsonObj.get(SERIALIZED_NAME_KEY_TEXT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key_text` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY_TEXT).toString()));
        }
    }

    public static GCPServiceAccountKey fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, GCPServiceAccountKey.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_KEY_ID);
        openapiFields.add(SERIALIZED_NAME_KEY_TEXT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!GCPServiceAccountKey.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<GCPServiceAccountKey> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(GCPServiceAccountKey.class));
            return new TypeAdapter<GCPServiceAccountKey>(){

                @Override
                public void write(JsonWriter out, GCPServiceAccountKey value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public GCPServiceAccountKey read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    GCPServiceAccountKey.validateJsonObject(jsonObj);
                    GCPServiceAccountKey instance = (GCPServiceAccountKey)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

