/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.v2.JSON;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Array directory (for reads)")
public class GenericTileOffsets {
    public static final String SERIALIZED_NAME_RTREE = "rtree";
    @SerializedName(value="rtree")
    private BigDecimal rtree;
    public static final String SERIALIZED_NAME_TILE_OFFSETS = "tileOffsets";
    @SerializedName(value="tileOffsets")
    private List<BigDecimal> tileOffsets = null;
    public static final String SERIALIZED_NAME_TILE_VAR_OFFSETS = "tileVarOffsets";
    @SerializedName(value="tileVarOffsets")
    private List<BigDecimal> tileVarOffsets = null;
    public static final String SERIALIZED_NAME_TILE_VAR_SIZES = "tileVarSizes";
    @SerializedName(value="tileVarSizes")
    private List<BigDecimal> tileVarSizes = null;
    public static final String SERIALIZED_NAME_TILE_VALIDITY_OFFSETS = "tileValidityOffsets";
    @SerializedName(value="tileValidityOffsets")
    private List<BigDecimal> tileValidityOffsets = null;
    public static final String SERIALIZED_NAME_TILE_MIN_OFFSETS = "tileMinOffsets";
    @SerializedName(value="tileMinOffsets")
    private List<BigDecimal> tileMinOffsets = null;
    public static final String SERIALIZED_NAME_TILE_MAX_OFFSETS = "tileMaxOffsets";
    @SerializedName(value="tileMaxOffsets")
    private List<BigDecimal> tileMaxOffsets = null;
    public static final String SERIALIZED_NAME_TILE_SUM_OFFSETS = "tileSumOffsets";
    @SerializedName(value="tileSumOffsets")
    private List<BigDecimal> tileSumOffsets = null;
    public static final String SERIALIZED_NAME_TILE_NULL_COUNT_OFFSETS = "tileNullCountOffsets";
    @SerializedName(value="tileNullCountOffsets")
    private List<BigDecimal> tileNullCountOffsets = null;
    public static final String SERIALIZED_NAME_FRAGMENT_MIN_MAX_SUM_NULL_COUNT_OFFSET = "fragmentMinMaxSumNullCountOffset";
    @SerializedName(value="fragmentMinMaxSumNullCountOffset")
    private BigDecimal fragmentMinMaxSumNullCountOffset;
    public static final String SERIALIZED_NAME_PROCESSED_CONDITIONS_OFFSETS = "processedConditionsOffsets";
    @SerializedName(value="processedConditionsOffsets")
    private BigDecimal processedConditionsOffsets;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public GenericTileOffsets rtree(BigDecimal rtree) {
        this.rtree = rtree;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RTree serialized as a blob")
    public BigDecimal getRtree() {
        return this.rtree;
    }

    public void setRtree(BigDecimal rtree) {
        this.rtree = rtree;
    }

    public GenericTileOffsets tileOffsets(List<BigDecimal> tileOffsets) {
        this.tileOffsets = tileOffsets;
        return this;
    }

    public GenericTileOffsets addTileOffsetsItem(BigDecimal tileOffsetsItem) {
        if (this.tileOffsets == null) {
            this.tileOffsets = new ArrayList<BigDecimal>();
        }
        this.tileOffsets.add(tileOffsetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="tile offsets")
    public List<BigDecimal> getTileOffsets() {
        return this.tileOffsets;
    }

    public void setTileOffsets(List<BigDecimal> tileOffsets) {
        this.tileOffsets = tileOffsets;
    }

    public GenericTileOffsets tileVarOffsets(List<BigDecimal> tileVarOffsets) {
        this.tileVarOffsets = tileVarOffsets;
        return this;
    }

    public GenericTileOffsets addTileVarOffsetsItem(BigDecimal tileVarOffsetsItem) {
        if (this.tileVarOffsets == null) {
            this.tileVarOffsets = new ArrayList<BigDecimal>();
        }
        this.tileVarOffsets.add(tileVarOffsetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="variable tile offsets")
    public List<BigDecimal> getTileVarOffsets() {
        return this.tileVarOffsets;
    }

    public void setTileVarOffsets(List<BigDecimal> tileVarOffsets) {
        this.tileVarOffsets = tileVarOffsets;
    }

    public GenericTileOffsets tileVarSizes(List<BigDecimal> tileVarSizes) {
        this.tileVarSizes = tileVarSizes;
        return this;
    }

    public GenericTileOffsets addTileVarSizesItem(BigDecimal tileVarSizesItem) {
        if (this.tileVarSizes == null) {
            this.tileVarSizes = new ArrayList<BigDecimal>();
        }
        this.tileVarSizes.add(tileVarSizesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="sizes of the uncompressed variable tiles offsets")
    public List<BigDecimal> getTileVarSizes() {
        return this.tileVarSizes;
    }

    public void setTileVarSizes(List<BigDecimal> tileVarSizes) {
        this.tileVarSizes = tileVarSizes;
    }

    public GenericTileOffsets tileValidityOffsets(List<BigDecimal> tileValidityOffsets) {
        this.tileValidityOffsets = tileValidityOffsets;
        return this;
    }

    public GenericTileOffsets addTileValidityOffsetsItem(BigDecimal tileValidityOffsetsItem) {
        if (this.tileValidityOffsets == null) {
            this.tileValidityOffsets = new ArrayList<BigDecimal>();
        }
        this.tileValidityOffsets.add(tileValidityOffsetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="tile validity offsets")
    public List<BigDecimal> getTileValidityOffsets() {
        return this.tileValidityOffsets;
    }

    public void setTileValidityOffsets(List<BigDecimal> tileValidityOffsets) {
        this.tileValidityOffsets = tileValidityOffsets;
    }

    public GenericTileOffsets tileMinOffsets(List<BigDecimal> tileMinOffsets) {
        this.tileMinOffsets = tileMinOffsets;
        return this;
    }

    public GenericTileOffsets addTileMinOffsetsItem(BigDecimal tileMinOffsetsItem) {
        if (this.tileMinOffsets == null) {
            this.tileMinOffsets = new ArrayList<BigDecimal>();
        }
        this.tileMinOffsets.add(tileMinOffsetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="min tile offsets")
    public List<BigDecimal> getTileMinOffsets() {
        return this.tileMinOffsets;
    }

    public void setTileMinOffsets(List<BigDecimal> tileMinOffsets) {
        this.tileMinOffsets = tileMinOffsets;
    }

    public GenericTileOffsets tileMaxOffsets(List<BigDecimal> tileMaxOffsets) {
        this.tileMaxOffsets = tileMaxOffsets;
        return this;
    }

    public GenericTileOffsets addTileMaxOffsetsItem(BigDecimal tileMaxOffsetsItem) {
        if (this.tileMaxOffsets == null) {
            this.tileMaxOffsets = new ArrayList<BigDecimal>();
        }
        this.tileMaxOffsets.add(tileMaxOffsetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="max tile offsets")
    public List<BigDecimal> getTileMaxOffsets() {
        return this.tileMaxOffsets;
    }

    public void setTileMaxOffsets(List<BigDecimal> tileMaxOffsets) {
        this.tileMaxOffsets = tileMaxOffsets;
    }

    public GenericTileOffsets tileSumOffsets(List<BigDecimal> tileSumOffsets) {
        this.tileSumOffsets = tileSumOffsets;
        return this;
    }

    public GenericTileOffsets addTileSumOffsetsItem(BigDecimal tileSumOffsetsItem) {
        if (this.tileSumOffsets == null) {
            this.tileSumOffsets = new ArrayList<BigDecimal>();
        }
        this.tileSumOffsets.add(tileSumOffsetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="tile sum offsets")
    public List<BigDecimal> getTileSumOffsets() {
        return this.tileSumOffsets;
    }

    public void setTileSumOffsets(List<BigDecimal> tileSumOffsets) {
        this.tileSumOffsets = tileSumOffsets;
    }

    public GenericTileOffsets tileNullCountOffsets(List<BigDecimal> tileNullCountOffsets) {
        this.tileNullCountOffsets = tileNullCountOffsets;
        return this;
    }

    public GenericTileOffsets addTileNullCountOffsetsItem(BigDecimal tileNullCountOffsetsItem) {
        if (this.tileNullCountOffsets == null) {
            this.tileNullCountOffsets = new ArrayList<BigDecimal>();
        }
        this.tileNullCountOffsets.add(tileNullCountOffsetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="null count offsets")
    public List<BigDecimal> getTileNullCountOffsets() {
        return this.tileNullCountOffsets;
    }

    public void setTileNullCountOffsets(List<BigDecimal> tileNullCountOffsets) {
        this.tileNullCountOffsets = tileNullCountOffsets;
    }

    public GenericTileOffsets fragmentMinMaxSumNullCountOffset(BigDecimal fragmentMinMaxSumNullCountOffset) {
        this.fragmentMinMaxSumNullCountOffset = fragmentMinMaxSumNullCountOffset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fragment min/max/sum/nullcount offsets")
    public BigDecimal getFragmentMinMaxSumNullCountOffset() {
        return this.fragmentMinMaxSumNullCountOffset;
    }

    public void setFragmentMinMaxSumNullCountOffset(BigDecimal fragmentMinMaxSumNullCountOffset) {
        this.fragmentMinMaxSumNullCountOffset = fragmentMinMaxSumNullCountOffset;
    }

    public GenericTileOffsets processedConditionsOffsets(BigDecimal processedConditionsOffsets) {
        this.processedConditionsOffsets = processedConditionsOffsets;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="processed conditions offsets")
    public BigDecimal getProcessedConditionsOffsets() {
        return this.processedConditionsOffsets;
    }

    public void setProcessedConditionsOffsets(BigDecimal processedConditionsOffsets) {
        this.processedConditionsOffsets = processedConditionsOffsets;
    }

    public GenericTileOffsets putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericTileOffsets genericTileOffsets = (GenericTileOffsets)o;
        return Objects.equals(this.rtree, genericTileOffsets.rtree) && Objects.equals(this.tileOffsets, genericTileOffsets.tileOffsets) && Objects.equals(this.tileVarOffsets, genericTileOffsets.tileVarOffsets) && Objects.equals(this.tileVarSizes, genericTileOffsets.tileVarSizes) && Objects.equals(this.tileValidityOffsets, genericTileOffsets.tileValidityOffsets) && Objects.equals(this.tileMinOffsets, genericTileOffsets.tileMinOffsets) && Objects.equals(this.tileMaxOffsets, genericTileOffsets.tileMaxOffsets) && Objects.equals(this.tileSumOffsets, genericTileOffsets.tileSumOffsets) && Objects.equals(this.tileNullCountOffsets, genericTileOffsets.tileNullCountOffsets) && Objects.equals(this.fragmentMinMaxSumNullCountOffset, genericTileOffsets.fragmentMinMaxSumNullCountOffset) && Objects.equals(this.processedConditionsOffsets, genericTileOffsets.processedConditionsOffsets) && Objects.equals(this.additionalProperties, genericTileOffsets.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.rtree, this.tileOffsets, this.tileVarOffsets, this.tileVarSizes, this.tileValidityOffsets, this.tileMinOffsets, this.tileMaxOffsets, this.tileSumOffsets, this.tileNullCountOffsets, this.fragmentMinMaxSumNullCountOffset, this.processedConditionsOffsets, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GenericTileOffsets {\n");
        sb.append("    rtree: ").append(this.toIndentedString(this.rtree)).append("\n");
        sb.append("    tileOffsets: ").append(this.toIndentedString(this.tileOffsets)).append("\n");
        sb.append("    tileVarOffsets: ").append(this.toIndentedString(this.tileVarOffsets)).append("\n");
        sb.append("    tileVarSizes: ").append(this.toIndentedString(this.tileVarSizes)).append("\n");
        sb.append("    tileValidityOffsets: ").append(this.toIndentedString(this.tileValidityOffsets)).append("\n");
        sb.append("    tileMinOffsets: ").append(this.toIndentedString(this.tileMinOffsets)).append("\n");
        sb.append("    tileMaxOffsets: ").append(this.toIndentedString(this.tileMaxOffsets)).append("\n");
        sb.append("    tileSumOffsets: ").append(this.toIndentedString(this.tileSumOffsets)).append("\n");
        sb.append("    tileNullCountOffsets: ").append(this.toIndentedString(this.tileNullCountOffsets)).append("\n");
        sb.append("    fragmentMinMaxSumNullCountOffset: ").append(this.toIndentedString(this.fragmentMinMaxSumNullCountOffset)).append("\n");
        sb.append("    processedConditionsOffsets: ").append(this.toIndentedString(this.processedConditionsOffsets)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in GenericTileOffsets is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_OFFSETS) != null && !jsonObj.get(SERIALIZED_NAME_TILE_OFFSETS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileOffsets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_OFFSETS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_VAR_OFFSETS) != null && !jsonObj.get(SERIALIZED_NAME_TILE_VAR_OFFSETS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileVarOffsets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_VAR_OFFSETS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_VAR_SIZES) != null && !jsonObj.get(SERIALIZED_NAME_TILE_VAR_SIZES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileVarSizes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_VAR_SIZES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_VALIDITY_OFFSETS) != null && !jsonObj.get(SERIALIZED_NAME_TILE_VALIDITY_OFFSETS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileValidityOffsets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_VALIDITY_OFFSETS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_MIN_OFFSETS) != null && !jsonObj.get(SERIALIZED_NAME_TILE_MIN_OFFSETS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileMinOffsets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_MIN_OFFSETS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_MAX_OFFSETS) != null && !jsonObj.get(SERIALIZED_NAME_TILE_MAX_OFFSETS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileMaxOffsets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_MAX_OFFSETS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_SUM_OFFSETS) != null && !jsonObj.get(SERIALIZED_NAME_TILE_SUM_OFFSETS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileSumOffsets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_SUM_OFFSETS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TILE_NULL_COUNT_OFFSETS) != null && !jsonObj.get(SERIALIZED_NAME_TILE_NULL_COUNT_OFFSETS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tileNullCountOffsets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TILE_NULL_COUNT_OFFSETS).toString()));
        }
    }

    public static GenericTileOffsets fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, GenericTileOffsets.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_RTREE);
        openapiFields.add(SERIALIZED_NAME_TILE_OFFSETS);
        openapiFields.add(SERIALIZED_NAME_TILE_VAR_OFFSETS);
        openapiFields.add(SERIALIZED_NAME_TILE_VAR_SIZES);
        openapiFields.add(SERIALIZED_NAME_TILE_VALIDITY_OFFSETS);
        openapiFields.add(SERIALIZED_NAME_TILE_MIN_OFFSETS);
        openapiFields.add(SERIALIZED_NAME_TILE_MAX_OFFSETS);
        openapiFields.add(SERIALIZED_NAME_TILE_SUM_OFFSETS);
        openapiFields.add(SERIALIZED_NAME_TILE_NULL_COUNT_OFFSETS);
        openapiFields.add(SERIALIZED_NAME_FRAGMENT_MIN_MAX_SUM_NULL_COUNT_OFFSET);
        openapiFields.add(SERIALIZED_NAME_PROCESSED_CONDITIONS_OFFSETS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!GenericTileOffsets.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<GenericTileOffsets> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(GenericTileOffsets.class));
            return new TypeAdapter<GenericTileOffsets>(){

                @Override
                public void write(JsonWriter out, GenericTileOffsets value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public GenericTileOffsets read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    GenericTileOffsets.validateJsonObject(jsonObj);
                    GenericTileOffsets instance = (GenericTileOffsets)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

