/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.v2.JSON;
import io.tiledb.cloud.rest_api.v2.model.Array;
import io.tiledb.cloud.rest_api.v2.model.AttributeBufferHeader;
import io.tiledb.cloud.rest_api.v2.model.Layout;
import io.tiledb.cloud.rest_api.v2.model.QueryReader;
import io.tiledb.cloud.rest_api.v2.model.Querystatus;
import io.tiledb.cloud.rest_api.v2.model.Querytype;
import io.tiledb.cloud.rest_api.v2.model.Writer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Query {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private Querytype type;
    public static final String SERIALIZED_NAME_LAYOUT = "layout";
    @SerializedName(value="layout")
    private Layout layout;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private Querystatus status;
    public static final String SERIALIZED_NAME_ATTRIBUTE_BUFFER_HEADERS = "attributeBufferHeaders";
    @SerializedName(value="attributeBufferHeaders")
    private List<AttributeBufferHeader> attributeBufferHeaders = new ArrayList<AttributeBufferHeader>();
    public static final String SERIALIZED_NAME_WRITER = "writer";
    @SerializedName(value="writer")
    private Writer writer;
    public static final String SERIALIZED_NAME_READER = "reader";
    @SerializedName(value="reader")
    private QueryReader reader;
    public static final String SERIALIZED_NAME_ARRAY = "array";
    @SerializedName(value="array")
    private Array array;
    public static final String SERIALIZED_NAME_TOTAL_FIXED_LENGTH_BUFFER_BYTES = "totalFixedLengthBufferBytes";
    @SerializedName(value="totalFixedLengthBufferBytes")
    private Integer totalFixedLengthBufferBytes;
    public static final String SERIALIZED_NAME_TOTAL_VAR_LEN_BUFFER_BYTES = "totalVarLenBufferBytes";
    @SerializedName(value="totalVarLenBufferBytes")
    private Integer totalVarLenBufferBytes;
    public static final String SERIALIZED_NAME_TOTAL_VALIDITY_BUFFER_BYTES = "totalValidityBufferBytes";
    @SerializedName(value="totalValidityBufferBytes")
    private Integer totalValidityBufferBytes;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Query type(Querytype type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Querytype getType() {
        return this.type;
    }

    public void setType(Querytype type) {
        this.type = type;
    }

    public Query layout(Layout layout) {
        this.layout = layout;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public Query status(Querystatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Querystatus getStatus() {
        return this.status;
    }

    public void setStatus(Querystatus status) {
        this.status = status;
    }

    public Query attributeBufferHeaders(List<AttributeBufferHeader> attributeBufferHeaders) {
        this.attributeBufferHeaders = attributeBufferHeaders;
        return this;
    }

    public Query addAttributeBufferHeadersItem(AttributeBufferHeader attributeBufferHeadersItem) {
        this.attributeBufferHeaders.add(attributeBufferHeadersItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="List of attribute buffer headers")
    public List<AttributeBufferHeader> getAttributeBufferHeaders() {
        return this.attributeBufferHeaders;
    }

    public void setAttributeBufferHeaders(List<AttributeBufferHeader> attributeBufferHeaders) {
        this.attributeBufferHeaders = attributeBufferHeaders;
    }

    public Query writer(Writer writer) {
        this.writer = writer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Query reader(QueryReader reader) {
        this.reader = reader;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public QueryReader getReader() {
        return this.reader;
    }

    public void setReader(QueryReader reader) {
        this.reader = reader;
    }

    public Query array(Array array) {
        this.array = array;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Array getArray() {
        return this.array;
    }

    public void setArray(Array array) {
        this.array = array;
    }

    public Query totalFixedLengthBufferBytes(Integer totalFixedLengthBufferBytes) {
        this.totalFixedLengthBufferBytes = totalFixedLengthBufferBytes;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Total number of bytes in fixed size attribute buffers.")
    public Integer getTotalFixedLengthBufferBytes() {
        return this.totalFixedLengthBufferBytes;
    }

    public void setTotalFixedLengthBufferBytes(Integer totalFixedLengthBufferBytes) {
        this.totalFixedLengthBufferBytes = totalFixedLengthBufferBytes;
    }

    public Query totalVarLenBufferBytes(Integer totalVarLenBufferBytes) {
        this.totalVarLenBufferBytes = totalVarLenBufferBytes;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Total number of bytes in variable size attribute buffers.")
    public Integer getTotalVarLenBufferBytes() {
        return this.totalVarLenBufferBytes;
    }

    public void setTotalVarLenBufferBytes(Integer totalVarLenBufferBytes) {
        this.totalVarLenBufferBytes = totalVarLenBufferBytes;
    }

    public Query totalValidityBufferBytes(Integer totalValidityBufferBytes) {
        this.totalValidityBufferBytes = totalValidityBufferBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of bytes in validity buffers")
    public Integer getTotalValidityBufferBytes() {
        return this.totalValidityBufferBytes;
    }

    public void setTotalValidityBufferBytes(Integer totalValidityBufferBytes) {
        this.totalValidityBufferBytes = totalValidityBufferBytes;
    }

    public Query putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        return Objects.equals((Object)this.type, (Object)query.type) && Objects.equals((Object)this.layout, (Object)query.layout) && Objects.equals((Object)this.status, (Object)query.status) && Objects.equals(this.attributeBufferHeaders, query.attributeBufferHeaders) && Objects.equals(this.writer, query.writer) && Objects.equals(this.reader, query.reader) && Objects.equals(this.array, query.array) && Objects.equals(this.totalFixedLengthBufferBytes, query.totalFixedLengthBufferBytes) && Objects.equals(this.totalVarLenBufferBytes, query.totalVarLenBufferBytes) && Objects.equals(this.totalValidityBufferBytes, query.totalValidityBufferBytes) && Objects.equals(this.additionalProperties, query.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.layout, this.status, this.attributeBufferHeaders, this.writer, this.reader, this.array, this.totalFixedLengthBufferBytes, this.totalVarLenBufferBytes, this.totalValidityBufferBytes, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Query {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    layout: ").append(this.toIndentedString((Object)this.layout)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    attributeBufferHeaders: ").append(this.toIndentedString(this.attributeBufferHeaders)).append("\n");
        sb.append("    writer: ").append(this.toIndentedString(this.writer)).append("\n");
        sb.append("    reader: ").append(this.toIndentedString(this.reader)).append("\n");
        sb.append("    array: ").append(this.toIndentedString(this.array)).append("\n");
        sb.append("    totalFixedLengthBufferBytes: ").append(this.toIndentedString(this.totalFixedLengthBufferBytes)).append("\n");
        sb.append("    totalVarLenBufferBytes: ").append(this.toIndentedString(this.totalVarLenBufferBytes)).append("\n");
        sb.append("    totalValidityBufferBytes: ").append(this.toIndentedString(this.totalValidityBufferBytes)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Query is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        JsonArray jsonArrayattributeBufferHeaders = jsonObj.getAsJsonArray(SERIALIZED_NAME_ATTRIBUTE_BUFFER_HEADERS);
        if (jsonArrayattributeBufferHeaders != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ATTRIBUTE_BUFFER_HEADERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `attributeBufferHeaders` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ATTRIBUTE_BUFFER_HEADERS).toString()));
            }
            for (int i = 0; i < jsonArrayattributeBufferHeaders.size(); ++i) {
                AttributeBufferHeader.validateJsonObject(jsonArrayattributeBufferHeaders.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_WRITER) != null) {
            Writer.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_WRITER));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_READER) != null) {
            QueryReader.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_READER));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ARRAY) != null) {
            Array.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ARRAY));
        }
    }

    public static Query fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, Query.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_LAYOUT);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_ATTRIBUTE_BUFFER_HEADERS);
        openapiFields.add(SERIALIZED_NAME_WRITER);
        openapiFields.add(SERIALIZED_NAME_READER);
        openapiFields.add(SERIALIZED_NAME_ARRAY);
        openapiFields.add(SERIALIZED_NAME_TOTAL_FIXED_LENGTH_BUFFER_BYTES);
        openapiFields.add(SERIALIZED_NAME_TOTAL_VAR_LEN_BUFFER_BYTES);
        openapiFields.add(SERIALIZED_NAME_TOTAL_VALIDITY_BUFFER_BYTES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_LAYOUT);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_ATTRIBUTE_BUFFER_HEADERS);
        openapiRequiredFields.add(SERIALIZED_NAME_ARRAY);
        openapiRequiredFields.add(SERIALIZED_NAME_TOTAL_FIXED_LENGTH_BUFFER_BYTES);
        openapiRequiredFields.add(SERIALIZED_NAME_TOTAL_VAR_LEN_BUFFER_BYTES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Query.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<Query> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(Query.class));
            return new TypeAdapter<Query>(){

                @Override
                public void write(JsonWriter out, Query value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public Query read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Query.validateJsonObject(jsonObj);
                    Query instance = (Query)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

