/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.v2.JSON;
import io.tiledb.cloud.rest_api.v2.model.SubarrayPartitioner;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="state for reads")
public class ReadState {
    public static final String SERIALIZED_NAME_INITIALIZED = "initialized";
    @SerializedName(value="initialized")
    private Boolean initialized;
    public static final String SERIALIZED_NAME_OVERFLOWED = "overflowed";
    @SerializedName(value="overflowed")
    private Boolean overflowed;
    public static final String SERIALIZED_NAME_UNSPLITTABLE = "unsplittable";
    @SerializedName(value="unsplittable")
    private Boolean unsplittable;
    public static final String SERIALIZED_NAME_SUBARRAY_PARTITIONER = "subarrayPartitioner";
    @SerializedName(value="subarrayPartitioner")
    private SubarrayPartitioner subarrayPartitioner;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ReadState initialized(Boolean initialized) {
        this.initialized = initialized;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the reader has been initialized.")
    public Boolean getInitialized() {
        return this.initialized;
    }

    public void setInitialized(Boolean initialized) {
        this.initialized = initialized;
    }

    public ReadState overflowed(Boolean overflowed) {
        this.overflowed = overflowed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the query produced results that could not fit in some buffer.")
    public Boolean getOverflowed() {
        return this.overflowed;
    }

    public void setOverflowed(Boolean overflowed) {
        this.overflowed = overflowed;
    }

    public ReadState unsplittable(Boolean unsplittable) {
        this.unsplittable = unsplittable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the current subarray partition is unsplittable.")
    public Boolean getUnsplittable() {
        return this.unsplittable;
    }

    public void setUnsplittable(Boolean unsplittable) {
        this.unsplittable = unsplittable;
    }

    public ReadState subarrayPartitioner(SubarrayPartitioner subarrayPartitioner) {
        this.subarrayPartitioner = subarrayPartitioner;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SubarrayPartitioner getSubarrayPartitioner() {
        return this.subarrayPartitioner;
    }

    public void setSubarrayPartitioner(SubarrayPartitioner subarrayPartitioner) {
        this.subarrayPartitioner = subarrayPartitioner;
    }

    public ReadState putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadState readState = (ReadState)o;
        return Objects.equals(this.initialized, readState.initialized) && Objects.equals(this.overflowed, readState.overflowed) && Objects.equals(this.unsplittable, readState.unsplittable) && Objects.equals(this.subarrayPartitioner, readState.subarrayPartitioner) && Objects.equals(this.additionalProperties, readState.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.initialized, this.overflowed, this.unsplittable, this.subarrayPartitioner, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReadState {\n");
        sb.append("    initialized: ").append(this.toIndentedString(this.initialized)).append("\n");
        sb.append("    overflowed: ").append(this.toIndentedString(this.overflowed)).append("\n");
        sb.append("    unsplittable: ").append(this.toIndentedString(this.unsplittable)).append("\n");
        sb.append("    subarrayPartitioner: ").append(this.toIndentedString(this.subarrayPartitioner)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ReadState is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SUBARRAY_PARTITIONER) != null) {
            SubarrayPartitioner.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SUBARRAY_PARTITIONER));
        }
    }

    public static ReadState fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, ReadState.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_INITIALIZED);
        openapiFields.add(SERIALIZED_NAME_OVERFLOWED);
        openapiFields.add(SERIALIZED_NAME_UNSPLITTABLE);
        openapiFields.add(SERIALIZED_NAME_SUBARRAY_PARTITIONER);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ReadState.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<ReadState> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(ReadState.class));
            return new TypeAdapter<ReadState>(){

                @Override
                public void write(JsonWriter out, ReadState value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public ReadState read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ReadState.validateJsonObject(jsonObj);
                    ReadState instance = (ReadState)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

