/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.v2.JSON;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="the timestamped filtered array metadata URIs, after removing the ones that need to be vacuumed and those that do not fall within")
public class TimestampedURI {
    public static final String SERIALIZED_NAME_URI = "uri";
    @SerializedName(value="uri")
    private String uri;
    public static final String SERIALIZED_NAME_TIMESTAMP_START = "timestampStart";
    @SerializedName(value="timestampStart")
    private BigDecimal timestampStart;
    public static final String SERIALIZED_NAME_TIMESTAMP_END = "timestampEnd";
    @SerializedName(value="timestampEnd")
    private BigDecimal timestampEnd;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TimestampedURI uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the uri")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public TimestampedURI timestampStart(BigDecimal timestampStart) {
        this.timestampStart = timestampStart;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="start of timestamp")
    public BigDecimal getTimestampStart() {
        return this.timestampStart;
    }

    public void setTimestampStart(BigDecimal timestampStart) {
        this.timestampStart = timestampStart;
    }

    public TimestampedURI timestampEnd(BigDecimal timestampEnd) {
        this.timestampEnd = timestampEnd;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="end of timestamp")
    public BigDecimal getTimestampEnd() {
        return this.timestampEnd;
    }

    public void setTimestampEnd(BigDecimal timestampEnd) {
        this.timestampEnd = timestampEnd;
    }

    public TimestampedURI putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampedURI timestampedURI = (TimestampedURI)o;
        return Objects.equals(this.uri, timestampedURI.uri) && Objects.equals(this.timestampStart, timestampedURI.timestampStart) && Objects.equals(this.timestampEnd, timestampedURI.timestampEnd) && Objects.equals(this.additionalProperties, timestampedURI.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.timestampStart, this.timestampEnd, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimestampedURI {\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    timestampStart: ").append(this.toIndentedString(this.timestampStart)).append("\n");
        sb.append("    timestampEnd: ").append(this.toIndentedString(this.timestampEnd)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TimestampedURI is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URI) != null && !jsonObj.get(SERIALIZED_NAME_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URI).toString()));
        }
    }

    public static TimestampedURI fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, TimestampedURI.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_URI);
        openapiFields.add(SERIALIZED_NAME_TIMESTAMP_START);
        openapiFields.add(SERIALIZED_NAME_TIMESTAMP_END);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!TimestampedURI.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<TimestampedURI> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(TimestampedURI.class));
            return new TypeAdapter<TimestampedURI>(){

                @Override
                public void write(JsonWriter out, TimestampedURI value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public TimestampedURI read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TimestampedURI.validateJsonObject(jsonObj);
                    TimestampedURI instance = (TimestampedURI)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

