/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.compression;

import com.github.luben.zstd.Zstd;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.compression.AbstractCompressionCodec;
import org.apache.arrow.vector.compression.CompressionUtil;

public class ZstdCompressionCodec
extends AbstractCompressionCodec {
    private int compressionLevel;
    private static final int DEFAULT_COMPRESSION_LEVEL = 3;

    public ZstdCompressionCodec() {
        this.compressionLevel = 3;
    }

    public ZstdCompressionCodec(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    @Override
    protected ArrowBuf doCompress(BufferAllocator allocator, ArrowBuf uncompressedBuffer) {
        long maxSize = Zstd.compressBound(uncompressedBuffer.writerIndex());
        long dstSize = 8L + maxSize;
        ArrowBuf compressedBuffer = allocator.buffer(dstSize);
        long bytesWritten = Zstd.compressUnsafe(compressedBuffer.memoryAddress() + 8L, dstSize, uncompressedBuffer.memoryAddress(), uncompressedBuffer.writerIndex(), this.compressionLevel);
        if (Zstd.isError(bytesWritten)) {
            compressedBuffer.close();
            throw new RuntimeException("Error compressing: " + Zstd.getErrorName(bytesWritten));
        }
        compressedBuffer.writerIndex(8L + bytesWritten);
        return compressedBuffer;
    }

    @Override
    protected ArrowBuf doDecompress(BufferAllocator allocator, ArrowBuf compressedBuffer) {
        long decompressedLength = this.readUncompressedLength(compressedBuffer);
        ArrowBuf uncompressedBuffer = allocator.buffer(decompressedLength);
        long decompressedSize = Zstd.decompressUnsafe(uncompressedBuffer.memoryAddress(), decompressedLength, compressedBuffer.memoryAddress() + 8L, compressedBuffer.writerIndex() - 8L);
        if (Zstd.isError(decompressedSize)) {
            uncompressedBuffer.close();
            throw new RuntimeException("Error decompressing: " + Zstd.getErrorName(decompressedLength));
        }
        if (decompressedLength != decompressedSize) {
            uncompressedBuffer.close();
            throw new RuntimeException("Expected != actual decompressed length: " + decompressedLength + " != " + decompressedSize);
        }
        uncompressedBuffer.writerIndex(decompressedLength);
        return uncompressedBuffer;
    }

    @Override
    public CompressionUtil.CodecType getCodecType() {
        return CompressionUtil.CodecType.ZSTD;
    }
}

