/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.client.response;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.client.response.OAuthClientResponse;
import org.apache.oltu.oauth2.client.validator.CodeTokenValidator;
import org.apache.oltu.oauth2.client.validator.CodeValidator;
import org.apache.oltu.oauth2.client.validator.OAuthClientValidator;
import org.apache.oltu.oauth2.client.validator.TokenValidator;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;

public class OAuthAuthzResponse
extends OAuthClientResponse {
    private HttpServletRequest request;

    protected OAuthAuthzResponse(HttpServletRequest request, OAuthClientValidator validator) {
        this.request = request;
        Map params = request.getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            String[] values2 = (String[])entry.getValue();
            if (OAuthUtils.hasEmptyValues(values2)) continue;
            this.parameters.put(key, values2[0]);
        }
        this.validator = validator;
    }

    public static OAuthAuthzResponse oauthCodeAuthzResponse(HttpServletRequest request) throws OAuthProblemException {
        OAuthAuthzResponse response = new OAuthAuthzResponse(request, new CodeValidator());
        response.validate();
        return response;
    }

    public static OAuthAuthzResponse oAuthCodeAndTokenAuthzResponse(HttpServletRequest request) throws OAuthProblemException {
        OAuthAuthzResponse response = new OAuthAuthzResponse(request, new CodeTokenValidator());
        response.validate();
        return response;
    }

    public static OAuthAuthzResponse oauthTokenAuthzResponse(HttpServletRequest request) throws OAuthProblemException {
        OAuthAuthzResponse response = new OAuthAuthzResponse(request, new TokenValidator());
        response.validate();
        return response;
    }

    public String getAccessToken() {
        return this.getParam("access_token");
    }

    public Long getExpiresIn() {
        String value = this.getParam("expires_in");
        return value == null ? null : Long.valueOf(value);
    }

    public String getScope() {
        return this.getParam("scope");
    }

    public String getCode() {
        return this.getParam("code");
    }

    public String getState() {
        return this.getParam("state");
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    protected void setBody(String body) {
        this.body = body;
    }

    @Override
    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    protected void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }
}

