/*
 * Decompiled with CFR 0.152.
 */
package examples.io.tiledb.java.api;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.Callback;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Layout;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.Query;
import io.tiledb.java.api.QueryStatus;
import io.tiledb.java.api.QueryType;
import java.util.Arrays;
import java.util.HashMap;

public class DenseReadAsync {
    public static void main(String[] args) throws Exception {
        QueryStatus status;
        Context ctx = new Context();
        Array my_dense_array = new Array(ctx, "my_dense_array");
        Query query = new Query(my_dense_array, QueryType.TILEDB_READ);
        query.setSubarray(new NativeArray(ctx, (Object)new long[]{1L, 4L, 1L, 4L}, Long.class));
        query.setLayout(Layout.TILEDB_GLOBAL_ORDER);
        HashMap<String, Pair<Long, Long>> max_sizes = query.getResultEstimations();
        query.setBuffer("a1", new NativeArray(ctx, max_sizes.get("a1").getSecond().intValue(), Integer.class));
        query.setBuffer("a2", new NativeArray(ctx, max_sizes.get("a2").getFirst().intValue(), Datatype.TILEDB_UINT64), new NativeArray(ctx, max_sizes.get("a2").getSecond().intValue(), String.class));
        query.setBuffer("a3", new NativeArray(ctx, max_sizes.get("a3").getSecond().intValue(), Float.class));
        query.submitAsync(new ReadCallback("Java Callback: Query completed"));
        System.out.printf("Query in progress\n", new Object[0]);
        while ((status = query.getQueryStatus()) == QueryStatus.TILEDB_INPROGRESS) {
        }
        HashMap<String, Pair<Long, Long>> result_el = query.resultBufferElements();
        int[] a1_buff = (int[])query.getBuffer("a1");
        long[] a2_offsets = query.getVarBuffer("a2");
        byte[] a2_data = (byte[])query.getBuffer("a2");
        float[] a3_buff = (float[])query.getBuffer("a3");
        System.out.println("Result num: " + a1_buff.length);
        System.out.println(String.format("%9s", "a1") + String.format("%11s", "a2") + String.format("%11s", "a3[0]") + String.format("%10s", "a3[1]"));
        for (int i = 0; i < a1_buff.length; ++i) {
            int end = i == a1_buff.length - 1 ? a2_data.length : (int)a2_offsets[i + 1];
            System.out.println(String.format("%9s", a1_buff[i]) + String.format("%11s", new String(Arrays.copyOfRange(a2_data, (int)a2_offsets[i], end))) + String.format("%11s", Float.valueOf(a3_buff[2 * i])) + String.format("%10s", Float.valueOf(a3_buff[2 * i + 1])));
        }
    }

    private static class ReadCallback
    implements Callback {
        private final String data;

        public ReadCallback(String data) {
            this.data = data;
        }

        @Override
        public void call() {
            System.out.println(this.data);
        }
    }
}

