/*
 * Decompiled with CFR 0.152.
 */
package examples.io.tiledb.java.api;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.Config;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.FileStore;
import io.tiledb.java.api.MimeType;
import io.tiledb.java.api.TileDBError;

public class FileStoreExample {
    public static void main(String[] args) throws TileDBError {
        try {
            Config config = new Config();
            config.set("vfs.s3.aws_access_key_id", "<ID>");
            config.set("vfs.s3.aws_secret_access_key", "<KEY>");
            config.set("rest.username", "<USERNAME>");
            config.set("rest.password", "<PASSWORD>");
            config.set("rest.token", "<TOKEN>");
            Context ctx = new Context(config);
            String filestore = "my_filestore";
            ArraySchema arraySchema = FileStore.schemaCreate(ctx, "test.txt");
            Array.create(filestore, arraySchema);
            FileStore.uriImport(ctx, filestore, "test.txt", MimeType.TILEDB_MIME_AUTODETECT);
            FileStore.uriExport(ctx, filestore, "test_output.txt");
        }
        catch (TileDBError e) {
            System.out.println("\nTo run the FileStore example make sure you complete the missing info in the '<>'\n");
        }
    }
}

