/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.ArrayType;
import io.tiledb.java.api.Attribute;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.EncryptionType;
import io.tiledb.java.api.FilterList;
import io.tiledb.java.api.Layout;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.Util;
import io.tiledb.libtiledb.SWIGTYPE_p_int;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_array_schema_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_attribute_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_domain_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_filter_list_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_array_schema_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_array_type_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_layout_t;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_int;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_long_long;
import io.tiledb.libtiledb.tiledb;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class ArraySchema
implements AutoCloseable {
    private Context ctx;
    private ArrayType arrayType;
    private HashMap<String, Attribute> attributes;
    private SWIGTYPE_p_tiledb_array_schema_t schemap;
    private SWIGTYPE_p_p_tiledb_array_schema_t schemapp;

    public ArraySchema(Context ctx, ArrayType type) throws TileDBError {
        SWIGTYPE_p_p_tiledb_array_schema_t _schemapp = tiledb.new_tiledb_array_schema_tpp();
        try {
            ctx.handleError(tiledb.tiledb_array_schema_alloc(ctx.getCtxp(), type.toSwigEnum(), _schemapp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_array_schema_tpp(_schemapp);
            throw err;
        }
        this.ctx = ctx;
        this.arrayType = type;
        this.schemap = tiledb.tiledb_array_schema_tpp_value(_schemapp);
        this.schemapp = _schemapp;
    }

    protected ArraySchema(Context ctx, SWIGTYPE_p_p_tiledb_array_schema_t schemapp) {
        this.ctx = ctx;
        this.schemap = tiledb.tiledb_array_schema_tpp_value(schemapp);
        this.schemapp = schemapp;
    }

    public ArraySchema(Context ctx, String uri) throws TileDBError {
        SWIGTYPE_p_p_tiledb_array_schema_t _schemapp = tiledb.new_tiledb_array_schema_tpp();
        try {
            ctx.handleError(tiledb.tiledb_array_schema_load(ctx.getCtxp(), uri, _schemapp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_array_schema_tpp(_schemapp);
            throw err;
        }
        this.ctx = ctx;
        this.schemap = tiledb.tiledb_array_schema_tpp_value(_schemapp);
        this.schemapp = _schemapp;
    }

    public ArraySchema(Context ctx, String uri, EncryptionType encryption_type, byte[] key) throws TileDBError {
        SWIGTYPE_p_p_tiledb_array_schema_t _schemapp = tiledb.new_tiledb_array_schema_tpp();
        try (NativeArray keyArray = new NativeArray(ctx, (Object)key, Byte.class);){
            try {
                ctx.handleError(tiledb.tiledb_array_schema_load_with_key(ctx.getCtxp(), uri, encryption_type.toSwigEnum(), keyArray.toVoidPointer(), keyArray.getSize(), _schemapp));
            }
            catch (TileDBError err) {
                tiledb.delete_tiledb_array_schema_tpp(_schemapp);
                throw err;
            }
        }
        this.ctx = ctx;
        this.schemap = tiledb.tiledb_array_schema_tpp_value(_schemapp);
        this.schemapp = _schemapp;
    }

    public void dump() throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_array_schema_dump_stdout(this.ctx.getCtxp(), this.getSchemap()));
    }

    public void dump(String filename) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_array_schema_dump_file(this.ctx.getCtxp(), this.getSchemap(), filename));
    }

    public ArrayType getArrayType() throws TileDBError {
        if (this.arrayType == null) {
            SWIGTYPE_p_tiledb_array_type_t typep = tiledb.new_tiledb_array_type_tp();
            try {
                this.ctx.handleError(tiledb.tiledb_array_schema_get_array_type(this.ctx.getCtxp(), this.getSchemap(), typep));
                this.arrayType = ArrayType.fromSwigEnum(tiledb.tiledb_array_type_tp_value(typep));
            }
            finally {
                tiledb.delete_tiledb_array_type_tp(typep);
            }
        }
        return this.arrayType;
    }

    public boolean isSparse() throws TileDBError {
        return this.getArrayType() == ArrayType.TILEDB_SPARSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCapacity() throws TileDBError {
        long capacity;
        SWIGTYPE_p_unsigned_long_long capacityp = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_schema_get_capacity(this.ctx.getCtxp(), this.getSchemap(), capacityp));
            capacity = tiledb.ullp_value(capacityp).longValue();
        }
        finally {
            tiledb.delete_ullp(capacityp);
        }
        return capacity;
    }

    public void setCapacity(long capacity) throws TileDBError {
        this.setCapacity(BigInteger.valueOf(capacity));
    }

    public void setCapacity(BigInteger capacity) throws TileDBError {
        Util.checkBigIntegerRange(capacity);
        this.ctx.handleError(tiledb.tiledb_array_schema_set_capacity(this.ctx.getCtxp(), this.schemap, capacity));
    }

    public Layout getTileOrder() throws TileDBError {
        Layout tileOrder;
        SWIGTYPE_p_tiledb_layout_t layoutpp = tiledb.new_tiledb_layout_tp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_schema_get_tile_order(this.ctx.getCtxp(), this.getSchemap(), layoutpp));
            tileOrder = Layout.fromSwigEnum(tiledb.tiledb_layout_tp_value(layoutpp));
        }
        finally {
            tiledb.delete_tiledb_layout_tp(layoutpp);
        }
        return tileOrder;
    }

    public ArraySchema setTileOrder(Layout layout) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_array_schema_set_tile_order(this.ctx.getCtxp(), this.getSchemap(), layout.toSwigEnum()));
        return this;
    }

    public Layout getCellOrder() throws TileDBError {
        Layout cellOrder;
        SWIGTYPE_p_tiledb_layout_t layoutpp = tiledb.new_tiledb_layout_tp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_schema_get_cell_order(this.ctx.getCtxp(), this.getSchemap(), layoutpp));
            cellOrder = Layout.fromSwigEnum(tiledb.tiledb_layout_tp_value(layoutpp));
        }
        finally {
            tiledb.delete_tiledb_layout_tp(layoutpp);
        }
        return cellOrder;
    }

    public ArraySchema setCellOrder(Layout layout) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_array_schema_set_cell_order(this.ctx.getCtxp(), this.getSchemap(), layout.toSwigEnum()));
        return this;
    }

    public Domain getDomain() throws TileDBError {
        SWIGTYPE_p_p_tiledb_domain_t domainpp = tiledb.new_tiledb_domain_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_schema_get_domain(this.ctx.getCtxp(), this.getSchemap(), domainpp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_domain_tpp(domainpp);
            throw err;
        }
        return new Domain(this.ctx, domainpp);
    }

    public void setDomain(Domain domain) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_array_schema_set_domain(this.ctx.getCtxp(), this.getSchemap(), domain.getDomainp()));
    }

    public void addAttribute(Attribute attr) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_array_schema_add_attribute(this.ctx.getCtxp(), this.getSchemap(), attr.getAttributep()));
    }

    public void check() throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_array_schema_check(this.ctx.getCtxp(), this.getSchemap()));
    }

    public HashMap<String, Attribute> getAttributes() throws TileDBError {
        if (this.attributes == null) {
            this.attributes = new HashMap();
            SWIGTYPE_p_p_tiledb_attribute_t attrpp = tiledb.new_tiledb_attribute_tpp();
            SWIGTYPE_p_unsigned_int nattrp = tiledb.new_uintp();
            try {
                this.ctx.handleError(tiledb.tiledb_array_schema_get_attribute_num(this.ctx.getCtxp(), this.schemap, nattrp));
            }
            catch (TileDBError err) {
                tiledb.delete_tiledb_attribute_tpp(attrpp);
                tiledb.delete_uintp(nattrp);
                throw err;
            }
            long nattr = tiledb.uintp_value(nattrp);
            tiledb.delete_uintp(nattrp);
            for (long i = 0L; i < nattr; ++i) {
                try {
                    this.ctx.handleError(tiledb.tiledb_array_schema_get_attribute_from_index(this.ctx.getCtxp(), this.schemap, i, attrpp));
                }
                catch (TileDBError err) {
                    tiledb.delete_tiledb_attribute_tpp(attrpp);
                    throw err;
                }
                Attribute attr = new Attribute(this.ctx, attrpp);
                this.attributes.put(attr.getName(), attr);
            }
        }
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAttributeNum() throws TileDBError {
        long num;
        SWIGTYPE_p_unsigned_int nump = tiledb.new_uintp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_schema_get_attribute_num(this.ctx.getCtxp(), this.getSchemap(), nump));
            num = tiledb.uintp_value(nump);
        }
        finally {
            tiledb.delete_uintp(nump);
        }
        return num;
    }

    public boolean hasAttribute(String name) throws TileDBError {
        SWIGTYPE_p_int hasAttribute = tiledb.new_intp();
        this.ctx.handleError(tiledb.tiledb_array_schema_has_attribute(this.ctx.getCtxp(), this.getSchemap(), name, hasAttribute));
        boolean result = tiledb.intp_value(hasAttribute) > 0;
        tiledb.delete_intp(hasAttribute);
        return result;
    }

    public Attribute getAttribute(String name) throws TileDBError {
        Attribute attr;
        SWIGTYPE_p_p_tiledb_attribute_t attrpp = tiledb.new_tiledb_attribute_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_schema_get_attribute_from_name(this.ctx.getCtxp(), this.getSchemap(), name, attrpp));
            attr = new Attribute(this.ctx, attrpp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_attribute_tpp(attrpp);
            throw err;
        }
        return attr;
    }

    public Attribute getAttribute(long index) throws TileDBError {
        Attribute attr;
        SWIGTYPE_p_p_tiledb_attribute_t attrpp = tiledb.new_tiledb_attribute_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_schema_get_attribute_from_index(this.ctx.getCtxp(), this.schemap, index, attrpp));
            attr = new Attribute(this.ctx, attrpp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_attribute_tpp(attrpp);
            throw err;
        }
        return attr;
    }

    public ArraySchema setValidityFilterList(FilterList filterList) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_array_schema_set_validity_filter_list(this.ctx.getCtxp(), this.getSchemap(), filterList.getFilterListp()));
        return this;
    }

    public FilterList getValidityFilterList() throws TileDBError {
        FilterList filterlist;
        SWIGTYPE_p_p_tiledb_filter_list_t filterlistpp = tiledb.new_tiledb_filter_list_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_schema_get_validity_filter_list(this.ctx.getCtxp(), this.getSchemap(), filterlistpp));
            filterlist = new FilterList(this.ctx, filterlistpp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_filter_list_tpp(filterlistpp);
            throw err;
        }
        return filterlist;
    }

    public ArraySchema setCoodsFilterList(FilterList filterList) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_array_schema_set_coords_filter_list(this.ctx.getCtxp(), this.getSchemap(), filterList.getFilterListp()));
        return this;
    }

    public FilterList getCoordsFilterList() throws TileDBError {
        FilterList filterlist;
        SWIGTYPE_p_p_tiledb_filter_list_t filterlistpp = tiledb.new_tiledb_filter_list_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_schema_get_coords_filter_list(this.ctx.getCtxp(), this.getSchemap(), filterlistpp));
            filterlist = new FilterList(this.ctx, filterlistpp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_filter_list_tpp(filterlistpp);
            throw err;
        }
        return filterlist;
    }

    public ArraySchema setOffsetsFilterList(FilterList filterList) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_array_schema_set_offsets_filter_list(this.ctx.getCtxp(), this.getSchemap(), filterList.getFilterListp()));
        return this;
    }

    public Pair<Long, Long> getTimestampRange() throws TileDBError {
        SWIGTYPE_p_unsigned_long_long t1 = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long t2 = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_schema_timestamp_range(this.ctx.getCtxp(), this.getSchemap(), t1, t2));
            return new Pair<BigInteger, BigInteger>(tiledb.ullp_value(t1), tiledb.ullp_value(t2));
        }
        catch (TileDBError err) {
            tiledb.delete_ullp(t1);
            tiledb.delete_ullp(t2);
            throw err;
        }
    }

    public FilterList getOffsetsFilterList() throws TileDBError {
        FilterList filterlist;
        SWIGTYPE_p_p_tiledb_filter_list_t filterlistpp = tiledb.new_tiledb_filter_list_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_schema_get_offsets_filter_list(this.ctx.getCtxp(), this.getSchemap(), filterlistpp));
            filterlist = new FilterList(this.ctx, filterlistpp);
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_filter_list_tpp(filterlistpp);
            throw err;
        }
        return filterlist;
    }

    public void setAllowDups(int allowsDups) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_array_schema_set_allows_dups(this.ctx.getCtxp(), this.getSchemap(), allowsDups));
    }

    public int getAllowDups() throws TileDBError {
        SWIGTYPE_p_int allowsDupsPtr = tiledb.new_intp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_schema_get_allows_dups(this.ctx.getCtxp(), this.getSchemap(), allowsDupsPtr));
            return tiledb.intp_value(allowsDupsPtr);
        }
        catch (TileDBError err) {
            tiledb.delete_intp(allowsDupsPtr);
            throw err;
        }
    }

    public long getVersion() throws TileDBError {
        SWIGTYPE_p_unsigned_int versionPtr = tiledb.new_uintp();
        try {
            this.ctx.handleError(tiledb.tiledb_array_schema_get_version(this.ctx.getCtxp(), this.getSchemap(), versionPtr));
            return tiledb.uintp_value(versionPtr);
        }
        catch (TileDBError err) {
            tiledb.delete_uintp(versionPtr);
            throw err;
        }
    }

    protected SWIGTYPE_p_tiledb_array_schema_t getSchemap() {
        return this.schemap;
    }

    public SWIGTYPE_p_p_tiledb_array_schema_t getSchemapp() {
        return this.schemapp;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public String toString() {
        try {
            StringBuilder s = new StringBuilder("ArraySchema<");
            s.append(this.getArrayType().name());
            s.append(" ");
            s.append(this.getDomain());
            for (Map.Entry<String, Attribute> e : this.getAttributes().entrySet()) {
                s.append(" ");
                s.append(e.getValue());
            }
            s.append(">");
            return s.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public void close() {
        if (this.schemap != null) {
            tiledb.tiledb_array_schema_free(this.schemapp);
            this.schemap = null;
            this.schemapp = null;
        }
        if (this.attributes != null) {
            for (Map.Entry<String, Attribute> e : this.attributes.entrySet()) {
                e.getValue().close();
            }
        }
        this.attributes = null;
    }
}

