/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Config;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.QueryType;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.Util;
import io.tiledb.libtiledb.SWIGTYPE_p_int;
import io.tiledb.libtiledb.SWIGTYPE_p_p_char;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_config_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_group_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_void;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_config_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_datatype_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_group_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_object_t;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_int;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_long_long;
import io.tiledb.libtiledb.tiledb;
import java.math.BigInteger;

public class Group
implements AutoCloseable {
    private Context ctx;
    private final String uri;
    private QueryType queryType;
    private SWIGTYPE_p_tiledb_group_t groupp;
    private SWIGTYPE_p_p_tiledb_group_t grouppp;

    public Group(Context ctx, String uri, QueryType queryType) throws TileDBError {
        SWIGTYPE_p_p_tiledb_group_t grouppp = tiledb.new_tiledb_group_tpp();
        try {
            ctx.handleError(tiledb.tiledb_group_alloc(ctx.getCtxp(), uri, grouppp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_group_tpp(grouppp);
            throw err;
        }
        this.ctx = ctx;
        this.groupp = tiledb.tiledb_group_tpp_value(grouppp);
        this.grouppp = grouppp;
        this.uri = uri;
        this.queryType = queryType;
        this.open(queryType);
    }

    protected SWIGTYPE_p_tiledb_group_t getGroupp() {
        return this.groupp;
    }

    protected Context getCtx() {
        return this.ctx;
    }

    public void setConfig(Config config) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_group_set_config(this.ctx.getCtxp(), this.getGroupp(), config.getConfigp()));
    }

    public void deleteMetadata(String key) throws TileDBError {
        if (!this.isOpen()) {
            throw new TileDBError("Group with URI: " + this.uri + " is closed");
        }
        this.ctx.handleError(tiledb.tiledb_group_delete_metadata(this.ctx.getCtxp(), this.getGroupp(), key));
    }

    public NativeArray getMetadata(String key, Datatype nativeType) throws TileDBError {
        if (!this.isOpen()) {
            throw new TileDBError("Group with URI: " + this.uri + " is closed");
        }
        SWIGTYPE_p_p_void resultArrpp = tiledb.new_voidpArray(0);
        SWIGTYPE_p_unsigned_int value_num = tiledb.new_uintp();
        SWIGTYPE_p_tiledb_datatype_t value_type = nativeType == null ? tiledb.new_tiledb_datatype_tp() : tiledb.copy_tiledb_datatype_tp(nativeType.toSwigEnum());
        this.ctx.handleError(tiledb.tiledb_group_get_metadata(this.ctx.getCtxp(), this.getGroupp(), key, value_type, value_num, resultArrpp));
        Datatype derivedNativeType = Datatype.fromSwigEnum(tiledb.tiledb_datatype_tp_value(value_type));
        long value = tiledb.uintp_value(value_num);
        NativeArray result = new NativeArray(this.ctx, derivedNativeType, resultArrpp, (int)value);
        tiledb.delete_uintp(value_num);
        tiledb.delete_tiledb_datatype_tp(value_type);
        return result;
    }

    public Config getConfig() throws TileDBError {
        SWIGTYPE_p_p_tiledb_config_t configpp = tiledb.new_tiledb_config_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_group_get_config(this.ctx.getCtxp(), this.getGroupp(), configpp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_config_tpp(configpp);
        }
        return new Config(configpp);
    }

    public BigInteger getMetadataNum() throws TileDBError {
        if (!this.isOpen()) {
            throw new TileDBError("Group with URI: " + this.uri + " is closed");
        }
        SWIGTYPE_p_unsigned_long_long value_num = tiledb.new_ullp();
        this.ctx.handleError(tiledb.tiledb_group_get_metadata_num(this.ctx.getCtxp(), this.getGroupp(), value_num));
        BigInteger value = tiledb.ullp_value(value_num);
        tiledb.delete_ullp(value_num);
        return value;
    }

    public long getMemberCount() throws TileDBError {
        SWIGTYPE_p_unsigned_long_long mc = tiledb.new_ullp();
        try {
            this.ctx.handleError(tiledb.tiledb_group_get_member_count(this.ctx.getCtxp(), this.getGroupp(), mc));
        }
        catch (TileDBError err) {
            tiledb.delete_ullp(mc);
            throw err;
        }
        long memberCount = tiledb.ullp_value(mc).longValue();
        tiledb.delete_ullp(mc);
        return memberCount;
    }

    public String getMemberURIByIndex(BigInteger index) throws TileDBError {
        Util.checkBigIntegerRange(index);
        SWIGTYPE_p_tiledb_object_t objtypep = tiledb.new_tiledb_object_tp();
        SWIGTYPE_p_p_char uripp = tiledb.new_charpp();
        SWIGTYPE_p_p_char namepp = tiledb.new_charpp();
        this.ctx.handleError(tiledb.tiledb_group_get_member_by_index(this.ctx.getCtxp(), this.getGroupp(), index, uripp, objtypep, uripp));
        return tiledb.charpp_value(uripp);
    }

    public String getMemberURIByName(String name) throws TileDBError {
        SWIGTYPE_p_tiledb_object_t objtypep = tiledb.new_tiledb_object_tp();
        SWIGTYPE_p_p_char uripp = tiledb.new_charpp();
        this.ctx.handleError(tiledb.tiledb_group_get_member_by_name(this.ctx.getCtxp(), this.getGroupp(), name, uripp, objtypep));
        return tiledb.charpp_value(uripp);
    }

    public String getMemberNameByIndex(BigInteger index) throws TileDBError {
        Util.checkBigIntegerRange(index);
        SWIGTYPE_p_tiledb_object_t objtypep = tiledb.new_tiledb_object_tp();
        SWIGTYPE_p_p_char uripp = tiledb.new_charpp();
        SWIGTYPE_p_p_char namepp = tiledb.new_charpp();
        this.ctx.handleError(tiledb.tiledb_group_get_member_by_index(this.ctx.getCtxp(), this.getGroupp(), index, uripp, objtypep, namepp));
        return tiledb.charpp_value(namepp);
    }

    public void addMember(String uri, boolean relative, String name) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_group_add_member(this.ctx.getCtxp(), this.getGroupp(), uri, relative ? (short)1 : 0, name));
    }

    public void removeMember(String uri) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_group_remove_member(this.ctx.getCtxp(), this.getGroupp(), uri));
    }

    public void dumpStr(String string, boolean flag) throws TileDBError {
        SWIGTYPE_p_p_char valuepp = tiledb.new_charpp();
        this.ctx.handleError(tiledb.tiledb_group_dump_str(this.ctx.getCtxp(), this.getGroupp(), valuepp, flag ? (short)1 : 0));
    }

    public Pair<String, NativeArray> getMetadataFromIndex(BigInteger index) throws TileDBError {
        Util.checkBigIntegerRange(index);
        if (!this.isOpen()) {
            throw new TileDBError("Group with URI: " + this.uri + " is closed");
        }
        SWIGTYPE_p_p_char key = tiledb.new_charpp();
        SWIGTYPE_p_unsigned_int key_len = tiledb.new_uintp();
        SWIGTYPE_p_tiledb_datatype_t value_type = tiledb.new_tiledb_datatype_tp();
        SWIGTYPE_p_unsigned_int value_num = tiledb.new_uintp();
        SWIGTYPE_p_p_void value = tiledb.new_voidpArray(0);
        this.ctx.handleError(tiledb.tiledb_group_get_metadata_from_index(this.ctx.getCtxp(), this.getGroupp(), index, key, key_len, value_type, value_num, value));
        String keyString = tiledb.charpp_value(key);
        long valueLength = tiledb.uintp_value(value_num);
        Datatype nativeType = Datatype.fromSwigEnum(tiledb.tiledb_datatype_tp_value(value_type));
        NativeArray result = new NativeArray(this.ctx, nativeType, value, (int)valueLength);
        tiledb.delete_uintp(value_num);
        tiledb.delete_uintp(key_len);
        tiledb.delete_charpp(key);
        tiledb.delete_tiledb_datatype_tp(value_type);
        return new Pair<String, NativeArray>(keyString, result);
    }

    public Boolean hasMetadataKey(String key) throws TileDBError {
        if (!this.isOpen()) {
            throw new TileDBError("Group with URI: " + this.uri + " is closed");
        }
        SWIGTYPE_p_tiledb_datatype_t value_type = tiledb.new_tiledb_datatype_tp();
        SWIGTYPE_p_int has_key = tiledb.new_intp();
        this.ctx.handleError(tiledb.tiledb_group_has_metadata_key(this.ctx.getCtxp(), this.getGroupp(), key, value_type, has_key));
        Boolean result = tiledb.intp_value(has_key) > 0;
        tiledb.delete_intp(has_key);
        tiledb.delete_tiledb_datatype_tp(value_type);
        return result;
    }

    public boolean isOpen() throws TileDBError {
        boolean isOpen;
        SWIGTYPE_p_int ret = tiledb.new_intp();
        try {
            this.ctx.handleError(tiledb.tiledb_group_is_open(this.ctx.getCtxp(), this.getGroupp(), ret));
            isOpen = tiledb.intp_value(ret) != 0;
        }
        finally {
            tiledb.delete_intp(ret);
        }
        return isOpen;
    }

    public void putMetadata(String key, NativeArray value) throws TileDBError {
        if (!this.isOpen()) {
            throw new TileDBError("Group with URI: " + this.uri + " is closed");
        }
        this.ctx.handleError(tiledb.tiledb_group_put_metadata(this.ctx.getCtxp(), this.getGroupp(), key, value.getNativeType().toSwigEnum(), value.getSize(), value.toVoidPointer()));
    }

    public void vacuumMetadata(Config config) throws TileDBError {
        SWIGTYPE_p_tiledb_config_t configp = null;
        try {
            configp = config.getConfigp();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.ctx.handleError(tiledb.tiledb_group_vacuum_metadata(this.ctx.getCtxp(), this.uri, configp));
    }

    public void consolidateMetadata(Config config) throws TileDBError {
        SWIGTYPE_p_tiledb_config_t configp = null;
        try {
            configp = config.getConfigp();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.ctx.handleError(tiledb.tiledb_group_consolidate_metadata(this.ctx.getCtxp(), this.uri, configp));
    }

    @Override
    public void close() {
        if (this.groupp != null && this.grouppp != null) {
            tiledb.tiledb_group_close(this.ctx.getCtxp(), this.groupp);
            tiledb.tiledb_group_free(this.grouppp);
            this.grouppp = null;
            this.groupp = null;
        }
    }

    public String getUri() throws TileDBError {
        return this.uri;
    }

    public void reopen(Context ctx, QueryType queryType) throws TileDBError {
        if (!this.isOpen()) {
            throw new TileDBError("Can not reopen group. Group is closed");
        }
        ctx.handleError(tiledb.tiledb_group_close(ctx.getCtxp(), this.groupp));
        this.ctx = ctx;
        this.open(queryType);
    }

    private void open(QueryType queryType) throws TileDBError {
        try {
            this.ctx.handleError(tiledb.tiledb_group_open(this.ctx.getCtxp(), this.groupp, queryType.toSwigEnum()));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_group_tpp(this.grouppp);
            throw err;
        }
    }

    public static void create(Context ctx, String uri) throws TileDBError {
        ctx.handleError(tiledb.tiledb_group_create(ctx.getCtxp(), uri));
    }
}

