/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.Config;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.Types;
import io.tiledb.java.api.Util;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_subarray_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_subarray_t;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_long_long;
import io.tiledb.libtiledb.tiledb;
import io.tiledb.libtiledb.uint64_tArray;
import java.math.BigInteger;

public class SubArray
implements AutoCloseable {
    private SWIGTYPE_p_tiledb_subarray_t subArrayp;
    private SWIGTYPE_p_p_tiledb_subarray_t subArraypp;
    private Context ctx;
    private Array array;

    public SubArray(Context ctx, Array array) throws TileDBError {
        this.ctx = ctx;
        this.array = array;
        this.subArraypp = tiledb.new_tiledb_subarray_tpp();
        try {
            ctx.handleError(tiledb.tiledb_subarray_alloc(ctx.getCtxp(), array.getArrayp(), this.subArraypp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_subarray_tpp(this.subArraypp);
            throw err;
        }
        this.subArrayp = tiledb.tiledb_subarray_tpp_value(this.subArraypp);
    }

    public SWIGTYPE_p_tiledb_subarray_t getSubArrayp() {
        return this.subArrayp;
    }

    public void setConfig(Config config) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_subarray_set_config(this.ctx.getCtxp(), this.subArrayp, config.getConfigp()));
    }

    public synchronized SubArray addRange(int dimIdx, Object start, Object end, Object stride) throws TileDBError {
        Datatype dimType;
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();){
            dimType = domain.getDimension(dimIdx).getType();
        }
        Types.javaTypeCheck(start.getClass(), dimType.javaClass());
        Types.javaTypeCheck(end.getClass(), dimType.javaClass());
        try (NativeArray startArr = new NativeArray(this.ctx, 1, dimType);
             NativeArray endArr = new NativeArray(this.ctx, 1, dimType);){
            startArr.setItem(0, start);
            endArr.setItem(0, end);
            this.ctx.handleError(tiledb.tiledb_subarray_add_range(this.ctx.getCtxp(), this.subArrayp, dimIdx, startArr.toVoidPointer(), endArr.toVoidPointer(), null));
        }
        return this;
    }

    public synchronized SubArray addPointRanges(int dimIdx, Object start, BigInteger count) throws TileDBError {
        int[] values;
        Datatype dimType;
        Util.checkBigIntegerRange(count);
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();){
            dimType = domain.getDimension(dimIdx).getType();
            values = (int[])start;
        }
        try (NativeArray arr = new NativeArray(this.ctx, values.length, dimType);){
            int i = 0;
            for (int value : values) {
                arr.setItem(i, value);
                ++i;
            }
            this.ctx.handleError(tiledb.tiledb_subarray_add_point_ranges(this.ctx.getCtxp(), this.subArrayp, dimIdx, arr.toVoidPointer(), count));
        }
        return this;
    }

    public synchronized SubArray addRangeByName(String name, Object start, Object end, Object stride) throws TileDBError {
        Datatype dimType;
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();){
            dimType = domain.getDimension(name).getType();
        }
        Types.javaTypeCheck(start.getClass(), dimType.javaClass());
        Types.javaTypeCheck(end.getClass(), dimType.javaClass());
        try (NativeArray startArr = new NativeArray(this.ctx, 1, dimType);
             NativeArray endArr = new NativeArray(this.ctx, 1, dimType);){
            startArr.setItem(0, start);
            endArr.setItem(0, end);
            this.ctx.handleError(tiledb.tiledb_subarray_add_range_by_name(this.ctx.getCtxp(), this.subArrayp, name, startArr.toVoidPointer(), endArr.toVoidPointer(), null));
        }
        return this;
    }

    public synchronized SubArray addRangeVar(int dimIdx, String start, String end) throws TileDBError {
        Datatype dimType;
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();){
            dimType = domain.getDimension(dimIdx).getType();
        }
        Types.javaTypeCheck(start.getClass(), dimType.javaClass());
        Types.javaTypeCheck(end.getClass(), dimType.javaClass());
        try (NativeArray startArr = new NativeArray(this.ctx, 1, dimType);
             NativeArray endArr = new NativeArray(this.ctx, 1, dimType);){
            startArr.setItem(0, start);
            endArr.setItem(0, end);
            this.ctx.handleError(tiledb.tiledb_subarray_add_range_var(this.ctx.getCtxp(), this.subArrayp, dimIdx, startArr.toVoidPointer(), BigInteger.valueOf(start.length()), endArr.toVoidPointer(), BigInteger.valueOf(end.length())));
        }
        return this;
    }

    public synchronized SubArray addRangeVarByName(String name, String start, String end) throws TileDBError {
        Datatype dimType;
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();){
            dimType = domain.getDimension(name).getType();
        }
        Types.javaTypeCheck(start.getClass(), dimType.javaClass());
        Types.javaTypeCheck(end.getClass(), dimType.javaClass());
        try (NativeArray startArr = new NativeArray(this.ctx, 1, dimType);
             NativeArray endArr = new NativeArray(this.ctx, 1, dimType);){
            startArr.setItem(0, start);
            endArr.setItem(0, end);
            this.ctx.handleError(tiledb.tiledb_subarray_add_range_var_by_name(this.ctx.getCtxp(), this.subArrayp, name, startArr.toVoidPointer(), BigInteger.valueOf(start.length()), endArr.toVoidPointer(), BigInteger.valueOf(end.length())));
        }
        return this;
    }

    public long getRangeNum(int dimIdx) throws TileDBError {
        uint64_tArray resultArr = new uint64_tArray(1);
        this.ctx.handleError(tiledb.tiledb_subarray_get_range_num(this.ctx.getCtxp(), this.subArrayp, dimIdx, resultArr.cast()));
        return resultArr.getitem(0).longValue();
    }

    public long getRangeNumFromName(String name) throws TileDBError {
        uint64_tArray resultArr = new uint64_tArray(1);
        this.ctx.handleError(tiledb.tiledb_subarray_get_range_num_from_name(this.ctx.getCtxp(), this.subArrayp, name, resultArr.cast()));
        return resultArr.getitem(0).longValue();
    }

    /*
     * Exception decompiling
     */
    public Pair<Object, Object> getRange(int dimIdx, long rangeIdx) throws TileDBError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Pair<Object, Object> getRangeFromName(String name, long rangeIdx) throws TileDBError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized Pair<Long, Long> getRangeVarSize(int dimIdx, BigInteger rangeIdx) throws TileDBError {
        Util.checkBigIntegerRange(rangeIdx);
        SWIGTYPE_p_unsigned_long_long startSize = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long endSize = tiledb.new_ullp();
        this.ctx.handleError(tiledb.tiledb_subarray_get_range_var_size(this.ctx.getCtxp(), this.subArrayp, dimIdx, rangeIdx, startSize, endSize));
        return new Pair<Long, Long>(tiledb.ullp_value(startSize).longValue(), tiledb.ullp_value(endSize).longValue());
    }

    public synchronized Pair<Long, Long> getRangeVarSizeByName(String name, BigInteger rangeIdx) throws TileDBError {
        Util.checkBigIntegerRange(rangeIdx);
        SWIGTYPE_p_unsigned_long_long startSize = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long endSize = tiledb.new_ullp();
        this.ctx.handleError(tiledb.tiledb_subarray_get_range_var_size_from_name(this.ctx.getCtxp(), this.subArrayp, name, rangeIdx, startSize, endSize));
        return new Pair<Long, Long>(tiledb.ullp_value(startSize).longValue(), tiledb.ullp_value(endSize).longValue());
    }

    public synchronized Pair<String, String> getRangeVar(int dimIdx, BigInteger rangeIdx) throws TileDBError {
        Datatype dimType;
        Util.checkBigIntegerRange(rangeIdx);
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();){
            dimType = domain.getDimension(dimIdx).getType();
        }
        Pair<Long, Long> size = this.getRangeVarSize(dimIdx, rangeIdx);
        try (NativeArray startArr = new NativeArray(this.ctx, size.getFirst().intValue(), dimType);){
            NativeArray endArr = new NativeArray(this.ctx, size.getSecond().intValue(), dimType);
            try {
                this.ctx.handleError(tiledb.tiledb_subarray_get_range_var(this.ctx.getCtxp(), this.subArrayp, dimIdx, rangeIdx, startArr.toVoidPointer(), endArr.toVoidPointer()));
                String start = new String((byte[])startArr.toJavaArray());
                String end = new String((byte[])endArr.toJavaArray());
                Pair<String, String> pair = new Pair<String, String>(start, end);
                endArr.close();
                return pair;
            }
            catch (Throwable throwable) {
                try {
                    endArr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public synchronized Pair<String, String> getRangeVarByName(String name, BigInteger rangeIdx) throws TileDBError {
        Datatype dimType;
        Util.checkBigIntegerRange(rangeIdx);
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();){
            dimType = domain.getDimension(name).getType();
        }
        Pair<Long, Long> size = this.getRangeVarSizeByName(name, rangeIdx);
        try (NativeArray startArr = new NativeArray(this.ctx, size.getFirst().intValue(), dimType);){
            NativeArray endArr = new NativeArray(this.ctx, size.getSecond().intValue(), dimType);
            try {
                this.ctx.handleError(tiledb.tiledb_subarray_get_range_var_from_name(this.ctx.getCtxp(), this.subArrayp, name, rangeIdx, startArr.toVoidPointer(), endArr.toVoidPointer()));
                String start = new String((byte[])startArr.toJavaArray());
                String end = new String((byte[])endArr.toJavaArray());
                Pair<String, String> pair = new Pair<String, String>(start, end);
                endArr.close();
                return pair;
            }
            catch (Throwable throwable) {
                try {
                    endArr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public void setCoalesceRanges(boolean flag) throws TileDBError {
        int coalesce = flag ? 1 : 0;
        this.ctx.handleError(tiledb.tiledb_subarray_set_coalesce_ranges(this.ctx.getCtxp(), this.subArrayp, coalesce));
    }

    public synchronized SubArray setSubarray(NativeArray subarray) throws TileDBError {
        Types.typeCheck(subarray.getNativeType(), this.array.getSchema().getDomain().getType());
        this.ctx.handleError(tiledb.tiledb_subarray_set_subarray(this.ctx.getCtxp(), this.subArrayp, subarray.toVoidPointer()));
        return this;
    }

    @Override
    public void close() throws Exception {
        if (this.subArrayp != null && this.subArraypp != null) {
            tiledb.tiledb_subarray_free(this.subArraypp);
            this.subArrayp = null;
            this.subArraypp = null;
            if (this.array != null) {
                this.array.close();
            }
        }
    }
}

