/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.Attribute;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.TileDBError;
import java.math.BigInteger;
import java.util.Arrays;

public class Util {
    public static String[] bytesToStrings(long[] offsets, byte[] data) {
        String[] results = new String[offsets.length];
        int start = 0;
        for (int i = 0; i < offsets.length; ++i) {
            int end;
            if (i < offsets.length - 1) {
                end = (int)offsets[i + 1];
                results[i] = new String(Arrays.copyOfRange(data, start, end));
                start = end;
                continue;
            }
            end = data.length;
            results[i] = new String(Arrays.copyOfRange(data, start, end));
        }
        return results;
    }

    public static int castLongToInt(long num) throws TileDBError {
        if (num > Integer.MAX_VALUE) {
            throw new TileDBError(num + " is larger that the integer max value");
        }
        return (int)num;
    }

    public static boolean checkBigIntegerRange(BigInteger bigInteger) throws TileDBError {
        BigInteger upperLimit = new BigInteger("18446744073709551615");
        if (bigInteger.compareTo(upperLimit) > 0 || bigInteger.compareTo(BigInteger.valueOf(-1L)) <= 0) {
            throw new TileDBError(bigInteger + " is outside the uint64 range");
        }
        return true;
    }

    public static Datatype getFieldDatatype(Array array, String fieldName) throws TileDBError {
        Datatype dt;
        block19: {
            try (ArraySchema schema = array.getSchema();
                 Domain domain = schema.getDomain();){
                if (domain.hasDimension(fieldName)) {
                    dt = domain.getDimension(fieldName).getType();
                    break block19;
                }
                try (Attribute attribute = schema.getAttribute(fieldName);){
                    dt = attribute.getType();
                }
            }
        }
        return dt;
    }
}

