/*
 * Decompiled with CFR 0.152.
 */
package examples.io.tiledb.java.api;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.ArrayType;
import io.tiledb.java.api.Attribute;
import io.tiledb.java.api.Constants;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Dimension;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.FilterList;
import io.tiledb.java.api.GzipFilter;
import io.tiledb.java.api.LZ4Filter;
import io.tiledb.java.api.Layout;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.ZstdFilter;

public class DenseCreate {
    public static void main(String[] args) throws Exception {
        Context ctx = new Context();
        Dimension<Long> d1 = new Dimension<Long>(ctx, "d1", Long.class, new Pair<Long, Long>(1L, 4L), Long.valueOf(2L));
        Dimension<Long> d2 = new Dimension<Long>(ctx, "d2", Long.class, new Pair<Long, Long>(1L, 4L), Long.valueOf(2L));
        Domain domain = new Domain(ctx);
        domain.addDimension(d1);
        domain.addDimension(d2);
        Attribute a1 = new Attribute(ctx, "a1", Integer.class);
        Attribute a2 = new Attribute(ctx, "a2", String.class);
        a2.setCellValNum(Constants.TILEDB_VAR_NUM);
        Attribute a3 = new Attribute(ctx, "a3", Float.class);
        a3.setCellValNum(2L);
        a1.setFilterList(new FilterList(ctx).addFilter(new LZ4Filter(ctx)));
        a2.setFilterList(new FilterList(ctx).addFilter(new GzipFilter(ctx)));
        a3.setFilterList(new FilterList(ctx).addFilter(new ZstdFilter(ctx)));
        ArraySchema schema = new ArraySchema(ctx, ArrayType.TILEDB_DENSE);
        schema.setTileOrder(Layout.TILEDB_ROW_MAJOR);
        schema.setCellOrder(Layout.TILEDB_ROW_MAJOR);
        schema.setDomain(domain);
        schema.addAttribute(a1);
        schema.addAttribute(a2);
        schema.addAttribute(a3);
        schema.check();
        schema.dump();
        Array.create("my_dense_array", schema);
    }
}

