/*
 * Decompiled with CFR 0.152.
 */
package examples.io.tiledb.java.api;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Layout;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.Query;
import io.tiledb.java.api.QueryType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SparseReadGlobal {
    public static void main(String[] args) throws Exception {
        Context ctx = new Context();
        Array my_sparse_array = new Array(ctx, "my_sparse_array");
        HashMap<String, Pair> dom = my_sparse_array.nonEmptyDomain();
        for (Map.Entry<String, Pair> e : dom.entrySet()) {
            System.out.println(e.getKey() + ": (" + e.getValue().getFirst() + ", " + e.getValue().getSecond() + ")");
        }
        NativeArray subarray = new NativeArray(ctx, (Object)new long[]{1L, 4L, 1L, 4L}, Long.class);
        Query query = new Query(my_sparse_array, QueryType.TILEDB_READ);
        query.setLayout(Layout.TILEDB_GLOBAL_ORDER);
        query.setSubarray(subarray);
        HashMap<String, Pair<Long, Long>> max_sizes = query.getResultEstimations();
        for (Map.Entry<String, Pair<Long, Long>> e : max_sizes.entrySet()) {
            System.out.println(e.getKey() + " (" + e.getValue().getFirst() + ", " + e.getValue().getSecond() + ")");
        }
        query.setBuffer("a1", new NativeArray(ctx, max_sizes.get("a1").getSecond().intValue(), Integer.class));
        query.setBuffer("a2", new NativeArray(ctx, max_sizes.get("a2").getFirst().intValue(), Datatype.TILEDB_UINT64), new NativeArray(ctx, max_sizes.get("a2").getSecond().intValue(), String.class));
        query.setBuffer("a3", new NativeArray(ctx, max_sizes.get("a3").getSecond().intValue(), Float.class));
        query.setBuffer("d1", new NativeArray(ctx, max_sizes.get("d1").getSecond().intValue(), Long.class));
        query.setBuffer("d2", new NativeArray(ctx, max_sizes.get("d2").getSecond().intValue(), Long.class));
        System.out.println("Query submitted: " + (Object)((Object)query.submit()));
        HashMap<String, Pair<Long, Long>> result_el = query.resultBufferElements();
        int[] a1_buff = (int[])query.getBuffer("a1");
        long[] a2_offsets = query.getVarBuffer("a2");
        byte[] a2_data = (byte[])query.getBuffer("a2");
        float[] a3_buff = (float[])query.getBuffer("a3");
        long[] d1_buff = (long[])query.getBuffer("d1");
        long[] d2_buff = (long[])query.getBuffer("d2");
        System.out.println("Result num: " + a1_buff.length);
        System.out.println("d1" + String.format("%9s", "d2") + String.format("%9s", "a1") + String.format("%11s", "a2") + String.format("%11s", "a3[0]") + String.format("%10s", "a3[1]"));
        for (int i = 0; i < a1_buff.length; ++i) {
            int end = i == a1_buff.length - 1 ? a2_data.length : (int)a2_offsets[i + 1];
            System.out.println(String.format("%8s", "(" + d1_buff[2 * i] + ", " + d2_buff[2 * i] + ")") + String.format("%9s", a1_buff[i]) + String.format("%11s", new String(Arrays.copyOfRange(a2_data, (int)a2_offsets[i], end))) + String.format("%11s", Float.valueOf(a3_buff[2 * i])) + String.format("%10s", Float.valueOf(a3_buff[2 * i + 1])));
        }
    }
}

