/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.Config;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.EncryptionType;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.TileDBError;
import io.tiledb.libtiledb.SWIGTYPE_p_int;
import io.tiledb.libtiledb.SWIGTYPE_p_p_char;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_fragment_info_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_fragment_info_t;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_int;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_long_long;
import io.tiledb.libtiledb.tiledb;

public class FragmentInfo {
    private SWIGTYPE_p_tiledb_fragment_info_t fragmentInfop;
    private SWIGTYPE_p_p_tiledb_fragment_info_t fragmentInfopp;
    private Context ctx;
    private String uri;

    public FragmentInfo(Context ctx, String uri) throws TileDBError {
        this.ctx = ctx;
        this.uri = uri;
        this.fragmentInfopp = tiledb.new_tiledb_fragment_info_tpp();
        ctx.handleError(tiledb.tiledb_fragment_info_alloc(ctx.getCtxp(), uri, this.fragmentInfopp));
        this.fragmentInfop = tiledb.tiledb_fragment_info_tpp_value(this.fragmentInfopp);
        ctx.handleError(tiledb.tiledb_fragment_info_load(ctx.getCtxp(), this.fragmentInfop));
    }

    public FragmentInfo(Context ctx, String uri, EncryptionType encryptionType, String key) throws TileDBError {
        this.ctx = ctx;
        this.uri = uri;
        this.fragmentInfopp = tiledb.new_tiledb_fragment_info_tpp();
        try (NativeArray keyArray = new NativeArray(ctx, (Object)key, Byte.class);){
            ctx.handleError(tiledb.tiledb_fragment_info_load_with_key(ctx.getCtxp(), this.fragmentInfop, encryptionType.toSwigEnum(), keyArray.toVoidPointer(), keyArray.getSize()));
        }
    }

    public void setConfig(Config config) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_fragment_info_set_config(this.ctx.getCtxp(), this.fragmentInfop, config.getConfigp()));
    }

    public Pair<Long, Long> getNonEmptyDomainVarSizeFromIndex(long fragmentID, long dimensionID) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long startSize = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long endSize = tiledb.new_ullp();
        this.ctx.handleError(tiledb.tiledb_fragment_info_get_non_empty_domain_var_size_from_index(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, dimensionID, startSize, endSize));
        return new Pair<Long, Long>(tiledb.ullp_value(startSize).longValue(), tiledb.ullp_value(endSize).longValue());
    }

    public Pair<Long, Long> getNonEmptyDomainVarSizeFromName(long fragmentID, String dimensionName) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long startSize = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long endSize = tiledb.new_ullp();
        this.ctx.handleError(tiledb.tiledb_fragment_info_get_non_empty_domain_var_size_from_name(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, dimensionName, startSize, endSize));
        return new Pair<Long, Long>(tiledb.ullp_value(startSize).longValue(), tiledb.ullp_value(endSize).longValue());
    }

    public long getFragmentNum() throws TileDBError {
        SWIGTYPE_p_unsigned_int num = tiledb.new_uintp();
        this.ctx.handleError(tiledb.tiledb_fragment_info_get_fragment_num(this.ctx.getCtxp(), this.fragmentInfop, num));
        return tiledb.uintp_value(num);
    }

    public String getFragmentURI(long fragmentID) throws TileDBError {
        SWIGTYPE_p_p_char uri = tiledb.new_charpp();
        tiledb.tiledb_fragment_info_get_fragment_uri(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, uri);
        return tiledb.charpp_value(uri);
    }

    public long getFragmentSize(long fragmentID) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long size = tiledb.new_ullp();
        tiledb.tiledb_fragment_info_get_fragment_size(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, size);
        return tiledb.ullp_value(size).longValue();
    }

    public boolean getDense(long fragmentID) throws TileDBError {
        SWIGTYPE_p_int size = tiledb.new_intp();
        tiledb.tiledb_fragment_info_get_dense(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, size);
        return tiledb.intp_value(size) == 1;
    }

    public boolean getSparse(long fragmentID) throws TileDBError {
        SWIGTYPE_p_int size = tiledb.new_intp();
        tiledb.tiledb_fragment_info_get_sparse(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, size);
        return tiledb.intp_value(size) == 1;
    }

    public Pair<Long, Long> getTimestampRange(long fragmentID) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long start = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long end = tiledb.new_ullp();
        this.ctx.handleError(tiledb.tiledb_fragment_info_get_timestamp_range(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, start, end));
        return new Pair<Long, Long>(tiledb.ullp_value(start).longValue(), tiledb.ullp_value(end).longValue());
    }

    public Pair getNonEmptyDomainFromIndex(long fragmentID, long dimensionID) throws TileDBError {
        try (Array arr = new Array(this.ctx, this.uri);){
            Datatype type = arr.getSchema().getDomain().getDimension(dimensionID).getType();
            NativeArray array = new NativeArray(this.ctx, 2, type);
            try {
                this.ctx.handleError(tiledb.tiledb_fragment_info_get_non_empty_domain_from_index(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, dimensionID, array.toVoidPointer()));
                Pair<Object, Object> pair = new Pair<Object, Object>(array.getItem(0), array.getItem(1));
                array.close();
                return pair;
            }
            catch (Throwable throwable) {
                try {
                    array.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public Pair getNonEmptyDomainFromName(long fragmentID, String dimensionName) throws TileDBError {
        try (Array arr = new Array(this.ctx, this.uri);){
            Datatype type = arr.getSchema().getDomain().getDimension(dimensionName).getType();
            NativeArray array = new NativeArray(this.ctx, 2, type);
            try {
                this.ctx.handleError(tiledb.tiledb_fragment_info_get_non_empty_domain_from_name(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, dimensionName, array.toVoidPointer()));
                Pair<Object, Object> pair = new Pair<Object, Object>(array.getItem(0), array.getItem(1));
                array.close();
                return pair;
            }
            catch (Throwable throwable) {
                try {
                    array.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public Pair getNonEmptyDomainVarFromIndex(long fragmentID, long dimensionID) throws TileDBError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Pair getNonEmptyDomainVarFromName(long fragmentID, String dimensionName) throws TileDBError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long getCellNum(long fragmentID) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long cellNum = tiledb.new_ullp();
        this.ctx.handleError(tiledb.tiledb_fragment_info_get_cell_num(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, cellNum));
        return tiledb.ullp_value(cellNum).longValue();
    }

    public long getVersion(long fragmentID) throws TileDBError {
        SWIGTYPE_p_unsigned_int version = tiledb.new_uintp();
        this.ctx.handleError(tiledb.tiledb_fragment_info_get_version(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, version));
        return tiledb.uintp_value(version);
    }

    public boolean hasConsolidatedMetadata(long fragmentID) throws TileDBError {
        SWIGTYPE_p_int has = tiledb.new_intp();
        this.ctx.handleError(tiledb.tiledb_fragment_info_has_consolidated_metadata(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, has));
        return tiledb.intp_value(has) == 1;
    }

    public long getUnconsolidatedMetadataNum() throws TileDBError {
        SWIGTYPE_p_unsigned_int unconsolidated = tiledb.new_uintp();
        this.ctx.handleError(tiledb.tiledb_fragment_info_get_unconsolidated_metadata_num(this.ctx.getCtxp(), this.fragmentInfop, unconsolidated));
        return tiledb.uintp_value(unconsolidated);
    }

    public long getToVacuumNum() throws TileDBError {
        SWIGTYPE_p_unsigned_int toVacuumNum = tiledb.new_uintp();
        this.ctx.handleError(tiledb.tiledb_fragment_info_get_to_vacuum_num(this.ctx.getCtxp(), this.fragmentInfop, toVacuumNum));
        return tiledb.uintp_value(toVacuumNum);
    }

    public String getToVacuumUri(long fragmentID) throws TileDBError {
        SWIGTYPE_p_p_char uri = tiledb.new_charpp();
        this.ctx.handleError(tiledb.tiledb_fragment_info_get_to_vacuum_uri(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, uri));
        return tiledb.charpp_value(uri);
    }

    public String dump() throws TileDBError {
        SWIGTYPE_p_p_char uri = tiledb.new_charpp();
        this.ctx.handleError(tiledb.tiledb_fragment_info_dump_stdout(this.ctx.getCtxp(), this.fragmentInfop));
        return tiledb.charpp_value(uri);
    }

    public long getMBRNum(long fragmentID) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long numFrags = tiledb.new_ullp();
        this.ctx.handleError(tiledb.tiledb_fragment_info_get_mbr_num(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, numFrags));
        return tiledb.ullp_value(numFrags).longValue();
    }

    public long[] getMBRFromIndex(long fragmentID, long dimensionID, long mid) throws TileDBError {
        long[] mbr;
        try (NativeArray mbrArray = new NativeArray(this.ctx, 2, Long.class);){
            this.ctx.handleError(tiledb.tiledb_fragment_info_get_mbr_from_index(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, mid, dimensionID, mbrArray.toVoidPointer()));
            mbr = (long[])mbrArray.toJavaArray();
        }
        return mbr;
    }

    public long[] getMBRFromName(long fragmentID, String dimName, long mid) throws TileDBError {
        long[] mbr;
        try (NativeArray mbrArray = new NativeArray(this.ctx, 2, Long.class);){
            this.ctx.handleError(tiledb.tiledb_fragment_info_get_mbr_from_name(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, mid, dimName, mbrArray.toVoidPointer()));
            mbr = (long[])mbrArray.toJavaArray();
        }
        return mbr;
    }

    public Pair<Long, Long> getMBRVarSizeFromIndex(long fragmentID, long dimId, long mid) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long startSize = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long endSize = tiledb.new_ullp();
        this.ctx.handleError(tiledb.tiledb_fragment_info_get_mbr_var_size_from_index(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, mid, dimId, startSize, endSize));
        return new Pair<Long, Long>(tiledb.ullp_value(startSize).longValue(), tiledb.ullp_value(endSize).longValue());
    }

    public Pair<Long, Long> getMBRVarSizeFromName(long fragmentID, String dimName, long mid) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long startSize = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long endSize = tiledb.new_ullp();
        this.ctx.handleError(tiledb.tiledb_fragment_info_get_mbr_var_size_from_name(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, mid, dimName, startSize, endSize));
        return new Pair<Long, Long>(tiledb.ullp_value(startSize).longValue(), tiledb.ullp_value(endSize).longValue());
    }

    public Pair<String, String> getMBRVarFromIndex(long fragmentID, long dimId, long mid) throws TileDBError {
        Pair<Long, Long> size = this.getMBRVarSizeFromIndex(fragmentID, dimId, mid);
        try (NativeArray start = new NativeArray(this.ctx, size.getFirst().intValue(), String.class);){
            NativeArray end = new NativeArray(this.ctx, size.getSecond().intValue(), String.class);
            try {
                this.ctx.handleError(tiledb.tiledb_fragment_info_get_mbr_var_from_index(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, mid, dimId, start.toVoidPointer(), end.toVoidPointer()));
                String st = new String((byte[])start.toJavaArray());
                String e = new String((byte[])end.toJavaArray());
                Pair<String, String> pair = new Pair<String, String>(st, e);
                end.close();
                return pair;
            }
            catch (Throwable throwable) {
                try {
                    end.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public Pair<String, String> getMBRVarFromName(long fragmentID, String dimName, long mid) throws TileDBError {
        Pair<Long, Long> size = this.getMBRVarSizeFromName(fragmentID, dimName, mid);
        try (NativeArray start = new NativeArray(this.ctx, size.getFirst().intValue(), String.class);){
            NativeArray end = new NativeArray(this.ctx, size.getSecond().intValue(), String.class);
            try {
                this.ctx.handleError(tiledb.tiledb_fragment_info_get_mbr_var_from_name(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, mid, dimName, start.toVoidPointer(), end.toVoidPointer()));
                String st = new String((byte[])start.toJavaArray());
                String e = new String((byte[])end.toJavaArray());
                Pair<String, String> pair = new Pair<String, String>(st, e);
                end.close();
                return pair;
            }
            catch (Throwable throwable) {
                try {
                    end.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public String getArraySchemaName(long fragmentID) throws TileDBError {
        SWIGTYPE_p_p_char name = tiledb.new_charpp();
        this.ctx.handleError(tiledb.tiledb_fragment_info_get_array_schema_name(this.ctx.getCtxp(), this.fragmentInfop, fragmentID, name));
        return tiledb.charpp_value(name);
    }
}

