/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Array;
import io.tiledb.java.api.ArraySchema;
import io.tiledb.java.api.Attribute;
import io.tiledb.java.api.Callback;
import io.tiledb.java.api.Config;
import io.tiledb.java.api.Context;
import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.Dimension;
import io.tiledb.java.api.Domain;
import io.tiledb.java.api.Layout;
import io.tiledb.java.api.NativeArray;
import io.tiledb.java.api.Pair;
import io.tiledb.java.api.QueryCondition;
import io.tiledb.java.api.QueryStatus;
import io.tiledb.java.api.QueryType;
import io.tiledb.java.api.SubArray;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.Types;
import io.tiledb.java.api.Util;
import io.tiledb.libtiledb.PointerUtils;
import io.tiledb.libtiledb.SWIGTYPE_p_p_char;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_config_t;
import io.tiledb.libtiledb.SWIGTYPE_p_p_tiledb_query_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_query_condition_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_query_status_t;
import io.tiledb.libtiledb.SWIGTYPE_p_tiledb_query_t;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_int;
import io.tiledb.libtiledb.SWIGTYPE_p_unsigned_long_long;
import io.tiledb.libtiledb.Utils;
import io.tiledb.libtiledb.tiledb;
import io.tiledb.libtiledb.uint64_tArray;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Query
implements AutoCloseable {
    private Context ctx;
    private Array array;
    private QueryType type;
    private SWIGTYPE_p_p_tiledb_query_t querypp;
    private SWIGTYPE_p_tiledb_query_t queryp;
    private NativeArray subarray;
    private Map<String, Pair<ByteBuffer, ByteBuffer>> byteBuffers_;
    private Map<String, Pair<NativeArray, NativeArray>> buffers_;
    private Map<String, Pair<uint64_tArray, uint64_tArray>> buffer_sizes_;
    private Map<String, NativeArray> validityByteMaps_;
    private Map<String, ByteBuffer> validityByteMapsByteBuffers_;
    private Map<String, uint64_tArray> validityByteMapSizes_;

    public Query(Array array, QueryType type) throws TileDBError {
        Context _ctx = array.getCtx();
        SWIGTYPE_p_p_tiledb_query_t _querypp = tiledb.new_tiledb_query_tpp();
        try {
            _ctx.handleError(tiledb.tiledb_query_alloc(_ctx.getCtxp(), array.getArrayp(), type.toSwigEnum(), _querypp));
        }
        catch (TileDBError err) {
            tiledb.delete_tiledb_query_tpp(_querypp);
            throw err;
        }
        this.ctx = _ctx;
        this.type = type;
        this.array = array;
        this.querypp = _querypp;
        this.queryp = tiledb.tiledb_query_tpp_value(_querypp);
        this.buffers_ = Collections.synchronizedMap(new HashMap());
        this.byteBuffers_ = Collections.synchronizedMap(new HashMap());
        this.buffer_sizes_ = Collections.synchronizedMap(new HashMap());
        this.validityByteMaps_ = Collections.synchronizedMap(new HashMap());
        this.validityByteMapsByteBuffers_ = Collections.synchronizedMap(new HashMap());
        this.validityByteMapSizes_ = Collections.synchronizedMap(new HashMap());
    }

    public Query(Array array) throws TileDBError {
        this(array, array.getQueryType());
    }

    public synchronized Query setLayout(Layout layout) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_query_set_layout(this.ctx.getCtxp(), this.queryp, layout.toSwigEnum()));
        return this;
    }

    public QueryStatus getQueryStatus() throws TileDBError {
        QueryStatus status;
        SWIGTYPE_p_tiledb_query_status_t statusp = tiledb.new_tiledb_query_status_tp();
        try {
            this.ctx.handleError(tiledb.tiledb_query_get_status(this.ctx.getCtxp(), this.queryp, statusp));
            status = QueryStatus.fromSwigEnum(tiledb.tiledb_query_status_tp_value(statusp));
        }
        finally {
            tiledb.delete_tiledb_query_status_tp(statusp);
        }
        return status;
    }

    public QueryStatus submit() throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_query_submit(this.ctx.getCtxp(), this.queryp));
        for (String attribute : this.byteBuffers_.keySet()) {
            boolean isVar;
            block21: {
                try (ArraySchema arraySchema = this.array.getSchema();){
                    if (arraySchema.hasAttribute(attribute)) {
                        try (Attribute attr = arraySchema.getAttribute(attribute);){
                            isVar = attr.isVar();
                            break block21;
                        }
                    }
                    try (Dimension dim = arraySchema.getDomain().getDimension(attribute);){
                        isVar = dim.isVar();
                    }
                }
            }
            if (isVar) {
                int offset_nbytes = this.buffer_sizes_.get(attribute).getFirst().getitem(0).intValue();
                int data_nbytes = this.buffer_sizes_.get(attribute).getSecond().getitem(0).intValue();
                this.byteBuffers_.get(attribute).getFirst().limit(offset_nbytes);
                this.byteBuffers_.get(attribute).getSecond().limit(data_nbytes);
                continue;
            }
            int nbytes = this.buffer_sizes_.get(attribute).getSecond().getitem(0).intValue();
            this.byteBuffers_.get(attribute).getSecond().limit(nbytes);
        }
        return this.getQueryStatus();
    }

    public void submitAsync() throws TileDBError {
        this.submitAsync(new DefaultCallback());
    }

    public void submitAsync(Callback callback) throws TileDBError {
        this.ctx.handleError(Utils.tiledb_query_submit_async(this.ctx.getCtxp(), this.queryp, callback));
    }

    public synchronized Query setSubarray(NativeArray subarray) throws TileDBError {
        Types.typeCheck(subarray.getNativeType(), this.array.getSchema().getDomain().getType());
        this.ctx.handleError(tiledb.tiledb_query_set_subarray(this.ctx.getCtxp(), this.queryp, subarray.toVoidPointer()));
        if (this.subarray != null) {
            this.subarray.close();
        }
        this.subarray = subarray;
        return this;
    }

    public synchronized Query setSubarray(SubArray subarray) throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_query_set_subarray_t(this.ctx.getCtxp(), this.queryp, subarray.getSubArrayp()));
        if (this.subarray != null) {
            this.subarray.close();
        }
        return this;
    }

    public synchronized Query setSubarray(ByteBuffer subarray) throws TileDBError {
        this.ctx.handleError(Utils.tiledb_query_set_subarray_nio(this.ctx.getCtxp(), this.queryp, subarray));
        return this;
    }

    public synchronized Query addPointRanges(int dimIdx, Object start, BigInteger count) throws TileDBError {
        int[] values;
        Datatype dimType;
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();){
            dimType = domain.getDimension(dimIdx).getType();
            values = (int[])start;
        }
        try (NativeArray arr = new NativeArray(this.ctx, values.length, dimType);){
            int i = 0;
            for (int value : values) {
                arr.setItem(i, value);
                ++i;
            }
            this.ctx.handleError(tiledb.tiledb_query_add_point_ranges(this.ctx.getCtxp(), this.queryp, dimIdx, arr.toVoidPointer(), count));
        }
        return this;
    }

    public synchronized Query addRange(int dimIdx, Object start, Object end) throws TileDBError {
        Datatype dimType;
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();){
            dimType = domain.getDimension(dimIdx).getType();
        }
        Types.javaTypeCheck(start.getClass(), dimType.javaClass());
        Types.javaTypeCheck(end.getClass(), dimType.javaClass());
        try (NativeArray startArr = new NativeArray(this.ctx, 1, dimType);
             NativeArray endArr = new NativeArray(this.ctx, 1, dimType);){
            startArr.setItem(0, start);
            endArr.setItem(0, end);
            this.ctx.handleError(tiledb.tiledb_query_add_range(this.ctx.getCtxp(), this.queryp, dimIdx, startArr.toVoidPointer(), endArr.toVoidPointer(), null));
        }
        return this;
    }

    public synchronized Query addRangeVar(int dimIdx, String start, String end) throws TileDBError {
        Datatype dimType;
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();){
            dimType = domain.getDimension(dimIdx).getType();
        }
        Types.javaTypeCheck(start.getClass(), dimType.javaClass());
        Types.javaTypeCheck(end.getClass(), dimType.javaClass());
        try (NativeArray startArr = new NativeArray(this.ctx, 1, dimType);
             NativeArray endArr = new NativeArray(this.ctx, 1, dimType);){
            startArr.setItem(0, start);
            endArr.setItem(0, end);
            this.ctx.handleError(tiledb.tiledb_query_add_range_var(this.ctx.getCtxp(), this.queryp, dimIdx, startArr.toVoidPointer(), BigInteger.valueOf(start.length()), endArr.toVoidPointer(), BigInteger.valueOf(end.length())));
        }
        return this;
    }

    public synchronized Pair<Long, Long> getRangeVarSize(int dimIdx, BigInteger rangeIdx) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long startSize = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long endSize = tiledb.new_ullp();
        this.ctx.handleError(tiledb.tiledb_query_get_range_var_size(this.ctx.getCtxp(), this.queryp, dimIdx, rangeIdx, startSize, endSize));
        return new Pair<Long, Long>(tiledb.ullp_value(startSize).longValue(), tiledb.ullp_value(endSize).longValue());
    }

    public synchronized Pair<String, String> getRangeVar(int dimIdx, BigInteger rangeIdx) throws TileDBError {
        Datatype dimType;
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();){
            dimType = domain.getDimension(dimIdx).getType();
        }
        Pair<Long, Long> size = this.getRangeVarSize(dimIdx, rangeIdx);
        try (NativeArray startArr = new NativeArray(this.ctx, size.getFirst().intValue(), dimType);){
            NativeArray endArr = new NativeArray(this.ctx, size.getSecond().intValue(), dimType);
            try {
                this.ctx.handleError(tiledb.tiledb_query_get_range_var(this.ctx.getCtxp(), this.queryp, dimIdx, rangeIdx, startArr.toVoidPointer(), endArr.toVoidPointer()));
                String start = new String((byte[])startArr.toJavaArray());
                String end = new String((byte[])endArr.toJavaArray());
                Pair<String, String> pair = new Pair<String, String>(start, end);
                endArr.close();
                return pair;
            }
            catch (Throwable throwable) {
                try {
                    endArr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public synchronized long getEstResultSize(Context ctx, String column) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long size = tiledb.new_ullp();
        ctx.handleError(tiledb.tiledb_query_get_est_result_size(ctx.getCtxp(), this.queryp, column, size));
        return tiledb.ullp_value(size).longValue();
    }

    public synchronized Pair<Long, Long> getEstResultSizeVar(Context ctx, String column) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long offsetsSize = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long dataSize = tiledb.new_ullp();
        ctx.handleError(tiledb.tiledb_query_get_est_result_size_var(ctx.getCtxp(), this.queryp, column, offsetsSize, dataSize));
        return new Pair<Long, Long>(tiledb.ullp_value(offsetsSize).longValue(), tiledb.ullp_value(dataSize).longValue());
    }

    public synchronized Pair<Pair<Long, Long>, Long> getEstResultSizeVarNullable(Context ctx, String column) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long size = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long offsets = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long validity = tiledb.new_ullp();
        ctx.handleError(tiledb.tiledb_query_get_est_result_size_var_nullable(ctx.getCtxp(), this.queryp, column, offsets, size, validity));
        return new Pair<Pair<Long, Long>, Long>(new Pair<Long, Long>(tiledb.ullp_value(offsets).longValue(), tiledb.ullp_value(size).longValue()), tiledb.ullp_value(validity).longValue());
    }

    public synchronized Pair<Long, Long> getEstResultSizeNullable(Context ctx, String column) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long size = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long validity = tiledb.new_ullp();
        ctx.handleError(tiledb.tiledb_query_get_est_result_size_nullable(ctx.getCtxp(), this.queryp, column, size, validity));
        return new Pair<Long, Long>(tiledb.ullp_value(size).longValue(), tiledb.ullp_value(validity).longValue());
    }

    public long getRangeNum(int dimIdx) throws TileDBError {
        uint64_tArray resultArr = new uint64_tArray(1);
        this.ctx.handleError(tiledb.tiledb_query_get_range_num(this.ctx.getCtxp(), this.queryp, dimIdx, resultArr.cast()));
        return resultArr.getitem(0).longValue();
    }

    /*
     * Exception decompiling
     */
    public Pair<Object, Object> getRange(int dimIdx, long rangeIdx) throws TileDBError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized Query setBuffer(String attr, NativeArray buffer) throws TileDBError {
        block21: {
            try (ArraySchema schema = this.array.getSchema();
                 Domain domain = schema.getDomain();){
                if (attr.equals(tiledb.tiledb_coords())) {
                    Types.typeCheck(domain.getDimension(attr).getType(), buffer.getNativeType());
                    break block21;
                }
                if (domain.hasDimension(attr)) {
                    Types.typeCheck(domain.getDimension(attr).getType(), buffer.getNativeType());
                    break block21;
                }
                try (Attribute attribute = schema.getAttribute(attr);){
                    Types.typeCheck(attribute.getType(), buffer.getNativeType());
                }
            }
        }
        uint64_tArray offsets_array_size = new uint64_tArray(1);
        uint64_tArray values_array_size = new uint64_tArray(1);
        offsets_array_size.setitem(0, BigInteger.valueOf(0L));
        values_array_size.setitem(0, BigInteger.valueOf(buffer.getNBytes()));
        Pair<uint64_tArray, uint64_tArray> buffer_sizes = new Pair<uint64_tArray, uint64_tArray>(offsets_array_size, values_array_size);
        if (this.buffers_.containsKey(attr)) {
            this.buffers_.get(attr).getSecond().close();
        }
        this.buffers_.put(attr, new Pair<Object, NativeArray>(null, buffer));
        this.buffer_sizes_.put(attr, buffer_sizes);
        uint64_tArray buffer_size = buffer_sizes.getSecond();
        this.ctx.handleError(tiledb.tiledb_query_set_buffer(this.ctx.getCtxp(), this.queryp, attr, buffer.toVoidPointer(), buffer_size.cast()));
        return this;
    }

    public synchronized Query setBuffer(String attr, NativeArray buffer, long bufferElements) throws TileDBError {
        block23: {
            if (bufferElements <= 0L) {
                throw new TileDBError("Number of buffer elements must be >= 1");
            }
            if (bufferElements > (long)buffer.getSize()) {
                throw new TileDBError("Number of elements requested exceeds the number of elements in allocated buffer: " + bufferElements + " > " + buffer.getSize());
            }
            try (ArraySchema schema = this.array.getSchema();
                 Domain domain = schema.getDomain();){
                if (attr.equals(tiledb.tiledb_coords())) {
                    Types.typeCheck(domain.getDimension(attr).getType(), buffer.getNativeType());
                    break block23;
                }
                if (domain.hasDimension(attr)) {
                    Types.typeCheck(domain.getDimension(attr).getType(), buffer.getNativeType());
                    break block23;
                }
                try (Attribute attribute = schema.getAttribute(attr);){
                    Types.typeCheck(attribute.getType(), buffer.getNativeType());
                }
            }
        }
        uint64_tArray offsets_array_size = new uint64_tArray(1);
        uint64_tArray values_array_size = new uint64_tArray(1);
        offsets_array_size.setitem(0, BigInteger.valueOf(0L));
        values_array_size.setitem(0, BigInteger.valueOf(bufferElements * (long)buffer.getNativeTypeSize()));
        Pair<uint64_tArray, uint64_tArray> buffer_sizes = new Pair<uint64_tArray, uint64_tArray>(offsets_array_size, values_array_size);
        if (this.buffers_.containsKey(attr)) {
            this.buffers_.get(attr).getSecond().close();
        }
        this.buffers_.put(attr, new Pair<Object, NativeArray>(null, buffer));
        this.buffer_sizes_.put(attr, buffer_sizes);
        uint64_tArray buffer_size = buffer_sizes.getSecond();
        this.ctx.handleError(tiledb.tiledb_query_set_buffer(this.ctx.getCtxp(), this.queryp, attr, buffer.toVoidPointer(), buffer_size.cast()));
        return this;
    }

    public synchronized Query setBufferNullable(String attr, NativeArray buffer, NativeArray bytemap) throws TileDBError {
        block21: {
            try (ArraySchema schema = this.array.getSchema();
                 Domain domain = schema.getDomain();){
                if (attr.equals(tiledb.tiledb_coords())) {
                    Types.typeCheck(domain.getDimension(attr).getType(), buffer.getNativeType());
                    break block21;
                }
                if (domain.hasDimension(attr)) {
                    Types.typeCheck(domain.getDimension(attr).getType(), buffer.getNativeType());
                    break block21;
                }
                try (Attribute attribute = schema.getAttribute(attr);){
                    Types.typeCheck(attribute.getType(), buffer.getNativeType());
                }
            }
        }
        uint64_tArray offsets_array_size = new uint64_tArray(1);
        uint64_tArray values_array_size = new uint64_tArray(1);
        uint64_tArray buffer_validity_bytemap_size = new uint64_tArray(1);
        offsets_array_size.setitem(0, BigInteger.valueOf(0L));
        values_array_size.setitem(0, BigInteger.valueOf(buffer.getNBytes()));
        buffer_validity_bytemap_size.setitem(0, BigInteger.valueOf(bytemap.getNBytes()));
        Pair<uint64_tArray, uint64_tArray> buffer_sizes = new Pair<uint64_tArray, uint64_tArray>(offsets_array_size, values_array_size);
        if (this.buffers_.containsKey(attr)) {
            this.buffers_.get(attr).getSecond().close();
        }
        this.buffers_.put(attr, new Pair<Object, NativeArray>(null, buffer));
        this.buffer_sizes_.put(attr, buffer_sizes);
        this.validityByteMaps_.put(attr, bytemap);
        this.validityByteMapSizes_.put(attr, buffer_validity_bytemap_size);
        uint64_tArray buffer_size = buffer_sizes.getSecond();
        this.ctx.handleError(tiledb.tiledb_query_set_buffer_nullable(this.ctx.getCtxp(), this.queryp, attr, buffer.toVoidPointer(), buffer_size.cast(), bytemap.getUint8_tArray().cast(), buffer_validity_bytemap_size.cast()));
        return this;
    }

    public synchronized Query setBufferNullableNIO(String attr, ByteBuffer buffer, ByteBuffer bytemap) throws TileDBError {
        if (buffer.capacity() <= 0) {
            throw new TileDBError("Number of buffer elements must be >= 1");
        }
        if (!buffer.isDirect()) {
            throw new TileDBError("The ByteBuffer provided is not direct. Please provide a direct buffer (ByteBuffer.allocateDirect(...))");
        }
        if (!buffer.order().equals(ByteOrder.nativeOrder())) {
            throw new TileDBError("The order of the data ByteBuffer should be the same as the native order (ByteOrder.nativeOrder()).");
        }
        this.byteBuffers_.put(attr, new Pair<Object, ByteBuffer>(null, buffer));
        uint64_tArray offsets_array_size = new uint64_tArray(1);
        uint64_tArray values_array_size = new uint64_tArray(1);
        uint64_tArray buffer_validity_bytemap_size = new uint64_tArray(1);
        offsets_array_size.setitem(0, BigInteger.valueOf(0L));
        values_array_size.setitem(0, BigInteger.valueOf(buffer.capacity()));
        buffer_validity_bytemap_size.setitem(0, BigInteger.valueOf(bytemap.capacity()));
        this.buffer_sizes_.put(attr, new Pair<uint64_tArray, uint64_tArray>(offsets_array_size, values_array_size));
        Pair<uint64_tArray, uint64_tArray> buffer_sizes = new Pair<uint64_tArray, uint64_tArray>(offsets_array_size, values_array_size);
        this.byteBuffers_.put(attr, new Pair<Object, ByteBuffer>(null, buffer));
        this.buffer_sizes_.put(attr, buffer_sizes);
        this.validityByteMapsByteBuffers_.put(attr, bytemap);
        uint64_tArray buffer_size = buffer_sizes.getSecond();
        this.ctx.handleError(Utils.tiledb_query_set_buffer_nullable_nio(this.ctx.getCtxp(), this.queryp, attr, buffer, buffer_size.cast(), bytemap, buffer_validity_bytemap_size.cast()));
        return this;
    }

    public synchronized Query setBufferNullable(String attr, NativeArray offsets, NativeArray buffer, NativeArray bytemap) throws TileDBError {
        block23: {
            if (attr.equals(tiledb.tiledb_coords())) {
                throw new TileDBError("Cannot set coordinate buffer as variable sized.");
            }
            if (!offsets.getNativeType().equals((Object)Datatype.TILEDB_UINT64)) {
                throw new TileDBError("Buffer offsets should be of getType TILEDB_UINT64 or Long. Found getType: " + (Object)((Object)offsets.getNativeType()));
            }
            try (ArraySchema schema = this.array.getSchema();
                 Domain domain = schema.getDomain();){
                if (attr.equals(tiledb.tiledb_coords())) {
                    Types.typeCheck(domain.getDimension(attr).getType(), buffer.getNativeType());
                    break block23;
                }
                if (domain.hasDimension(attr)) {
                    Types.typeCheck(domain.getDimension(attr).getType(), buffer.getNativeType());
                    break block23;
                }
                try (Attribute attribute = schema.getAttribute(attr);){
                    Types.typeCheck(attribute.getType(), buffer.getNativeType());
                }
            }
        }
        uint64_tArray offsets_array = PointerUtils.uint64_tArrayFromVoid(offsets.toVoidPointer());
        uint64_tArray offsets_array_size = new uint64_tArray(1);
        uint64_tArray values_array_size = new uint64_tArray(1);
        uint64_tArray buffer_validity_bytemap_size = new uint64_tArray(1);
        offsets_array_size.setitem(0, BigInteger.valueOf(offsets.getNBytes()));
        values_array_size.setitem(0, BigInteger.valueOf(buffer.getNBytes()));
        buffer_validity_bytemap_size.setitem(0, BigInteger.valueOf(bytemap.getSize() * bytemap.getNativeTypeSize()));
        Pair<uint64_tArray, uint64_tArray> buffer_sizes = new Pair<uint64_tArray, uint64_tArray>(offsets_array_size, values_array_size);
        if (this.buffers_.containsKey(attr)) {
            Pair<NativeArray, NativeArray> prev_buffers = this.buffers_.get(attr);
            prev_buffers.getFirst().close();
            prev_buffers.getSecond().close();
        }
        this.buffers_.put(attr, new Pair<NativeArray, NativeArray>(offsets, buffer));
        this.buffer_sizes_.put(attr, buffer_sizes);
        this.validityByteMaps_.put(attr, bytemap);
        this.validityByteMapSizes_.put(attr, buffer_validity_bytemap_size);
        this.ctx.handleError(tiledb.tiledb_query_set_buffer_var_nullable(this.ctx.getCtxp(), this.queryp, attr, offsets_array.cast(), offsets_array_size.cast(), buffer.toVoidPointer(), values_array_size.cast(), bytemap.getUint8_tArray().cast(), buffer_validity_bytemap_size.cast()));
        return this;
    }

    public synchronized Query setBufferNullableNIO(String attr, ByteBuffer offsets, ByteBuffer buffer, ByteBuffer bytemap) throws TileDBError {
        if (attr.equals(tiledb.tiledb_coords())) {
            throw new TileDBError("Cannot set coordinate buffer as variable sized.");
        }
        if (!offsets.order().equals(ByteOrder.nativeOrder()) && offsets.position() > 0) {
            throw new TileDBError("The order of the offsets ByteBuffer should be the same as the native order (ByteOrder.nativeOrder()) before values are inserted.");
        }
        if (!buffer.order().equals(ByteOrder.nativeOrder()) && buffer.position() > 0) {
            throw new TileDBError("The order of the data ByteBuffer should be the same as the native order (ByteOrder.nativeOrder()) before values are inserted.");
        }
        offsets.order(ByteOrder.nativeOrder());
        buffer.order(ByteOrder.nativeOrder());
        uint64_tArray offsets_array_size = new uint64_tArray(0);
        uint64_tArray values_array_size = new uint64_tArray(0);
        uint64_tArray buffer_validity_bytemap_size = new uint64_tArray(0);
        offsets_array_size.setitem(0, BigInteger.valueOf(offsets.capacity()));
        values_array_size.setitem(0, BigInteger.valueOf(buffer.capacity()));
        buffer_validity_bytemap_size.setitem(0, BigInteger.valueOf(bytemap.capacity()));
        Pair<uint64_tArray, uint64_tArray> buffer_sizes = new Pair<uint64_tArray, uint64_tArray>(offsets_array_size, values_array_size);
        if (this.buffers_.containsKey(attr)) {
            Pair<NativeArray, NativeArray> prev_buffers = this.buffers_.get(attr);
            prev_buffers.getFirst().close();
            prev_buffers.getSecond().close();
        }
        this.buffer_sizes_.put(attr, buffer_sizes);
        this.byteBuffers_.put(attr, new Pair<ByteBuffer, ByteBuffer>(offsets, buffer));
        this.ctx.handleError(Utils.tiledb_query_set_buffer_var_nullable_nio(this.ctx.getCtxp(), this.queryp, attr, offsets, offsets_array_size.cast(), buffer, values_array_size.cast(), bytemap, buffer_validity_bytemap_size.cast()));
        return this;
    }

    public synchronized Query setBuffer(String attr, long bufferElements) throws TileDBError {
        if (bufferElements <= 0L) {
            throw new TileDBError("Number of buffer elements must be >= 1");
        }
        Datatype dt = Util.getFieldDatatype(this.array, attr);
        int size = Util.castLongToInt(bufferElements * (long)dt.getNativeSize());
        ByteBuffer buffer = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
        this.setBuffer(attr, buffer);
        return this;
    }

    public synchronized Query setBuffer(String attr, ByteBuffer buffer) throws TileDBError {
        if (buffer.capacity() <= 0) {
            throw new TileDBError("Number of buffer elements must be >= 1");
        }
        if (!buffer.isDirect()) {
            throw new TileDBError("The ByteBuffer provided is not direct. Please provide a direct buffer (ByteBuffer.allocateDirect(...))");
        }
        if (!buffer.order().equals(ByteOrder.nativeOrder())) {
            throw new TileDBError("The order of the data ByteBuffer should be the same as the native order (ByteOrder.nativeOrder()).");
        }
        this.byteBuffers_.put(attr, new Pair<Object, ByteBuffer>(null, buffer));
        uint64_tArray offsets_array_size = new uint64_tArray(1);
        uint64_tArray values_array_size = new uint64_tArray(1);
        offsets_array_size.setitem(0, BigInteger.valueOf(0L));
        values_array_size.setitem(0, BigInteger.valueOf(buffer.capacity()));
        this.buffer_sizes_.put(attr, new Pair<uint64_tArray, uint64_tArray>(offsets_array_size, values_array_size));
        this.ctx.handleError(Utils.tiledb_query_set_buffer_nio(this.ctx.getCtxp(), this.queryp, attr, buffer, values_array_size.cast()));
        return this;
    }

    public synchronized Query setBuffer(String attr, NativeArray offsets, NativeArray buffer) throws TileDBError {
        block23: {
            if (attr.equals(tiledb.tiledb_coords())) {
                throw new TileDBError("Cannot set coordinate buffer as variable sized.");
            }
            if (!offsets.getNativeType().equals((Object)Datatype.TILEDB_UINT64)) {
                throw new TileDBError("Buffer offsets should be of getType TILEDB_UINT64 or Long. Found getType: " + (Object)((Object)offsets.getNativeType()));
            }
            try (ArraySchema schema = this.array.getSchema();
                 Domain domain = schema.getDomain();){
                if (attr.equals(tiledb.tiledb_coords())) {
                    Types.typeCheck(domain.getDimension(attr).getType(), buffer.getNativeType());
                    break block23;
                }
                if (domain.hasDimension(attr)) {
                    Types.typeCheck(domain.getDimension(attr).getType(), buffer.getNativeType());
                    break block23;
                }
                try (Attribute attribute = schema.getAttribute(attr);){
                    Types.typeCheck(attribute.getType(), buffer.getNativeType());
                }
            }
        }
        uint64_tArray offsets_array = PointerUtils.uint64_tArrayFromVoid(offsets.toVoidPointer());
        uint64_tArray offsets_array_size = new uint64_tArray(1);
        uint64_tArray values_array_size = new uint64_tArray(1);
        offsets_array_size.setitem(0, BigInteger.valueOf(offsets.getNBytes()));
        values_array_size.setitem(0, BigInteger.valueOf(buffer.getNBytes()));
        Pair<uint64_tArray, uint64_tArray> buffer_sizes = new Pair<uint64_tArray, uint64_tArray>(offsets_array_size, values_array_size);
        if (this.buffers_.containsKey(attr)) {
            Pair<NativeArray, NativeArray> prev_buffers = this.buffers_.get(attr);
            prev_buffers.getFirst().close();
            prev_buffers.getSecond().close();
        }
        this.buffers_.put(attr, new Pair<NativeArray, NativeArray>(offsets, buffer));
        this.buffer_sizes_.put(attr, buffer_sizes);
        this.ctx.handleError(tiledb.tiledb_query_set_buffer_var(this.ctx.getCtxp(), this.queryp, attr, offsets_array.cast(), offsets_array_size.cast(), buffer.toVoidPointer(), values_array_size.cast()));
        return this;
    }

    public synchronized Query setBuffer(String attr, ByteBuffer offsets, ByteBuffer buffer) throws TileDBError {
        if (attr.equals(tiledb.tiledb_coords())) {
            throw new TileDBError("Cannot set coordinate buffer as variable sized.");
        }
        if (!offsets.order().equals(ByteOrder.nativeOrder()) && offsets.position() > 0) {
            throw new TileDBError("The order of the offsets ByteBuffer should be the same as the native order (ByteOrder.nativeOrder()) before values are inserted.");
        }
        if (!buffer.order().equals(ByteOrder.nativeOrder()) && buffer.position() > 0) {
            throw new TileDBError("The order of the data ByteBuffer should be the same as the native order (ByteOrder.nativeOrder()) before values are inserted.");
        }
        offsets.order(ByteOrder.nativeOrder());
        buffer.order(ByteOrder.nativeOrder());
        uint64_tArray offsets_array_size = new uint64_tArray(1);
        uint64_tArray values_array_size = new uint64_tArray(1);
        offsets_array_size.setitem(0, BigInteger.valueOf(offsets.capacity()));
        values_array_size.setitem(0, BigInteger.valueOf(buffer.capacity()));
        Pair<uint64_tArray, uint64_tArray> buffer_sizes = new Pair<uint64_tArray, uint64_tArray>(offsets_array_size, values_array_size);
        if (this.buffers_.containsKey(attr)) {
            Pair<NativeArray, NativeArray> prev_buffers = this.buffers_.get(attr);
            prev_buffers.getFirst().close();
            prev_buffers.getSecond().close();
        }
        this.buffer_sizes_.put(attr, buffer_sizes);
        this.byteBuffers_.put(attr, new Pair<ByteBuffer, ByteBuffer>(offsets, buffer));
        this.ctx.handleError(Utils.tiledb_query_set_buffer_var_nio(this.ctx.getCtxp(), this.queryp, attr, offsets, offsets_array_size.cast(), buffer, values_array_size.cast()));
        return this;
    }

    public synchronized Query setBuffer(String attr, NativeArray offsets, NativeArray buffer, long offsetElements, long bufferElements) throws TileDBError {
        Integer offsetSize = buffer.getSize();
        Integer bufferSize = buffer.getSize();
        if (offsetElements > (long)offsetSize.intValue()) {
            throw new TileDBError("Number of offset elements requested exceeds the number of elements in allocated offset buffer: " + offsetElements + " > " + offsetSize);
        }
        if (bufferElements > (long)bufferSize.intValue()) {
            throw new TileDBError("Number of buffer elements requested exceeds the number of elements in allocated buffer" + bufferElements + " > " + bufferSize);
        }
        if (attr.equals(tiledb.tiledb_coords())) {
            throw new TileDBError("Cannot set coordinate buffer as variable sized.");
        }
        if (!offsets.getNativeType().equals((Object)Datatype.TILEDB_UINT64)) {
            throw new TileDBError("Buffer offsets should be of getType TILEDB_UINT64 or Long. Found getType: " + (Object)((Object)offsets.getNativeType()));
        }
        if (offsetElements <= 0L || bufferElements <= 0L) {
            throw new TileDBError("Number of buffer elements must be >= 1");
        }
        try (ArraySchema schema = this.array.getSchema();
             Attribute attribute = schema.getAttribute(attr);){
            Types.typeCheck(attribute.getType(), buffer.getNativeType());
        }
        uint64_tArray offsets_array = PointerUtils.uint64_tArrayFromVoid(offsets.toVoidPointer());
        uint64_tArray offsets_array_size = new uint64_tArray(1);
        uint64_tArray values_array_size = new uint64_tArray(1);
        offsets_array_size.setitem(0, BigInteger.valueOf(offsetElements * (long)offsets.getNativeTypeSize()));
        values_array_size.setitem(0, BigInteger.valueOf(bufferElements * (long)buffer.getNativeTypeSize()));
        Pair<uint64_tArray, uint64_tArray> buffer_sizes = new Pair<uint64_tArray, uint64_tArray>(offsets_array_size, values_array_size);
        if (this.buffers_.containsKey(attr)) {
            Pair<NativeArray, NativeArray> prev_buffers = this.buffers_.get(attr);
            prev_buffers.getFirst().close();
            prev_buffers.getSecond().close();
        }
        this.buffers_.put(attr, new Pair<NativeArray, NativeArray>(offsets, buffer));
        this.buffer_sizes_.put(attr, buffer_sizes);
        this.ctx.handleError(tiledb.tiledb_query_set_buffer_var(this.ctx.getCtxp(), this.queryp, attr, offsets_array.cast(), offsets_array_size.cast(), buffer.toVoidPointer(), values_array_size.cast()));
        return this;
    }

    private Query setBufferSizeUnsafe(String attribute, long offsetSize, long bufferSize) {
        this.buffer_sizes_.get(attribute).getFirst().setitem(0, BigInteger.valueOf(offsetSize));
        this.buffer_sizes_.get(attribute).getSecond().setitem(0, BigInteger.valueOf(bufferSize));
        return this;
    }

    public synchronized Query setBufferByteSize(String attribute, Long offsetSize, Long bufferSize) throws TileDBError {
        if (!this.buffers_.containsKey(attribute)) {
            throw new TileDBError("Query var attribute buffer does not exist: " + attribute);
        }
        if (offsetSize <= 0L || bufferSize <= 0L) {
            throw new TileDBError("Number of buffer bytes must be >= 1");
        }
        Pair<NativeArray, NativeArray> varBuffers = this.buffers_.get(attribute);
        NativeArray offsetBuffer = varBuffers.getFirst();
        Long offsetNBytes = offsetBuffer.getNBytes();
        NativeArray buffer = varBuffers.getSecond();
        Long bufferNBytes = buffer.getNBytes();
        if (offsetSize > offsetNBytes) {
            throw new TileDBError("Number of offset bytes requested exceeds the number bytes of in allocated offset buffer: " + offsetNBytes + " > " + offsetSize);
        }
        if (bufferSize > bufferNBytes) {
            throw new TileDBError("Number of buffer bytes requested exceeds the number of bytes in allocated buffer" + bufferNBytes + " > " + bufferSize);
        }
        return this.setBufferSizeUnsafe(attribute, offsetSize, bufferSize);
    }

    public synchronized Query setBufferByteSize(String attribute, Long bufferSize) throws TileDBError {
        if (!this.buffers_.containsKey(attribute)) {
            throw new TileDBError("Query attrbute buffer does not exist: " + attribute);
        }
        if (bufferSize <= 0L) {
            throw new TileDBError("Number of buffer bytes must be >= 1");
        }
        NativeArray buffer = this.buffers_.get(attribute).getSecond();
        Long bufferNBytes = buffer.getNBytes();
        if (bufferSize > bufferNBytes) {
            throw new TileDBError("Number of bytes requested exceeds the number of bytes in allocated buffer: " + bufferSize + " > " + bufferNBytes);
        }
        return this.setBufferSizeUnsafe(attribute, 0L, bufferSize);
    }

    public synchronized Query setBufferElements(String attribute, Integer bufferElements) throws TileDBError {
        if (!this.buffers_.containsKey(attribute)) {
            throw new TileDBError("Query attribute buffer does not exist: " + attribute);
        }
        if (bufferElements <= 0) {
            throw new TileDBError("Number of buffer elements must be >= 1");
        }
        NativeArray buffer = this.buffers_.get(attribute).getSecond();
        Integer bufferSize = buffer.getSize();
        if (bufferElements > bufferSize) {
            throw new TileDBError("Number of elements requested exceeds the number of elements in allocated buffer: " + bufferElements + " > " + bufferSize);
        }
        return this.setBufferSizeUnsafe(attribute, 0L, bufferElements * buffer.getNativeTypeSize());
    }

    public synchronized Query setBufferElements(String attribute, Integer offsetElements, Integer bufferElements) throws TileDBError {
        if (!this.buffers_.containsKey(attribute)) {
            throw new TileDBError("Query var attribute buffer does not exist: " + attribute);
        }
        if (offsetElements <= 0 || bufferElements <= 0) {
            throw new TileDBError("Number of buffer elements must be >= 1");
        }
        Pair<NativeArray, NativeArray> varBuffers = this.buffers_.get(attribute);
        NativeArray offsetBuffer = varBuffers.getFirst();
        Integer offsetSize = offsetBuffer.getSize();
        NativeArray buffer = varBuffers.getSecond();
        Integer bufferSize = buffer.getSize();
        if (offsetElements > offsetSize) {
            throw new TileDBError("Number of offset elements requested exceeds the number of elements in allocated offset buffer: " + offsetElements + " > " + offsetSize);
        }
        if (bufferElements > bufferSize) {
            throw new TileDBError("Number of buffer elements requested exceeds the number of elements in allocated buffer" + bufferElements + " > " + bufferSize);
        }
        return this.setBufferSizeUnsafe(attribute, offsetElements * offsetBuffer.getNativeTypeSize(), bufferElements * buffer.getNativeTypeSize());
    }

    @Deprecated
    public Query setCoordinates(NativeArray buffer) throws TileDBError {
        this.setBuffer(tiledb.tiledb_coords(), buffer);
        return this;
    }

    @Deprecated
    public Object getCoordinates() throws TileDBError {
        return this.getBuffer(tiledb.tiledb_coords());
    }

    public Pair<Long, Long> resultBufferElementsNIO(String name, int typeSize) throws TileDBError {
        Pair<ByteBuffer, ByteBuffer> entry = this.byteBuffers_.get(name);
        if (entry.getFirst() == null) {
            BigInteger val_nbytes = this.buffer_sizes_.get(name).getSecond().getitem(0);
            Long nelements = val_nbytes.divide(BigInteger.valueOf(typeSize)).longValue();
            return new Pair<Long, Long>(0L, nelements);
        }
        Pair<uint64_tArray, uint64_tArray> buffer_size = this.buffer_sizes_.get(name);
        BigInteger off_nbytes = buffer_size.getFirst().getitem(0);
        int divisor = 8;
        if (Integer.parseInt(this.getConfig().get("sm.var_offsets.bitsize")) == 32) {
            divisor = 4;
        }
        Long off_nelements = off_nbytes.divide(BigInteger.valueOf(divisor)).longValue();
        BigInteger val_nbytes = buffer_size.getSecond().getitem(0);
        Long val_nelements = val_nbytes.divide(BigInteger.valueOf(typeSize)).longValue();
        return new Pair<Long, Long>(off_nelements, val_nelements);
    }

    public HashMap<String, Pair<Long, Long>> resultBufferElements() throws TileDBError {
        HashMap<String, Pair<Long, Long>> result = new HashMap<String, Pair<Long, Long>>();
        for (Map.Entry<String, Pair<NativeArray, NativeArray>> entry : this.buffers_.entrySet()) {
            String name = entry.getKey();
            if (entry.getValue().getFirst() == null) {
                NativeArray val_buffer = entry.getValue().getSecond();
                BigInteger val_nbytes = this.buffer_sizes_.get(name).getSecond().getitem(0);
                Long nelements = val_nbytes.divide(BigInteger.valueOf(val_buffer.getNativeTypeSize())).longValue();
                result.put(name, new Pair<Long, Long>(0L, nelements));
                continue;
            }
            Pair<uint64_tArray, uint64_tArray> buffer_size = this.buffer_sizes_.get(name);
            NativeArray off_buffer = entry.getValue().getFirst();
            BigInteger off_nbytes = buffer_size.getFirst().getitem(0);
            Long off_nelements = off_nbytes.divide(BigInteger.valueOf(off_buffer.getNativeTypeSize())).longValue();
            NativeArray val_buffer = entry.getValue().getSecond();
            BigInteger val_nbytes = buffer_size.getSecond().getitem(0);
            Long val_nelements = val_nbytes.divide(BigInteger.valueOf(val_buffer.getNativeTypeSize())).longValue();
            result.put(name, new Pair<Long, Long>(off_nelements, val_nelements));
        }
        return result;
    }

    public HashMap<String, Pair<Long, Long>> resultBufferSizes() throws TileDBError {
        HashMap<String, Pair<Long, Long>> result = new HashMap<String, Pair<Long, Long>>();
        for (String string : this.buffers_.keySet()) {
            BigInteger val_nbytes = this.buffer_sizes_.get(string).getSecond().getitem(0);
            result.put(string, new Pair<Long, Long>(0L, val_nbytes.longValue()));
        }
        for (Map.Entry entry : this.buffers_.entrySet()) {
            String name = (String)entry.getKey();
            Pair<uint64_tArray, uint64_tArray> buffer_size = this.buffer_sizes_.get(name);
            BigInteger off_nbytes = buffer_size.getFirst().getitem(0);
            BigInteger val_nbytes = buffer_size.getSecond().getitem(0);
            result.put(name, new Pair<Long, Long>(off_nbytes.longValue(), val_nbytes.longValue()));
        }
        return result;
    }

    public synchronized void resetBuffers() {
        for (Pair<NativeArray, NativeArray> pair : this.buffers_.values()) {
            pair.getSecond().close();
        }
        for (Pair<Object, Object> pair : this.byteBuffers_.values()) {
            ((ByteBuffer)pair.getSecond()).clear();
        }
        this.byteBuffers_.clear();
        this.buffers_.clear();
        for (Pair<Object, Object> pair : this.buffers_.values()) {
            ((NativeArray)pair.getFirst()).close();
            ((NativeArray)pair.getSecond()).close();
        }
        for (Pair<Object, Object> pair : this.byteBuffers_.values()) {
            ((ByteBuffer)pair.getFirst()).clear();
            ((ByteBuffer)pair.getSecond()).clear();
        }
        this.byteBuffers_.clear();
        this.buffers_.clear();
        for (Pair<Object, Object> pair : this.buffer_sizes_.values()) {
            ((uint64_tArray)pair.getFirst()).delete();
            ((uint64_tArray)pair.getSecond()).delete();
        }
        this.buffer_sizes_.clear();
    }

    public synchronized Query resetBufferSizes(Long val) {
        BigInteger sizeVal = BigInteger.valueOf(val);
        for (Pair<uint64_tArray, uint64_tArray> size_pair : this.buffer_sizes_.values()) {
            size_pair.getFirst().setitem(0, sizeVal);
            size_pair.getSecond().setitem(0, sizeVal);
        }
        return this;
    }

    public Query resetBufferSizes() {
        return this.resetBufferSizes(0L);
    }

    public Object getBuffer(String bufferName) throws TileDBError {
        if (this.buffers_.containsKey(bufferName)) {
            NativeArray buffer = this.buffers_.get(bufferName).getSecond();
            Integer nelements = this.buffer_sizes_.get(bufferName).getSecond().getitem(0).divide(BigInteger.valueOf(buffer.getNativeTypeSize())).intValue();
            return buffer.toJavaArray(nelements);
        }
        if (this.buffers_.containsKey(bufferName)) {
            NativeArray buffer = this.buffers_.get(bufferName).getSecond();
            Integer nelements = this.buffer_sizes_.get(bufferName).getSecond().getitem(0).divide(BigInteger.valueOf(buffer.getNativeTypeSize())).intValue();
            return buffer.toJavaArray(nelements);
        }
        throw new TileDBError("Query attribute buffer does not exist: " + bufferName);
    }

    public Pair<ByteBuffer, ByteBuffer> getByteBuffer(String attr) throws TileDBError {
        if (this.byteBuffers_.containsKey(attr)) {
            return this.byteBuffers_.get(attr);
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + attr);
    }

    public long[] getVarBuffer(String bufferName) throws TileDBError {
        if (!this.buffers_.containsKey(bufferName)) {
            throw new TileDBError("Query variable attribute buffer does not exist: " + bufferName);
        }
        NativeArray buffer = this.buffers_.get(bufferName).getFirst();
        Integer nelements = this.buffer_sizes_.get(bufferName).getFirst().getitem(0).divide(BigInteger.valueOf(buffer.getNativeTypeSize())).intValue();
        return (long[])buffer.toJavaArray(nelements);
    }

    public Pair<LongBuffer, IntBuffer> getIntBuffer(String bufferName) throws TileDBError {
        Datatype dt = Util.getFieldDatatype(this.array, bufferName);
        if (dt.javaClass() != Integer.class) {
            throw new TileDBError("IntBuffer requested, but attribute " + bufferName + " has type " + dt.name());
        }
        Pair<ByteBuffer, ByteBuffer> buffer = this.byteBuffers_.get(bufferName);
        if (this.byteBuffers_.containsKey(bufferName)) {
            LongBuffer offsets = null;
            if (buffer.getFirst() != null) {
                offsets = buffer.getFirst().asLongBuffer();
            }
            return new Pair<LongBuffer, IntBuffer>(offsets, buffer.getSecond().asIntBuffer());
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + bufferName);
    }

    public Pair<LongBuffer, LongBuffer> getLongBuffer(String bufferName) throws TileDBError {
        Datatype dt = Util.getFieldDatatype(this.array, bufferName);
        if (dt.javaClass() != Long.class) {
            throw new TileDBError("LongBuffer requested, but attribute " + bufferName + " has type " + dt.name());
        }
        Pair<ByteBuffer, ByteBuffer> buffer = this.byteBuffers_.get(bufferName);
        if (this.byteBuffers_.containsKey(bufferName)) {
            return new Pair<LongBuffer, LongBuffer>(buffer.getFirst().asLongBuffer(), buffer.getSecond().asLongBuffer());
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + bufferName);
    }

    public Pair<LongBuffer, ShortBuffer> getShortBuffer(String bufferName) throws TileDBError {
        Datatype dt = Util.getFieldDatatype(this.array, bufferName);
        if (dt.javaClass() != Short.class) {
            throw new TileDBError("ShortBuffer requested, but attribute " + bufferName + " has type " + dt.name());
        }
        Pair<ByteBuffer, ByteBuffer> buffer = this.byteBuffers_.get(bufferName);
        if (this.byteBuffers_.containsKey(bufferName)) {
            LongBuffer offsets = null;
            if (buffer.getFirst() != null) {
                offsets = buffer.getFirst().asLongBuffer();
            }
            return new Pair<LongBuffer, ShortBuffer>(offsets, buffer.getSecond().asShortBuffer());
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + bufferName);
    }

    public Pair<LongBuffer, CharBuffer> getCharBuffer(String bufferName) throws TileDBError {
        Datatype dt = Util.getFieldDatatype(this.array, bufferName);
        if (dt.javaClass() != Byte.class) {
            throw new TileDBError("CharBuffer requested, but attribute " + bufferName + " has type " + dt.name());
        }
        Pair<ByteBuffer, ByteBuffer> buffer = this.byteBuffers_.get(bufferName);
        if (this.byteBuffers_.containsKey(bufferName)) {
            LongBuffer offsets = null;
            if (buffer.getFirst() != null) {
                offsets = buffer.getFirst().asLongBuffer();
            }
            Charset charset = StandardCharsets.US_ASCII;
            CharBuffer charBuffer = charset.decode(buffer.getSecond());
            return new Pair<LongBuffer, CharBuffer>(offsets, charBuffer);
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + bufferName);
    }

    public Pair<LongBuffer, FloatBuffer> getFloatBuffer(String bufferName) throws TileDBError {
        Datatype dt = Util.getFieldDatatype(this.array, bufferName);
        if (dt.javaClass() != Float.class) {
            throw new TileDBError("FloatBuffer requested, but attribute " + bufferName + " has type " + dt.name());
        }
        Pair<ByteBuffer, ByteBuffer> buffer = this.byteBuffers_.get(bufferName);
        if (this.byteBuffers_.containsKey(bufferName)) {
            LongBuffer offsets = null;
            if (buffer.getFirst() != null) {
                offsets = buffer.getFirst().asLongBuffer();
            }
            return new Pair<LongBuffer, FloatBuffer>(offsets, buffer.getSecond().asFloatBuffer());
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + bufferName);
    }

    public Pair<LongBuffer, DoubleBuffer> getDoubleBuffer(String bufferName) throws TileDBError {
        Datatype dt = Util.getFieldDatatype(this.array, bufferName);
        if (dt.javaClass() != Double.class) {
            throw new TileDBError("DoubleBuffer requested, but attribute " + bufferName + " has type " + dt.name());
        }
        Pair<ByteBuffer, ByteBuffer> buffer = this.byteBuffers_.get(bufferName);
        if (this.byteBuffers_.containsKey(bufferName)) {
            LongBuffer offsets = null;
            if (buffer.getFirst() != null) {
                offsets = buffer.getFirst().asLongBuffer();
            }
            return new Pair<LongBuffer, DoubleBuffer>(offsets, buffer.getSecond().asDoubleBuffer());
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + bufferName);
    }

    public byte[] getByteArray(String bufferName) throws TileDBError {
        ByteBuffer buffer = this.byteBuffers_.get(bufferName).getSecond();
        if (this.byteBuffers_.containsKey(bufferName)) {
            byte[] bytes = new byte[buffer.limit()];
            int idx = 0;
            while (buffer.hasRemaining()) {
                bytes[idx++] = buffer.get();
            }
            buffer.flip();
            return bytes;
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + bufferName);
    }

    public long[] getOffsetArray(String bufferName) throws TileDBError {
        Pair<ByteBuffer, ByteBuffer> buffer = this.byteBuffers_.get(bufferName);
        if (this.byteBuffers_.containsKey(bufferName)) {
            LongBuffer offsets = null;
            if (buffer.getFirst() != null) {
                offsets = buffer.getFirst().asLongBuffer();
                long[] offsetArr = new long[offsets.limit()];
                int idx = 0;
                while (offsets.hasRemaining()) {
                    offsetArr[idx++] = offsets.get();
                }
                return offsetArr;
            }
        }
        throw new TileDBError("ByteBuffer does not exist for attribute: " + bufferName);
    }

    public short[] getValidityByteMap(String attribute) throws TileDBError {
        if (this.validityByteMaps_.containsKey(attribute)) {
            int nelements = this.validityByteMapSizes_.get(attribute).getitem(0).divide(BigInteger.valueOf(Datatype.TILEDB_UINT8.getNativeSize())).intValue();
            return (short[])this.validityByteMaps_.get(attribute).toJavaArray(nelements);
        }
        throw new TileDBError("Attribute " + attribute + " is not nullable");
    }

    public HashMap<String, Pair<Long, Long>> getResultEstimations() throws TileDBError {
        HashMap<String, Pair<Long, Long>> estimations = new HashMap<String, Pair<Long, Long>>();
        try (ArraySchema schema = this.array.getSchema();
             Domain domain = schema.getDomain();){
            String name;
            for (Dimension dimension : domain.getDimensions()) {
                name = dimension.getName();
                if (dimension.isVar()) {
                    estimations.put(name, this.getEstResultSizeVar(this.ctx, name));
                    continue;
                }
                estimations.put(name, new Pair<Object, Long>(null, this.getEstResultSize(this.ctx, name)));
            }
            for (Attribute attribute : schema.getAttributes().values()) {
                name = attribute.getName();
                if (attribute.isVar()) {
                    estimations.put(name, this.getEstResultSizeVar(this.ctx, name));
                    continue;
                }
                estimations.put(name, new Pair<Object, Long>(null, this.getEstResultSize(this.ctx, name)));
            }
        }
        return estimations;
    }

    public Query finalizeQuery() throws TileDBError {
        this.ctx.handleError(tiledb.tiledb_query_finalize(this.ctx.getCtxp(), this.queryp));
        return this;
    }

    public long getFragmentNum() throws TileDBError {
        SWIGTYPE_p_unsigned_int fragmentNum = tiledb.new_uintp();
        this.ctx.handleError(tiledb.tiledb_query_get_fragment_num(this.ctx.getCtxp(), this.queryp, fragmentNum));
        return tiledb.uintp_value(fragmentNum);
    }

    public String getFragmentURI(BigInteger idx) throws TileDBError {
        SWIGTYPE_p_p_char uri = tiledb.new_charpp();
        this.ctx.handleError(tiledb.tiledb_query_get_fragment_uri(this.ctx.getCtxp(), this.queryp, idx, uri));
        return tiledb.charpp_value(uri);
    }

    public Pair<Long, Long> getFragmentTimestampRange(BigInteger idx) throws TileDBError {
        SWIGTYPE_p_unsigned_long_long t1 = tiledb.new_ullp();
        SWIGTYPE_p_unsigned_long_long t2 = tiledb.new_ullp();
        this.ctx.handleError(tiledb.tiledb_query_get_fragment_timestamp_range(this.ctx.getCtxp(), this.queryp, idx, t1, t2));
        return new Pair<BigInteger, BigInteger>(tiledb.ullp_value(t1), tiledb.ullp_value(t2));
    }

    public String toString() {
        switch (this.type) {
            case TILEDB_READ: {
                return "READ";
            }
            case TILEDB_WRITE: {
                return "WRITE";
            }
        }
        return "";
    }

    protected SWIGTYPE_p_tiledb_query_t getQueryp() {
        return this.queryp;
    }

    public String getStats() throws TileDBError {
        String stats;
        SWIGTYPE_p_p_char statspp = tiledb.new_charpp();
        try {
            this.ctx.handleError(tiledb.tiledb_query_get_stats(this.ctx.getCtxp(), this.getQueryp(), statspp));
            stats = tiledb.charpp_value(statspp);
        }
        finally {
            tiledb.delete_charpp(statspp);
        }
        return stats;
    }

    public void setCondition(QueryCondition queryCondition) throws TileDBError {
        SWIGTYPE_p_tiledb_query_condition_t condition_t = queryCondition.getConditionp();
        this.ctx.handleError(tiledb.tiledb_query_set_condition(this.ctx.getCtxp(), this.getQueryp(), condition_t));
    }

    public Config getConfig() throws TileDBError {
        Config config;
        SWIGTYPE_p_p_tiledb_config_t configpp = tiledb.new_tiledb_config_tpp();
        try {
            this.ctx.handleError(tiledb.tiledb_query_get_config(this.ctx.getCtxp(), this.queryp, configpp));
            config = new Config(configpp);
        }
        finally {
            tiledb.delete_tiledb_config_tpp(configpp);
        }
        return config;
    }

    @Override
    public synchronized void close() {
        if (this.queryp != null) {
            for (Pair<uint64_tArray, uint64_tArray> pair : this.buffer_sizes_.values()) {
                pair.getFirst().delete();
                pair.getSecond().delete();
            }
            for (Pair<Object, Object> pair : this.buffers_.values()) {
                if (pair.getFirst() != null) {
                    ((NativeArray)pair.getFirst()).close();
                }
                if (pair.getSecond() == null) continue;
                ((NativeArray)pair.getSecond()).close();
            }
            if (this.subarray != null) {
                this.subarray.close();
            }
            tiledb.tiledb_query_free(this.querypp);
            this.queryp = null;
        }
    }

    private static class DefaultCallback
    implements Callback {
        @Override
        public void call() {
        }
    }
}

