/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.java.api;

import io.tiledb.java.api.Datatype;
import io.tiledb.java.api.TileDBError;
import io.tiledb.java.api.Types;

public class JavaArray {
    private Object array;
    private Datatype dataType;
    private int numElements;

    public JavaArray(Datatype dt, int numElements) throws TileDBError {
        this.dataType = dt;
        this.numElements = numElements;
        Class c = Types.getJavaType(dt);
        if (c == Integer.class) {
            this.array = new int[numElements];
        } else if (c == Long.class) {
            this.array = new long[numElements];
        } else if (c == Double.class) {
            this.array = new double[numElements];
        } else if (c == Float.class) {
            this.array = new float[numElements];
        } else if (c == Short.class) {
            this.array = new short[numElements];
        } else if (c == Byte.class) {
            this.array = new byte[numElements];
        } else if (c == String.class) {
            this.array = new byte[numElements];
        }
    }

    public Object get() {
        return this.array;
    }

    public int getNumElements() {
        return this.numElements;
    }

    public void set(int position, int o) throws ArrayIndexOutOfBoundsException {
        ((int[])this.array)[position] = o;
    }

    public void set(int position, long o) throws ArrayIndexOutOfBoundsException {
        ((long[])this.array)[position] = o;
    }

    public void set(int position, float o) throws ArrayIndexOutOfBoundsException {
        ((float[])this.array)[position] = o;
    }

    public void set(int position, double o) throws ArrayIndexOutOfBoundsException {
        ((double[])this.array)[position] = o;
    }

    public void set(int position, byte o) throws ArrayIndexOutOfBoundsException {
        ((byte[])this.array)[position] = o;
    }

    public void set(int position, short o) throws ArrayIndexOutOfBoundsException {
        ((short[])this.array)[position] = o;
    }

    public void set(int position, byte[] o) throws ArrayIndexOutOfBoundsException {
        int curr = position;
        byte[] byArray = o;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte b;
            ((byte[])this.array)[curr] = b = byArray[i];
            ++curr;
        }
    }

    public Datatype getDataType() {
        return this.dataType;
    }
}

