/*
 * Decompiled with CFR 0.152.
 */
package io.tiler.core.time;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.regex.Pattern;

public class TimePeriodParser {
    private static final Pattern timePeriodPattern = Pattern.compile("([1-9][0-9]+|[0-9])(\\.[0-9]+)?[usmhdw]");
    private static final String UNIT_MICROSECONDS = "u";
    private static final String UNIT_SECONDS = "s";
    private static final String UNIT_MINUTES = "m";
    private static final String UNIT_HOURS = "h";
    private static final String UNIT_DAYS = "d";
    private static final String UNIT_WEEKS = "w";
    private static final BigDecimal MILLISECONDS_PER_SECOND = new BigDecimal(1000L);
    private static final BigDecimal MILLISECONDS_PER_MINUTE = new BigDecimal(60000L);
    private static final BigDecimal MILLISECONDS_PER_HOUR = new BigDecimal(3600000L);
    private static final BigDecimal MILLISECONDS_PER_DAY = new BigDecimal(86400000L);
    private static final BigDecimal MILLISECONDS_PER_WEEK = new BigDecimal(604800000L);
    private static final BigDecimal MICROSECONDS_PER_MICROSECOND = new BigDecimal(1L);
    private static final BigDecimal MICROSECONDS_PER_SECOND = new BigDecimal(1000000L);
    private static final BigDecimal MICROSECONDS_PER_MINUTE = new BigDecimal(60000000L);
    private static final BigDecimal MICROSECONDS_PER_HOUR = new BigDecimal(3600000000L);
    private static final BigDecimal MICROSECONDS_PER_DAY = new BigDecimal(86400000000L);
    private static final BigDecimal MICROSECONDS_PER_WEEK = new BigDecimal(604800000000L);

    public static boolean isATimePeriod(String value) {
        return timePeriodPattern.matcher(value).matches();
    }

    public static long parseTimePeriodToMilliseconds(String value) {
        return TimePeriodParser.getQuantityFromTimePeriod(value).multiply(TimePeriodParser.getMillisecondsPerUnit(TimePeriodParser.getUnitFromTimePeriod(value))).setScale(0, RoundingMode.HALF_EVEN).longValueExact();
    }

    public static long parseTimePeriodToMicroseconds(String value) {
        return TimePeriodParser.getQuantityFromTimePeriod(value).multiply(TimePeriodParser.getMicrosecondsPerUnit(TimePeriodParser.getUnitFromTimePeriod(value))).setScale(0, RoundingMode.HALF_EVEN).longValueExact();
    }

    private static BigDecimal getQuantityFromTimePeriod(String value) {
        return new BigDecimal(value.substring(0, value.length() - 1));
    }

    private static String getUnitFromTimePeriod(String value) {
        return value.substring(value.length() - 1);
    }

    private static BigDecimal getMicrosecondsPerUnit(String unit) {
        switch (unit) {
            case "u": {
                return MICROSECONDS_PER_MICROSECOND;
            }
            case "s": {
                return MICROSECONDS_PER_SECOND;
            }
            case "m": {
                return MICROSECONDS_PER_MINUTE;
            }
            case "h": {
                return MICROSECONDS_PER_HOUR;
            }
            case "d": {
                return MICROSECONDS_PER_DAY;
            }
            case "w": {
                return MICROSECONDS_PER_WEEK;
            }
        }
        throw new IllegalArgumentException("Unsupported unit");
    }

    private static BigDecimal getMillisecondsPerUnit(String unit) {
        switch (unit) {
            case "s": {
                return MILLISECONDS_PER_SECOND;
            }
            case "m": {
                return MILLISECONDS_PER_MINUTE;
            }
            case "h": {
                return MILLISECONDS_PER_HOUR;
            }
            case "d": {
                return MILLISECONDS_PER_DAY;
            }
            case "w": {
                return MILLISECONDS_PER_WEEK;
            }
        }
        throw new IllegalArgumentException("Unsupported unit");
    }
}

