/*
 * Decompiled with CFR 0.152.
 */
package io.tiler.core.regex;

import io.tiler.core.regex.InvalidPatternOptionsException;

public class PatternOptionsParser {
    public int parsePatternOptions(String patternOptions) throws InvalidPatternOptionsException {
        int flags = 0;
        int length = patternOptions.length();
        for (int index = 0; index < length; ++index) {
            int flag;
            char option = patternOptions.charAt(index);
            switch (option) {
                case 'd': {
                    flag = 1;
                    break;
                }
                case 'i': {
                    flag = 2;
                    break;
                }
                case 'x': {
                    flag = 4;
                    break;
                }
                case 'm': {
                    flag = 8;
                    break;
                }
                case 's': {
                    flag = 32;
                    break;
                }
                case 'u': {
                    flag = 64;
                    break;
                }
                case 'U': {
                    flag = 256;
                    break;
                }
                default: {
                    throw new InvalidPatternOptionsException("Unsupported option '" + option + "'");
                }
            }
            if ((flags & flag) != 0) {
                throw new InvalidPatternOptionsException("Same option '" + option + "' specified multiple times");
            }
            flags |= flag;
        }
        return flags;
    }
}

