/*
 * Decompiled with CFR 0.152.
 */
package io.tiler.core;

import io.tiler.core.internal.DefaultAsyncResult;
import java.util.List;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.Verticle;

public class BaseCollectorVerticle
extends Verticle {
    private static final long TWO_MINUTES_IN_MILLISECONDS = 120000L;

    protected void getExistingMetrics(List<String> metricNames, AsyncResultHandler<JsonArray> handler) {
        JsonObject message = new JsonObject().putString("type", "getMetrics").putObject("body", new JsonObject().putArray("metricNames", new JsonArray(metricNames)));
        this.vertx.eventBus().sendWithTimeout("io.tiler", message, 120000L, result -> {
            if (result.failed()) {
                handler.handle(DefaultAsyncResult.fail(result.cause()));
                return;
            }
            JsonObject responseMessage = (JsonObject)((Message)result.result()).body();
            JsonObject responseBody = responseMessage.getObject("body");
            if (responseBody.containsField("error")) {
                String errorMessage = responseMessage.getObject("error").getString("message");
                this.container.logger().error((Object)("Failed to get metrics: " + errorMessage));
                handler.handle(DefaultAsyncResult.fail(new RuntimeException(errorMessage)));
                return;
            }
            handler.handle(DefaultAsyncResult.succeed(responseBody.getArray("metrics")));
        });
    }

    protected void saveMetrics(JsonArray metrics) {
        this.container.logger().info((Object)"Sending metrics to event bus");
        JsonObject message = new JsonObject().putString("type", "publishMetrics").putObject("body", new JsonObject().putArray("metrics", metrics));
        this.vertx.eventBus().send("io.tiler", message);
    }

    protected long currentTimeInMicroseconds() {
        return System.currentTimeMillis() * 1000L;
    }
}

