/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.collect;

import com.google.auto.value.AutoValue;
import io.timeandspace.collect.AutoValue_Equivalence_EntryEquivalence;
import io.timeandspace.collect.StatelessEquivalence;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class Equivalence<T> {
    private static final Equivalence<Object> DEFAULT_EQUALITY = new DefaultEquality();
    private static final Equivalence<Object> IDENTITY = new Identity();
    private static final Equivalence<String> CASE_INSENSITIVE = new CaseInsensitive();
    private static final Equivalence<CharSequence> CHAR_SEQUENCE = new OfCharSequence();

    public static <T> Equivalence<T> defaultEquality() {
        return DEFAULT_EQUALITY;
    }

    public static <T> Equivalence<T> identity() {
        return IDENTITY;
    }

    public static Equivalence<CharSequence> charSequence() {
        return CHAR_SEQUENCE;
    }

    public static Equivalence<String> caseInsensitive() {
        return CASE_INSENSITIVE;
    }

    public static <K, V> Equivalence<Map.Entry<K, V>> entryEquivalence(Equivalence<K> keyEquivalence, Equivalence<V> valueEquivalence) {
        if (keyEquivalence.equals(Equivalence.defaultEquality()) && valueEquivalence.equals(Equivalence.defaultEquality())) {
            return Equivalence.defaultEquality();
        }
        return new AutoValue_Equivalence_EntryEquivalence<K, V>(keyEquivalence, valueEquivalence);
    }

    protected Equivalence() {
    }

    public boolean nullableEquivalent(@Nullable T a, @Nullable T b) {
        boolean objectsIdentical = a == b;
        return objectsIdentical || a != null && b != null && this.equivalent(a, b);
    }

    public abstract boolean equivalent(T var1, T var2);

    public int nullableHash(@Nullable T t) {
        return t != null ? this.hash(t) : 0;
    }

    public abstract int hash(T var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    private static class OfCharSequence
    extends StatelessEquivalence<CharSequence> {
        private OfCharSequence() {
        }

        @Override
        public boolean equivalent(CharSequence a, CharSequence b) {
            boolean charSequencesEqual = a.equals(b);
            if (charSequencesEqual) {
                return true;
            }
            if (a instanceof String) {
                return ((String)a).contentEquals(b);
            }
            if (b instanceof String) {
                return ((String)b).contentEquals(a);
            }
            int len = a.length();
            if (len != b.length()) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hash(CharSequence cs) {
            if (cs instanceof String) {
                return cs.hashCode();
            }
            int h = 0;
            int len = cs.length();
            for (int i = 0; i < len; ++i) {
                h = 31 * h + cs.charAt(i);
            }
            return h;
        }
    }

    private static class CaseInsensitive
    extends StatelessEquivalence<String> {
        private CaseInsensitive() {
        }

        @Override
        public boolean equivalent(String a, String b) {
            return a.equalsIgnoreCase(b);
        }

        @Override
        public int hash(String s) {
            return s.toLowerCase().hashCode();
        }
    }

    private static class Identity
    extends StatelessEquivalence<Object> {
        private Identity() {
        }

        @Override
        public boolean nullableEquivalent(@Nullable Object a, @Nullable Object b) {
            return a == b;
        }

        @Override
        public boolean equivalent(Object a, Object b) {
            return a == b;
        }

        @Override
        public int nullableHash(@Nullable Object o) {
            return System.identityHashCode(o);
        }

        @Override
        public int hash(Object o) {
            return System.identityHashCode(o);
        }
    }

    private static class DefaultEquality
    extends StatelessEquivalence<Object> {
        private DefaultEquality() {
        }

        @Override
        public boolean equivalent(Object a, Object b) {
            return a.equals(b);
        }

        @Override
        public int hash(Object o) {
            return o.hashCode();
        }
    }

    @AutoValue
    static abstract class EntryEquivalence<K, V>
    extends Equivalence<Map.Entry<K, V>> {
        EntryEquivalence() {
        }

        abstract Equivalence<K> keyEquivalence();

        abstract Equivalence<V> valueEquivalence();

        @Override
        public boolean equivalent(Map.Entry<K, V> a, Map.Entry<K, V> b) {
            boolean entriesIdentical = a == b;
            return entriesIdentical || this.keyEquivalence().nullableEquivalent(a.getKey(), b.getKey()) && this.valueEquivalence().nullableEquivalent(a.getValue(), b.getValue());
        }

        @Override
        public int hash(Map.Entry<K, V> entry) {
            return this.keyEquivalence().nullableHash(entry.getKey()) ^ this.valueEquivalence().nullableHash(entry.getValue());
        }
    }
}

