/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.smoothie.Utils;

final class BitSetAndState {
    private static final int BIT_SET_BITS = 48;
    private static final long BIT_SET_MASK = 0xFFFFFFFFFFFFL;
    static final long EMPTY_BIT_SET = 0xFFFFFFFFFFFFL;
    private static final int SEGMENT_ORDER_SHIFT = 48;
    static final long SEGMENT_ORDER_UNIT = 0x1000000000000L;
    private static final int SEGMENT_ORDER_BITS = 5;
    private static final int SEGMENT_ORDER_MASK = 31;
    private static final int EXTRA_ALLOC_CAPACITY_SHIFT = 53;
    private static final int EXTRA_ALLOC_CAPACITY_BITS = 5;
    private static final int EXTRA_ALLOC_CAPACITY_MASK = 31;
    private static final int MAX_EXTRA_ALLOC_CAPACITY = 31;
    private static final int BASE_ALLOC_CAPACITY = 17;
    private static final int SPECIAL_VALUE_SHIFT = 58;
    private static final int SPECIAL_VALUE_BITS = 6;
    private static final int SPECIAL_VALUE_MASK = 63;
    private static final int INFLATED_SEGMENT_SPECIAL_VALUE = 32;
    private static final long MIN_BULK_OPERATION_PLACEHOLDER_BIT_SET_AND_STATE = 0x400000000000000L;

    static long makeNewBitSetAndState(int allocCapacity, int segmentOrder) {
        int extraAllocCapacity = allocCapacity - 17;
        return 0xFFFFFFFFFFFFL | (long)segmentOrder << 48 | (long)extraAllocCapacity << 53;
    }

    static long clearBitSet(long bitSetAndState) {
        return bitSetAndState | 0xFFFFFFFFFFFFL;
    }

    static long makeBitSetAndStateForPrivatelyPopulatedContinuousSegment(int allocCapacity, int segmentOrder, int segmentSize) {
        long bitSet = 0xFFFFFFFFFFFFL << segmentSize & 0xFFFFFFFFFFFFL;
        int extraAllocCapacity = allocCapacity - 17;
        return bitSet | (long)segmentOrder << 48 | (long)extraAllocCapacity << 53;
    }

    static long incrementSegmentOrder(long bitSetAndState) {
        return bitSetAndState += 0x1000000000000L;
    }

    static long makeBitSetAndStateWithNewAllocCapacity(long bitSetAndState, int newAllocCapacity) {
        long negativeExtraAllocCapacityMask = -279223176896970753L;
        int newExtraAllocCapacity = newAllocCapacity - 17;
        return bitSetAndState & negativeExtraAllocCapacityMask | (long)newExtraAllocCapacity << 53;
    }

    static long makeInflatedBitSetAndState(int segmentOrder) {
        int extraAllocCapacity = 15;
        return Long.MIN_VALUE | (long)extraAllocCapacity << 53 | (long)segmentOrder << 48;
    }

    static long makeBulkOperationPlaceholderBitSetAndState(long bitSetAndState) {
        return (bitSetAndState | 0x400000000000000L) & 0xFFFF000000000000L;
    }

    static boolean isInflatedBitSetAndState(long bitSetAndState) {
        long inflatedSegment_maxBitSetAndState = -8935141660703064065L;
        return bitSetAndState <= inflatedSegment_maxBitSetAndState;
    }

    static boolean isBulkOperationPlaceholderBitSetAndState(long bitSetAndState) {
        return bitSetAndState >= 0x400000000000000L;
    }

    static long extractBitSetForIteration(long bitSetAndState) {
        return (bitSetAndState ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFFFFFL;
    }

    static int lowestFreeAllocIndex(long bitSetAndState) {
        return Long.numberOfTrailingZeros(bitSetAndState);
    }

    static int freeAllocIndexClosestTo(long bitSetAndState, int allocIndexBoundary, int allocCapacity) {
        long bitSetMask = 0xFFFFFFFFFFFFL >>> 48 - allocCapacity;
        int distanceToClosestNextFreeAllocIndex = Long.numberOfTrailingZeros((bitSetAndState & bitSetMask) >>> allocIndexBoundary);
        int distanceToClosestPrevFreeAllocIndex = Long.numberOfLeadingZeros(bitSetAndState << -allocIndexBoundary);
        int distanceToPrevIsLessThanDistanceToPrev = BitSetAndState.signExtend(distanceToClosestPrevFreeAllocIndex - distanceToClosestNextFreeAllocIndex);
        int closestNextFreeAllocIndex = allocIndexBoundary + distanceToClosestNextFreeAllocIndex;
        int closestPrevFreeAllocIndex = allocIndexBoundary - 1 - distanceToClosestPrevFreeAllocIndex;
        return closestNextFreeAllocIndex + (closestPrevFreeAllocIndex - closestNextFreeAllocIndex & distanceToPrevIsLessThanDistanceToPrev);
    }

    private static int signExtend(int v) {
        return v >> 31;
    }

    static long clearAllocBit(long bitSetAndState, long allocIndex) {
        return bitSetAndState | 1L << (int)allocIndex;
    }

    static long setAllocBit(long bitSetAndState, int allocIndex) {
        return bitSetAndState & (1L << allocIndex ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static long setLowestAllocBit(long bitSetAndState) {
        return bitSetAndState & bitSetAndState - 1L;
    }

    static int segmentSize(long bitSetAndState) {
        return 48 - Long.bitCount(bitSetAndState & 0xFFFFFFFFFFFFL);
    }

    static boolean isEmpty(long bitSetAndState) {
        return (bitSetAndState & 0xFFFFFFFFFFFFL) == 0xFFFFFFFFFFFFL;
    }

    static int segmentOrder(long bitSetAndState) {
        return (int)(bitSetAndState >>> 48) & 0x1F;
    }

    static int allocCapacity(long bitSetAndState) {
        int extraAllocCapacity = (int)(bitSetAndState >>> 53) & 0x1F;
        return 17 + extraAllocCapacity;
    }

    static boolean isFullCapacity(long bitSetAndState) {
        long fullAllocCapacityMask = 0x3E0000000000000L;
        return (bitSetAndState & fullAllocCapacityMask) == fullAllocCapacityMask;
    }

    static int allocCapacityMinusOneHalved(long bitSetAndState) {
        int extraAllocCapacityHalved = (int)(bitSetAndState >>> 54) & 0xF;
        return 8 + extraAllocCapacityHalved;
    }

    private BitSetAndState() {
    }

    static {
        Utils.verifyEqual(48, 48);
        long fullBitSetAndState = -1L;
        Utils.verifyEqual(fullBitSetAndState, -1L);
        Utils.verifyEqual(17, 17);
    }

    static class DebugBitSetAndState {
        final Type type;
        final long bitSet;
        final int size;
        final int order;
        final int allocCapacity;

        DebugBitSetAndState(long bitSetAndState) {
            this.type = Type.fromSpecialValue((int)(bitSetAndState >>> 58));
            this.bitSet = BitSetAndState.extractBitSetForIteration(bitSetAndState);
            this.size = Long.bitCount(this.bitSet);
            this.order = BitSetAndState.segmentOrder(bitSetAndState);
            this.allocCapacity = BitSetAndState.allocCapacity(bitSetAndState);
        }

        public String toString() {
            return "DebugBitSetAndState{type=" + (Object)((Object)this.type) + ", bitSet=" + this.bitSet + ", size=" + this.size + ", order=" + this.order + ", allocCapacity=" + this.allocCapacity + '}';
        }

        static enum Type {
            ORDINARY,
            INFLATED,
            BULK_OPERATION_PLACEHOLDER,
            UNKNOWN;


            static Type fromSpecialValue(int specialValue) {
                switch (specialValue) {
                    case 0: {
                        return ORDINARY;
                    }
                    case 1: {
                        return BULK_OPERATION_PLACEHOLDER;
                    }
                    case 32: {
                        return INFLATED;
                    }
                }
                return UNKNOWN;
            }
        }
    }
}

