/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.smoothie.Utils;
import java.nio.ByteOrder;
import org.checkerframework.common.value.qual.IntVal;

final class HashTable {
    static final boolean IS_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    static final int HASH_TABLE_SLOTS = 64;
    static final int HASH_TABLE_SLOTS_MASK = 63;
    static final int GROUP_SLOTS = 8;
    static final int GROUP_SLOTS_MASK = 7;
    static final int GROUP_SLOTS_DIVISION_SHIFT = 3;
    static final @IntVal(value={8L}) int HASH_TABLE_GROUPS = 8;
    static final int HASH_TABLE_GROUPS_MASK = 7;
    private static final int DATA__ALLOC_INDEX_BITS = 6;
    private static final int DATA__ALLOC_INDEX_MASK = 63;
    private static final int DATA__OUTBOUND_OVERFLOW_BIT = 64;
    private static final int DATA__FULLNESS_BIT = 128;
    static final long EMPTY_DATA_GROUP = 0L;
    private static final long MOST_SIGNIFICANT_SLOT_BITS = -9187201950435737472L;
    private static final long LEAST_SIGNIFICANT_SLOT_BITS = 0x101010101010101L;
    static final long DATA_GROUP__OUTBOUND_OVERFLOW_MASK = 0x4040404040404040L;
    private static final int INFLATED_SEGMENT_MARKER_DATA = 127;
    static final long INFLATED_SEGMENT__MARKER_DATA_GROUP = 0x7F7F7F7F7F7F7F7FL;

    static long baseGroupIndex(long hash) {
        return hash & 7L;
    }

    static long addGroupIndex(long groupIndex, long addition) {
        return groupIndex + addition & 7L;
    }

    static void assertValidGroupIndex(long groupIndex) {
        assert ((groupIndex & 7L) == groupIndex) : "groupIndex=" + groupIndex;
    }

    static void assertValidSlotIndexWithinGroup(int slotIndexWithinGroup) {
        assert ((slotIndexWithinGroup & 7) == slotIndexWithinGroup) : "slotIndexWithinGroup=" + slotIndexWithinGroup;
    }

    static long slotByteOffset(int slotIndexWithinGroup) {
        if (IS_LITTLE_ENDIAN) {
            return slotIndexWithinGroup;
        }
        return 7L - (long)slotIndexWithinGroup;
    }

    static long match(long tagGroup, long tagBitsToMatch, long dataGroup) {
        long x = tagGroup ^ 0x101010101010101L * tagBitsToMatch;
        long matchZeroSlots = x - 0x101010101010101L & ((x ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L);
        return matchZeroSlots & HashTable.matchFull(dataGroup);
    }

    static boolean shouldStopProbing(long dataGroup) {
        return (dataGroup & 0x4040404040404040L) == 0L;
    }

    static long copyOutboundOverflowBits(long fromDataGroup, long toDataGroup) {
        return toDataGroup | fromDataGroup & 0x4040404040404040L;
    }

    static void verifyOutboundOverflowBitsZero(long dataGroup) {
        Utils.verifyEqual(dataGroup & 0x4040404040404040L, 0L);
    }

    static long matchEmpty(long dataGroup) {
        return (dataGroup ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L;
    }

    static long matchFull(long dataGroup) {
        return dataGroup & 0x8080808080808080L;
    }

    static int lowestMatchingSlotIndex(long matchBitMask) {
        return Long.numberOfTrailingZeros(matchBitMask) >>> 3;
    }

    static int lowestMatchingSlotIndexFromTrailingZeros(int bitMaskTrailingZeros) {
        return bitMaskTrailingZeros >>> 3;
    }

    static long firstAllocIndex(long dataGroup, long matchBitMask) {
        return HashTable.extractAllocIndex(dataGroup, Long.numberOfTrailingZeros(matchBitMask));
    }

    static long extractAllocIndex(long dataGroup, int bitMaskTrailingZeros) {
        return dataGroup >>> bitMaskTrailingZeros - 7 & 0x3FL;
    }

    static byte extractDataByte(long dataGroup, int bitMaskTrailingZeros) {
        return (byte)(dataGroup >>> bitMaskTrailingZeros - 7);
    }

    static byte extractTagByte(long tagGroup, int bitMaskTrailingZeros) {
        return (byte)(tagGroup >>> bitMaskTrailingZeros - 7);
    }

    static long setSlotEmpty(long dataGroup, int bitMaskTrailingZeros) {
        return dataGroup & (1L << bitMaskTrailingZeros ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static byte changeAllocIndexInData(int dirtyData, int newAllocIndex) {
        return (byte)(dirtyData & 0xFFFFFFC0 | newAllocIndex);
    }

    static int allocIndex(int dirtyData) {
        return dirtyData & 0x3F;
    }

    static byte makeData(long dataGroup, int allocIndex) {
        return (byte)(allocIndex | 0x80 | (int)dataGroup & 0x40);
    }

    static byte makeDataWithZeroOutboundOverflowBit(int allocIndex) {
        return (byte)(allocIndex | 0x80);
    }

    static byte makeData(long dataGroup, long allocIndex) {
        return (byte)(allocIndex | 0x80L | dataGroup & 0x40L);
    }

    static long fullDataGroupForTesting() {
        return -9187201950435737472L;
    }

    private HashTable() {
    }

    static {
        Utils.verifyEqual(3, Integer.numberOfTrailingZeros(8));
        Utils.verifyEqual(64, 64);
        Utils.verifyEqual(8, 8);
        Utils.verifyEqual(-9187201950435737472L, HashTable.fullDataGroupForTesting());
        Utils.verifyEqual(63, 63);
    }
}

