/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.smoothie.AbstractSegment;
import io.timeandspace.smoothie.BitSetAndState;
import io.timeandspace.smoothie.UnsafeUtils;
import java.util.ConcurrentModificationException;

abstract class InterleavedSegment_BitSetAndStateArea<K, V>
extends AbstractSegment<K, V> {
    long bitSetAndState;
    long outboundOverflowCountsPerGroup;
    private static final long BIT_SET_AND_STATE_OFFSET = UnsafeUtils.getFieldOffset(InterleavedSegment_BitSetAndStateArea.class, "bitSetAndState");
    private static final long OUTBOUND_OVERFLOW_COUNTS_PER_GROUP_OFFSET = UnsafeUtils.getFieldOffset(InterleavedSegment_BitSetAndStateArea.class, "outboundOverflowCountsPerGroup");

    InterleavedSegment_BitSetAndStateArea() {
    }

    static long getBitSetAndState(Object segment) {
        return UnsafeUtils.U.getLong(segment, BIT_SET_AND_STATE_OFFSET);
    }

    static void setBitSetAndState(Object segment, long bitSetAndState) {
        UnsafeUtils.U.putLong(segment, BIT_SET_AND_STATE_OFFSET, bitSetAndState);
    }

    static long getOutboundOverflowCountsPerGroup(Object segment) {
        return UnsafeUtils.U.getLong(segment, OUTBOUND_OVERFLOW_COUNTS_PER_GROUP_OFFSET);
    }

    static void setOutboundOverflowCountsPerGroup(Object segment, long outboundOverflowCountsPerGroup) {
        UnsafeUtils.U.putLong(segment, OUTBOUND_OVERFLOW_COUNTS_PER_GROUP_OFFSET, outboundOverflowCountsPerGroup);
    }

    void clearOutboundOverflowCountsPerGroup() {
        this.outboundOverflowCountsPerGroup = 0L;
    }

    long replaceBitSetAndStateWithBulkOperationPlaceholderOrThrowCme() {
        long bitSetAndState = this.bitSetAndState;
        if (BitSetAndState.isBulkOperationPlaceholderBitSetAndState(bitSetAndState)) {
            throw new ConcurrentModificationException();
        }
        this.bitSetAndState = BitSetAndState.makeBulkOperationPlaceholderBitSetAndState(bitSetAndState);
        return bitSetAndState;
    }

    void setBitSetAndStateAfterBulkOperation(long newBitSetAndState) {
        if (!BitSetAndState.isBulkOperationPlaceholderBitSetAndState(this.bitSetAndState)) {
            throw new ConcurrentModificationException();
        }
        this.bitSetAndState = newBitSetAndState;
    }

    @Deprecated
    final BitSetAndState.DebugBitSetAndState debugBitSetAndState() {
        return new BitSetAndState.DebugBitSetAndState(this.bitSetAndState);
    }
}

