/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.smoothie.BitSetAndState;
import io.timeandspace.smoothie.HashTable;
import io.timeandspace.smoothie.LongMath;
import io.timeandspace.smoothie.OrdinarySegmentStats;
import io.timeandspace.smoothie.OutboundOverflowCounts;
import io.timeandspace.smoothie.RarelyCalledAmortizedPerSegment;
import io.timeandspace.smoothie.Segments;
import io.timeandspace.smoothie.SmoothieMap;
import io.timeandspace.smoothie.UnsafeUtils;
import io.timeandspace.smoothie.Utils;
import java.util.ConcurrentModificationException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

final class InterleavedSegments {
    private static final int NUM_FULL_STRIDES = 7;
    private static final long ALLOCATION_INDEX_SIZE_IN_BYTES = UnsafeUtils.ARRAY_OBJECT_INDEX_SCALE_AS_LONG * 2L;

    InterleavedSegments() {
    }

    static int allocIndexBoundaryForLocalAllocation(int groupIndex, int isFullCapacitySegment) {
        return 2 + isFullCapacitySegment + groupIndex * (4 + isFullCapacitySegment * 2);
    }

    static long allocOffset(long allocIndex, long isFullCapacitySegment) {
        long fullCap_allocOffset = FullCapacitySegment.allocOffset(allocIndex);
        long intermediateCap_allocOffset = IntermediateCapacitySegment.allocOffset(allocIndex);
        return intermediateCap_allocOffset + isFullCapacitySegment * (fullCap_allocOffset - intermediateCap_allocOffset);
    }

    static long readTagGroupAtOffset(Object segment, long tagGroupOffset) {
        return UnsafeUtils.U.getLong(segment, tagGroupOffset);
    }

    static void writeTagGroupAtOffset(Object segment, long tagGroupOffset, long tagGroup) {
        UnsafeUtils.U.putLong(segment, tagGroupOffset, tagGroup);
    }

    static long readDataGroupAtOffset(Object segment, long dataGroupOffset) {
        return UnsafeUtils.U.getLong(segment, dataGroupOffset);
    }

    static void writeDataGroupAtOffset(Object segment, long dataGroupOffset, long dataGroup) {
        UnsafeUtils.U.putLong(segment, dataGroupOffset, dataGroup);
    }

    static void writeTagAndData(Object segment, long isFullCapacitySegment, long groupIndex, int slotIndexWithinGroup, byte tag, byte data) {
        long slotByteOffset = HashTable.slotByteOffset(slotIndexWithinGroup);
        long tagGroupOffset = InterleavedSegments.tagGroupOffset(groupIndex, isFullCapacitySegment);
        UnsafeUtils.U.putByte(segment, tagGroupOffset + slotByteOffset, tag);
        long dataGroupOffset = InterleavedSegments.dataGroupFromTagGroupOffset(tagGroupOffset);
        UnsafeUtils.U.putByte(segment, dataGroupOffset + slotByteOffset, data);
    }

    static long tagGroupOffset(long groupIndex, long isFullCapacitySegment) {
        return IntermediateCapacitySegment.TAG_GROUP_0_OFFSET + isFullCapacitySegment * (FullCapacitySegment.TAG_GROUP_0_OFFSET - IntermediateCapacitySegment.TAG_GROUP_0_OFFSET) + groupIndex * (IntermediateCapacitySegment.STRIDE_SIZE_IN_BYTES + isFullCapacitySegment * (FullCapacitySegment.STRIDE_SIZE_IN_BYTES - IntermediateCapacitySegment.STRIDE_SIZE_IN_BYTES));
    }

    static long dataGroupOffset(long groupIndex, long isFullCapacitySegment) {
        return IntermediateCapacitySegment.DATA_GROUP_0_OFFSET + isFullCapacitySegment * (FullCapacitySegment.DATA_GROUP_0_OFFSET - IntermediateCapacitySegment.DATA_GROUP_0_OFFSET) + groupIndex * (IntermediateCapacitySegment.STRIDE_SIZE_IN_BYTES + isFullCapacitySegment * (FullCapacitySegment.STRIDE_SIZE_IN_BYTES - IntermediateCapacitySegment.STRIDE_SIZE_IN_BYTES));
    }

    static long tagGroupFromDataGroupOffset(long dataGroupOffset) {
        return dataGroupOffset - 8L;
    }

    static long dataGroupFromTagGroupOffset(long tagGroupOffset) {
        return tagGroupOffset + 8L;
    }

    @RarelyCalledAmortizedPerSegment
    static long swapContentsDuringSplit(SmoothieMap.Segment<?, ?> fullCapacitySegment, long fullCapSegment_bitSetAndState, SmoothieMap.Segment<?, ?> intermediateCapacitySegment, long intermediateCapSegment_bitSetAndState) {
        FullCapacitySegment fullCapSegment = (FullCapacitySegment)fullCapacitySegment;
        IntermediateCapacitySegment intermediateCapSegment = (IntermediateCapacitySegment)intermediateCapacitySegment;
        long[] intermediateCapSegment_hashTable = intermediateCapSegment.copyHashTableToArrayDuringSegmentSwap();
        Object[] intermediateCapSegment_entries = intermediateCapSegment.copyEntriesToArrayDuringSegmentSwap();
        long intermediateCapSegment_outboundOverflowCountsPerGroup = intermediateCapSegment.outboundOverflowCountsPerGroup;
        Utils.verifyEqual(intermediateCapSegment_outboundOverflowCountsPerGroup, 0L);
        intermediateCapSegment.clearHashTableAndAllocArea();
        InterleavedSegments.moveContentsFromFullToIntermediateCapacitySegment(fullCapSegment, intermediateCapSegment, intermediateCapSegment_bitSetAndState);
        fullCapSegment.clearHashTableAndAllocArea();
        fullCapSegment_bitSetAndState = fullCapSegment.copyContentsFromArrays(fullCapSegment_bitSetAndState, intermediateCapSegment_hashTable, intermediateCapSegment_entries, intermediateCapSegment_outboundOverflowCountsPerGroup);
        return fullCapSegment_bitSetAndState;
    }

    @RarelyCalledAmortizedPerSegment
    private static void moveContentsFromFullToIntermediateCapacitySegment(FullCapacitySegment fullCapSegment, IntermediateCapacitySegment intermediateCapSegment, long intermediateCapSegment_bitSetAndState) {
        intermediateCapSegment_bitSetAndState = BitSetAndState.clearBitSet(intermediateCapSegment_bitSetAndState);
        for (long groupIndex = 0L; groupIndex < 8L; ++groupIndex) {
            long tagGroup = FullCapacitySegment.readTagGroup(fullCapSegment, groupIndex);
            IntermediateCapacitySegment.writeTagGroup(intermediateCapSegment, groupIndex, tagGroup);
            long fullCapSegment_dataGroup = FullCapacitySegment.readDataGroup(fullCapSegment, groupIndex);
            long bitMask = HashTable.matchFull(fullCapSegment_dataGroup);
            while (bitMask != 0L) {
                int trailingZeros = Long.numberOfTrailingZeros(bitMask);
                long allocIndex = HashTable.extractAllocIndex(fullCapSegment_dataGroup, trailingZeros);
                long allocOffset = FullCapacitySegment.allocOffset(allocIndex);
                Object key = FullCapacitySegment.readKeyAtOffset(fullCapSegment, allocOffset);
                Object value = FullCapacitySegment.readValueAtOffset(fullCapSegment, allocOffset);
                int slotIndexWithinGroup = HashTable.lowestMatchingSlotIndexFromTrailingZeros(trailingZeros);
                intermediateCapSegment_bitSetAndState = intermediateCapSegment.insertDuringContentsMove(intermediateCapSegment_bitSetAndState, groupIndex, slotIndexWithinGroup, key, value);
                bitMask = LongMath.clearLowestSetBit(bitMask);
            }
            intermediateCapSegment.copyOutboundOverflowBitsFrom(groupIndex, fullCapSegment_dataGroup);
        }
        intermediateCapSegment.bitSetAndState = intermediateCapSegment_bitSetAndState;
        intermediateCapSegment.outboundOverflowCountsPerGroup = fullCapSegment.outboundOverflowCountsPerGroup;
    }

    static <K, V> FullCapacitySegment<K, V> grow(SmoothieMap.Segment<K, V> intermediateCapSegment, long intermediateCapSegment_bitSetAndState, int toAllocCapacity) {
        Utils.verifyEqual(toAllocCapacity, 48);
        FullCapacitySegment fullCapSegment = new FullCapacitySegment();
        int segmentOrder = BitSetAndState.segmentOrder(intermediateCapSegment_bitSetAndState);
        long fullCapSegment_bitSetAndState = BitSetAndState.makeNewBitSetAndState(48, segmentOrder);
        fullCapSegment.bitSetAndState = fullCapSegment_bitSetAndState = InterleavedSegments.moveContentsFromIntermediateToFullCapacitySegment((IntermediateCapacitySegment)intermediateCapSegment, fullCapSegment, fullCapSegment_bitSetAndState);
        UnsafeUtils.U.storeFence();
        return fullCapSegment;
    }

    private static long moveContentsFromIntermediateToFullCapacitySegment(IntermediateCapacitySegment intermediateCapSegment, FullCapacitySegment fullCapSegment, long fullCapSegment_bitSetAndState) {
        for (long groupIndex = 0L; groupIndex < 8L; ++groupIndex) {
            long tagGroup = IntermediateCapacitySegment.readTagGroup(intermediateCapSegment, groupIndex);
            FullCapacitySegment.writeTagGroup(fullCapSegment, groupIndex, tagGroup);
            long intermediateCapSegment_dataGroup = IntermediateCapacitySegment.readDataGroup(intermediateCapSegment, groupIndex);
            long bitMask = HashTable.matchFull(intermediateCapSegment_dataGroup);
            while (bitMask != 0L) {
                int trailingZeros = Long.numberOfTrailingZeros(bitMask);
                long allocIndex = HashTable.extractAllocIndex(intermediateCapSegment_dataGroup, trailingZeros);
                long allocOffset = IntermediateCapacitySegment.allocOffset(allocIndex);
                Object key = IntermediateCapacitySegment.readKeyAtOffset(intermediateCapSegment, allocOffset);
                Object value = IntermediateCapacitySegment.readValueAtOffset(intermediateCapSegment, allocOffset);
                int slotIndexWithinGroup = HashTable.lowestMatchingSlotIndexFromTrailingZeros(trailingZeros);
                fullCapSegment_bitSetAndState = fullCapSegment.insertDuringContentsMove(fullCapSegment_bitSetAndState, groupIndex, slotIndexWithinGroup, key, value);
                bitMask = LongMath.clearLowestSetBit(bitMask);
            }
            fullCapSegment.copyOutboundOverflowBitsFrom(groupIndex, intermediateCapSegment_dataGroup);
        }
        fullCapSegment.outboundOverflowCountsPerGroup = intermediateCapSegment.outboundOverflowCountsPerGroup;
        return fullCapSegment_bitSetAndState;
    }

    static <K, V> SmoothieMap.Segment<K, V> allocateNewSegmentWithoutSettingBitSetAndSet(int allocCapacity) {
        SmoothieMap.Segment<K, V> segment = InterleavedSegments.allocateSegment(allocCapacity);
        return segment;
    }

    static <K, V> SmoothieMap.Segment<K, V> createNewSegment(int allocCapacity, int segmentOrder) {
        SmoothieMap.Segment<K, V> segment = InterleavedSegments.allocateNewSegmentWithoutSettingBitSetAndSet(allocCapacity);
        segment.bitSetAndState = BitSetAndState.makeNewBitSetAndState(allocCapacity, segmentOrder);
        UnsafeUtils.U.storeFence();
        return segment;
    }

    private static <K, V> SmoothieMap.Segment<K, V> allocateSegment(int allocCapacity) {
        if (allocCapacity == 48) {
            return new FullCapacitySegment();
        }
        if (allocCapacity == 32) {
            return new IntermediateCapacitySegment();
        }
        throw new AssertionError((Object)"Interleaved segments cannot have arbitrary capacity");
    }

    static class IntermediateCapacitySegment<K, V>
    extends IntermediateCapacitySegment_AllocationSpaceAfterGroup7<K, V> {
        static final long TAG_GROUP_0_OFFSET;
        private static final long DATA_GROUP_0_OFFSET;
        static final long STRIDE_SIZE_IN_BYTES;
        static final int STRIDE_SIZE_IN_ALLOC_INDEXES = 4;
        static final int STRIDE_SIZE_IN_ALLOC_INDEXES__SHIFT = 2;
        static final int STRIDE_SIZE_IN_ALLOC_INDEXES__MASK = 3;
        static final long STRIDE_0_OFFSET;
        static final long ALLOC_INDEX_0_OFFSET;
        static final long ALLOC_INDEX_30_OFFSET;
        static final int STRIDE_0__NUM_ACTUAL_ALLOC_INDEXES = 2;
        static final int STRIDE_8__NUM_ACTUAL_ALLOC_INDEXES = 2;

        IntermediateCapacitySegment() {
        }

        private static long tagGroupOffset(long groupIndex) {
            return TAG_GROUP_0_OFFSET + groupIndex * STRIDE_SIZE_IN_BYTES;
        }

        private static long readTagGroup(Object segment, long groupIndex) {
            return UnsafeUtils.U.getLong(segment, IntermediateCapacitySegment.tagGroupOffset(groupIndex));
        }

        private static void writeTagGroup(Object segment, long groupIndex, long tagGroup) {
            UnsafeUtils.U.putLong(segment, IntermediateCapacitySegment.tagGroupOffset(groupIndex), tagGroup);
        }

        private static long dataGroupOffset(long groupIndex) {
            return DATA_GROUP_0_OFFSET + groupIndex * STRIDE_SIZE_IN_BYTES;
        }

        private static long readDataGroup(Object segment, long groupIndex) {
            return UnsafeUtils.U.getLong(segment, IntermediateCapacitySegment.dataGroupOffset(groupIndex));
        }

        private static void writeDataGroup(Object segment, long groupIndex, long dataGroup) {
            UnsafeUtils.U.putLong(segment, IntermediateCapacitySegment.dataGroupOffset(groupIndex), dataGroup);
        }

        private static void writeData(Object segment, long groupIndex, int slotIndexWithinGroup, byte data) {
            long slotByteOffset = HashTable.slotByteOffset(slotIndexWithinGroup);
            UnsafeUtils.U.putByte(segment, IntermediateCapacitySegment.dataGroupOffset(groupIndex) + slotByteOffset, data);
        }

        private static int allocIndexBoundaryForLocalAllocation(int groupIndex) {
            return 2 + groupIndex * 4;
        }

        private static long allocOffset(long allocIndex) {
            long strideIndex = (allocIndex += 2L) >>> 2;
            long allocIndexWithinStride = allocIndex & 3L;
            return STRIDE_0_OFFSET + strideIndex * STRIDE_SIZE_IN_BYTES + allocIndexWithinStride * ALLOCATION_INDEX_SIZE_IN_BYTES;
        }

        static void writeKeyAndValueAtIndex(Object segment, int allocIndex, Object key, Object value) {
            long allocOffset = IntermediateCapacitySegment.allocOffset(allocIndex);
            UnsafeUtils.U.putObject(segment, allocOffset, key);
            UnsafeUtils.U.putObject(segment, Segments.valueOffsetFromAllocOffset(allocOffset), value);
        }

        private long insertDuringContentsMove(long bitSetAndState, long groupIndex, int slotIndexWithinGroup, Object key, Object value) {
            int insertionAllocIndex = BitSetAndState.freeAllocIndexClosestTo(bitSetAndState, IntermediateCapacitySegment.allocIndexBoundaryForLocalAllocation((int)groupIndex), 32);
            if (insertionAllocIndex >= 32) {
                throw new ConcurrentModificationException("insertionAllocIndex: " + insertionAllocIndex);
            }
            byte dataToInsert = HashTable.makeDataWithZeroOutboundOverflowBit(insertionAllocIndex);
            IntermediateCapacitySegment.writeData(this, groupIndex, slotIndexWithinGroup, dataToInsert);
            IntermediateCapacitySegment.writeKeyAndValueAtIndex(this, insertionAllocIndex, key, value);
            bitSetAndState = BitSetAndState.setAllocBit(bitSetAndState, insertionAllocIndex);
            return bitSetAndState;
        }

        private void copyOutboundOverflowBitsFrom(long groupIndex, long fromDataGroup) {
            long dataGroup = IntermediateCapacitySegment.readDataGroup(this, groupIndex);
            dataGroup = HashTable.copyOutboundOverflowBits(fromDataGroup, dataGroup);
            IntermediateCapacitySegment.writeDataGroup(this, groupIndex, dataGroup);
        }

        @RarelyCalledAmortizedPerSegment
        private Object[] copyEntriesToArrayDuringSegmentSwap() {
            Object[] entries = new Object[64];
            int entriesIndex = 0;
            for (int allocIndex = 0; allocIndex < 32; ++allocIndex) {
                long allocOffset = IntermediateCapacitySegment.allocOffset(allocIndex);
                Object key = IntermediateCapacitySegment.readKeyAtOffset(this, allocOffset);
                Object value = IntermediateCapacitySegment.readValueAtOffset(this, allocOffset);
                entries[entriesIndex++] = key;
                entries[entriesIndex++] = value;
            }
            return entries;
        }

        @RarelyCalledAmortizedPerSegment
        private long[] copyHashTableToArrayDuringSegmentSwap() {
            long[] hashTable = new long[16];
            int hashTableIndex = 0;
            for (long groupIndex = 0L; groupIndex < 8L; ++groupIndex) {
                hashTable[hashTableIndex++] = IntermediateCapacitySegment.readTagGroup(this, groupIndex);
                hashTable[hashTableIndex++] = IntermediateCapacitySegment.readDataGroup(this, groupIndex);
            }
            return hashTable;
        }

        @Override
        void clearHashTableAndAllocArea() {
            this.setAllDataGroups(0L);
            this.clearAllocArea();
        }

        @Override
        void setAllDataGroups(long dataGroup) {
            for (int groupIndex = 0; groupIndex < 8; ++groupIndex) {
                IntermediateCapacitySegment.writeDataGroup(this, groupIndex, dataGroup);
            }
        }

        private void clearAllocArea() {
            UnsafeUtils.U.putObject(this, ALLOC_INDEX_0_OFFSET, null);
            UnsafeUtils.U.putObject(this, Segments.valueOffsetFromAllocOffset(ALLOC_INDEX_0_OFFSET), null);
            long allocIndex1_offset = ALLOC_INDEX_0_OFFSET + ALLOCATION_INDEX_SIZE_IN_BYTES;
            UnsafeUtils.U.putObject(this, allocIndex1_offset, null);
            UnsafeUtils.U.putObject(this, Segments.valueOffsetFromAllocOffset(allocIndex1_offset), null);
            for (int strideIndex = 1; strideIndex <= 7; ++strideIndex) {
                long strideOffset = STRIDE_0_OFFSET + (long)strideIndex * STRIDE_SIZE_IN_BYTES;
                for (int allocIndexWithinStride = 0; allocIndexWithinStride < 4; ++allocIndexWithinStride) {
                    long allocOffset = strideOffset + (long)allocIndexWithinStride * ALLOCATION_INDEX_SIZE_IN_BYTES;
                    UnsafeUtils.U.putObject(this, allocOffset, null);
                    UnsafeUtils.U.putObject(this, Segments.valueOffsetFromAllocOffset(allocOffset), null);
                }
            }
            UnsafeUtils.U.putObject(this, ALLOC_INDEX_30_OFFSET, null);
            UnsafeUtils.U.putObject(this, Segments.valueOffsetFromAllocOffset(ALLOC_INDEX_30_OFFSET), null);
            long allocIndex31_offset = ALLOC_INDEX_30_OFFSET + ALLOCATION_INDEX_SIZE_IN_BYTES;
            UnsafeUtils.U.putObject(this, allocIndex31_offset, null);
            UnsafeUtils.U.putObject(this, Segments.valueOffsetFromAllocOffset(allocIndex31_offset), null);
        }

        @Override
        void copyEntriesDuringInflate(SmoothieMap<K, V> map, SmoothieMap.InflatedSegment<K, V> intoSegment) {
            throw new UnsupportedOperationException("copyEntriesDuringInflate should be called only on full-capacity segments");
        }

        @Override
        void aggregateStats(SmoothieMap<K, V> map, OrdinarySegmentStats ordinarySegmentStats) {
            ordinarySegmentStats.incrementAggregatedSegments(this.bitSetAndState);
            for (long groupIndex = 0L; groupIndex < 8L; ++groupIndex) {
                long dataGroup = IntermediateCapacitySegment.readDataGroup(this, groupIndex);
                int allocIndexBoundaryForGroup = IntermediateCapacitySegment.allocIndexBoundaryForLocalAllocation((int)groupIndex);
                long bitMask = HashTable.matchFull(dataGroup);
                while (bitMask != 0L) {
                    long allocIndex = HashTable.firstAllocIndex(dataGroup, bitMask);
                    long allocOffset = IntermediateCapacitySegment.allocOffset(allocIndex);
                    Object key = IntermediateCapacitySegment.readKeyAtOffset(this, allocOffset);
                    long hash = map.keyHashCode(key);
                    long baseGroupIndex = HashTable.baseGroupIndex(hash);
                    ordinarySegmentStats.aggregateFullSlot(baseGroupIndex, groupIndex, map.countCollisionKeyComparisons(this, key, hash), (int)allocIndex, allocIndexBoundaryForGroup);
                    bitMask = LongMath.clearLowestSetBit(bitMask);
                }
            }
        }

        @Override
        String debugToString() {
            BitSetAndState.DebugBitSetAndState bitSetAndState = new BitSetAndState.DebugBitSetAndState(this.bitSetAndState);
            StringBuilder sb = new StringBuilder();
            sb.append(bitSetAndState).append('\n');
            sb.append("Slots:\n");
            for (int allocIndex = 0; allocIndex < bitSetAndState.allocCapacity; ++allocIndex) {
                long allocOffset = IntermediateCapacitySegment.allocOffset(allocIndex);
                Object key = UnsafeUtils.U.getObject(this, allocOffset);
                Object value = UnsafeUtils.U.getObject(this, Segments.valueOffsetFromAllocOffset(allocOffset));
                sb.append(key).append('=').append(value).append('\n');
            }
            return sb.toString();
        }

        @Override
        @Nullable SmoothieMap.Segment.DebugHashTableSlot<K, V>[] debugHashTable(SmoothieMap<K, V> map) {
            @Nullable SmoothieMap.Segment.DebugHashTableSlot[] debugHashTableSlots = new SmoothieMap.Segment.DebugHashTableSlot[64];
            for (long groupIndex = 0L; groupIndex < 8L; ++groupIndex) {
                long dataGroup = IntermediateCapacitySegment.readDataGroup(this, groupIndex);
                long tagGroup = IntermediateCapacitySegment.readTagGroup(this, groupIndex);
                long bitMask = HashTable.matchFull(dataGroup);
                while (bitMask != 0L) {
                    int trailingZeros = Long.numberOfTrailingZeros(bitMask);
                    long allocIndex = HashTable.extractAllocIndex(dataGroup, trailingZeros);
                    long valueOffset = Segments.valueOffsetFromAllocOffset(IntermediateCapacitySegment.allocOffset(allocIndex));
                    byte tagByte = HashTable.extractTagByte(tagGroup, trailingZeros);
                    int dataByte = Byte.toUnsignedInt(HashTable.extractDataByte(dataGroup, trailingZeros));
                    int slotIndexWithinGroup = HashTable.lowestMatchingSlotIndexFromTrailingZeros(trailingZeros);
                    int slotIndex = (int)(groupIndex * 8L) + slotIndexWithinGroup;
                    debugHashTableSlots[slotIndex] = new SmoothieMap.Segment.DebugHashTableSlot<K, V>(map, this, (int)allocIndex, valueOffset, tagByte, dataByte);
                    bitMask = LongMath.clearLowestSetBit(bitMask);
                }
            }
            return debugHashTableSlots;
        }

        @Override
        int hashCode(SmoothieMap<K, V> map) {
            int h = 0;
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = IntermediateCapacitySegment.allocOffset(iterAllocIndex);
                Object key = IntermediateCapacitySegment.readKeyAtOffset(this, iterAllocOffset);
                Object value = IntermediateCapacitySegment.readValueAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                h += map.keyHashCodeForAggregateHashCodes(key) ^ map.valueHashCodeForAggregateHashCodes(value);
            }
            return h;
        }

        @Override
        int keySetHashCode(SmoothieMap.KeySet<K, V> keySet) {
            SmoothieMap map = keySet.smoothie;
            int h = 0;
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = IntermediateCapacitySegment.allocOffset(iterAllocIndex);
                Object key = IntermediateCapacitySegment.readKeyAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                h += map.keyHashCodeForAggregateHashCodes(key);
            }
            return h;
        }

        @Override
        void forEach(BiConsumer<? super K, ? super V> action) {
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = IntermediateCapacitySegment.allocOffset(iterAllocIndex);
                Object key = IntermediateCapacitySegment.readKeyAtOffset(this, iterAllocOffset);
                Object value = IntermediateCapacitySegment.readValueAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                action.accept(key, value);
            }
        }

        @Override
        boolean forEachWhile(BiPredicate<? super K, ? super V> predicate) {
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = IntermediateCapacitySegment.allocOffset(iterAllocIndex);
                Object key = IntermediateCapacitySegment.readKeyAtOffset(this, iterAllocOffset);
                Object value = IntermediateCapacitySegment.readValueAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                if (predicate.test(key, value)) continue;
                return false;
            }
            return true;
        }

        @Override
        void forEachKey(Consumer<? super K> action) {
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = IntermediateCapacitySegment.allocOffset(iterAllocIndex);
                Object key = IntermediateCapacitySegment.readKeyAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                action.accept(key);
            }
        }

        @Override
        boolean forEachKeyWhile(Predicate<? super K> predicate) {
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = IntermediateCapacitySegment.allocOffset(iterAllocIndex);
                Object key = IntermediateCapacitySegment.readKeyAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                if (predicate.test(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        void forEachValue(Consumer<? super V> action) {
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = IntermediateCapacitySegment.allocOffset(iterAllocIndex);
                Object value = IntermediateCapacitySegment.readValueAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                action.accept(value);
            }
        }

        @Override
        boolean forEachValueWhile(Predicate<? super V> predicate) {
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = IntermediateCapacitySegment.allocOffset(iterAllocIndex);
                Object value = IntermediateCapacitySegment.readValueAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                if (predicate.test(value)) continue;
                return false;
            }
            return true;
        }

        @Override
        void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = IntermediateCapacitySegment.allocOffset(iterAllocIndex);
                Object key = IntermediateCapacitySegment.readKeyAtOffset(this, iterAllocOffset);
                Object value = IntermediateCapacitySegment.readValueAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                IntermediateCapacitySegment.writeValueAtOffset(this, iterAllocOffset, function.apply(key, value));
            }
        }

        @Override
        boolean containsValue(SmoothieMap<K, V> map, V queriedValue) {
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                boolean valuesIdentical;
                long iterAllocOffset = IntermediateCapacitySegment.allocOffset(iterAllocIndex);
                Object internalVal = IntermediateCapacitySegment.readValueAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                boolean bl = valuesIdentical = queriedValue == internalVal;
                if (!valuesIdentical && !map.valuesEqual(queriedValue, internalVal)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int removeIf(SmoothieMap<K, V> map, BiPredicate<? super K, ? super V> filter, int modCount) {
            long bitSetAndState = this.bitSetAndState;
            int initialModCount = modCount;
            try {
                for (int iterGroupIndex = 0; iterGroupIndex < 8; ++iterGroupIndex) {
                    long iterDataGroupOffset = IntermediateCapacitySegment.dataGroupOffset(iterGroupIndex);
                    long dataGroup = InterleavedSegments.readDataGroupAtOffset(this, iterDataGroupOffset);
                    long bitMask = HashTable.matchFull(dataGroup);
                    while (bitMask != 0L) {
                        Object value;
                        int trailingZeros = Long.numberOfTrailingZeros(bitMask);
                        long allocIndex = HashTable.extractAllocIndex(dataGroup, trailingZeros);
                        long allocOffset = IntermediateCapacitySegment.allocOffset(allocIndex);
                        Object key = IntermediateCapacitySegment.readKeyAtOffset(this, allocOffset);
                        if (filter.test(key, value = IntermediateCapacitySegment.readValueAtOffset(this, allocOffset))) {
                            long baseGroupIndex = HashTable.baseGroupIndex(map.keyHashCode(key));
                            long outboundOverflowCount_perGroupDecrements = OutboundOverflowCounts.computeOutboundOverflowCount_perGroupChanges(baseGroupIndex, iterGroupIndex);
                            int isFullCapacitySegment = 0;
                            bitSetAndState = map.removeAtSlotNoShrink(bitSetAndState, this, isFullCapacitySegment, outboundOverflowCount_perGroupDecrements, iterDataGroupOffset, HashTable.setSlotEmpty(dataGroup, trailingZeros), allocIndex, allocOffset);
                            ++modCount;
                        }
                        bitMask = LongMath.clearLowestSetBit(bitMask);
                    }
                }
            }
            finally {
                if (modCount != initialModCount) {
                    this.bitSetAndState = bitSetAndState;
                }
            }
            return modCount;
        }

        static {
            Utils.verifyEqual(4, 4);
            Utils.verifyEqual(2, Integer.numberOfTrailingZeros(4));
            TAG_GROUP_0_OFFSET = UnsafeUtils.minInstanceFieldOffset(IntermediateCapacitySegment_Group0.class);
            DATA_GROUP_0_OFFSET = TAG_GROUP_0_OFFSET + 8L;
            long tagGroup1_offset = UnsafeUtils.minInstanceFieldOffset(IntermediateCapacitySegment_Group1.class);
            STRIDE_SIZE_IN_BYTES = tagGroup1_offset - TAG_GROUP_0_OFFSET;
            long stride1_offset = UnsafeUtils.minInstanceFieldOffset(IntermediateCapacitySegment_AllocationSpaceBetweenGroups0And1.class);
            STRIDE_0_OFFSET = stride1_offset - STRIDE_SIZE_IN_BYTES;
            Utils.verifyEqual(STRIDE_0_OFFSET, TAG_GROUP_0_OFFSET - STRIDE_SIZE_IN_BYTES + 16L);
            ALLOC_INDEX_0_OFFSET = IntermediateCapacitySegment.allocOffset(0L);
            long allocIndex0_offset_obtainedFromFields = UnsafeUtils.minInstanceFieldOffset(IntermediateCapacitySegment_AllocationSpaceBeforeGroup0.class);
            Utils.verifyEqual(ALLOC_INDEX_0_OFFSET, allocIndex0_offset_obtainedFromFields);
            ALLOC_INDEX_30_OFFSET = IntermediateCapacitySegment.allocOffset(30L);
            long allocIndex30_offset_obtainedFromFields = UnsafeUtils.minInstanceFieldOffset(IntermediateCapacitySegment_AllocationSpaceAfterGroup7.class);
            Utils.verifyEqual(ALLOC_INDEX_30_OFFSET, allocIndex30_offset_obtainedFromFields);
        }
    }

    static abstract class IntermediateCapacitySegment_AllocationSpaceAfterGroup7<K, V>
    extends IntermediateCapacitySegment_Group7<K, V> {
        private @Nullable Object k30;
        private @Nullable Object v30;
        private @Nullable Object k31;
        private @Nullable Object v31;

        IntermediateCapacitySegment_AllocationSpaceAfterGroup7() {
        }
    }

    static abstract class IntermediateCapacitySegment_Group7<K, V>
    extends IntermediateCapacitySegment_AllocationSpaceBetweenGroups6And7<K, V> {
        private long tagGroup7;
        private long dataGroup7;

        IntermediateCapacitySegment_Group7() {
        }
    }

    static abstract class IntermediateCapacitySegment_AllocationSpaceBetweenGroups6And7<K, V>
    extends IntermediateCapacitySegment_Group6<K, V> {
        private @Nullable Object k26;
        private @Nullable Object v26;
        private @Nullable Object k27;
        private @Nullable Object v27;
        private @Nullable Object k28;
        private @Nullable Object v28;
        private @Nullable Object k29;
        private @Nullable Object v29;

        IntermediateCapacitySegment_AllocationSpaceBetweenGroups6And7() {
        }
    }

    static abstract class IntermediateCapacitySegment_Group6<K, V>
    extends IntermediateCapacitySegment_AllocationSpaceBetweenGroups5And6<K, V> {
        private long tagGroup6;
        private long dataGroup6;

        IntermediateCapacitySegment_Group6() {
        }
    }

    static abstract class IntermediateCapacitySegment_AllocationSpaceBetweenGroups5And6<K, V>
    extends IntermediateCapacitySegment_Group5<K, V> {
        private @Nullable Object k22;
        private @Nullable Object v22;
        private @Nullable Object k23;
        private @Nullable Object v23;
        private @Nullable Object k24;
        private @Nullable Object v24;
        private @Nullable Object k25;
        private @Nullable Object v25;

        IntermediateCapacitySegment_AllocationSpaceBetweenGroups5And6() {
        }
    }

    static abstract class IntermediateCapacitySegment_Group5<K, V>
    extends IntermediateCapacitySegment_AllocationSpaceBetweenGroups4And5<K, V> {
        private long tagGroup5;
        private long dataGroup5;

        IntermediateCapacitySegment_Group5() {
        }
    }

    static abstract class IntermediateCapacitySegment_AllocationSpaceBetweenGroups4And5<K, V>
    extends IntermediateCapacitySegment_Group4<K, V> {
        private @Nullable Object k18;
        private @Nullable Object v18;
        private @Nullable Object k19;
        private @Nullable Object v19;
        private @Nullable Object k20;
        private @Nullable Object v20;
        private @Nullable Object k21;
        private @Nullable Object v21;

        IntermediateCapacitySegment_AllocationSpaceBetweenGroups4And5() {
        }
    }

    static abstract class IntermediateCapacitySegment_Group4<K, V>
    extends IntermediateCapacitySegment_AllocationSpaceBetweenGroups3And4<K, V> {
        private long tagGroup4;
        private long dataGroup4;

        IntermediateCapacitySegment_Group4() {
        }
    }

    static abstract class IntermediateCapacitySegment_AllocationSpaceBetweenGroups3And4<K, V>
    extends IntermediateCapacitySegment_Group3<K, V> {
        private @Nullable Object k14;
        private @Nullable Object v14;
        private @Nullable Object k15;
        private @Nullable Object v15;
        private @Nullable Object k16;
        private @Nullable Object v16;
        private @Nullable Object k17;
        private @Nullable Object v17;

        IntermediateCapacitySegment_AllocationSpaceBetweenGroups3And4() {
        }
    }

    static abstract class IntermediateCapacitySegment_Group3<K, V>
    extends IntermediateCapacitySegment_AllocationSpaceBetweenGroups2And3<K, V> {
        private long tagGroup3;
        private long dataGroup3;

        IntermediateCapacitySegment_Group3() {
        }
    }

    static abstract class IntermediateCapacitySegment_AllocationSpaceBetweenGroups2And3<K, V>
    extends IntermediateCapacitySegment_Group2<K, V> {
        private @Nullable Object k10;
        private @Nullable Object v10;
        private @Nullable Object k11;
        private @Nullable Object v11;
        private @Nullable Object k12;
        private @Nullable Object v12;
        private @Nullable Object k13;
        private @Nullable Object v13;

        IntermediateCapacitySegment_AllocationSpaceBetweenGroups2And3() {
        }
    }

    static abstract class IntermediateCapacitySegment_Group2<K, V>
    extends IntermediateCapacitySegment_AllocationSpaceBetweenGroups1And2<K, V> {
        private long tagGroup2;
        private long dataGroup2;

        IntermediateCapacitySegment_Group2() {
        }
    }

    static abstract class IntermediateCapacitySegment_AllocationSpaceBetweenGroups1And2<K, V>
    extends IntermediateCapacitySegment_Group1<K, V> {
        private @Nullable Object k6;
        private @Nullable Object v6;
        private @Nullable Object k7;
        private @Nullable Object v7;
        private @Nullable Object k8;
        private @Nullable Object v8;
        private @Nullable Object k9;
        private @Nullable Object v9;

        IntermediateCapacitySegment_AllocationSpaceBetweenGroups1And2() {
        }
    }

    static abstract class IntermediateCapacitySegment_Group1<K, V>
    extends IntermediateCapacitySegment_AllocationSpaceBetweenGroups0And1<K, V> {
        private long tagGroup1;
        private long dataGroup1;

        IntermediateCapacitySegment_Group1() {
        }
    }

    static abstract class IntermediateCapacitySegment_AllocationSpaceBetweenGroups0And1<K, V>
    extends IntermediateCapacitySegment_Group0<K, V> {
        private @Nullable Object k2;
        private @Nullable Object v2;
        private @Nullable Object k3;
        private @Nullable Object v3;
        private @Nullable Object k4;
        private @Nullable Object v4;
        private @Nullable Object k5;
        private @Nullable Object v5;

        IntermediateCapacitySegment_AllocationSpaceBetweenGroups0And1() {
        }
    }

    static abstract class IntermediateCapacitySegment_Group0<K, V>
    extends IntermediateCapacitySegment_AllocationSpaceBeforeGroup0<K, V> {
        private long tagGroup0;
        private long dataGroup0;

        IntermediateCapacitySegment_Group0() {
        }
    }

    static abstract class IntermediateCapacitySegment_AllocationSpaceBeforeGroup0<K, V>
    extends SmoothieMap.Segment<K, V> {
        private @Nullable Object k0;
        private @Nullable Object v0;
        private @Nullable Object k1;
        private @Nullable Object v1;

        IntermediateCapacitySegment_AllocationSpaceBeforeGroup0() {
        }
    }

    static class FullCapacitySegment<K, V>
    extends FullCapacitySegment_AllocationSpaceAfterGroup7<K, V> {
        static final long TAG_GROUP_0_OFFSET;
        private static final long DATA_GROUP_0_OFFSET;
        static final long STRIDE_SIZE_IN_BYTES;
        static final int STRIDE_SIZE_IN_ALLOC_INDEXES = 6;
        static final long STRIDE_0_OFFSET;
        static final long ALLOC_INDEX_0_OFFSET;
        static final long ALLOC_INDEX_45_OFFSET;
        static final int STRIDE_0__NUM_ACTUAL_ALLOC_INDEXES = 3;
        static final int STRIDE_8__NUM_ACTUAL_ALLOC_INDEXES = 3;

        FullCapacitySegment() {
        }

        private static long tagGroupOffset(long groupIndex) {
            return TAG_GROUP_0_OFFSET + groupIndex * STRIDE_SIZE_IN_BYTES;
        }

        private static long readTagGroup(Object segment, long groupIndex) {
            return UnsafeUtils.U.getLong(segment, FullCapacitySegment.tagGroupOffset(groupIndex));
        }

        private static void writeTagGroup(Object segment, long groupIndex, long tagGroup) {
            UnsafeUtils.U.putLong(segment, FullCapacitySegment.tagGroupOffset(groupIndex), tagGroup);
        }

        private static long dataGroupOffset(long groupIndex) {
            return DATA_GROUP_0_OFFSET + groupIndex * STRIDE_SIZE_IN_BYTES;
        }

        static long readDataGroup(Object segment, long groupIndex) {
            return UnsafeUtils.U.getLong(segment, FullCapacitySegment.dataGroupOffset(groupIndex));
        }

        static void writeDataGroup(Object segment, long groupIndex, long dataGroup) {
            UnsafeUtils.U.putLong(segment, FullCapacitySegment.dataGroupOffset(groupIndex), dataGroup);
        }

        static void writeTagAndData(Object segment, long groupIndex, int slotIndexWithinGroup, byte tag, byte data) {
            long slotByteOffset = HashTable.slotByteOffset(slotIndexWithinGroup);
            UnsafeUtils.U.putByte(segment, FullCapacitySegment.tagGroupOffset(groupIndex) + slotByteOffset, tag);
            UnsafeUtils.U.putByte(segment, FullCapacitySegment.dataGroupOffset(groupIndex) + slotByteOffset, data);
        }

        private static void writeData(Object segment, long groupIndex, int slotIndexWithinGroup, byte data) {
            long slotByteOffset = HashTable.slotByteOffset(slotIndexWithinGroup);
            UnsafeUtils.U.putByte(segment, FullCapacitySegment.dataGroupOffset(groupIndex) + slotByteOffset, data);
        }

        static int allocIndexBoundaryForLocalAllocation(int groupIndex) {
            return 3 + groupIndex * 6;
        }

        static long allocOffset(long allocIndex) {
            long strideIndex = (allocIndex += 3L) * 0xAAAAAAABL >>> 34;
            long allocIndexWithinStride = allocIndex - strideIndex * 6L;
            return STRIDE_0_OFFSET + strideIndex * STRIDE_SIZE_IN_BYTES + allocIndexWithinStride * ALLOCATION_INDEX_SIZE_IN_BYTES;
        }

        static void writeKeyAndValueAtIndex(Object segment, int allocIndex, Object key, Object value) {
            long allocOffset = FullCapacitySegment.allocOffset(allocIndex);
            UnsafeUtils.U.putObject(segment, allocOffset, key);
            UnsafeUtils.U.putObject(segment, Segments.valueOffsetFromAllocOffset(allocOffset), value);
        }

        static <K, V> void writeEntry(Object segment, K key, byte tag, V value, long groupIndex, long dataGroup, int slotIndexWithinGroup, int allocIndex) {
            byte data = HashTable.makeData(dataGroup, allocIndex);
            FullCapacitySegment.writeTagAndData(segment, groupIndex, slotIndexWithinGroup, tag, data);
            FullCapacitySegment.writeKeyAndValueAtIndex(segment, allocIndex, key, value);
        }

        private long insertDuringContentsMove(long bitSetAndState, long groupIndex, int slotIndexWithinGroup, Object key, Object value) {
            int insertionAllocIndex = BitSetAndState.freeAllocIndexClosestTo(bitSetAndState, FullCapacitySegment.allocIndexBoundaryForLocalAllocation((int)groupIndex), 48);
            byte dataToInsert = HashTable.makeDataWithZeroOutboundOverflowBit(insertionAllocIndex);
            FullCapacitySegment.writeData(this, groupIndex, slotIndexWithinGroup, dataToInsert);
            FullCapacitySegment.writeKeyAndValueAtIndex(this, insertionAllocIndex, key, value);
            bitSetAndState = BitSetAndState.setAllocBit(bitSetAndState, insertionAllocIndex);
            return bitSetAndState;
        }

        private void copyOutboundOverflowBitsFrom(long groupIndex, long fromDataGroup) {
            long dataGroup = FullCapacitySegment.readDataGroup(this, groupIndex);
            dataGroup = HashTable.copyOutboundOverflowBits(fromDataGroup, dataGroup);
            FullCapacitySegment.writeDataGroup(this, groupIndex, dataGroup);
        }

        @RarelyCalledAmortizedPerSegment
        private long copyContentsFromArrays(long bitSetAndState, long[] hashTable, Object[] entries, long outboundOverflowCountsPerGroup) {
            bitSetAndState = BitSetAndState.clearBitSet(bitSetAndState);
            for (int groupIndex = 0; groupIndex < 8; ++groupIndex) {
                long tagGroup = hashTable[groupIndex * 2];
                FullCapacitySegment.writeTagGroup(this, groupIndex, tagGroup);
                long dataGroupToCopy = hashTable[groupIndex * 2 + 1];
                long bitMask = HashTable.matchFull(dataGroupToCopy);
                while (bitMask != 0L) {
                    int trailingZeros = Long.numberOfTrailingZeros(bitMask);
                    int allocIndex = (int)HashTable.extractAllocIndex(dataGroupToCopy, trailingZeros);
                    Object key = entries[allocIndex * 2];
                    Object value = entries[allocIndex * 2 + 1];
                    int slotIndexWithinGroup = HashTable.lowestMatchingSlotIndexFromTrailingZeros(trailingZeros);
                    bitSetAndState = this.insertDuringContentsMove(bitSetAndState, groupIndex, slotIndexWithinGroup, key, value);
                    bitMask = LongMath.clearLowestSetBit(bitMask);
                }
                this.copyOutboundOverflowBitsFrom(groupIndex, dataGroupToCopy);
            }
            this.outboundOverflowCountsPerGroup = outboundOverflowCountsPerGroup;
            return bitSetAndState;
        }

        @Override
        @RarelyCalledAmortizedPerSegment
        void copyEntriesDuringInflate(SmoothieMap<K, V> map, SmoothieMap.InflatedSegment<K, V> intoSegment) {
            for (int allocIndex = 0; allocIndex < 48; ++allocIndex) {
                long allocOffset = FullCapacitySegment.allocOffset(allocIndex);
                Object key = FullCapacitySegment.readKeyAtOffset(this, allocOffset);
                Object value = FullCapacitySegment.readValueAtOffset(this, allocOffset);
                intoSegment.putDuringInflation(map, key, map.keyHashCode(key), value);
            }
        }

        @Override
        void clearHashTableAndAllocArea() {
            this.setAllDataGroups(0L);
            this.clearAllocArea();
        }

        @Override
        void setAllDataGroups(long dataGroup) {
            for (int groupIndex = 0; groupIndex < 8; ++groupIndex) {
                FullCapacitySegment.writeDataGroup(this, groupIndex, dataGroup);
            }
        }

        private void clearAllocArea() {
            UnsafeUtils.U.putObject(this, ALLOC_INDEX_0_OFFSET, null);
            UnsafeUtils.U.putObject(this, Segments.valueOffsetFromAllocOffset(ALLOC_INDEX_0_OFFSET), null);
            long allocIndex1_offset = ALLOC_INDEX_0_OFFSET + ALLOCATION_INDEX_SIZE_IN_BYTES;
            UnsafeUtils.U.putObject(this, allocIndex1_offset, null);
            UnsafeUtils.U.putObject(this, Segments.valueOffsetFromAllocOffset(allocIndex1_offset), null);
            long allocIndex2_offset = ALLOC_INDEX_0_OFFSET + 2L * ALLOCATION_INDEX_SIZE_IN_BYTES;
            UnsafeUtils.U.putObject(this, allocIndex2_offset, null);
            UnsafeUtils.U.putObject(this, Segments.valueOffsetFromAllocOffset(allocIndex2_offset), null);
            for (int strideIndex = 1; strideIndex <= 7; ++strideIndex) {
                long strideOffset = STRIDE_0_OFFSET + (long)strideIndex * STRIDE_SIZE_IN_BYTES;
                for (int allocIndexWithinStride = 0; allocIndexWithinStride < 6; ++allocIndexWithinStride) {
                    long allocOffset = strideOffset + (long)allocIndexWithinStride * ALLOCATION_INDEX_SIZE_IN_BYTES;
                    UnsafeUtils.U.putObject(this, allocOffset, null);
                    UnsafeUtils.U.putObject(this, Segments.valueOffsetFromAllocOffset(allocOffset), null);
                }
            }
            UnsafeUtils.U.putObject(this, ALLOC_INDEX_45_OFFSET, null);
            UnsafeUtils.U.putObject(this, Segments.valueOffsetFromAllocOffset(ALLOC_INDEX_45_OFFSET), null);
            long allocIndex46_offset = ALLOC_INDEX_45_OFFSET + ALLOCATION_INDEX_SIZE_IN_BYTES;
            UnsafeUtils.U.putObject(this, allocIndex46_offset, null);
            UnsafeUtils.U.putObject(this, Segments.valueOffsetFromAllocOffset(allocIndex46_offset), null);
            long allocIndex47_offset = ALLOC_INDEX_45_OFFSET + 2L * ALLOCATION_INDEX_SIZE_IN_BYTES;
            UnsafeUtils.U.putObject(this, allocIndex47_offset, null);
            UnsafeUtils.U.putObject(this, Segments.valueOffsetFromAllocOffset(allocIndex47_offset), null);
        }

        @Override
        void aggregateStats(SmoothieMap<K, V> map, OrdinarySegmentStats ordinarySegmentStats) {
            ordinarySegmentStats.incrementAggregatedSegments(this.bitSetAndState);
            for (long groupIndex = 0L; groupIndex < 8L; ++groupIndex) {
                long dataGroup = FullCapacitySegment.readDataGroup(this, groupIndex);
                int allocIndexBoundaryForGroup = FullCapacitySegment.allocIndexBoundaryForLocalAllocation((int)groupIndex);
                long bitMask = HashTable.matchFull(dataGroup);
                while (bitMask != 0L) {
                    long allocIndex = HashTable.firstAllocIndex(dataGroup, bitMask);
                    long allocOffset = FullCapacitySegment.allocOffset(allocIndex);
                    Object key = FullCapacitySegment.readKeyAtOffset(this, allocOffset);
                    long hash = map.keyHashCode(key);
                    long baseGroupIndex = HashTable.baseGroupIndex(hash);
                    ordinarySegmentStats.aggregateFullSlot(baseGroupIndex, groupIndex, map.countCollisionKeyComparisons(this, key, hash), (int)allocIndex, allocIndexBoundaryForGroup);
                    bitMask = LongMath.clearLowestSetBit(bitMask);
                }
            }
        }

        @Override
        String debugToString() {
            BitSetAndState.DebugBitSetAndState bitSetAndState = new BitSetAndState.DebugBitSetAndState(this.bitSetAndState);
            StringBuilder sb = new StringBuilder();
            sb.append(bitSetAndState).append('\n');
            sb.append("Slots:\n");
            for (int allocIndex = 0; allocIndex < bitSetAndState.allocCapacity; ++allocIndex) {
                long allocOffset = FullCapacitySegment.allocOffset(allocIndex);
                Object key = UnsafeUtils.U.getObject(this, allocOffset);
                Object value = UnsafeUtils.U.getObject(this, Segments.valueOffsetFromAllocOffset(allocOffset));
                sb.append(key).append('=').append(value).append('\n');
            }
            return sb.toString();
        }

        @Override
        @Nullable SmoothieMap.Segment.DebugHashTableSlot<K, V>[] debugHashTable(SmoothieMap<K, V> map) {
            @Nullable SmoothieMap.Segment.DebugHashTableSlot[] debugHashTableSlots = new SmoothieMap.Segment.DebugHashTableSlot[64];
            for (long groupIndex = 0L; groupIndex < 8L; ++groupIndex) {
                long dataGroup = FullCapacitySegment.readDataGroup(this, groupIndex);
                long tagGroup = FullCapacitySegment.readTagGroup(this, groupIndex);
                long bitMask = HashTable.matchFull(dataGroup);
                while (bitMask != 0L) {
                    int trailingZeros = Long.numberOfTrailingZeros(bitMask);
                    long allocIndex = HashTable.extractAllocIndex(dataGroup, trailingZeros);
                    long valueOffset = Segments.valueOffsetFromAllocOffset(FullCapacitySegment.allocOffset(allocIndex));
                    byte tagByte = HashTable.extractTagByte(tagGroup, trailingZeros);
                    int dataByte = Byte.toUnsignedInt(HashTable.extractDataByte(dataGroup, trailingZeros));
                    int slotIndexWithinGroup = HashTable.lowestMatchingSlotIndexFromTrailingZeros(trailingZeros);
                    int slotIndex = (int)(groupIndex * 8L) + slotIndexWithinGroup;
                    debugHashTableSlots[slotIndex] = new SmoothieMap.Segment.DebugHashTableSlot<K, V>(map, this, (int)allocIndex, valueOffset, tagByte, dataByte);
                    bitMask = LongMath.clearLowestSetBit(bitMask);
                }
            }
            return debugHashTableSlots;
        }

        @Override
        int hashCode(SmoothieMap<K, V> map) {
            int h = 0;
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = FullCapacitySegment.allocOffset(iterAllocIndex);
                Object key = FullCapacitySegment.readKeyAtOffset(this, iterAllocOffset);
                Object value = FullCapacitySegment.readValueAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                h += map.keyHashCodeForAggregateHashCodes(key) ^ map.valueHashCodeForAggregateHashCodes(value);
            }
            return h;
        }

        @Override
        int keySetHashCode(SmoothieMap.KeySet<K, V> keySet) {
            SmoothieMap map = keySet.smoothie;
            int h = 0;
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = FullCapacitySegment.allocOffset(iterAllocIndex);
                Object key = FullCapacitySegment.readKeyAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                h += map.keyHashCodeForAggregateHashCodes(key);
            }
            return h;
        }

        @Override
        void forEach(BiConsumer<? super K, ? super V> action) {
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = FullCapacitySegment.allocOffset(iterAllocIndex);
                Object key = FullCapacitySegment.readKeyAtOffset(this, iterAllocOffset);
                Object value = FullCapacitySegment.readValueAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                action.accept(key, value);
            }
        }

        @Override
        boolean forEachWhile(BiPredicate<? super K, ? super V> predicate) {
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = FullCapacitySegment.allocOffset(iterAllocIndex);
                Object key = FullCapacitySegment.readKeyAtOffset(this, iterAllocOffset);
                Object value = FullCapacitySegment.readValueAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                if (predicate.test(key, value)) continue;
                return false;
            }
            return true;
        }

        @Override
        void forEachKey(Consumer<? super K> action) {
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = FullCapacitySegment.allocOffset(iterAllocIndex);
                Object key = FullCapacitySegment.readKeyAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                action.accept(key);
            }
        }

        @Override
        boolean forEachKeyWhile(Predicate<? super K> predicate) {
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = FullCapacitySegment.allocOffset(iterAllocIndex);
                Object key = FullCapacitySegment.readKeyAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                if (predicate.test(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        void forEachValue(Consumer<? super V> action) {
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = FullCapacitySegment.allocOffset(iterAllocIndex);
                Object value = FullCapacitySegment.readValueAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                action.accept(value);
            }
        }

        @Override
        boolean forEachValueWhile(Predicate<? super V> predicate) {
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = FullCapacitySegment.allocOffset(iterAllocIndex);
                Object value = FullCapacitySegment.readValueAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                if (predicate.test(value)) continue;
                return false;
            }
            return true;
        }

        @Override
        void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                long iterAllocOffset = FullCapacitySegment.allocOffset(iterAllocIndex);
                Object key = FullCapacitySegment.readKeyAtOffset(this, iterAllocOffset);
                Object value = FullCapacitySegment.readValueAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                FullCapacitySegment.writeValueAtOffset(this, iterAllocOffset, function.apply(key, value));
            }
        }

        @Override
        boolean containsValue(SmoothieMap<K, V> map, V queriedValue) {
            long bitSet = BitSetAndState.extractBitSetForIteration(this.bitSetAndState);
            int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
            int iterAllocIndex = 64;
            while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
                boolean valuesIdentical;
                long iterAllocOffset = FullCapacitySegment.allocOffset(iterAllocIndex);
                Object internalVal = FullCapacitySegment.readValueAtOffset(this, iterAllocOffset);
                iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet <<= iterAllocIndexStep) + 1;
                boolean bl = valuesIdentical = queriedValue == internalVal;
                if (!valuesIdentical && !map.valuesEqual(queriedValue, internalVal)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int removeIf(SmoothieMap<K, V> map, BiPredicate<? super K, ? super V> filter, int modCount) {
            long bitSetAndState = this.bitSetAndState;
            int initialModCount = modCount;
            try {
                for (int iterGroupIndex = 0; iterGroupIndex < 8; ++iterGroupIndex) {
                    long iterDataGroupOffset = FullCapacitySegment.dataGroupOffset(iterGroupIndex);
                    long dataGroup = InterleavedSegments.readDataGroupAtOffset(this, iterDataGroupOffset);
                    long bitMask = HashTable.matchFull(dataGroup);
                    while (bitMask != 0L) {
                        Object value;
                        int trailingZeros = Long.numberOfTrailingZeros(bitMask);
                        long allocIndex = HashTable.extractAllocIndex(dataGroup, trailingZeros);
                        long allocOffset = FullCapacitySegment.allocOffset(allocIndex);
                        Object key = FullCapacitySegment.readKeyAtOffset(this, allocOffset);
                        if (filter.test(key, value = FullCapacitySegment.readValueAtOffset(this, allocOffset))) {
                            long baseGroupIndex = HashTable.baseGroupIndex(map.keyHashCode(key));
                            long outboundOverflowCount_perGroupDecrements = OutboundOverflowCounts.computeOutboundOverflowCount_perGroupChanges(baseGroupIndex, iterGroupIndex);
                            int isFullCapacitySegment = 1;
                            bitSetAndState = map.removeAtSlotNoShrink(bitSetAndState, this, isFullCapacitySegment, outboundOverflowCount_perGroupDecrements, iterDataGroupOffset, HashTable.setSlotEmpty(dataGroup, trailingZeros), allocIndex, allocOffset);
                            ++modCount;
                        }
                        bitMask = LongMath.clearLowestSetBit(bitMask);
                    }
                }
            }
            finally {
                if (modCount != initialModCount) {
                    this.bitSetAndState = bitSetAndState;
                }
            }
            return modCount;
        }

        static {
            Utils.verifyEqual(6, 6);
            TAG_GROUP_0_OFFSET = UnsafeUtils.minInstanceFieldOffset(FullCapacitySegment_Group0.class);
            DATA_GROUP_0_OFFSET = TAG_GROUP_0_OFFSET + 8L;
            long tagGroup1_offset = UnsafeUtils.minInstanceFieldOffset(FullCapacitySegment_Group1.class);
            STRIDE_SIZE_IN_BYTES = tagGroup1_offset - TAG_GROUP_0_OFFSET;
            long stride1_offset = UnsafeUtils.minInstanceFieldOffset(FullCapacitySegment_AllocationSpaceBetweenGroups0And1.class);
            STRIDE_0_OFFSET = stride1_offset - STRIDE_SIZE_IN_BYTES;
            Utils.verifyEqual(STRIDE_0_OFFSET, TAG_GROUP_0_OFFSET - STRIDE_SIZE_IN_BYTES + 16L);
            ALLOC_INDEX_0_OFFSET = FullCapacitySegment.allocOffset(0L);
            Utils.verifyEqual(ALLOC_INDEX_0_OFFSET, UnsafeUtils.minInstanceFieldOffset(FullCapacitySegment_AllocationSpaceBeforeGroup0.class));
            ALLOC_INDEX_45_OFFSET = FullCapacitySegment.allocOffset(45L);
            Utils.verifyEqual(ALLOC_INDEX_45_OFFSET, UnsafeUtils.minInstanceFieldOffset(FullCapacitySegment_AllocationSpaceAfterGroup7.class));
        }
    }

    static abstract class FullCapacitySegment_AllocationSpaceAfterGroup7<K, V>
    extends FullCapacitySegment_Group7<K, V> {
        @Nullable Object k45;
        @Nullable Object v45;
        @Nullable Object k46;
        @Nullable Object v46;
        @Nullable Object k47;
        @Nullable Object v47;

        FullCapacitySegment_AllocationSpaceAfterGroup7() {
        }
    }

    static abstract class FullCapacitySegment_Group7<K, V>
    extends FullCapacitySegment_AllocationSpaceBetweenGroups6And7<K, V> {
        private long tagGroup7;
        private long dataGroup7;

        FullCapacitySegment_Group7() {
        }
    }

    static abstract class FullCapacitySegment_AllocationSpaceBetweenGroups6And7<K, V>
    extends FullCapacitySegment_Group6<K, V> {
        @Nullable Object k39;
        @Nullable Object v39;
        @Nullable Object k40;
        @Nullable Object v40;
        @Nullable Object k41;
        @Nullable Object v41;
        @Nullable Object k42;
        @Nullable Object v42;
        @Nullable Object k43;
        @Nullable Object v43;
        @Nullable Object k44;
        @Nullable Object v44;

        FullCapacitySegment_AllocationSpaceBetweenGroups6And7() {
        }
    }

    static abstract class FullCapacitySegment_Group6<K, V>
    extends FullCapacitySegment_AllocationSpaceBetweenGroups5And6<K, V> {
        private long tagGroup6;
        private long dataGroup6;

        FullCapacitySegment_Group6() {
        }
    }

    static abstract class FullCapacitySegment_AllocationSpaceBetweenGroups5And6<K, V>
    extends FullCapacitySegment_Group5<K, V> {
        @Nullable Object k33;
        @Nullable Object v33;
        @Nullable Object k34;
        @Nullable Object v34;
        @Nullable Object k35;
        @Nullable Object v35;
        @Nullable Object k36;
        @Nullable Object v36;
        @Nullable Object k37;
        @Nullable Object v37;
        @Nullable Object k38;
        @Nullable Object v38;

        FullCapacitySegment_AllocationSpaceBetweenGroups5And6() {
        }
    }

    static abstract class FullCapacitySegment_Group5<K, V>
    extends FullCapacitySegment_AllocationSpaceBetweenGroups4And5<K, V> {
        private long tagGroup5;
        private long dataGroup5;

        FullCapacitySegment_Group5() {
        }
    }

    static abstract class FullCapacitySegment_AllocationSpaceBetweenGroups4And5<K, V>
    extends FullCapacitySegment_Group4<K, V> {
        @Nullable Object k27;
        @Nullable Object v27;
        @Nullable Object k28;
        @Nullable Object v28;
        @Nullable Object k29;
        @Nullable Object v29;
        @Nullable Object k30;
        @Nullable Object v30;
        @Nullable Object k31;
        @Nullable Object v31;
        @Nullable Object k32;
        @Nullable Object v32;

        FullCapacitySegment_AllocationSpaceBetweenGroups4And5() {
        }
    }

    static abstract class FullCapacitySegment_Group4<K, V>
    extends FullCapacitySegment_AllocationSpaceBetweenGroups3And4<K, V> {
        private long tagGroup4;
        private long dataGroup4;

        FullCapacitySegment_Group4() {
        }
    }

    static abstract class FullCapacitySegment_AllocationSpaceBetweenGroups3And4<K, V>
    extends FullCapacitySegment_Group3<K, V> {
        @Nullable Object k21;
        @Nullable Object v21;
        @Nullable Object k22;
        @Nullable Object v22;
        @Nullable Object k23;
        @Nullable Object v23;
        @Nullable Object k24;
        @Nullable Object v24;
        @Nullable Object k25;
        @Nullable Object v25;
        @Nullable Object k26;
        @Nullable Object v26;

        FullCapacitySegment_AllocationSpaceBetweenGroups3And4() {
        }
    }

    static abstract class FullCapacitySegment_Group3<K, V>
    extends FullCapacitySegment_AllocationSpaceBetweenGroups2And3<K, V> {
        private long tagGroup3;
        private long dataGroup3;

        FullCapacitySegment_Group3() {
        }
    }

    static abstract class FullCapacitySegment_AllocationSpaceBetweenGroups2And3<K, V>
    extends FullCapacitySegment_Group2<K, V> {
        @Nullable Object k15;
        @Nullable Object v15;
        @Nullable Object k16;
        @Nullable Object v16;
        @Nullable Object k17;
        @Nullable Object v17;
        @Nullable Object k18;
        @Nullable Object v18;
        @Nullable Object k19;
        @Nullable Object v19;
        @Nullable Object k20;
        @Nullable Object v20;

        FullCapacitySegment_AllocationSpaceBetweenGroups2And3() {
        }
    }

    static abstract class FullCapacitySegment_Group2<K, V>
    extends FullCapacitySegment_AllocationSpaceBetweenGroups1And2<K, V> {
        private long tagGroup2;
        private long dataGroup2;

        FullCapacitySegment_Group2() {
        }
    }

    static abstract class FullCapacitySegment_AllocationSpaceBetweenGroups1And2<K, V>
    extends FullCapacitySegment_Group1<K, V> {
        @Nullable Object k9;
        @Nullable Object v9;
        @Nullable Object k10;
        @Nullable Object v10;
        @Nullable Object k11;
        @Nullable Object v11;
        @Nullable Object k12;
        @Nullable Object v12;
        @Nullable Object k13;
        @Nullable Object v13;
        @Nullable Object k14;
        @Nullable Object v14;

        FullCapacitySegment_AllocationSpaceBetweenGroups1And2() {
        }
    }

    static abstract class FullCapacitySegment_Group1<K, V>
    extends FullCapacitySegment_AllocationSpaceBetweenGroups0And1<K, V> {
        private long tagGroup1;
        private long dataGroup1;

        FullCapacitySegment_Group1() {
        }
    }

    static abstract class FullCapacitySegment_AllocationSpaceBetweenGroups0And1<K, V>
    extends FullCapacitySegment_Group0<K, V> {
        @Nullable Object k3;
        @Nullable Object v3;
        @Nullable Object k4;
        @Nullable Object v4;
        @Nullable Object k5;
        @Nullable Object v5;
        @Nullable Object k6;
        @Nullable Object v6;
        @Nullable Object k7;
        @Nullable Object v7;
        @Nullable Object k8;
        @Nullable Object v8;

        FullCapacitySegment_AllocationSpaceBetweenGroups0And1() {
        }
    }

    static abstract class FullCapacitySegment_Group0<K, V>
    extends FullCapacitySegment_AllocationSpaceBeforeGroup0<K, V> {
        private long tagGroup0;
        private long dataGroup0;

        FullCapacitySegment_Group0() {
        }
    }

    static abstract class FullCapacitySegment_AllocationSpaceBeforeGroup0<K, V>
    extends SmoothieMap.Segment<K, V> {
        @Nullable Object k0;
        @Nullable Object v0;
        @Nullable Object k1;
        @Nullable Object v1;
        @Nullable Object k2;
        @Nullable Object v2;

        FullCapacitySegment_AllocationSpaceBeforeGroup0() {
        }
    }
}

