/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.smoothie.UnsafeUtils;
import io.timeandspace.smoothie.Utils;
import java.util.Arrays;

final class IsFullCapacitySegmentBitSet {
    private static final int INDEX_SHIFT = 5;
    private static final int BIT_INDEX_MASK = 31;

    static int[] allocate(int segmentsArrayLength) {
        return new int[IsFullCapacitySegmentBitSet.bitSetArrayLengthFromSegmentsArrayLength(segmentsArrayLength)];
    }

    static int bitSetArrayLengthFromSegmentsArrayLength(int segmentsArrayLength) {
        Utils.verifyIsPowerOfTwo(segmentsArrayLength, "segmentsArrayLength");
        return (segmentsArrayLength + 32 - 1) / 32;
    }

    static void setAll(int[] bitSet) {
        int allSetWord = -1;
        Arrays.fill(bitSet, allSetWord);
    }

    static int[] duplicate(int[] bitSet, int oldSegmentsArrayLength, int newSegmentsArrayLength) {
        int numFilledBits;
        int[] newBitSet;
        Utils.verifyIsPowerOfTwo(oldSegmentsArrayLength, "oldSegmentsArrayLength");
        Utils.verifyIsPowerOfTwo(newSegmentsArrayLength, "newSegmentsArrayLength");
        int newArrayLength = Math.max(1, newSegmentsArrayLength >>> 5);
        if (newSegmentsArrayLength <= 32) {
            newBitSet = bitSet;
        } else {
            newBitSet = new int[newArrayLength];
            int oldArrayLength = Math.max(1, oldSegmentsArrayLength >>> 5);
            System.arraycopy(bitSet, 0, newBitSet, 0, oldArrayLength);
        }
        int numBitsGrowthLimitWithinWord = Math.min(newSegmentsArrayLength, 32);
        for (numFilledBits = oldSegmentsArrayLength; numFilledBits < numBitsGrowthLimitWithinWord; numFilledBits *= 2) {
            int word = newBitSet[0];
            int mask = (1 << numFilledBits) - 1 << numFilledBits;
            newBitSet[0] = word = word & ~mask | word << numFilledBits;
        }
        if (newSegmentsArrayLength > 32) {
            int filledLowPartLength = numFilledBits >>> 5;
            Utils.duplicateArray(newBitSet, newArrayLength, filledLowPartLength);
        }
        return newBitSet;
    }

    static int getValue(Object bitSet, long index) {
        long wordIndex = index >>> 5;
        long bitIndex = index & 0x1FL;
        long offset = UnsafeUtils.ARRAY_INT_BASE_OFFSET_AS_LONG + 4L * wordIndex;
        int word = UnsafeUtils.U.getInt(bitSet, offset);
        return word >>> (int)bitIndex & 1;
    }

    static void setValue(int[] bitSet, int index, int value) {
        int wordIndex = index >>> 5;
        int bitIndex = index & 0x1F;
        int word = bitSet[wordIndex];
        bitSet[wordIndex] = word = word & ~(1 << bitIndex) | value << bitIndex;
    }

    private IsFullCapacitySegmentBitSet() {
    }

    static {
        Utils.verifyEqual(5, Integer.numberOfTrailingZeros(32));
    }
}

