/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

final class LongMath {
    LongMath() {
    }

    static long clearLowestSetBit(long bitMask) {
        return bitMask & bitMask - 1L;
    }

    static long clearLowestNBits(long bitMask, int n) {
        if (n <= 0 || n > 63) {
            throw new IllegalArgumentException("n must be between 1 and 63, " + n + " given");
        }
        return bitMask & -1L << n;
    }

    static long floorPowerOfTwo(long x) {
        if (x <= 0L) {
            throw new IllegalArgumentException("x must be positive, " + x + " given");
        }
        return Long.highestOneBit(x);
    }

    static double percentOf(long x, long total) {
        return 100.0 * (double)x / (double)total;
    }
}

