/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.smoothie.BitSetAndState;
import io.timeandspace.smoothie.LongMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.IntToLongFunction;
import java.util.stream.IntStream;

final class OrdinarySegmentStats {
    private static final int[] QUADRATIC_PROBING_CHAIN_GROUP_INDEX_TO_CHAIN_LENGTH = new int[8];
    private int numAggregatedSegments = 0;
    private long numAggregatedFullSlots = 0L;
    private final long[] numAggregatedSegmentsPerAllocCapacity = new long[49];
    private final long[] numSlotsPerCollisionChainGroupLength = new long[8];
    private final long[] numSlotsPerNumCollisionKeyComparisons = new long[48];
    private final long[] numSlotsPerDistancesToAllocIndexBoundary = new long[45];

    OrdinarySegmentStats() {
    }

    int getNumAggregatedSegments() {
        return this.numAggregatedSegments;
    }

    long getNumAggregatedFullSlots() {
        return this.numAggregatedFullSlots;
    }

    void aggregateFullSlot(long baseGroupIndex, long groupIndex, int numCollisionKeyComparisons, int allocIndex, int allocIndexBoundaryForGroup) {
        int collisionChainGroupLength;
        int quadraticProbingChainGroupIndex = (int)(groupIndex - baseGroupIndex & 7L);
        int n = collisionChainGroupLength = QUADRATIC_PROBING_CHAIN_GROUP_INDEX_TO_CHAIN_LENGTH[quadraticProbingChainGroupIndex];
        this.numSlotsPerCollisionChainGroupLength[n] = this.numSlotsPerCollisionChainGroupLength[n] + 1L;
        int n2 = numCollisionKeyComparisons;
        this.numSlotsPerNumCollisionKeyComparisons[n2] = this.numSlotsPerNumCollisionKeyComparisons[n2] + 1L;
        int distanceToAllocIndexBoundary = allocIndex >= allocIndexBoundaryForGroup ? allocIndex - allocIndexBoundaryForGroup : allocIndexBoundaryForGroup - allocIndex - 1;
        int n3 = distanceToAllocIndexBoundary;
        this.numSlotsPerDistancesToAllocIndexBoundary[n3] = this.numSlotsPerDistancesToAllocIndexBoundary[n3] + 1L;
        ++this.numAggregatedFullSlots;
    }

    void incrementAggregatedSegments(long bitSetAndState) {
        ++this.numAggregatedSegments;
        int n = BitSetAndState.allocCapacity(bitSetAndState);
        this.numAggregatedSegmentsPerAllocCapacity[n] = this.numAggregatedSegmentsPerAllocCapacity[n] + 1L;
    }

    void add(OrdinarySegmentStats other) {
        this.numAggregatedSegments += other.numAggregatedSegments;
        OrdinarySegmentStats.addMetricArrays(this.numAggregatedSegmentsPerAllocCapacity, other.numAggregatedSegmentsPerAllocCapacity);
        this.numAggregatedFullSlots += other.numAggregatedFullSlots;
        OrdinarySegmentStats.addMetricArrays(this.numSlotsPerCollisionChainGroupLength, other.numSlotsPerCollisionChainGroupLength);
        OrdinarySegmentStats.addMetricArrays(this.numSlotsPerNumCollisionKeyComparisons, other.numSlotsPerNumCollisionKeyComparisons);
        OrdinarySegmentStats.addMetricArrays(this.numSlotsPerDistancesToAllocIndexBoundary, other.numSlotsPerDistancesToAllocIndexBoundary);
    }

    private static void addMetricArrays(long[] target, long[] source) {
        for (int i = 0; i < target.length; ++i) {
            int n = i;
            target[n] = target[n] + source[i];
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Number of segments: %d%n", this.numAggregatedSegments));
        Count segments = new Count("segments", allocCapacity -> this.numAggregatedSegmentsPerAllocCapacity[allocCapacity]);
        OrdinarySegmentStats.appendNonZeroOrderedCountsWithPercentiles(sb, "segments with alloc capacity =", this.numAggregatedSegmentsPerAllocCapacity.length, Collections.singletonList(segments), allocCapacity -> {});
        double averageFullSlots = (double)this.numAggregatedFullSlots / (double)this.numAggregatedSegments;
        sb.append(String.format("Average full slots: %.2f%n", averageFullSlots));
        OrdinarySegmentStats.appendSlotMetricStats(sb, this.numSlotsPerCollisionChainGroupLength, "collision chain group length");
        OrdinarySegmentStats.appendSlotMetricStats(sb, this.numSlotsPerNumCollisionKeyComparisons, "num collision key comparisons");
        OrdinarySegmentStats.appendSlotMetricStats(sb, this.numSlotsPerDistancesToAllocIndexBoundary, "distance to alloc index boundary");
        return sb.toString();
    }

    private static void appendSlotMetricStats(StringBuilder sb, long[] numSlotsPerMetric, String metricName) {
        OrdinarySegmentStats.appendMetricStats(sb, "slots", numSlotsPerMetric, metricName);
    }

    static void appendMetricStats(StringBuilder sb, String countName, long[] countsPerMetric, String metricName) {
        long totalMetricSum = 0L;
        long totalCount = 0L;
        for (int metricValue2 = 0; metricValue2 < countsPerMetric.length; ++metricValue2) {
            long countWithMetricValue = countsPerMetric[metricValue2];
            totalMetricSum += countWithMetricValue * (long)metricValue2;
            totalCount += countWithMetricValue;
        }
        double averageMetricValue = (double)totalMetricSum / (double)totalCount;
        sb.append(String.format("Average %s: %.2f%n", metricName, averageMetricValue));
        OrdinarySegmentStats.appendNonZeroOrderedCountsWithPercentiles(sb, metricName + " =", countsPerMetric.length, Collections.singletonList(new Count(countName, metricValue -> countsPerMetric[metricValue])), metricValue -> {});
    }

    static void appendNonZeroOrderedCountsWithPercentiles(StringBuilder sb, String orderPrefix, int maxOrderExclusive, List<Count> counts, IntConsumer perOrderAction) {
        int maxOrderWidth = String.valueOf(maxOrderExclusive - 1).length();
        String lineFormat = orderPrefix + " %" + maxOrderWidth + "d:";
        for (Count count2 : counts) {
            long maxCount = IntStream.range(0, maxOrderExclusive).mapToLong(count2.countFunction).max().orElse(0L);
            int maxCountWidth = String.valueOf(maxCount).length();
            lineFormat = lineFormat + " %" + maxCountWidth + "d " + count2.name + ", %6.2f%% %6.2f%%";
        }
        lineFormat = lineFormat + "%n";
        long[] totalCounts = counts.stream().mapToLong(count -> IntStream.range(0, maxOrderExclusive).mapToLong(count.countFunction).sum()).toArray();
        long[] currentAggregatedCounts = new long[counts.size()];
        for (int order = 0; order < maxOrderExclusive; ++order) {
            int finalOrder = order;
            long[] countsForOrder = counts.stream().mapToLong(count -> count.countFunction.applyAsLong(finalOrder)).toArray();
            if (Arrays.stream(countsForOrder).allMatch(c -> c == 0L)) continue;
            Arrays.setAll(currentAggregatedCounts, i -> currentAggregatedCounts[i] + countsForOrder[i]);
            ArrayList<Number> formatArguments = new ArrayList<Number>();
            formatArguments.add(order);
            for (int i2 = 0; i2 < counts.size(); ++i2) {
                double percentile = LongMath.percentOf(countsForOrder[i2], totalCounts[i2]);
                double currentAggregatedPercentile = LongMath.percentOf(currentAggregatedCounts[i2], totalCounts[i2]);
                formatArguments.add(countsForOrder[i2]);
                formatArguments.add(percentile);
                formatArguments.add(currentAggregatedPercentile);
            }
            sb.append(String.format(lineFormat, formatArguments.toArray()));
            perOrderAction.accept(order);
        }
    }

    static {
        int groupIndex = 0;
        int step = 0;
        int chainLength = 0;
        while (chainLength < QUADRATIC_PROBING_CHAIN_GROUP_INDEX_TO_CHAIN_LENGTH.length) {
            OrdinarySegmentStats.QUADRATIC_PROBING_CHAIN_GROUP_INDEX_TO_CHAIN_LENGTH[groupIndex] = chainLength++;
            groupIndex = (groupIndex + ++step) % 8;
        }
    }

    static class Count {
        final String name;
        final IntToLongFunction countFunction;

        Count(String name, IntToLongFunction countFunction) {
            this.name = name;
            this.countFunction = countFunction;
        }
    }
}

