/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.DoNotCall;
import io.timeandspace.collect.Equivalence;
import io.timeandspace.collect.ObjCollection;
import io.timeandspace.collect.ObjSet;
import io.timeandspace.collect.map.KeyValue;
import io.timeandspace.collect.map.ObjObjMap;
import io.timeandspace.smoothie.AbstractEntry;
import io.timeandspace.smoothie.BitSetAndState;
import io.timeandspace.smoothie.DefaultHashFunction;
import io.timeandspace.smoothie.HashTable;
import io.timeandspace.smoothie.InflatedSegmentQueryContext;
import io.timeandspace.smoothie.InterleavedSegment_BitSetAndStateArea;
import io.timeandspace.smoothie.InterleavedSegments;
import io.timeandspace.smoothie.IsFullCapacitySegmentBitSet;
import io.timeandspace.smoothie.KeySearchStats;
import io.timeandspace.smoothie.LongMath;
import io.timeandspace.smoothie.ObjectSize;
import io.timeandspace.smoothie.OrdinarySegmentStats;
import io.timeandspace.smoothie.OutboundOverflowCounts;
import io.timeandspace.smoothie.RarelyCalledAmortizedPerSegment;
import io.timeandspace.smoothie.Segments;
import io.timeandspace.smoothie.SimpleMutableEntry;
import io.timeandspace.smoothie.SmoothieMapBuilder;
import io.timeandspace.smoothie.SmoothieMapStats;
import io.timeandspace.smoothie.UnsafeUtils;
import io.timeandspace.smoothie.Utils;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.value.qual.IntRange;
import org.jetbrains.annotations.Contract;
import sun.misc.Unsafe;

public class SmoothieMap<K, V>
implements ObjObjMap<K, V> {
    private static final long SIZE_IN_BYTES = ObjectSize.classSizeInBytes(SmoothieMap.class);
    private static final long KEY_SET__SIZE_IN_BYTES = ObjectSize.classSizeInBytes(KeySet.class);
    private static final long VALUES__SIZE_IN_BYTES = ObjectSize.classSizeInBytes(Values.class);
    private static final long ENTRY_SET__SIZE_IN_BYTES = ObjectSize.classSizeInBytes(EntrySet.class);
    static final double POOR_HASH_CODE_DISTRIB__BENIGN_OCCASION__MAX_PROB__MAX = 0.2;
    static final double POOR_HASH_CODE_DISTRIB__BENIGN_OCCASION__MAX_PROB__MIN = 1.0E-5;
    static final int MAX_SEGMENTS_ARRAY_ORDER = 30;
    private static final int MAX_SEGMENTS_ARRAY_LENGTH = 0x40000000;
    static final int SEGMENT_MAX_ALLOC_CAPACITY = 48;
    static final int MAX_ALLOC_CAPACITY_POWER_OF_TWO_COMPONENT_SIZE = 16;
    static final int MAX_ALLOC_CAPACITY_POWER_OF_TWO_COMPONENT_SIZE_DIVISION_SHIFT = 4;
    static final int SEGMENT_INTERMEDIATE_ALLOC_CAPACITY = 32;
    private static final int MIN_ENTRIES_IN_INTERMEDIATE_CAPACITY_SEGMENT_AFTER_SPLIT_FOR_SWAPPING = 29;
    private static final long FULL_CAPACITY_SEGMENT_SIZE_IN_BYTES;
    private static final long INTERMEDIATE_CAPACITY_SEGMENT_SIZE_IN_BYTES;
    private static final long MAP_AVERAGE_SEGMENTS_SATURATION_SEGMENT_CAPACITY_POWER_OF_TWO_COMPONENTS = 0xC0000000L;
    static final int MAX_SEGMENT_ORDER_DIFFERENCE_FROM_AVERAGE = 1;
    static final int MIN_ROUNDED_UP_AVERAGE_ENTRIES_PER_SEGMENT = 32;
    static final int MAX_ROUNDED_UP_AVERAGE_ENTRIES_PER_SEGMENT = 63;
    private static final long[] SEGMENTS_QUADRUPLING_FROM_REF_SIZE_4;
    private static final long[] SEGMENTS_QUADRUPLING_FROM_REF_SIZE_8;
    private static final long[] SEGMENTS_QUADRUPLING_FROM;
    private static final byte[] ALLOC_CAPACITIES_REF_SIZE_4;
    private static final byte[] ALLOC_CAPACITIES_REF_SIZE_8;
    private static final byte[] ALLOC_CAPACITIES;
    static final int HASH__SEGMENT_LOOKUP_SHIFT = 11;
    private static final int HASH__SEGMENT_ARRAY_OFFSET_SHIFT;
    private static final AtomicIntegerFieldUpdater<SmoothieMap> SEGMENT_STRUCTURE_MODIFICATION_STAMP_UPDATER;
    private static final long MOD_COUNT_FIELD_OFFSET;
    static final long LONG_PHI_MAGIC = -7046029254386353131L;
    private volatile int segmentStructureModStamp = 0;
    private volatile long segmentLookupMask;
    @Nullable Object segmentsArray;
    private long size;
    private int modCount;
    @MonotonicNonNull InflatedSegmentQueryContext<K, V> inflatedSegmentQueryContext;
    byte averageSegmentOrder_lastComputed;
    private boolean allocateIntermediateSegments;
    private boolean splitBetweenTwoNewSegments;
    private Object isFullCapacitySegmentBitSet;
    private boolean doShrink;
    private @MonotonicNonNull ObjSet<K> keySet;
    private @MonotonicNonNull Collection<V> values;
    private @MonotonicNonNull ObjSet<Map.Entry<K, V>> entrySet;

    @Contract(value=" -> new", pure=true)
    public static <K, V> SmoothieMapBuilder<K, V> newBuilder() {
        return SmoothieMapBuilder.create();
    }

    static int doComputeAverageSegmentOrder(long size) {
        assert (size > 0L);
        long saturatedSize = size + 48L - 1L;
        long segmentCapacityPowerOfTwoComponents = Math.min(saturatedSize >>> 4, 0xC0000000L);
        int averageSegments = (int)(segmentCapacityPowerOfTwoComponents * 0xAAAAAAABL >>> 33);
        return 32 - Integer.numberOfLeadingZeros(averageSegments - 1);
    }

    static int maxSplittableSegmentOrder(int averageSegmentOrder) {
        return averageSegmentOrder + 1 - 1;
    }

    private static SegmentsArrayLengthAndNumSegments chooseInitialSegmentsArrayLength(SmoothieMapBuilder<?, ?> builder) {
        long minPeakSize = builder.minPeakSize();
        if (minPeakSize == Long.MAX_VALUE) {
            return new SegmentsArrayLengthAndNumSegments(1, 1);
        }
        return SmoothieMap.chooseInitialSegmentsArrayLengthInternal(minPeakSize);
    }

    private static SegmentsArrayLengthAndNumSegments chooseInitialSegmentsArrayLengthInternal(long minPeakSize) {
        Utils.verifyThat(minPeakSize >= 0L);
        if (minPeakSize <= 48L) {
            return new SegmentsArrayLengthAndNumSegments(1, 1);
        }
        if (minPeakSize <= 96L) {
            return new SegmentsArrayLengthAndNumSegments(2, 2);
        }
        int initialNumSegments = (int)Math.min(0x40000000L, LongMath.floorPowerOfTwo(minPeakSize / 48L));
        int initialSegmentsArrayLength = (int)Math.min(0x40000000L, (long)initialNumSegments * 2L);
        return new SegmentsArrayLengthAndNumSegments(initialSegmentsArrayLength, initialNumSegments);
    }

    private static int chooseUpFrontScale(long expectedSize, int segments) {
        if (segments == 1) {
            return 0;
        }
        int roundedUpAverageEntriesPerSegment = Math.max((int)SmoothieMap.roundedUpDivide(expectedSize, segments), 32);
        assert (roundedUpAverageEntriesPerSegment <= 63);
        int indexInSegmentsQuadruplingFromArray = roundedUpAverageEntriesPerSegment - 32;
        if ((long)segments * 4L <= 0x40000000L && indexInSegmentsQuadruplingFromArray < SEGMENTS_QUADRUPLING_FROM.length && (long)segments >= SEGMENTS_QUADRUPLING_FROM[indexInSegmentsQuadruplingFromArray]) {
            return 2;
        }
        if ((long)segments * 2L <= 0x40000000L) {
            return 1;
        }
        return 0;
    }

    private static long roundedUpDivide(long dividend, long divisor) {
        return (dividend + divisor - 1L) / divisor;
    }

    private static int chooseAllocCapacity(long expectedSize, int segments) {
        int averageEntriesPerSegment = Math.max((int)SmoothieMap.roundedUpDivide(expectedSize, segments), 32);
        return ALLOC_CAPACITIES[averageEntriesPerSegment - 32];
    }

    private static int order(int numSegments) {
        Utils.verifyIsPowerOfTwo(numSegments, "num segments");
        return Integer.numberOfTrailingZeros(numSegments);
    }

    SmoothieMap(SmoothieMapBuilder<K, V> builder) {
        this.allocateIntermediateSegments = builder.allocateIntermediateCapacitySegments();
        this.splitBetweenTwoNewSegments = builder.splitBetweenTwoNewSegments();
        this.doShrink = builder.doShrink();
        SegmentsArrayLengthAndNumSegments initialSegmentsArrayLengthAndNumSegments = SmoothieMap.chooseInitialSegmentsArrayLength(builder);
        this.initArrays(initialSegmentsArrayLengthAndNumSegments);
    }

    private void initArrays(SegmentsArrayLengthAndNumSegments initialSegmentsArrayLengthAndNumSegments) {
        Object[] segmentsArray = this.initSegmentsArray(initialSegmentsArrayLengthAndNumSegments);
        this.updateSegmentLookupMask(segmentsArray.length);
        UnsafeUtils.U.storeFence();
    }

    public final long sizeInBytes() {
        return this.smoothieMapClassSizeInBytes() + ObjectSize.objectSizeInBytes(this.segmentsArray) + ObjectSize.objectSizeInBytes(this.isFullCapacitySegmentBitSet) + this.totalSizeOfSegmentsInBytes() + (this.inflatedSegmentQueryContext != null ? this.inflatedSegmentQueryContext.sizeInBytes() : 0L) + (this.keySet != null ? KEY_SET__SIZE_IN_BYTES : 0L) + (this.values != null ? VALUES__SIZE_IN_BYTES : 0L) + (this.entrySet != null ? ENTRY_SET__SIZE_IN_BYTES : 0L);
    }

    long smoothieMapClassSizeInBytes() {
        return SIZE_IN_BYTES;
    }

    boolean keysEqual(Object queriedKey, K internalKey) {
        return queriedKey.equals(internalKey);
    }

    @Override
    public Equivalence<K> keyEquivalence() {
        return Equivalence.defaultEquality();
    }

    long keyHashCode(Object key) {
        return SmoothieMap.defaultKeyHashCode(key);
    }

    static long defaultKeyHashCode(Object key) {
        return SmoothieMap.intToLongHashCode(key.hashCode());
    }

    static long intToLongHashCode(int intHashCode) {
        long x = (long)intHashCode * -7046029254386353131L;
        return x ^ x >>> 53;
    }

    int keyHashCodeForAggregateHashCodes(Object key) {
        return key.hashCode();
    }

    ToLongFunction<K> getKeyHashFunction() {
        return DefaultHashFunction.instance();
    }

    boolean valuesEqual(Object queriedValue, V internalValue) {
        return queriedValue.equals(internalValue);
    }

    @Override
    public Equivalence<V> valueEquivalence() {
        return Equivalence.defaultEquality();
    }

    int valueHashCodeForAggregateHashCodes(V value) {
        return value.hashCode();
    }

    private int getInitialSegmentAllocCapacity(int segmentOrder) {
        if (this.allocateIntermediateSegments) {
            return 32;
        }
        return 48;
    }

    private Object[] initSegmentsArray(SegmentsArrayLengthAndNumSegments segmentsArrayLengthAndNumSegments) {
        Object[] segmentsArray = new Object[segmentsArrayLengthAndNumSegments.segmentsArrayLength];
        int numCreatedSegments = segmentsArrayLengthAndNumSegments.numSegments;
        int segmentsOrder = SmoothieMap.order(numCreatedSegments);
        int segmentAllocCapacity = this.getInitialSegmentAllocCapacity(segmentsOrder);
        for (int i = 0; i < numCreatedSegments; ++i) {
            segmentsArray[i] = InterleavedSegments.createNewSegment(segmentAllocCapacity, segmentsOrder);
        }
        Utils.duplicateArray(segmentsArray, segmentsArray.length, numCreatedSegments);
        this.segmentsArray = segmentsArray;
        int[] isFullCapacityBitSet = IsFullCapacitySegmentBitSet.allocate(segmentsArray.length);
        if (segmentAllocCapacity == 48) {
            IsFullCapacitySegmentBitSet.setAll(isFullCapacityBitSet);
        }
        this.isFullCapacitySegmentBitSet = isFullCapacityBitSet;
        return segmentsArray;
    }

    private void updateSegmentLookupMask(int segmentsArrayLength) {
        Utils.verifyIsPowerOfTwo(segmentsArrayLength, "segments array length");
        this.segmentLookupMask = (long)segmentsArrayLength - 1L << 11;
    }

    private int tryEnsureSegmentsArrayCapacityForSplit(int priorSegmentOrder) {
        long visibleSegmentsArrayLength = (this.segmentLookupMask >>> 11) + 1L;
        long requiredSegmentsArrayLength = 1L << priorSegmentOrder + 1;
        if (visibleSegmentsArrayLength >= requiredSegmentsArrayLength) {
            return 0;
        }
        if (requiredSegmentsArrayLength <= 0x40000000L) {
            this.growSegmentsArray((int)requiredSegmentsArrayLength);
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void growSegmentsArray(int requiredSegmentsArrayLength) {
        block4: {
            int lockedStamp = this.beginSegmentStructureModification();
            try {
                Object[] oldSegments = this.getNonNullSegmentsArrayOrThrowCme();
                if (oldSegments.length < requiredSegmentsArrayLength) {
                    ++this.modCount;
                    int[] oldIsFullCapacitySegmentBitSet = (int[])this.isFullCapacitySegmentBitSet;
                    this.isFullCapacitySegmentBitSet = IsFullCapacitySegmentBitSet.duplicate(oldIsFullCapacitySegmentBitSet, oldSegments.length, requiredSegmentsArrayLength);
                    Object[] newSegments = Arrays.copyOf(oldSegments, requiredSegmentsArrayLength);
                    Utils.duplicateArray(newSegments, newSegments.length, oldSegments.length);
                    this.segmentsArray = newSegments;
                    this.updateSegmentLookupMask(newSegments.length);
                    break block4;
                }
                throw new ConcurrentModificationException("oldSegments.length: " + oldSegments.length + ", requiredSegmentsArrayLength: " + requiredSegmentsArrayLength);
            }
            finally {
                this.endSegmentStructureModification(lockedStamp);
            }
        }
    }

    private long segmentLookupBits(long hash) {
        return hash & this.segmentLookupMask;
    }

    private Object segmentBySegmentLookupBits(long hash_segmentLookupBits) {
        long segmentArrayOffset = hash_segmentLookupBits >>> HASH__SEGMENT_ARRAY_OFFSET_SHIFT;
        @Nullable Object segmentsArray = this.segmentsArray;
        return UnsafeUtils.U.getObject(segmentsArray, UnsafeUtils.ARRAY_OBJECT_BASE_OFFSET_AS_LONG + segmentArrayOffset);
    }

    private int isFullCapacitySegment(long hash_segmentLookupBits) {
        return IsFullCapacitySegmentBitSet.getValue(this.isFullCapacitySegmentBitSet, hash_segmentLookupBits >>> 11);
    }

    private int isFullCapacitySegmentByIndex(int segmentIndex) {
        return IsFullCapacitySegmentBitSet.getValue(this.isFullCapacitySegmentBitSet, segmentIndex);
    }

    @Deprecated
    final int debugSegmentsArrayLength() {
        return ((Object[])this.segmentsArray).length;
    }

    @Deprecated
    final Segment<K, V> debugSegmentByIndex(int segmentIndex) {
        return (Segment)((Object[])this.segmentsArray)[segmentIndex];
    }

    private static <K, V> Segment<K, V> segmentCheckedByIndex(@Nullable Object[] segmentsArray, int segmentIndex) {
        @Nullable Object segment = segmentsArray[segmentIndex];
        if (segment == null) {
            throw new ConcurrentModificationException();
        }
        return (Segment)segment;
    }

    static int firstSegmentIndexByHashAndOrder(long hash, int segmentOrder) {
        return (int)(hash >>> 11) & (1 << segmentOrder) - 1;
    }

    private static int firstSegmentIndexByIndexAndOrder(@NonNegative int segmentIndex, @IntRange(from=0L, to=30L) int segmentOrder) {
        return segmentIndex & (1 << segmentOrder) - 1;
    }

    private static int siblingSegmentIndex(int segmentIndex, int segmentOrder) {
        return segmentIndex ^ 1 << segmentOrder - 1;
    }

    private static int chooseFirstSiblingSegmentIndex(int firstSiblingsSegmentIndex, int newSegmentOrder, int chooseLower) {
        int n = newSegmentOrder - 1;
        int x = 1 - chooseLower;
        int number = firstSiblingsSegmentIndex;
        return number & ~(1 << n) | x << n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceInSegmentsArray(Object[] segmentsArray, int firstReplacedSegmentIndex, int replacementSegmentOrder, Object replacementSegment, boolean replacedSegment_isFullCapacity) {
        ++this.modCount;
        int step = 1 << replacementSegmentOrder;
        int lockedStamp = 0;
        try {
            int segmentIndex;
            boolean replacementSegment_isFullCapacity;
            boolean isFullCapacitySegmentValue_needFlip;
            int[] isFullCapacitySegmentBitSet = (int[])this.isFullCapacitySegmentBitSet;
            if (isFullCapacitySegmentBitSet.length != IsFullCapacitySegmentBitSet.bitSetArrayLengthFromSegmentsArrayLength(segmentsArray.length)) {
                SmoothieMap.throwGenericCme();
            }
            if (isFullCapacitySegmentValue_needFlip = replacedSegment_isFullCapacity ^ (replacementSegment_isFullCapacity = replacementSegment instanceof InterleavedSegments.FullCapacitySegment)) {
                lockedStamp = this.beginSegmentStructureModification();
                for (segmentIndex = firstReplacedSegmentIndex; segmentIndex < segmentsArray.length; segmentIndex += step) {
                    int value = replacementSegment_isFullCapacity ? 1 : 0;
                    IsFullCapacitySegmentBitSet.setValue(isFullCapacitySegmentBitSet, segmentIndex, value);
                }
            }
            for (segmentIndex = firstReplacedSegmentIndex; segmentIndex < segmentsArray.length; segmentIndex += step) {
                segmentsArray[segmentIndex] = replacementSegment;
            }
        }
        finally {
            if (lockedStamp != 0) {
                this.endSegmentStructureModification(lockedStamp);
            }
        }
    }

    private Object[] getNonNullSegmentsArrayOrThrowCme() {
        Object @Nullable [] segmentsArray = (Object[])this.segmentsArray;
        return segmentsArray;
    }

    private Object[] getNonNullSegmentsArrayOrThrowIse() {
        Object @Nullable [] segmentsArray = (Object[])this.segmentsArray;
        return segmentsArray;
    }

    @Contract(value=" -> fail")
    private static void throwIseSegmentsArrayNull() {
        throw new IllegalStateException("Old map object shouldn't be accessed after explicit shrinking");
    }

    @Contract(value=" -> fail")
    private static void throwCmeSegmentsArrayNull() {
        throw new ConcurrentModificationException("Explicit shrinking is done concurrently with other some modification operations on a map");
    }

    @Contract(value=" -> fail")
    private static void throwGenericCme() {
        throw new ConcurrentModificationException("Concurrent map update is in progress");
    }

    final void incrementSize() {
        ++this.modCount;
        ++this.size;
    }

    final void decrementSize() {
        ++this.modCount;
        --this.size;
    }

    final int getModCountOpaque() {
        return UnsafeUtils.U.getIntVolatile(this, MOD_COUNT_FIELD_OFFSET);
    }

    final void checkModCountOrThrowCme(int expectedModCount) {
        int actualModCount = this.getModCountOpaque();
        Utils.checkModCount(expectedModCount, actualModCount);
    }

    private static boolean isLockedSegmentStructureModStamp(int stamp) {
        return stamp < 0;
    }

    private int beginSegmentStructureModification() {
        int stamp = this.segmentStructureModStamp;
        int lockedStamp = Integer.MIN_VALUE | stamp;
        if (SmoothieMap.isLockedSegmentStructureModStamp(stamp) || !SEGMENT_STRUCTURE_MODIFICATION_STAMP_UPDATER.compareAndSet(this, stamp, lockedStamp)) {
            SmoothieMap.throwGenericCme();
        }
        UnsafeUtils.storeStoreFence();
        return lockedStamp;
    }

    private void endSegmentStructureModification(int lockedStamp) {
        Utils.verifyThat(SmoothieMap.isLockedSegmentStructureModStamp(lockedStamp));
        this.segmentStructureModStamp = lockedStamp + 1 & Integer.MAX_VALUE;
    }

    private int acquireSegmentStructureModStamp() {
        int stamp = this.segmentStructureModStamp;
        if (SmoothieMap.isLockedSegmentStructureModStamp(stamp)) {
            SmoothieMap.throwGenericCme();
        }
        return stamp;
    }

    private void validateSegmentStructureModStamp(int stamp) {
        UnsafeUtils.acquireFence();
        if (stamp != this.segmentStructureModStamp) {
            SmoothieMap.throwGenericCme();
        }
    }

    private InflatedSegmentQueryContext<K, V> getInflatedSegmentQueryContext() {
        @MonotonicNonNull InflatedSegmentQueryContext<K, V> context = this.inflatedSegmentQueryContext;
        if (context == null) {
            this.inflatedSegmentQueryContext = context = new InflatedSegmentQueryContext(this);
        }
        return context;
    }

    final int computeAverageSegmentOrder(long size) {
        byte averageSegmentOrder_prevComputed = this.averageSegmentOrder_lastComputed;
        int averageSegmentOrder = SmoothieMap.doComputeAverageSegmentOrder(size);
        if (averageSegmentOrder == averageSegmentOrder_prevComputed) {
            return averageSegmentOrder;
        }
        this.updateAverageSegmentOrder(averageSegmentOrder_prevComputed, averageSegmentOrder);
        return averageSegmentOrder;
    }

    private void updateAverageSegmentOrder(int averageSegmentOrder_prevComputed, int newAverageSegmentOrder) {
        this.averageSegmentOrder_lastComputed = (byte)newAverageSegmentOrder;
    }

    @Override
    public final int size() {
        return (int)Math.min(this.size, Integer.MAX_VALUE);
    }

    @Override
    public final long sizeAsLong() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0L;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.getInternalKey(key) != null;
    }

    @Override
    public final boolean containsEntry(Object key, Object value) {
        Utils.checkNonNull(value);
        @Nullable V internalVal = this.get(key);
        boolean valuesIdentical = internalVal == value;
        return valuesIdentical || internalVal != null && this.valuesEqual(value, internalVal);
    }

    @Override
    public final V getOrDefault(Object key, V defaultValue) {
        @Nullable V internalVal = this.get(key);
        return internalVal != null ? internalVal : defaultValue;
    }

    @Override
    @CanIgnoreReturnValue
    public final @Nullable V remove(Object key) {
        Utils.checkNonNull(key);
        long hash = this.keyHashCode(key);
        long hash_segmentLookupBits = this.segmentLookupBits(hash);
        int segmentStructureModStamp = this.acquireSegmentStructureModStamp();
        Object segment = this.segmentBySegmentLookupBits(hash_segmentLookupBits);
        int isFullCapacitySegment = this.isFullCapacitySegment(hash_segmentLookupBits);
        this.validateSegmentStructureModStamp(segmentStructureModStamp);
        return this.removeImpl(segment, isFullCapacitySegment, key, hash, null);
    }

    @Override
    public final boolean remove(Object key, Object value) {
        Utils.checkNonNull(key);
        Utils.checkNonNull(value);
        long hash = this.keyHashCode(key);
        long hash_segmentLookupBits = this.segmentLookupBits(hash);
        int segmentStructureModStamp = this.acquireSegmentStructureModStamp();
        Object segment = this.segmentBySegmentLookupBits(hash_segmentLookupBits);
        int isFullCapacitySegment = this.isFullCapacitySegment(hash_segmentLookupBits);
        this.validateSegmentStructureModStamp(segmentStructureModStamp);
        return this.removeImpl(segment, isFullCapacitySegment, key, hash, value) != null;
    }

    @Override
    public final V replace(K key, V value) {
        Utils.checkNonNull(key);
        Utils.checkNonNull(value);
        long hash = this.keyHashCode(key);
        long hash_segmentLookupBits = this.segmentLookupBits(hash);
        int segmentStructureModStamp = this.acquireSegmentStructureModStamp();
        Object segment = this.segmentBySegmentLookupBits(hash_segmentLookupBits);
        int isFullCapacitySegment = this.isFullCapacitySegment(hash_segmentLookupBits);
        this.validateSegmentStructureModStamp(segmentStructureModStamp);
        return this.replaceImpl(segment, isFullCapacitySegment, key, hash, null, value);
    }

    @Override
    public final boolean replace(K key, V oldValue, V newValue) {
        Utils.checkNonNull(key);
        Utils.checkNonNull(oldValue);
        Utils.checkNonNull(newValue);
        long hash = this.keyHashCode(key);
        long hash_segmentLookupBits = this.segmentLookupBits(hash);
        int segmentStructureModStamp = this.acquireSegmentStructureModStamp();
        Object segment = this.segmentBySegmentLookupBits(hash_segmentLookupBits);
        int isFullCapacitySegment = this.isFullCapacitySegment(hash_segmentLookupBits);
        this.validateSegmentStructureModStamp(segmentStructureModStamp);
        return this.replaceImpl(segment, isFullCapacitySegment, key, hash, oldValue, newValue) != null;
    }

    @Override
    @CanIgnoreReturnValue
    public final @Nullable V put(K key, V value) {
        Utils.checkNonNull(key);
        Utils.checkNonNull(value);
        long hash = this.keyHashCode(key);
        long hash_segmentLookupBits = this.segmentLookupBits(hash);
        int segmentStructureModStamp = this.acquireSegmentStructureModStamp();
        Object segment = this.segmentBySegmentLookupBits(hash_segmentLookupBits);
        int isFullCapacitySegment = this.isFullCapacitySegment(hash_segmentLookupBits);
        this.validateSegmentStructureModStamp(segmentStructureModStamp);
        return this.putImpl(segment, isFullCapacitySegment, key, hash, value, false);
    }

    @Override
    public final @Nullable V putIfAbsent(K key, V value) {
        Utils.checkNonNull(key);
        Utils.checkNonNull(value);
        long hash = this.keyHashCode(key);
        return this.internalPutIfAbsent(key, hash, value);
    }

    private @Nullable V internalPutIfAbsent(K key, long hash, V value) {
        long hash_segmentLookupBits = this.segmentLookupBits(hash);
        int segmentStructureModStamp = this.acquireSegmentStructureModStamp();
        Object segment = this.segmentBySegmentLookupBits(hash_segmentLookupBits);
        int isFullCapacitySegment = this.isFullCapacitySegment(hash_segmentLookupBits);
        this.validateSegmentStructureModStamp(segmentStructureModStamp);
        return this.putImpl(segment, isFullCapacitySegment, key, hash, value, true);
    }

    @Override
    public final @Nullable V get(Object key) {
        Object segment;
        long hash;
        block4: {
            Utils.checkNonNull(key);
            hash = this.keyHashCode(key);
            long hash_segmentLookupBits = this.segmentLookupBits(hash);
            int segmentStructureModStamp = this.acquireSegmentStructureModStamp();
            segment = this.segmentBySegmentLookupBits(hash_segmentLookupBits);
            int isFullCapacitySegment = this.isFullCapacitySegment(hash_segmentLookupBits);
            this.validateSegmentStructureModStamp(segmentStructureModStamp);
            long baseGroupIndex = HashTable.baseGroupIndex(hash);
            long hashTagBits = Segment.tagBits(hash);
            long groupIndex = baseGroupIndex;
            long groupIndexStep = 0L;
            while (true) {
                long tagGroupOffset = InterleavedSegments.tagGroupOffset(groupIndex, isFullCapacitySegment);
                long tagGroup = InterleavedSegments.readTagGroupAtOffset(segment, tagGroupOffset);
                long dataGroupOffset = InterleavedSegments.dataGroupFromTagGroupOffset(tagGroupOffset);
                long dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset);
                long bitMask = HashTable.match(tagGroup, hashTagBits, dataGroup);
                while (bitMask != 0L) {
                    boolean keysIdentical;
                    long allocOffset = InterleavedSegments.allocOffset(HashTable.firstAllocIndex(dataGroup, bitMask), isFullCapacitySegment);
                    Object internalKey = Segment.readKeyAtOffset(segment, allocOffset);
                    boolean bl = keysIdentical = internalKey == key;
                    if (keysIdentical || this.keysEqual(key, internalKey)) {
                        return Segment.readValueAtOffset(segment, allocOffset);
                    }
                    bitMask = LongMath.clearLowestSetBit(bitMask);
                }
                if (HashTable.shouldStopProbing(dataGroup)) {
                    return null;
                }
                if (dataGroup == 0x7F7F7F7F7F7F7F7FL) break block4;
                if (++groupIndexStep == 8L) break;
                groupIndex = HashTable.addGroupIndex(groupIndex, groupIndexStep);
            }
            return null;
        }
        return this.getInflated(segment, key, hash);
    }

    final int countCollisionKeyComparisons(Object segment, Object key, long hash) {
        block4: {
            Utils.verifyNonNull(segment);
            Utils.verifyNonNull(key);
            int isFullCapacitySegment = segment instanceof InterleavedSegments.FullCapacitySegment ? 1 : 0;
            int numCollisionKeyComparisons = 0;
            long baseGroupIndex = HashTable.baseGroupIndex(hash);
            long hashTagBits = Segment.tagBits(hash);
            long groupIndex = baseGroupIndex;
            long groupIndexStep = 0L;
            while (true) {
                long tagGroupOffset = InterleavedSegments.tagGroupOffset(groupIndex, isFullCapacitySegment);
                long tagGroup = InterleavedSegments.readTagGroupAtOffset(segment, tagGroupOffset);
                long dataGroupOffset = InterleavedSegments.dataGroupFromTagGroupOffset(tagGroupOffset);
                long dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset);
                long bitMask = HashTable.match(tagGroup, hashTagBits, dataGroup);
                while (bitMask != 0L) {
                    boolean keysIdentical;
                    long allocOffset = InterleavedSegments.allocOffset(HashTable.firstAllocIndex(dataGroup, bitMask), isFullCapacitySegment);
                    Object internalKey = Segment.readKeyAtOffset(segment, allocOffset);
                    boolean bl = keysIdentical = internalKey == key;
                    if (keysIdentical || this.keysEqual(key, internalKey)) {
                        return numCollisionKeyComparisons;
                    }
                    ++numCollisionKeyComparisons;
                    bitMask = LongMath.clearLowestSetBit(bitMask);
                }
                if (HashTable.shouldStopProbing(dataGroup)) {
                    throw new IllegalStateException("Expected the key to be in the map");
                }
                if (dataGroup == 0x7F7F7F7F7F7F7F7FL) break block4;
                if (++groupIndexStep == 8L) break;
                groupIndex = HashTable.addGroupIndex(groupIndex, groupIndexStep);
            }
            throw new IllegalStateException("Expected the key to be in the map");
        }
        throw new IllegalStateException("Expected an ordinary segment");
    }

    final void aggregateKeySearchStats(Object key, KeySearchStats keySearchStats) {
        int numCollisionKeyComparisons;
        int collisionChainGroupLength;
        block4: {
            Utils.checkNonNull(key);
            long hash = this.keyHashCode(key);
            long hash_segmentLookupBits = this.segmentLookupBits(hash);
            int segmentStructureModStamp = this.acquireSegmentStructureModStamp();
            Object segment = this.segmentBySegmentLookupBits(hash_segmentLookupBits);
            int isFullCapacitySegment = this.isFullCapacitySegment(hash_segmentLookupBits);
            this.validateSegmentStructureModStamp(segmentStructureModStamp);
            collisionChainGroupLength = 0;
            numCollisionKeyComparisons = 0;
            long baseGroupIndex = HashTable.baseGroupIndex(hash);
            long hashTagBits = Segment.tagBits(hash);
            long groupIndex = baseGroupIndex;
            long groupIndexStep = 0L;
            while (true) {
                long tagGroupOffset = InterleavedSegments.tagGroupOffset(groupIndex, isFullCapacitySegment);
                long tagGroup = InterleavedSegments.readTagGroupAtOffset(segment, tagGroupOffset);
                long dataGroupOffset = InterleavedSegments.dataGroupFromTagGroupOffset(tagGroupOffset);
                long dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset);
                long bitMask = HashTable.match(tagGroup, hashTagBits, dataGroup);
                while (bitMask != 0L) {
                    boolean keysIdentical;
                    long allocOffset = InterleavedSegments.allocOffset(HashTable.firstAllocIndex(dataGroup, bitMask), isFullCapacitySegment);
                    Object internalKey = Segment.readKeyAtOffset(segment, allocOffset);
                    boolean bl = keysIdentical = internalKey == key;
                    if (!keysIdentical && !this.keysEqual(key, internalKey)) {
                        ++numCollisionKeyComparisons;
                        bitMask = LongMath.clearLowestSetBit(bitMask);
                        continue;
                    }
                    break block4;
                }
                if (HashTable.shouldStopProbing(dataGroup)) break block4;
                if (dataGroup == 0x7F7F7F7F7F7F7F7FL) break;
                if (++groupIndexStep != 8L) {
                    groupIndex = HashTable.addGroupIndex(groupIndex, groupIndexStep);
                    ++collisionChainGroupLength;
                    continue;
                }
                break block4;
                break;
            }
            return;
        }
        keySearchStats.aggregate(collisionChainGroupLength, numCollisionKeyComparisons);
    }

    private @Nullable V getInflated(Object segment, Object key, long hash) {
        InflatedSegment inflatedSegment = (InflatedSegment)segment;
        return inflatedSegment.get(this, key, hash);
    }

    @Override
    public final @Nullable K getInternalKey(Object key) {
        Object segment;
        long hash;
        block4: {
            Utils.checkNonNull(key);
            hash = this.keyHashCode(key);
            long hash_segmentLookupBits = this.segmentLookupBits(hash);
            int segmentStructureModStamp = this.acquireSegmentStructureModStamp();
            segment = this.segmentBySegmentLookupBits(hash_segmentLookupBits);
            int isFullCapacitySegment = this.isFullCapacitySegment(hash_segmentLookupBits);
            this.validateSegmentStructureModStamp(segmentStructureModStamp);
            long baseGroupIndex = HashTable.baseGroupIndex(hash);
            long hashTagBits = Segment.tagBits(hash);
            long groupIndex = baseGroupIndex;
            long groupIndexStep = 0L;
            while (true) {
                long tagGroupOffset = InterleavedSegments.tagGroupOffset(groupIndex, isFullCapacitySegment);
                long tagGroup = InterleavedSegments.readTagGroupAtOffset(segment, tagGroupOffset);
                long dataGroupOffset = InterleavedSegments.dataGroupFromTagGroupOffset(tagGroupOffset);
                long dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset);
                long bitMask = HashTable.match(tagGroup, hashTagBits, dataGroup);
                while (bitMask != 0L) {
                    boolean keysIdentical;
                    long allocOffset = InterleavedSegments.allocOffset(HashTable.firstAllocIndex(dataGroup, bitMask), isFullCapacitySegment);
                    Object internalKey = Segment.readKeyAtOffset(segment, allocOffset);
                    boolean bl = keysIdentical = internalKey == key;
                    if (keysIdentical || this.keysEqual(key, internalKey)) {
                        return internalKey;
                    }
                    bitMask = LongMath.clearLowestSetBit(bitMask);
                }
                if (HashTable.shouldStopProbing(dataGroup)) {
                    return null;
                }
                if (dataGroup == 0x7F7F7F7F7F7F7F7FL) break block4;
                if (++groupIndexStep == 8L) break;
                groupIndex = HashTable.addGroupIndex(groupIndex, groupIndexStep);
            }
            return null;
        }
        return this.getInternalKeyInflated(segment, key, hash);
    }

    private @Nullable K getInternalKeyInflated(Object segment, Object key, long hash) {
        InflatedSegment inflatedSegment = (InflatedSegment)segment;
        return inflatedSegment.getInternalKey(this, key, hash);
    }

    @Override
    public final @Nullable V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends @Nullable V> remappingFunction) {
        Object segment;
        long hash;
        block6: {
            Utils.checkNonNull(key);
            Utils.checkNonNull(remappingFunction);
            hash = this.keyHashCode(key);
            long hash_segmentLookupBits = this.segmentLookupBits(hash);
            int segmentStructureModStamp = this.acquireSegmentStructureModStamp();
            segment = this.segmentBySegmentLookupBits(hash_segmentLookupBits);
            int isFullCapacitySegment = this.isFullCapacitySegment(hash_segmentLookupBits);
            this.validateSegmentStructureModStamp(segmentStructureModStamp);
            long baseGroupIndex = HashTable.baseGroupIndex(hash);
            long hashTagBits = Segment.tagBits(hash);
            long groupIndex = baseGroupIndex;
            long groupIndexStep = 0L;
            while (true) {
                long tagGroupOffset = InterleavedSegments.tagGroupOffset(groupIndex, isFullCapacitySegment);
                long tagGroup = InterleavedSegments.readTagGroupAtOffset(segment, tagGroupOffset);
                long dataGroupOffset = InterleavedSegments.dataGroupFromTagGroupOffset(tagGroupOffset);
                long dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset);
                long bitMask = HashTable.match(tagGroup, hashTagBits, dataGroup);
                while (bitMask != 0L) {
                    boolean keysIdentical;
                    int trailingZeros = Long.numberOfTrailingZeros(bitMask);
                    long allocIndex = HashTable.extractAllocIndex(dataGroup, trailingZeros);
                    long allocOffset = InterleavedSegments.allocOffset(allocIndex, isFullCapacitySegment);
                    Object internalKey = Segment.readKeyAtOffset(segment, allocOffset);
                    boolean bl = keysIdentical = internalKey == key;
                    if (keysIdentical || this.keysEqual(key, internalKey)) {
                        Object internalVal = Segment.readValueAtOffset(segment, allocOffset);
                        @Nullable V newValue = remappingFunction.apply(key, internalVal);
                        if (newValue != null) {
                            Segment.writeValueAtOffset(segment, allocOffset, newValue);
                        } else {
                            long outboundOverflowCount_perGroupDecrements = OutboundOverflowCounts.computeOutboundOverflowCount_perGroupChanges(baseGroupIndex, groupIndex);
                            dataGroup = HashTable.setSlotEmpty(dataGroup, trailingZeros);
                            this.removeAtSlot(hash, segment, isFullCapacitySegment, outboundOverflowCount_perGroupDecrements, dataGroupOffset, dataGroup, allocIndex, allocOffset);
                        }
                        return newValue;
                    }
                    bitMask = LongMath.clearLowestSetBit(bitMask);
                }
                if (HashTable.shouldStopProbing(dataGroup)) {
                    return null;
                }
                if (dataGroup == 0x7F7F7F7F7F7F7F7FL) break block6;
                if (++groupIndexStep == 8L) break;
                groupIndex = HashTable.addGroupIndex(groupIndex, groupIndexStep);
            }
            return null;
        }
        return this.computeIfPresentInflated(segment, key, hash, remappingFunction);
    }

    private @Nullable V computeIfPresentInflated(Object segment, K key, long hash, BiFunction<? super K, ? super V, ? extends @Nullable V> remappingFunction) {
        InflatedSegment inflatedSegment = (InflatedSegment)segment;
        return inflatedSegment.computeIfPresent(this, key, hash, remappingFunction);
    }

    private @Nullable V removeImpl(Object segment, int isFullCapacitySegment, Object key, long hash, @Nullable Object matchValue) {
        block5: {
            long baseGroupIndex = HashTable.baseGroupIndex(hash);
            long hashTagBits = Segment.tagBits(hash);
            long outboundOverflowCount_perGroupDecrements = 0L;
            long groupIndex = baseGroupIndex;
            long groupIndexStep = 0L;
            while (true) {
                long tagGroupOffset = InterleavedSegments.tagGroupOffset(groupIndex, isFullCapacitySegment);
                long tagGroup = InterleavedSegments.readTagGroupAtOffset(segment, tagGroupOffset);
                long dataGroupOffset = InterleavedSegments.dataGroupFromTagGroupOffset(tagGroupOffset);
                long dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset);
                long bitMask = HashTable.match(tagGroup, hashTagBits, dataGroup);
                while (bitMask != 0L) {
                    boolean keysIdentical;
                    int trailingZeros = Long.numberOfTrailingZeros(bitMask);
                    long allocIndex = HashTable.extractAllocIndex(dataGroup, trailingZeros);
                    long allocOffset = InterleavedSegments.allocOffset(allocIndex, isFullCapacitySegment);
                    Object internalKey = Segment.readKeyAtOffset(segment, allocOffset);
                    boolean bl = keysIdentical = internalKey == key;
                    if (keysIdentical || this.keysEqual(key, internalKey)) {
                        boolean valuesIdentical;
                        Object internalVal = Segment.readValueAtOffset(segment, allocOffset);
                        boolean bl2 = valuesIdentical = internalVal == matchValue;
                        if (valuesIdentical || matchValue == null || this.valuesEqual(matchValue, internalVal)) {
                            dataGroup = HashTable.setSlotEmpty(dataGroup, trailingZeros);
                            this.removeAtSlot(hash, segment, isFullCapacitySegment, outboundOverflowCount_perGroupDecrements, dataGroupOffset, dataGroup, allocIndex, allocOffset);
                            return internalVal;
                        }
                        return null;
                    }
                    bitMask = LongMath.clearLowestSetBit(bitMask);
                }
                if (HashTable.shouldStopProbing(dataGroup)) {
                    return null;
                }
                if (dataGroup == 0x7F7F7F7F7F7F7F7FL) break block5;
                outboundOverflowCount_perGroupDecrements = OutboundOverflowCounts.outboundOverflowCount_markGroupForChange(outboundOverflowCount_perGroupDecrements, groupIndex);
                if (++groupIndexStep == 8L) break;
                groupIndex = HashTable.addGroupIndex(groupIndex, groupIndexStep);
            }
            return null;
        }
        return this.removeOrReplaceInflated(segment, key, hash, matchValue, null);
    }

    private void removeDuringIterationFromOrdinarySegment(Segment<K, V> segment, long allocIndexToRemove) {
        int isFullCapacitySegment = segment instanceof InterleavedSegments.FullCapacitySegment ? 1 : 0;
        Object key = Segment.readKeyCheckedAtIndex(segment, allocIndexToRemove, isFullCapacitySegment);
        long hash = this.keyHashCode(key);
        long baseGroupIndex = HashTable.baseGroupIndex(hash);
        long hashTagBits = Segment.tagBits(hash);
        long outboundOverflowCount_perGroupDecrements = 0L;
        long groupIndex = baseGroupIndex;
        long groupIndexStep = 0L;
        do {
            long tagGroupOffset = InterleavedSegments.tagGroupOffset(groupIndex, isFullCapacitySegment);
            long tagGroup = InterleavedSegments.readTagGroupAtOffset(segment, tagGroupOffset);
            long dataGroupOffset = InterleavedSegments.dataGroupFromTagGroupOffset(tagGroupOffset);
            long dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset);
            long bitMask = HashTable.match(tagGroup, hashTagBits, dataGroup);
            while (bitMask != 0L) {
                int trailingZeros = Long.numberOfTrailingZeros(bitMask);
                long allocIndex = HashTable.extractAllocIndex(dataGroup, trailingZeros);
                if (allocIndex == allocIndexToRemove) {
                    dataGroup = HashTable.setSlotEmpty(dataGroup, trailingZeros);
                    long bitSetAndState = segment.bitSetAndState;
                    long allocOffset = InterleavedSegments.allocOffset(allocIndex, isFullCapacitySegment);
                    segment.bitSetAndState = bitSetAndState = this.removeAtSlotNoShrink(bitSetAndState, segment, isFullCapacitySegment, outboundOverflowCount_perGroupDecrements, dataGroupOffset, dataGroup, allocIndex, allocOffset);
                    return;
                }
                bitMask = LongMath.clearLowestSetBit(bitMask);
            }
            if (HashTable.shouldStopProbing(dataGroup)) break;
            outboundOverflowCount_perGroupDecrements = OutboundOverflowCounts.outboundOverflowCount_markGroupForChange(outboundOverflowCount_perGroupDecrements, groupIndex);
        } while ((groupIndex = HashTable.addGroupIndex(groupIndex, ++groupIndexStep)) != baseGroupIndex);
        throw new ConcurrentModificationException();
    }

    private @Nullable V replaceImpl(Object segment, int isFullCapacitySegment, Object key, long hash, @Nullable Object matchValue, V replacementValue) {
        block5: {
            long baseGroupIndex = HashTable.baseGroupIndex(hash);
            long hashTagBits = Segment.tagBits(hash);
            long groupIndex = baseGroupIndex;
            long groupIndexStep = 0L;
            while (true) {
                long tagGroupOffset = InterleavedSegments.tagGroupOffset(groupIndex, isFullCapacitySegment);
                long tagGroup = InterleavedSegments.readTagGroupAtOffset(segment, tagGroupOffset);
                long dataGroupOffset = InterleavedSegments.dataGroupFromTagGroupOffset(tagGroupOffset);
                long dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset);
                long bitMask = HashTable.match(tagGroup, hashTagBits, dataGroup);
                while (bitMask != 0L) {
                    boolean keysIdentical;
                    long allocIndex = HashTable.firstAllocIndex(dataGroup, bitMask);
                    long allocOffset = InterleavedSegments.allocOffset(allocIndex, isFullCapacitySegment);
                    Object internalKey = Segment.readKeyAtOffset(segment, allocOffset);
                    boolean bl = keysIdentical = internalKey == key;
                    if (keysIdentical || this.keysEqual(key, internalKey)) {
                        boolean valuesIdentical;
                        Object internalVal = Segment.readValueAtOffset(segment, allocOffset);
                        boolean bl2 = valuesIdentical = internalVal == matchValue;
                        if (valuesIdentical || matchValue == null || this.valuesEqual(matchValue, internalVal)) {
                            Segment.writeValueAtOffset(segment, allocOffset, replacementValue);
                            return internalVal;
                        }
                        return null;
                    }
                    bitMask = LongMath.clearLowestSetBit(bitMask);
                }
                if (HashTable.shouldStopProbing(dataGroup)) {
                    return null;
                }
                if (dataGroup == 0x7F7F7F7F7F7F7F7FL) break block5;
                if (++groupIndexStep == 8L) break;
                groupIndex = HashTable.addGroupIndex(groupIndex, groupIndexStep);
            }
            return null;
        }
        return this.removeOrReplaceInflated(segment, key, hash, matchValue, replacementValue);
    }

    private @Nullable V removeOrReplaceInflated(Object segment, Object key, long hash, @Nullable Object matchValue, @Nullable V replacementValue) {
        InflatedSegment inflatedSegment = (InflatedSegment)segment;
        return (V)inflatedSegment.removeOrReplace(this, key, hash, matchValue, replacementValue);
    }

    private @Nullable V putImpl(Object segment, int isFullCapacitySegment, K key, long hash, V value, boolean onlyIfAbsent) {
        long outboundOverflowCount_perGroupIncrements;
        long emptyBitMask;
        long dataGroup;
        long groupIndex;
        block9: {
            long dataGroupOffset;
            long groupIndexStep;
            block10: {
                long baseGroupIndex;
                block8: {
                    baseGroupIndex = HashTable.baseGroupIndex(hash);
                    long hashTagBits = Segment.tagBits(hash);
                    groupIndex = baseGroupIndex;
                    groupIndexStep = 0L;
                    while (true) {
                        long tagGroupOffset = InterleavedSegments.tagGroupOffset(groupIndex, isFullCapacitySegment);
                        long tagGroup = InterleavedSegments.readTagGroupAtOffset(segment, tagGroupOffset);
                        long dataGroupOffset2 = InterleavedSegments.dataGroupFromTagGroupOffset(tagGroupOffset);
                        dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset2);
                        long bitMask = HashTable.match(tagGroup, hashTagBits, dataGroup);
                        while (bitMask != 0L) {
                            boolean keysIdentical;
                            long allocOffset = InterleavedSegments.allocOffset(HashTable.firstAllocIndex(dataGroup, bitMask), isFullCapacitySegment);
                            Object internalKey = Segment.readKeyAtOffset(segment, allocOffset);
                            boolean bl = keysIdentical = internalKey == key;
                            if (keysIdentical || this.keysEqual(key, internalKey)) {
                                Object internalVal = Segment.readValueAtOffset(segment, allocOffset);
                                if (!onlyIfAbsent) {
                                    Segment.writeValueAtOffset(segment, allocOffset, value);
                                }
                                return internalVal;
                            }
                            bitMask = LongMath.clearLowestSetBit(bitMask);
                        }
                        if (HashTable.shouldStopProbing(dataGroup)) {
                            if (groupIndexStep != 0L) break block8;
                            emptyBitMask = HashTable.matchEmpty(dataGroup);
                            if (emptyBitMask != 0L) {
                                outboundOverflowCount_perGroupIncrements = 0L;
                                break block9;
                            }
                            outboundOverflowCount_perGroupIncrements = OutboundOverflowCounts.outboundOverflowCount_groupForChange(groupIndex);
                            groupIndexStep = 1L;
                            groupIndex = HashTable.addGroupIndex(groupIndex, groupIndexStep);
                            break block10;
                        }
                        if (dataGroup == 0x7F7F7F7F7F7F7F7FL) break;
                        if (++groupIndexStep != 8L) {
                            groupIndex = HashTable.addGroupIndex(groupIndex, groupIndexStep);
                            continue;
                        }
                        break block8;
                        break;
                    }
                    return this.putInflated(segment, key, hash, value, onlyIfAbsent);
                }
                groupIndexStep = 0L;
                outboundOverflowCount_perGroupIncrements = 0L;
                groupIndex = baseGroupIndex;
            }
            while ((emptyBitMask = HashTable.matchEmpty(dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset = InterleavedSegments.dataGroupOffset(groupIndex, isFullCapacitySegment)))) == 0L) {
                outboundOverflowCount_perGroupIncrements = OutboundOverflowCounts.outboundOverflowCount_markGroupForChange(outboundOverflowCount_perGroupIncrements, groupIndex);
                groupIndex = HashTable.addGroupIndex(groupIndex, ++groupIndexStep);
            }
        }
        int insertionSlotIndexWithinGroup = HashTable.lowestMatchingSlotIndex(emptyBitMask);
        this.insert(segment, isFullCapacitySegment, outboundOverflowCount_perGroupIncrements, key, hash, value, groupIndex, dataGroup, insertionSlotIndexWithinGroup);
        return null;
    }

    private @Nullable V putInflated(Object segment, K key, long hash, V value, boolean onlyIfAbsent) {
        InflatedSegment inflatedSegment = (InflatedSegment)segment;
        return inflatedSegment.put(this, key, hash, value, onlyIfAbsent);
    }

    @Override
    public final @Nullable V computeIfAbsent(K key, Function<? super K, ? extends @Nullable V> mappingFunction) {
        long outboundOverflowCount_perGroupIncrements;
        long emptyBitMask;
        V value;
        long dataGroup;
        long groupIndex;
        int isFullCapacitySegment;
        Object segment;
        long hash;
        block9: {
            long dataGroupOffset;
            long groupIndexStep;
            block10: {
                long baseGroupIndex;
                block8: {
                    block11: {
                        Utils.checkNonNull(key);
                        Utils.checkNonNull(mappingFunction);
                        hash = this.keyHashCode(key);
                        long hash_segmentLookupBits = this.segmentLookupBits(hash);
                        int segmentStructureModStamp = this.acquireSegmentStructureModStamp();
                        segment = this.segmentBySegmentLookupBits(hash_segmentLookupBits);
                        isFullCapacitySegment = this.isFullCapacitySegment(hash_segmentLookupBits);
                        this.validateSegmentStructureModStamp(segmentStructureModStamp);
                        baseGroupIndex = HashTable.baseGroupIndex(hash);
                        long hashTagBits = Segment.tagBits(hash);
                        groupIndex = baseGroupIndex;
                        groupIndexStep = 0L;
                        while (true) {
                            long tagGroupOffset = InterleavedSegments.tagGroupOffset(groupIndex, isFullCapacitySegment);
                            long tagGroup = InterleavedSegments.readTagGroupAtOffset(segment, tagGroupOffset);
                            long dataGroupOffset2 = InterleavedSegments.dataGroupFromTagGroupOffset(tagGroupOffset);
                            dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset2);
                            long bitMask = HashTable.match(tagGroup, hashTagBits, dataGroup);
                            while (bitMask != 0L) {
                                boolean keysIdentical;
                                long allocOffset = InterleavedSegments.allocOffset(HashTable.firstAllocIndex(dataGroup, bitMask), isFullCapacitySegment);
                                Object internalKey = Segment.readKeyAtOffset(segment, allocOffset);
                                boolean bl = keysIdentical = internalKey == key;
                                if (keysIdentical || this.keysEqual(key, internalKey)) {
                                    return Segment.readValueAtOffset(segment, allocOffset);
                                }
                                bitMask = LongMath.clearLowestSetBit(bitMask);
                            }
                            if (HashTable.shouldStopProbing(dataGroup)) {
                                value = mappingFunction.apply(key);
                                if (value != null) {
                                    if (groupIndexStep != 0L) break block8;
                                    emptyBitMask = HashTable.matchEmpty(dataGroup);
                                    if (emptyBitMask != 0L) {
                                        outboundOverflowCount_perGroupIncrements = 0L;
                                        break block9;
                                    }
                                    outboundOverflowCount_perGroupIncrements = OutboundOverflowCounts.outboundOverflowCount_groupForChange(groupIndex);
                                    groupIndexStep = 1L;
                                    groupIndex = HashTable.addGroupIndex(groupIndex, groupIndexStep);
                                    break block10;
                                }
                                return null;
                            }
                            if (dataGroup == 0x7F7F7F7F7F7F7F7FL) break block11;
                            if (++groupIndexStep == 8L) break;
                            groupIndex = HashTable.addGroupIndex(groupIndex, groupIndexStep);
                        }
                        value = mappingFunction.apply(key);
                        if (value == null) {
                            return null;
                        }
                        break block8;
                    }
                    return this.computeIfAbsentInflated(segment, key, hash, mappingFunction);
                }
                groupIndexStep = 0L;
                outboundOverflowCount_perGroupIncrements = 0L;
                groupIndex = baseGroupIndex;
            }
            while ((emptyBitMask = HashTable.matchEmpty(dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset = InterleavedSegments.dataGroupOffset(groupIndex, isFullCapacitySegment)))) == 0L) {
                outboundOverflowCount_perGroupIncrements = OutboundOverflowCounts.outboundOverflowCount_markGroupForChange(outboundOverflowCount_perGroupIncrements, groupIndex);
                groupIndex = HashTable.addGroupIndex(groupIndex, ++groupIndexStep);
            }
        }
        int insertionSlotIndexWithinGroup = HashTable.lowestMatchingSlotIndex(emptyBitMask);
        this.insert(segment, isFullCapacitySegment, outboundOverflowCount_perGroupIncrements, key, hash, value, groupIndex, dataGroup, insertionSlotIndexWithinGroup);
        return value;
    }

    private @Nullable V computeIfAbsentInflated(Object segment, K key, long hash, Function<? super K, ? extends @Nullable V> mappingFunction) {
        InflatedSegment inflatedSegment = (InflatedSegment)segment;
        return inflatedSegment.computeIfAbsent(this, key, hash, mappingFunction);
    }

    @Override
    public final @Nullable V compute(K key, BiFunction<? super K, ? super @Nullable V, ? extends @Nullable V> remappingFunction) {
        long outboundOverflowCount_perGroupIncrements;
        long emptyBitMask;
        V newValue;
        long dataGroup;
        long groupIndex;
        int isFullCapacitySegment;
        Object segment;
        long hash;
        block11: {
            long dataGroupOffset;
            long groupIndexStep;
            block12: {
                long baseGroupIndex;
                block10: {
                    block13: {
                        Utils.checkNonNull(key);
                        Utils.checkNonNull(remappingFunction);
                        hash = this.keyHashCode(key);
                        long hash_segmentLookupBits = this.segmentLookupBits(hash);
                        int segmentStructureModStamp = this.acquireSegmentStructureModStamp();
                        segment = this.segmentBySegmentLookupBits(hash_segmentLookupBits);
                        isFullCapacitySegment = this.isFullCapacitySegment(hash_segmentLookupBits);
                        this.validateSegmentStructureModStamp(segmentStructureModStamp);
                        baseGroupIndex = HashTable.baseGroupIndex(hash);
                        long hashTagBits = Segment.tagBits(hash);
                        groupIndex = baseGroupIndex;
                        groupIndexStep = 0L;
                        while (true) {
                            long tagGroupOffset = InterleavedSegments.tagGroupOffset(groupIndex, isFullCapacitySegment);
                            long tagGroup = InterleavedSegments.readTagGroupAtOffset(segment, tagGroupOffset);
                            long dataGroupOffset2 = InterleavedSegments.dataGroupFromTagGroupOffset(tagGroupOffset);
                            dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset2);
                            long bitMask = HashTable.match(tagGroup, hashTagBits, dataGroup);
                            while (bitMask != 0L) {
                                boolean keysIdentical;
                                int trailingZeros = Long.numberOfTrailingZeros(bitMask);
                                long allocIndex = HashTable.extractAllocIndex(dataGroup, trailingZeros);
                                long allocOffset = InterleavedSegments.allocOffset(allocIndex, isFullCapacitySegment);
                                Object internalKey = Segment.readKeyAtOffset(segment, allocOffset);
                                boolean bl = keysIdentical = internalKey == key;
                                if (keysIdentical || this.keysEqual(key, internalKey)) {
                                    Object oldValue = Segment.readValueAtOffset(segment, allocOffset);
                                    V newValue2 = remappingFunction.apply(key, oldValue);
                                    if (newValue2 != null) {
                                        Segment.writeValueAtOffset(segment, allocOffset, newValue2);
                                    } else {
                                        long outboundOverflowCount_perGroupDecrements = OutboundOverflowCounts.computeOutboundOverflowCount_perGroupChanges(baseGroupIndex, groupIndex);
                                        dataGroup = HashTable.setSlotEmpty(dataGroup, trailingZeros);
                                        this.removeAtSlot(hash, segment, isFullCapacitySegment, outboundOverflowCount_perGroupDecrements, dataGroupOffset2, dataGroup, allocIndex, allocOffset);
                                    }
                                    return newValue2;
                                }
                                bitMask = LongMath.clearLowestSetBit(bitMask);
                            }
                            if (HashTable.shouldStopProbing(dataGroup)) {
                                newValue = remappingFunction.apply(key, null);
                                if (newValue != null) {
                                    if (groupIndexStep != 0L) break block10;
                                    emptyBitMask = HashTable.matchEmpty(dataGroup);
                                    if (emptyBitMask != 0L) {
                                        outboundOverflowCount_perGroupIncrements = 0L;
                                        break block11;
                                    }
                                    outboundOverflowCount_perGroupIncrements = OutboundOverflowCounts.outboundOverflowCount_groupForChange(groupIndex);
                                    groupIndexStep = 1L;
                                    groupIndex = HashTable.addGroupIndex(groupIndex, groupIndexStep);
                                    break block12;
                                }
                                return null;
                            }
                            if (dataGroup == 0x7F7F7F7F7F7F7F7FL) break block13;
                            if (++groupIndexStep == 8L) break;
                            groupIndex = HashTable.addGroupIndex(groupIndex, groupIndexStep);
                        }
                        newValue = remappingFunction.apply(key, null);
                        if (newValue == null) {
                            return null;
                        }
                        break block10;
                    }
                    return this.computeInflated(segment, key, hash, remappingFunction);
                }
                groupIndexStep = 0L;
                outboundOverflowCount_perGroupIncrements = 0L;
                groupIndex = baseGroupIndex;
            }
            while ((emptyBitMask = HashTable.matchEmpty(dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset = InterleavedSegments.dataGroupOffset(groupIndex, isFullCapacitySegment)))) == 0L) {
                outboundOverflowCount_perGroupIncrements = OutboundOverflowCounts.outboundOverflowCount_markGroupForChange(outboundOverflowCount_perGroupIncrements, groupIndex);
                groupIndex = HashTable.addGroupIndex(groupIndex, ++groupIndexStep);
            }
        }
        int insertionSlotIndexWithinGroup = HashTable.lowestMatchingSlotIndex(emptyBitMask);
        this.insert(segment, isFullCapacitySegment, outboundOverflowCount_perGroupIncrements, key, hash, newValue, groupIndex, dataGroup, insertionSlotIndexWithinGroup);
        return newValue;
    }

    private @Nullable V computeInflated(Object segment, K key, long hash, BiFunction<? super K, ? super @Nullable V, ? extends @Nullable V> remappingFunction) {
        InflatedSegment inflatedSegment = (InflatedSegment)segment;
        return inflatedSegment.compute(this, key, hash, remappingFunction);
    }

    @Override
    public final @Nullable V merge(K key, V value, BiFunction<? super V, ? super V, ? extends @Nullable V> remappingFunction) {
        long outboundOverflowCount_perGroupIncrements;
        long emptyBitMask;
        long dataGroup;
        long groupIndex;
        int isFullCapacitySegment;
        Object segment;
        long hash;
        block10: {
            long dataGroupOffset;
            long groupIndexStep;
            block11: {
                long baseGroupIndex;
                block9: {
                    Utils.checkNonNull(key);
                    Utils.checkNonNull(value);
                    Utils.checkNonNull(remappingFunction);
                    hash = this.keyHashCode(key);
                    long hash_segmentLookupBits = this.segmentLookupBits(hash);
                    int segmentStructureModStamp = this.acquireSegmentStructureModStamp();
                    segment = this.segmentBySegmentLookupBits(hash_segmentLookupBits);
                    isFullCapacitySegment = this.isFullCapacitySegment(hash_segmentLookupBits);
                    this.validateSegmentStructureModStamp(segmentStructureModStamp);
                    baseGroupIndex = HashTable.baseGroupIndex(hash);
                    long hashTagBits = Segment.tagBits(hash);
                    groupIndex = baseGroupIndex;
                    groupIndexStep = 0L;
                    while (true) {
                        long tagGroupOffset = InterleavedSegments.tagGroupOffset(groupIndex, isFullCapacitySegment);
                        long tagGroup = InterleavedSegments.readTagGroupAtOffset(segment, tagGroupOffset);
                        long dataGroupOffset2 = InterleavedSegments.dataGroupFromTagGroupOffset(tagGroupOffset);
                        dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset2);
                        long bitMask = HashTable.match(tagGroup, hashTagBits, dataGroup);
                        while (bitMask != 0L) {
                            boolean keysIdentical;
                            int trailingZeros = Long.numberOfTrailingZeros(bitMask);
                            long allocIndex = HashTable.extractAllocIndex(dataGroup, trailingZeros);
                            long allocOffset = InterleavedSegments.allocOffset(allocIndex, isFullCapacitySegment);
                            Object internalKey = Segment.readKeyAtOffset(segment, allocOffset);
                            boolean bl = keysIdentical = internalKey == key;
                            if (keysIdentical || this.keysEqual(key, internalKey)) {
                                Object internalVal = Segment.readValueAtOffset(segment, allocOffset);
                                @Nullable V newValue = remappingFunction.apply(internalVal, value);
                                if (newValue != null) {
                                    Segment.writeValueAtOffset(segment, allocOffset, newValue);
                                } else {
                                    long outboundOverflowCount_perGroupDecrements = OutboundOverflowCounts.computeOutboundOverflowCount_perGroupChanges(baseGroupIndex, groupIndex);
                                    dataGroup = HashTable.setSlotEmpty(dataGroup, trailingZeros);
                                    this.removeAtSlot(hash, segment, isFullCapacitySegment, outboundOverflowCount_perGroupDecrements, dataGroupOffset2, dataGroup, allocIndex, allocOffset);
                                }
                                return newValue;
                            }
                            bitMask = LongMath.clearLowestSetBit(bitMask);
                        }
                        if (HashTable.shouldStopProbing(dataGroup)) {
                            if (groupIndexStep != 0L) break block9;
                            emptyBitMask = HashTable.matchEmpty(dataGroup);
                            if (emptyBitMask != 0L) {
                                outboundOverflowCount_perGroupIncrements = 0L;
                                break block10;
                            }
                            outboundOverflowCount_perGroupIncrements = OutboundOverflowCounts.outboundOverflowCount_groupForChange(groupIndex);
                            groupIndexStep = 1L;
                            groupIndex = HashTable.addGroupIndex(groupIndex, groupIndexStep);
                            break block11;
                        }
                        if (dataGroup == 0x7F7F7F7F7F7F7F7FL) break;
                        if (++groupIndexStep != 8L) {
                            groupIndex = HashTable.addGroupIndex(groupIndex, groupIndexStep);
                            continue;
                        }
                        break block9;
                        break;
                    }
                    return this.mergeInflated(segment, key, hash, value, remappingFunction);
                }
                groupIndexStep = 0L;
                outboundOverflowCount_perGroupIncrements = 0L;
                groupIndex = baseGroupIndex;
            }
            while ((emptyBitMask = HashTable.matchEmpty(dataGroup = InterleavedSegments.readDataGroupAtOffset(segment, dataGroupOffset = InterleavedSegments.dataGroupOffset(groupIndex, isFullCapacitySegment)))) == 0L) {
                outboundOverflowCount_perGroupIncrements = OutboundOverflowCounts.outboundOverflowCount_markGroupForChange(outboundOverflowCount_perGroupIncrements, groupIndex);
                groupIndex = HashTable.addGroupIndex(groupIndex, ++groupIndexStep);
            }
        }
        int insertionSlotIndexWithinGroup = HashTable.lowestMatchingSlotIndex(emptyBitMask);
        this.insert(segment, isFullCapacitySegment, outboundOverflowCount_perGroupIncrements, key, hash, value, groupIndex, dataGroup, insertionSlotIndexWithinGroup);
        return value;
    }

    private @Nullable V mergeInflated(Object segment, K key, long hash, V value, BiFunction<? super V, ? super V, ? extends @Nullable V> remappingFunction) {
        InflatedSegment inflatedSegment = (InflatedSegment)segment;
        return inflatedSegment.merge(this, key, hash, value, remappingFunction);
    }

    private void insert(Object segment, int isFullCapacitySegment, long outboundOverflowCounts_perGroupIncrements, K key, long hash, V value, long groupIndex, long dataGroup, int insertionSlotIndexWithinGroup) {
        long bitSetAndState = InterleavedSegment_BitSetAndStateArea.getBitSetAndState(segment);
        int allocCapacity = BitSetAndState.allocCapacity(bitSetAndState);
        int allocIndex = BitSetAndState.freeAllocIndexClosestTo(bitSetAndState, InterleavedSegments.allocIndexBoundaryForLocalAllocation((int)groupIndex, isFullCapacitySegment), allocCapacity);
        if (allocIndex < allocCapacity) {
            this.doInsert(segment, isFullCapacitySegment, outboundOverflowCounts_perGroupIncrements, key, hash, value, groupIndex, dataGroup, insertionSlotIndexWithinGroup, bitSetAndState, allocIndex);
        } else {
            Segment seg = (Segment)segment;
            this.makeSpaceAndInsert(allocCapacity, seg, outboundOverflowCounts_perGroupIncrements, key, hash, value, groupIndex, dataGroup, insertionSlotIndexWithinGroup, bitSetAndState);
        }
    }

    private void doInsert(Object segment, int isFullCapacitySegment, long outboundOverflowCounts_perGroupIncrements, K key, long hash, V value, long groupIndex, long dataGroup, int insertionSlotIndexWithinGroup, long bitSetAndState, int allocIndex) {
        this.incrementSize();
        if (outboundOverflowCounts_perGroupIncrements != 0L) {
            OutboundOverflowCounts.incrementOutboundOverflowCountsPerGroup(segment, isFullCapacitySegment, outboundOverflowCounts_perGroupIncrements);
        }
        bitSetAndState = BitSetAndState.setAllocBit(bitSetAndState, allocIndex);
        InterleavedSegment_BitSetAndStateArea.setBitSetAndState(segment, bitSetAndState);
        byte tag = (byte)Segment.tagBits(hash);
        Segment.writeEntry(segment, isFullCapacitySegment, key, tag, value, groupIndex, dataGroup, insertionSlotIndexWithinGroup, allocIndex);
    }

    final void makeSpaceAndInsert(int allocCapacity, Segment<K, V> segment, long outboundOverflowCounts_perGroupIncrements, K key, long hash, V value, long groupIndex, long dataGroup, int insertionSlotIndexWithinGroup, long bitSetAndState) {
        int modCountAddition;
        int averageSegmentOrder;
        boolean acceptableOrderAfterSplitting;
        if (BitSetAndState.isBulkOperationPlaceholderBitSetAndState(bitSetAndState)) {
            throw new ConcurrentModificationException();
        }
        if (allocCapacity < 48) {
            this.growCapacityAndInsert(segment, outboundOverflowCounts_perGroupIncrements, key, hash, value, groupIndex, dataGroup, insertionSlotIndexWithinGroup, bitSetAndState);
            return;
        }
        int modCount = this.getModCountOpaque();
        int segmentOrder = BitSetAndState.segmentOrder(bitSetAndState);
        boolean bl = acceptableOrderAfterSplitting = segmentOrder < (averageSegmentOrder = this.computeAverageSegmentOrder(this.size + 1L)) + 1;
        if (acceptableOrderAfterSplitting && (modCountAddition = this.tryEnsureSegmentsArrayCapacityForSplit(segmentOrder)) >= 0) {
            this.splitAndInsert(modCount += modCountAddition, segment, key, hash, value, bitSetAndState, segmentOrder);
        } else {
            this.inflateAndInsert(modCount, segmentOrder, segment, bitSetAndState, key, hash, value);
        }
    }

    private void growCapacityAndInsert(Segment<K, V> oldSegment, long outboundOverflowCounts_perGroupIncrements, K key, long hash, V value, long groupIndex, long dataGroup, int insertionSlotIndexWithinGroup, long bitSetAndState) {
        int modCount = this.getModCountOpaque();
        oldSegment.bitSetAndState = BitSetAndState.makeBulkOperationPlaceholderBitSetAndState(bitSetAndState);
        int newAllocCapacity = 48;
        InterleavedSegments.FullCapacitySegment<K, V> newSegment = InterleavedSegments.grow(oldSegment, bitSetAndState, newAllocCapacity);
        bitSetAndState = newSegment.bitSetAndState;
        int segmentOrder = BitSetAndState.segmentOrder(bitSetAndState);
        int firstSegmentIndex = SmoothieMap.firstSegmentIndexByHashAndOrder(hash, segmentOrder);
        boolean oldSegment_isFullCapacity = false;
        this.replaceInSegmentsArray(this.getNonNullSegmentsArrayOrThrowCme(), firstSegmentIndex, segmentOrder, newSegment, oldSegment_isFullCapacity);
        ++modCount;
        int allocIndex = BitSetAndState.freeAllocIndexClosestTo(bitSetAndState, InterleavedSegments.FullCapacitySegment.allocIndexBoundaryForLocalAllocation((int)groupIndex), newAllocCapacity);
        int newSegment_isFullCapacity = 1;
        this.doInsert(newSegment, newSegment_isFullCapacity, outboundOverflowCounts_perGroupIncrements, key, hash, value, groupIndex, dataGroup, insertionSlotIndexWithinGroup, bitSetAndState, allocIndex);
        this.checkModCountOrThrowCme(++modCount);
    }

    private void splitAndInsert(int modCount, Segment<K, V> fromSegment, K key, long hash, V value, long fromSegment_bitSetAndState, int priorSegmentOrder) {
        if (!this.splitBetweenTwoNewSegments) {
            this.split(modCount, fromSegment, hash, fromSegment_bitSetAndState, priorSegmentOrder);
        } else {
            this.splitBetweenTwoNewSegments(modCount, fromSegment, hash, fromSegment_bitSetAndState, priorSegmentOrder);
        }
        this.internalPutIfAbsentDuringSplit(key, hash, value);
    }

    private void internalPutIfAbsentDuringSplit(K key, long hash, V value) {
        if (this.internalPutIfAbsent(key, hash, value) != null) {
            throw new ConcurrentModificationException("New entry shouldn't replace existing one during split");
        }
    }

    private void split(int modCount, Segment<K, V> fromSegment, long hash, long fromSegment_bitSetAndState, int priorSegmentOrder) {
        ++modCount;
        ++this.modCount;
        fromSegment.bitSetAndState = BitSetAndState.makeBulkOperationPlaceholderBitSetAndState(fromSegment_bitSetAndState);
        int siblingSegmentsOrder = priorSegmentOrder + 1;
        int intoSegmentAllocCapacity = this.getInitialSegmentAllocCapacity(siblingSegmentsOrder);
        Segment intoSegment = InterleavedSegments.allocateNewSegmentWithoutSettingBitSetAndSet(intoSegmentAllocCapacity);
        int siblingSegmentsQualificationBitIndex = 11 + siblingSegmentsOrder - 1;
        long fromSegmentIsHigher = this.doSplit(fromSegment, fromSegment_bitSetAndState, intoSegment, intoSegmentAllocCapacity, siblingSegmentsOrder, siblingSegmentsQualificationBitIndex);
        int intoSegmentIsLower = (int)(fromSegmentIsHigher >>> siblingSegmentsQualificationBitIndex);
        int firstSiblingSegmentsIndex = SmoothieMap.firstSegmentIndexByHashAndOrder(hash, priorSegmentOrder);
        int firstIntoSegmentIndex = SmoothieMap.chooseFirstSiblingSegmentIndex(firstSiblingSegmentsIndex, siblingSegmentsOrder, intoSegmentIsLower);
        boolean fromSegment_isFullCapacity = true;
        this.replaceInSegmentsArray(this.getNonNullSegmentsArrayOrThrowCme(), firstIntoSegmentIndex, siblingSegmentsOrder, intoSegment, fromSegment_isFullCapacity);
        this.checkModCountOrThrowCme(++modCount);
    }

    final long doSplit(Segment<K, V> fromSegment, long fromSegment_bitSetAndState, Segment<K, V> intoSegment, int intoSegment_allocCapacity, int newSegmentOrder, int siblingSegmentsQualificationBitIndex) {
        fromSegment_bitSetAndState = BitSetAndState.incrementSegmentOrder(fromSegment_bitSetAndState);
        int intoSegment_currentSize = 0;
        long intoSegment_bitSetAndState = BitSetAndState.makeNewBitSetAndState(intoSegment_allocCapacity, newSegmentOrder);
        long fromSegment_outboundOverflowCount_perGroupDeductions = 0L;
        long intoSegment_outboundOverflowCount_perGroupAdditions = 0L;
        long swappedSegments = 0L;
        long siblingSegmentsQualificationBit = 1L << siblingSegmentsQualificationBitIndex;
        int intoSegment_isFullCapacity = intoSegment_allocCapacity == 48 ? 1 : 0;
        int fromSegment_isFullCapacity = 1;
        long iterGroupIndexStart = this.size & 7L;
        for (int extraGroupIndex = 0; extraGroupIndex < 8; ++extraGroupIndex) {
            long iterGroupIndex = HashTable.addGroupIndex(iterGroupIndexStart, extraGroupIndex);
            long iterDataGroupOffset = InterleavedSegments.dataGroupOffset(iterGroupIndex, fromSegment_isFullCapacity);
            long iterDataGroup = InterleavedSegments.readDataGroupAtOffset(fromSegment, iterDataGroupOffset);
            long iterBitMask = HashTable.matchFull(iterDataGroup);
            while (iterBitMask != 0L) {
                boolean entryShouldRemainInFromSegment;
                int iterTrailingZeros = Long.numberOfTrailingZeros(iterBitMask);
                long fromSegment_allocIndex = HashTable.extractAllocIndex(iterDataGroup, iterTrailingZeros);
                long fromSegment_allocOffset = InterleavedSegments.allocOffset(fromSegment_allocIndex, fromSegment_isFullCapacity);
                Object key = Segment.readKeyAtOffset(fromSegment, fromSegment_allocOffset);
                long hash = this.keyHashCode(key);
                long baseGroupIndex = HashTable.baseGroupIndex(hash);
                boolean bl = entryShouldRemainInFromSegment = (hash & siblingSegmentsQualificationBit) == 0L;
                if (entryShouldRemainInFromSegment) {
                    if (iterGroupIndex != baseGroupIndex) {
                        long newGroupIndex = baseGroupIndex;
                        long groupIndexStep = 0L;
                        do {
                            long dataGroupOffset;
                            long dataGroup;
                            long emptyBitMask;
                            if ((emptyBitMask = HashTable.matchEmpty(dataGroup = InterleavedSegments.readDataGroupAtOffset(fromSegment, dataGroupOffset = InterleavedSegments.dataGroupOffset(newGroupIndex, fromSegment_isFullCapacity)))) == 0L) continue;
                            int newSlotIndexWithinGroup = HashTable.lowestMatchingSlotIndex(emptyBitMask);
                            byte data = HashTable.makeData(dataGroup, fromSegment_allocIndex);
                            InterleavedSegments.writeTagAndData(fromSegment, fromSegment_isFullCapacity, newGroupIndex, newSlotIndexWithinGroup, (byte)Segment.tagBits(hash), data);
                            fromSegment_outboundOverflowCount_perGroupDeductions += OutboundOverflowCounts.computeOutboundOverflowCount_perGroupChanges(baseGroupIndex, newGroupIndex) ^ OutboundOverflowCounts.computeOutboundOverflowCount_perGroupChanges(baseGroupIndex, iterGroupIndex);
                            iterDataGroup = HashTable.setSlotEmpty(iterDataGroup, iterTrailingZeros);
                            break;
                        } while ((newGroupIndex = HashTable.addGroupIndex(newGroupIndex, ++groupIndexStep)) != iterGroupIndex);
                    }
                } else {
                    Object value = Segment.readValueAtOffset(fromSegment, fromSegment_allocOffset);
                    Segment.eraseKeyAndValueAtOffset(fromSegment, fromSegment_allocOffset);
                    fromSegment_bitSetAndState = BitSetAndState.clearAllocBit(fromSegment_bitSetAndState, fromSegment_allocIndex);
                    iterDataGroup = HashTable.setSlotEmpty(iterDataGroup, iterTrailingZeros);
                    if (intoSegment_currentSize == intoSegment_allocCapacity) {
                        if (swappedSegments != 0L) {
                            throw new ConcurrentModificationException();
                        }
                        swappedSegments = siblingSegmentsQualificationBit;
                        InterleavedSegments.FullCapacitySegment.writeDataGroup(fromSegment, iterGroupIndex, iterDataGroup);
                        int fromSegment_allocCapacity = 48;
                        intoSegment_bitSetAndState = fromSegment_bitSetAndState = InterleavedSegments.swapContentsDuringSplit(fromSegment, fromSegment_bitSetAndState, intoSegment, intoSegment_bitSetAndState);
                        fromSegment_bitSetAndState = intoSegment.bitSetAndState;
                        Segment<K, V> tmpSegment = intoSegment;
                        intoSegment = fromSegment;
                        fromSegment = tmpSegment;
                        intoSegment_allocCapacity = fromSegment_allocCapacity;
                        fromSegment_isFullCapacity = 0;
                        intoSegment_isFullCapacity = 1;
                        iterDataGroupOffset = InterleavedSegments.dataGroupOffset(iterGroupIndex, fromSegment_isFullCapacity);
                        iterDataGroup = InterleavedSegments.readDataGroupAtOffset(fromSegment, iterDataGroupOffset);
                        iterBitMask = HashTable.matchFull(iterDataGroup);
                        iterBitMask = LongMath.clearLowestNBits(iterBitMask, iterTrailingZeros);
                        iterBitMask |= 1L << iterTrailingZeros;
                    }
                    long groupIndex = baseGroupIndex;
                    long groupIndexStep = 0L;
                    while (true) {
                        long dataGroupOffset;
                        long dataGroup;
                        long emptyBitMask;
                        if ((emptyBitMask = HashTable.matchEmpty(dataGroup = InterleavedSegments.readDataGroupAtOffset(intoSegment, dataGroupOffset = InterleavedSegments.dataGroupOffset(groupIndex, intoSegment_isFullCapacity)))) != 0L) {
                            int insertionSlotIndexWithinGroup = HashTable.lowestMatchingSlotIndex(emptyBitMask);
                            intoSegment_outboundOverflowCount_perGroupAdditions += OutboundOverflowCounts.computeOutboundOverflowCount_perGroupChanges(baseGroupIndex, groupIndex);
                            int intoSegment_allocIndex = BitSetAndState.freeAllocIndexClosestTo(intoSegment_bitSetAndState, InterleavedSegments.allocIndexBoundaryForLocalAllocation((int)groupIndex, intoSegment_isFullCapacity), intoSegment_allocCapacity);
                            intoSegment_bitSetAndState = BitSetAndState.setAllocBit(intoSegment_bitSetAndState, intoSegment_allocIndex);
                            byte tag = (byte)Segment.tagBits(hash);
                            Segment.writeEntry(intoSegment, intoSegment_isFullCapacity, key, tag, value, groupIndex, dataGroup, insertionSlotIndexWithinGroup, intoSegment_allocIndex);
                            ++intoSegment_currentSize;
                            break;
                        }
                        groupIndex = HashTable.addGroupIndex(groupIndex, ++groupIndexStep);
                    }
                }
                iterBitMask = LongMath.clearLowestSetBit(iterBitMask);
            }
            iterDataGroupOffset = InterleavedSegments.dataGroupOffset(iterGroupIndex, fromSegment_isFullCapacity);
            InterleavedSegments.writeDataGroupAtOffset(fromSegment, iterDataGroupOffset, iterDataGroup);
        }
        if (swappedSegments == 0L && intoSegment_isFullCapacity == 0 && intoSegment_currentSize >= 29) {
            swappedSegments = siblingSegmentsQualificationBit;
            int fromSegment_allocCapacity = 48;
            intoSegment_bitSetAndState = fromSegment_bitSetAndState = InterleavedSegments.swapContentsDuringSplit(fromSegment, fromSegment_bitSetAndState, intoSegment, intoSegment_bitSetAndState);
            fromSegment_bitSetAndState = intoSegment.bitSetAndState;
            Segment<K, V> tmpSegment = intoSegment;
            intoSegment = fromSegment;
            fromSegment = tmpSegment;
            intoSegment_allocCapacity = fromSegment_allocCapacity;
            fromSegment_isFullCapacity = 0;
            intoSegment_isFullCapacity = 1;
        }
        if (swappedSegments == 0L) {
            fromSegment.setBitSetAndStateAfterBulkOperation(fromSegment_bitSetAndState);
            intoSegment.bitSetAndState = intoSegment_bitSetAndState;
        } else {
            fromSegment.bitSetAndState = fromSegment_bitSetAndState;
            intoSegment.setBitSetAndStateAfterBulkOperation(intoSegment_bitSetAndState);
        }
        OutboundOverflowCounts.subtractOutboundOverflowCountsPerGroupAndUpdateAllGroups(fromSegment, fromSegment_isFullCapacity, fromSegment_outboundOverflowCount_perGroupDeductions);
        OutboundOverflowCounts.addOutboundOverflowCountsPerGroup(intoSegment, intoSegment_outboundOverflowCount_perGroupAdditions);
        UnsafeUtils.U.storeFence();
        return swappedSegments;
    }

    private void splitBetweenTwoNewSegments(int modCount, Segment<K, V> oldSegment, long hash, long oldSegment_bitSetAndState, int priorSegmentOrder) {
        oldSegment.bitSetAndState = BitSetAndState.makeBulkOperationPlaceholderBitSetAndState(oldSegment_bitSetAndState);
        int resultSegmentsOrder = priorSegmentOrder + 1;
        int resultSegmentsAllocCapacity = this.getInitialSegmentAllocCapacity(resultSegmentsOrder);
        int firstIndexOfResultSegmentOne = SmoothieMap.firstSegmentIndexByHashAndOrder(hash, resultSegmentsOrder);
        Segment resultSegmentOne = InterleavedSegments.createNewSegment(resultSegmentsAllocCapacity, resultSegmentsOrder);
        Object[] segmentsArray = this.getNonNullSegmentsArrayOrThrowCme();
        boolean oldSegment_isFullCapacitySegment = true;
        this.replaceInSegmentsArray(segmentsArray, firstIndexOfResultSegmentOne, resultSegmentsOrder, resultSegmentOne, oldSegment_isFullCapacitySegment);
        ++modCount;
        int firstIndexOfResultSegmentTwo = SmoothieMap.siblingSegmentIndex(firstIndexOfResultSegmentOne, resultSegmentsOrder);
        Segment resultSegmentTwo = InterleavedSegments.createNewSegment(resultSegmentsAllocCapacity, resultSegmentsOrder);
        this.replaceInSegmentsArray(segmentsArray, firstIndexOfResultSegmentTwo, resultSegmentsOrder, resultSegmentTwo, oldSegment_isFullCapacitySegment);
        this.checkModCountOrThrowCme(++modCount);
        this.doSplitBetweenTwoNewSegments(oldSegment);
    }

    private void doSplitBetweenTwoNewSegments(Segment<K, V> oldSegment) {
        int numMovedEntries = 0;
        for (int iterGroupIndex = 0; iterGroupIndex < 8; ++iterGroupIndex) {
            long iterDataGroup = InterleavedSegments.FullCapacitySegment.readDataGroup(oldSegment, iterGroupIndex);
            long iterBitMask = HashTable.matchFull(iterDataGroup);
            while (iterBitMask != 0L) {
                int iterTrailingZeros = Long.numberOfTrailingZeros(iterBitMask);
                long oldSegment_allocIndex = HashTable.extractAllocIndex(iterDataGroup, iterTrailingZeros);
                long oldSegment_allocOffset = InterleavedSegments.FullCapacitySegment.allocOffset(oldSegment_allocIndex);
                Object key = Segment.readKeyAtOffset(oldSegment, oldSegment_allocOffset);
                long hash = this.keyHashCode(key);
                Object value = Segment.readValueAtOffset(oldSegment, oldSegment_allocOffset);
                this.internalPutIfAbsentDuringSplit(key, hash, value);
                ++numMovedEntries;
                iterBitMask = LongMath.clearLowestSetBit(iterBitMask);
            }
        }
        this.size -= (long)numMovedEntries;
    }

    @RarelyCalledAmortizedPerSegment
    private void inflateAndInsert(int modCount, int segmentOrder, Segment<K, V> oldSegment, long bitSetAndState, K key, long hash, V value) {
        oldSegment.bitSetAndState = BitSetAndState.makeBulkOperationPlaceholderBitSetAndState(bitSetAndState);
        InflatedSegment<K, V> inflatedSegment = new InflatedSegment<K, V>(segmentOrder, this.size);
        oldSegment.copyEntriesDuringInflate(this, inflatedSegment);
        int firstSegmentIndex = SmoothieMap.firstSegmentIndexByHashAndOrder(hash, segmentOrder);
        boolean oldSegment_isFullCapacity = true;
        this.replaceInSegmentsArray(this.getNonNullSegmentsArrayOrThrowCme(), firstSegmentIndex, segmentOrder, inflatedSegment, oldSegment_isFullCapacity);
        ++modCount;
        if (inflatedSegment.put(this, key, hash, value, true) != null) {
            throw new ConcurrentModificationException();
        }
        this.checkModCountOrThrowCme(++modCount);
    }

    final long removeAtSlotNoShrink(long bitSetAndState, Object segment, int isFullCapacitySegment, long outboundOverflowCount_perGroupDecrements, long dataGroupOffset, long dataGroupWithEmptiedSlot, long allocIndex, long allocOffset) {
        this.decrementSize();
        if (outboundOverflowCount_perGroupDecrements != 0L) {
            OutboundOverflowCounts.decrementOutboundOverflowCountsPerGroup(segment, isFullCapacitySegment, outboundOverflowCount_perGroupDecrements);
        }
        bitSetAndState = BitSetAndState.clearAllocBit(bitSetAndState, allocIndex);
        InterleavedSegments.writeDataGroupAtOffset(segment, dataGroupOffset, dataGroupWithEmptiedSlot);
        Segment.eraseKeyAndValueAtOffset(segment, allocOffset);
        return bitSetAndState;
    }

    private void removeAtSlot(long hash, Object segment, int isFullCapacitySegment, long outboundOverflowCount_perGroupDecrements, long dataGroupOffset, long dataGroupWithEmptiedSlot, long allocIndex, long allocOffset) {
        long bitSetAndState = InterleavedSegment_BitSetAndStateArea.getBitSetAndState(segment);
        bitSetAndState = this.removeAtSlotNoShrink(bitSetAndState, segment, isFullCapacitySegment, outboundOverflowCount_perGroupDecrements, dataGroupOffset, dataGroupWithEmptiedSlot, allocIndex, allocOffset);
        InterleavedSegment_BitSetAndStateArea.setBitSetAndState(segment, bitSetAndState);
        if (this.doShrink) {
            this.tryShrink1(hash, segment, bitSetAndState);
        }
    }

    private void tryShrink1(long hash, Object segment, long bitSetAndState) {
        int segmentSize = BitSetAndState.segmentSize(bitSetAndState);
        if (segmentSize > 22) {
            return;
        }
        Segment seg = (Segment)segment;
        this.tryShrink2(seg, bitSetAndState, hash);
    }

    private void tryShrink2(Segment<K, V> segmentOne, long segmentOne_bitSetAndState, long hash) {
        if (BitSetAndState.isBulkOperationPlaceholderBitSetAndState(segmentOne_bitSetAndState)) {
            throw new ConcurrentModificationException();
        }
        int segmentOneOrder = BitSetAndState.segmentOrder(segmentOne_bitSetAndState);
        if (segmentOneOrder == 0) {
            return;
        }
        int firstSegmentOneIndex = SmoothieMap.firstSegmentIndexByHashAndOrder(hash, segmentOneOrder);
        int modCountChange = this.tryShrink3(segmentOne, segmentOne_bitSetAndState, segmentOneOrder, firstSegmentOneIndex);
    }

    private int tryShrink3(Segment<K, V> segmentOne, long segmentOne_bitSetAndState, int segmentOneOrder, int firstSegmentOneIndex) {
        long segmentTwo_bitSetAndState;
        int segmentTwoOrder;
        int originalModCount;
        int modCount = originalModCount = this.getModCountOpaque();
        int firstSegmentTwoIndex = SmoothieMap.siblingSegmentIndex(firstSegmentOneIndex, segmentOneOrder);
        Object[] segmentsArray = this.getNonNullSegmentsArrayOrThrowCme();
        Segment<K, V> segmentTwo = SmoothieMap.segmentCheckedByIndex(segmentsArray, firstSegmentTwoIndex);
        if (segmentTwo instanceof InflatedSegment) {
            int segmentTwoSize = ((InflatedSegment)segmentTwo).delegate.size();
            if (!InflatedSegment.shouldDeflateSmall(segmentTwoSize)) {
                return 0;
            }
            this.deflateSmallWithSegmentIndex((InflatedSegment)segmentTwo, firstSegmentTwoIndex);
            ++modCount;
            segmentTwo = SmoothieMap.segmentCheckedByIndex(segmentsArray, firstSegmentTwoIndex);
        }
        if ((segmentTwoOrder = BitSetAndState.segmentOrder(segmentTwo_bitSetAndState = segmentTwo.bitSetAndState)) == segmentOneOrder) {
            int segmentTwo_allocCapacity;
            int segmentOne_allocCapacity;
            int maxAllocCapacity;
            int segmentTwoSize;
            int segmentOneSize = BitSetAndState.segmentSize(segmentOne_bitSetAndState);
            int sizeAfterShrinking = segmentOneSize + (segmentTwoSize = BitSetAndState.segmentSize(segmentTwo_bitSetAndState));
            if (sizeAfterShrinking + 4 <= (maxAllocCapacity = Math.max(segmentOne_allocCapacity = BitSetAndState.allocCapacity(segmentOne_bitSetAndState), segmentTwo_allocCapacity = BitSetAndState.allocCapacity(segmentTwo_bitSetAndState)))) {
                long intoSegment_bitSetAndState;
                Segment<K, V> intoSegment;
                int fromSegmentSize;
                long fromSegment_bitSetAndState;
                Segment<K, V> fromSegment;
                int fromSegment_firstIndex;
                if (segmentOne_allocCapacity + ((int)this.size & 1) <= segmentTwo_allocCapacity) {
                    fromSegment_firstIndex = firstSegmentOneIndex;
                    fromSegment = segmentOne;
                    fromSegment_bitSetAndState = segmentOne_bitSetAndState;
                    fromSegmentSize = segmentOneSize;
                    intoSegment = segmentTwo;
                    intoSegment_bitSetAndState = segmentTwo_bitSetAndState;
                } else {
                    fromSegment_firstIndex = firstSegmentTwoIndex;
                    fromSegment = segmentTwo;
                    fromSegment_bitSetAndState = segmentTwo_bitSetAndState;
                    fromSegmentSize = segmentTwoSize;
                    intoSegment = segmentOne;
                    intoSegment_bitSetAndState = segmentOne_bitSetAndState;
                }
                intoSegment.bitSetAndState = BitSetAndState.makeBulkOperationPlaceholderBitSetAndState(intoSegment_bitSetAndState);
                this.replaceInSegmentsArray(segmentsArray, fromSegment_firstIndex, segmentOneOrder, intoSegment, fromSegment instanceof InterleavedSegments.FullCapacitySegment);
                ++modCount;
                this.doShrinkInto(fromSegment, fromSegment_bitSetAndState, intoSegment, intoSegment_bitSetAndState);
                this.checkModCountOrThrowCme(modCount += fromSegmentSize);
            }
        } else if (segmentTwoOrder <= segmentOneOrder) {
            throw new ConcurrentModificationException();
        }
        return modCount - originalModCount;
    }

    private void doShrinkInto(Segment<K, V> fromSegment, long fromSegment_bitSetAndState, Segment<K, V> intoSegment, long intoSegment_bitSetAndState) {
        int intoSegment_allocCapacity = BitSetAndState.allocCapacity(intoSegment_bitSetAndState);
        long fromSegment_isFullCapacity = BitSetAndState.isFullCapacity(fromSegment_bitSetAndState) ? 1L : 0L;
        int intoSegment_isFullCapacity = intoSegment_allocCapacity == 48 ? 1 : 0;
        long intoSegment_outboundOverflowCount_perGroupAdditions = 0L;
        long fromSegment_bitSet = BitSetAndState.extractBitSetForIteration(fromSegment_bitSetAndState);
        int iterAllocIndexStep = Long.numberOfLeadingZeros(fromSegment_bitSet) + 1;
        int iterAllocIndex = 64;
        block0: while ((iterAllocIndex -= iterAllocIndexStep) >= 0) {
            long baseGroupIndex;
            long iterAllocOffset = InterleavedSegments.allocOffset(iterAllocIndex, fromSegment_isFullCapacity);
            Object key = Segment.readKeyAtOffset(fromSegment, iterAllocOffset);
            Object value = Segment.readValueAtOffset(fromSegment, iterAllocOffset);
            iterAllocIndexStep = Long.numberOfLeadingZeros(fromSegment_bitSet <<= iterAllocIndexStep) + 1;
            long hash = this.keyHashCode(key);
            long groupIndex = baseGroupIndex = HashTable.baseGroupIndex(hash);
            long groupIndexStep = 0L;
            while (true) {
                long dataGroupOffset;
                long dataGroup;
                long emptyBitMask;
                if ((emptyBitMask = HashTable.matchEmpty(dataGroup = InterleavedSegments.readDataGroupAtOffset(intoSegment, dataGroupOffset = InterleavedSegments.dataGroupOffset(groupIndex, intoSegment_isFullCapacity)))) != 0L) {
                    int insertionSlotIndexWithinGroup = HashTable.lowestMatchingSlotIndex(emptyBitMask);
                    intoSegment_outboundOverflowCount_perGroupAdditions += OutboundOverflowCounts.computeOutboundOverflowCount_perGroupChanges(baseGroupIndex, groupIndex);
                    int intoSegment_allocIndex = BitSetAndState.freeAllocIndexClosestTo(intoSegment_bitSetAndState, InterleavedSegments.allocIndexBoundaryForLocalAllocation((int)groupIndex, intoSegment_isFullCapacity), intoSegment_allocCapacity);
                    intoSegment_bitSetAndState = BitSetAndState.setAllocBit(intoSegment_bitSetAndState, intoSegment_allocIndex);
                    if (intoSegment_allocIndex >= intoSegment_allocCapacity) {
                        throw new ConcurrentModificationException("intoSegment_allocIndex: " + intoSegment_allocIndex + ", intoSegment_allocCapacity: " + intoSegment_allocCapacity);
                    }
                    ++this.modCount;
                    byte tag = (byte)Segment.tagBits(hash);
                    Segment.writeEntry(intoSegment, intoSegment_isFullCapacity, key, tag, value, groupIndex, dataGroup, insertionSlotIndexWithinGroup, intoSegment_allocIndex);
                    continue block0;
                }
                groupIndex = HashTable.addGroupIndex(groupIndex, ++groupIndexStep);
            }
        }
        intoSegment.setBitSetAndStateAfterBulkOperation(intoSegment_bitSetAndState -= 0x1000000000000L);
        OutboundOverflowCounts.addOutboundOverflowCountsPerGroup(intoSegment, intoSegment_outboundOverflowCount_perGroupAdditions);
    }

    @RarelyCalledAmortizedPerSegment
    private void deflateSmall(long hash, InflatedSegment<K, V> inflatedSegment) {
        int segmentOrder = BitSetAndState.segmentOrder(inflatedSegment.bitSetAndState);
        int firstSegmentIndex = SmoothieMap.firstSegmentIndexByHashAndOrder(hash, segmentOrder);
        this.deflateSmallWithSegmentIndex(inflatedSegment, firstSegmentIndex);
    }

    private void deflateSmallWithSegmentIndex(InflatedSegment<K, V> inflatedSegment, int firstSegmentIndex) {
        int modCount = this.getModCountOpaque();
        long inflatedSegment_bitSetAndState = inflatedSegment.replaceBitSetAndStateWithBulkOperationPlaceholderOrThrowCme();
        int segmentOrder = BitSetAndState.segmentOrder(inflatedSegment_bitSetAndState);
        int deflatedSegment_allocCapacity = 48;
        Segment deflatedSegment = InterleavedSegments.allocateNewSegmentWithoutSettingBitSetAndSet(deflatedSegment_allocCapacity);
        this.doDeflateSmall(segmentOrder, inflatedSegment, deflatedSegment, deflatedSegment_allocCapacity);
        boolean inflatedSegment_isFullCapacitySegment = false;
        this.replaceInSegmentsArray(this.getNonNullSegmentsArrayOrThrowCme(), firstSegmentIndex, segmentOrder, deflatedSegment, inflatedSegment_isFullCapacitySegment);
        this.checkModCountOrThrowCme(++modCount);
    }

    @RarelyCalledAmortizedPerSegment
    private void doDeflateSmall(int segmentOrder, InflatedSegment<K, V> inflatedSegment, Segment<K, V> intoSegment, int intoSegment_allocCapacity) {
        int intoSegment_currentSize = 0;
        long intoSegment_outboundOverflowCount_perGroupAdditions = 0L;
        long intoSegment_bitSetAndState = BitSetAndState.makeNewBitSetAndState(intoSegment_allocCapacity, segmentOrder);
        for (InflatedSegmentQueryContext.Node node : ((InflatedSegment)inflatedSegment).delegate.keySet()) {
            int intoSegment_allocIndex;
            int insertionSlotIndexWithinGroup;
            long dataGroup;
            long baseGroupIndex;
            Object key = node.getKey();
            Object value = node.getValue();
            long hash = node.hash;
            long groupIndex = baseGroupIndex = HashTable.baseGroupIndex(hash);
            long groupIndexStep = 0L;
            while (true) {
                long emptyBitMask;
                if ((emptyBitMask = HashTable.matchEmpty(dataGroup = InterleavedSegments.FullCapacitySegment.readDataGroup(intoSegment, groupIndex))) != 0L) {
                    insertionSlotIndexWithinGroup = HashTable.lowestMatchingSlotIndex(emptyBitMask);
                    intoSegment_outboundOverflowCount_perGroupAdditions += OutboundOverflowCounts.computeOutboundOverflowCount_perGroupChanges(baseGroupIndex, groupIndex);
                    intoSegment_allocIndex = BitSetAndState.freeAllocIndexClosestTo(intoSegment_bitSetAndState, InterleavedSegments.FullCapacitySegment.allocIndexBoundaryForLocalAllocation((int)groupIndex), intoSegment_allocCapacity);
                    intoSegment_bitSetAndState = BitSetAndState.setAllocBit(intoSegment_bitSetAndState, intoSegment_allocIndex);
                    if (intoSegment_allocIndex >= intoSegment_allocCapacity) {
                        throw new ConcurrentModificationException("intoSegment_allocIndex: " + intoSegment_allocIndex + ", intoSegment_allocCapacity: " + intoSegment_allocCapacity);
                    }
                    break;
                }
                groupIndex = HashTable.addGroupIndex(groupIndex, ++groupIndexStep);
            }
            byte tag = (byte)Segment.tagBits(hash);
            InterleavedSegments.FullCapacitySegment.writeEntry(intoSegment, key, tag, value, groupIndex, dataGroup, insertionSlotIndexWithinGroup, intoSegment_allocIndex);
            ++intoSegment_currentSize;
        }
        intoSegment.bitSetAndState = intoSegment_bitSetAndState;
        boolean intoSegment_isFullCapacity = true;
        OutboundOverflowCounts.addOutboundOverflowCountsPerGroup(intoSegment, intoSegment_outboundOverflowCount_perGroupAdditions);
        UnsafeUtils.U.storeFence();
    }

    @RarelyCalledAmortizedPerSegment
    private void replaceInflatedWithEmptyOrdinary(int segmentIndex, InflatedSegment<K, V> inflatedSegment) {
        long inflatedSegment_bitSetAndState = inflatedSegment.replaceBitSetAndStateWithBulkOperationPlaceholderOrThrowCme();
        int segmentOrder = BitSetAndState.segmentOrder(inflatedSegment_bitSetAndState);
        int ordinarySegmentAllocCapacity = this.getInitialSegmentAllocCapacity(segmentOrder);
        Segment ordinarySegment = InterleavedSegments.createNewSegment(ordinarySegmentAllocCapacity, segmentOrder);
        int firstSegmentIndex = SmoothieMap.firstSegmentIndexByIndexAndOrder(segmentIndex, segmentOrder);
        boolean inflatedSegment_isFullCapacitySegment = false;
        this.replaceInSegmentsArray(this.getNonNullSegmentsArrayOrThrowCme(), firstSegmentIndex, segmentOrder, ordinarySegment, inflatedSegment_isFullCapacitySegment);
    }

    private void splitInflated(long hash, InflatedSegment<K, V> inflatedSegment) {
        int modCount = this.getModCountOpaque();
        long inflatedSegmentBitSetAndState = inflatedSegment.replaceBitSetAndStateWithBulkOperationPlaceholderOrThrowCme();
        int inflatedSegmentOrder = BitSetAndState.segmentOrder(inflatedSegmentBitSetAndState);
        int modCountIncrement = this.tryEnsureSegmentsArrayCapacityForSplit(inflatedSegmentOrder);
        if (modCountIncrement < 0) {
            throw new ConcurrentModificationException();
        }
        modCount += modCountIncrement;
        int resultSegmentsOrder = inflatedSegmentOrder + 1;
        int resultSegmentsAllocCapacity = this.getInitialSegmentAllocCapacity(resultSegmentsOrder);
        int firstIndexOfResultSegmentOne = SmoothieMap.firstSegmentIndexByHashAndOrder(hash, resultSegmentsOrder);
        Segment resultSegmentOne = InterleavedSegments.createNewSegment(resultSegmentsAllocCapacity, resultSegmentsOrder);
        Object[] segmentsArray = this.getNonNullSegmentsArrayOrThrowCme();
        boolean inflatedSegment_isFullCapacitySegment = false;
        this.replaceInSegmentsArray(segmentsArray, firstIndexOfResultSegmentOne, resultSegmentsOrder, resultSegmentOne, inflatedSegment_isFullCapacitySegment);
        ++modCount;
        int firstIndexOfResultSegmentTwo = SmoothieMap.siblingSegmentIndex(firstIndexOfResultSegmentOne, resultSegmentsOrder);
        Segment resultSegmentTwo = InterleavedSegments.createNewSegment(resultSegmentsAllocCapacity, resultSegmentsOrder);
        this.replaceInSegmentsArray(segmentsArray, firstIndexOfResultSegmentTwo, resultSegmentsOrder, resultSegmentTwo, inflatedSegment_isFullCapacitySegment);
        this.checkModCountOrThrowCme(++modCount);
        this.doSplitInflated(inflatedSegment);
    }

    private void doSplitInflated(InflatedSegment<K, V> inflatedSegment) {
        int numMovedEntries = 0;
        for (InflatedSegmentQueryContext.Node node : ((InflatedSegment)inflatedSegment).delegate.keySet()) {
            Object key = node.getKey();
            Object value = node.getValue();
            long hash = node.hash;
            this.internalPutIfAbsentDuringSplit(key, hash, value);
            ++numMovedEntries;
        }
        this.size -= (long)numMovedEntries;
    }

    private void shrinkAndTrimToSize() {
        throw new UnsupportedOperationException("TODO");
    }

    private static int nextSegmentIndex(int segmentsArrayLength, int segmentsArrayOrder, int segmentIndex, Segment<?, ?> segment) {
        segmentIndex <<= -segmentsArrayOrder;
        segmentIndex = Integer.reverse(segmentIndex);
        int segmentOrder = BitSetAndState.segmentOrder(segment.bitSetAndState);
        Utils.verifyThat(segmentOrder <= segmentsArrayOrder);
        int numberOfArrayIndexesWithThisSegment = 1 << segmentsArrayOrder - segmentOrder;
        if ((segmentIndex += numberOfArrayIndexesWithThisSegment) >= segmentsArrayLength) {
            return -1;
        }
        segmentIndex = Integer.reverse(segmentIndex);
        return segmentIndex >>>= -segmentsArrayOrder;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map otherMap = (Map)obj;
        if ((long)otherMap.size() != this.size) {
            return false;
        }
        if (otherMap instanceof ObjObjMap) {
            return ((ObjObjMap)otherMap).forEachWhile((otherKey, otherValue) -> otherKey != null && otherValue != null && this.containsEntry(otherKey, otherValue));
        }
        for (Map.Entry e : otherMap.entrySet()) {
            @Nullable K otherKey2 = e.getKey();
            @Nullable V otherValue2 = e.getValue();
            if (otherKey2 != null && otherValue2 != null && this.containsEntry(otherKey2, otherValue2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int h = 0;
        int modCount = this.getModCountOpaque();
        Object[] segmentsArray = this.getNonNullSegmentsArrayOrThrowIse();
        int segmentArrayLength = segmentsArray.length;
        int segmentsArrayOrder = SmoothieMap.order(segmentArrayLength);
        int segmentIndex = 0;
        while (segmentIndex >= 0) {
            Segment<K, V> segment = SmoothieMap.segmentCheckedByIndex(segmentsArray, segmentIndex);
            h += segment.hashCode(this);
            segmentIndex = SmoothieMap.nextSegmentIndex(segmentArrayLength, segmentsArrayOrder, segmentIndex, segment);
        }
        this.checkModCountOrThrowCme(modCount);
        return h;
    }

    @Override
    public final void forEach(BiConsumer<? super K, ? super V> action) {
        Utils.checkNonNull(action);
        int modCount = this.getModCountOpaque();
        Object[] segmentsArray = this.getNonNullSegmentsArrayOrThrowIse();
        int segmentArrayLength = segmentsArray.length;
        int segmentsArrayOrder = SmoothieMap.order(segmentArrayLength);
        int segmentIndex = 0;
        while (segmentIndex >= 0) {
            Segment<? super K, ? super V> segment = SmoothieMap.segmentCheckedByIndex(segmentsArray, segmentIndex);
            segment.forEach(action);
            segmentIndex = SmoothieMap.nextSegmentIndex(segmentArrayLength, segmentsArrayOrder, segmentIndex, segment);
        }
        this.checkModCountOrThrowCme(modCount);
    }

    @Override
    public final boolean forEachWhile(BiPredicate<? super K, ? super V> predicate) {
        Utils.checkNonNull(predicate);
        boolean interrupted = false;
        int modCount = this.getModCountOpaque();
        Object[] segmentsArray = this.getNonNullSegmentsArrayOrThrowIse();
        int segmentArrayLength = segmentsArray.length;
        int segmentsArrayOrder = SmoothieMap.order(segmentArrayLength);
        int segmentIndex = 0;
        while (segmentIndex >= 0) {
            Segment<? super K, ? super V> segment = SmoothieMap.segmentCheckedByIndex(segmentsArray, segmentIndex);
            if (!segment.forEachWhile(predicate)) {
                interrupted = true;
                break;
            }
            segmentIndex = SmoothieMap.nextSegmentIndex(segmentArrayLength, segmentsArrayOrder, segmentIndex, segment);
        }
        this.checkModCountOrThrowCme(modCount);
        return !interrupted;
    }

    @Override
    public final void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Utils.checkNonNull(function);
        int modCount = this.getModCountOpaque();
        Object[] segmentsArray = this.getNonNullSegmentsArrayOrThrowIse();
        int segmentArrayLength = segmentsArray.length;
        int segmentsArrayOrder = SmoothieMap.order(segmentArrayLength);
        int segmentIndex = 0;
        while (segmentIndex >= 0) {
            Segment<? super K, ? extends V> segment = SmoothieMap.segmentCheckedByIndex(segmentsArray, segmentIndex);
            segment.replaceAll(function);
            segmentIndex = SmoothieMap.nextSegmentIndex(segmentArrayLength, segmentsArrayOrder, segmentIndex, segment);
        }
        this.checkModCountOrThrowCme(modCount);
    }

    @Override
    public final boolean containsValue(Object value) {
        int modCount = this.getModCountOpaque();
        Object[] segmentsArray = this.getNonNullSegmentsArrayOrThrowIse();
        int segmentArrayLength = segmentsArray.length;
        int segmentsArrayOrder = SmoothieMap.order(segmentArrayLength);
        Object v = value;
        boolean found = false;
        int segmentIndex = 0;
        while (segmentIndex >= 0) {
            Segment<K, Object> segment = SmoothieMap.segmentCheckedByIndex(segmentsArray, segmentIndex);
            if (segment.containsValue(this, v)) {
                found = true;
                break;
            }
            segmentIndex = SmoothieMap.nextSegmentIndex(segmentArrayLength, segmentsArrayOrder, segmentIndex, segment);
        }
        this.checkModCountOrThrowCme(modCount);
        return found;
    }

    public final String toString() {
        if (this.size == 0L) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        this.forEach((k, v) -> sb.append(k).append('=').append(v).append(", "));
        sb.setCharAt(sb.length() - 2, '}');
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public final void clear() {
        int modCount = this.getModCountOpaque();
        Object[] segmentsArray = this.getNonNullSegmentsArrayOrThrowIse();
        int segmentArrayLength = segmentsArray.length;
        int segmentsArrayOrder = SmoothieMap.order(segmentArrayLength);
        int segmentIndex = 0;
        while (segmentIndex >= 0) {
            Segment<K, V> segment = SmoothieMap.segmentCheckedByIndex(segmentsArray, segmentIndex);
            if (segment.clear(segmentIndex, this)) {
                ++modCount;
            }
            segmentIndex = SmoothieMap.nextSegmentIndex(segmentArrayLength, segmentsArrayOrder, segmentIndex, segment);
        }
        this.checkModCountOrThrowCme(modCount);
    }

    @Override
    public final boolean removeIf(BiPredicate<? super K, ? super V> filter) {
        Utils.checkNonNull(filter);
        if (this.isEmpty()) {
            return false;
        }
        boolean removedSomeEntries = false;
        int modCount = this.getModCountOpaque();
        Object[] segmentsArray = this.getNonNullSegmentsArrayOrThrowIse();
        int segmentArrayLength = segmentsArray.length;
        int segmentsArrayOrder = SmoothieMap.order(segmentArrayLength);
        int segmentIndex = 0;
        while (segmentIndex >= 0) {
            Segment<? super K, ? super V> segment = SmoothieMap.segmentCheckedByIndex(segmentsArray, segmentIndex);
            int newModCount = segment.removeIf(this, filter, modCount);
            removedSomeEntries |= modCount != newModCount;
            modCount = newModCount;
            segmentIndex = SmoothieMap.nextSegmentIndex(segmentArrayLength, segmentsArrayOrder, segmentIndex, segment);
        }
        this.checkModCountOrThrowCme(modCount);
        return removedSomeEntries;
    }

    final void aggregateStats(SmoothieMapStats stats) {
        stats.incrementAggregatedMaps();
        int modCount = this.getModCountOpaque();
        Object[] segmentsArray = this.getNonNullSegmentsArrayOrThrowIse();
        int segmentArrayLength = segmentsArray.length;
        int segmentsArrayOrder = SmoothieMap.order(segmentArrayLength);
        int segmentIndex = 0;
        while (segmentIndex >= 0) {
            Segment<K, V> segment = SmoothieMap.segmentCheckedByIndex(segmentsArray, segmentIndex);
            stats.aggregateSegment(this, segment);
            segmentIndex = SmoothieMap.nextSegmentIndex(segmentArrayLength, segmentsArrayOrder, segmentIndex, segment);
        }
        this.checkModCountOrThrowCme(modCount);
    }

    private long totalSizeOfSegmentsInBytes() {
        long totalSizeOfSegmentsInBytes = 0L;
        int modCount = this.getModCountOpaque();
        Object[] segmentsArray = this.getNonNullSegmentsArrayOrThrowIse();
        int segmentArrayLength = segmentsArray.length;
        int segmentsArrayOrder = SmoothieMap.order(segmentArrayLength);
        int segmentIndex = 0;
        while (segmentIndex >= 0) {
            Segment<K, V> segment = SmoothieMap.segmentCheckedByIndex(segmentsArray, segmentIndex);
            if (segment instanceof InflatedSegment) {
                totalSizeOfSegmentsInBytes += ((InflatedSegment)segment).sizeInBytes();
            } else {
                int segmentAllocCapacity = BitSetAndState.allocCapacity(segment.bitSetAndState);
                if (segmentAllocCapacity == 48) {
                    totalSizeOfSegmentsInBytes += FULL_CAPACITY_SEGMENT_SIZE_IN_BYTES;
                } else if (segmentAllocCapacity == 32) {
                    totalSizeOfSegmentsInBytes += INTERMEDIATE_CAPACITY_SEGMENT_SIZE_IN_BYTES;
                } else {
                    throw new AssertionError((Object)("Interleaved segments cannot have capacity " + segmentAllocCapacity));
                }
            }
            segmentIndex = SmoothieMap.nextSegmentIndex(segmentArrayLength, segmentsArrayOrder, segmentIndex, segment);
        }
        this.checkModCountOrThrowCme(modCount);
        return totalSizeOfSegmentsInBytes;
    }

    @Override
    @EnsuresNonNull(value={"keySet"})
    public final ObjSet<K> keySet() {
        @MonotonicNonNull ObjSet<K> ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet(this));
    }

    public Iterator<K> mutableKeyIterator() {
        return new MutableKeyIterator(this);
    }

    @Override
    @EnsuresNonNull(value={"values"})
    public final Collection<V> values() {
        @MonotonicNonNull Collection<V> vs = this.values;
        return vs != null ? vs : (this.values = new Values(this));
    }

    public Iterator<V> mutableValueIterator() {
        return new MutableValueIterator(this);
    }

    @Override
    @EnsuresNonNull(value={"entrySet"})
    public final ObjSet<Map.Entry<K, V>> entrySet() {
        @MonotonicNonNull ObjSet<Map.Entry<K, V>> es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet(this));
    }

    private <T> boolean equalsForSetViews(ObjSet<T> setView, Object other) {
        if (!(other instanceof Set)) {
            return false;
        }
        Set otherSet = (Set)other;
        if (this.size != (long)otherSet.size()) {
            return false;
        }
        if (otherSet instanceof ObjSet) {
            return ((ObjSet)otherSet).forEachWhile((? super E e) -> e != null && setView.contains(e));
        }
        for (Object e2 : otherSet) {
            if (e2 != null && setView.contains(e2)) continue;
            return false;
        }
        return true;
    }

    public Iterator<Map.Entry<K, V>> mutableEntryIterator() {
        return new MutableEntryIterator(this);
    }

    public Map<K, V> asMapWithMutableIterators() {
        return new MapViewWithMutableIterators(this);
    }

    static {
        Utils.verifyIsPowerOfTwo(16, "");
        Utils.verifyEqual(4, Integer.numberOfTrailingZeros(16));
        FULL_CAPACITY_SEGMENT_SIZE_IN_BYTES = ObjectSize.objectSizeInBytes(InterleavedSegments.createNewSegment(48, 0));
        INTERMEDIATE_CAPACITY_SEGMENT_SIZE_IN_BYTES = ObjectSize.objectSizeInBytes(InterleavedSegments.createNewSegment(32, 0));
        SEGMENTS_QUADRUPLING_FROM_REF_SIZE_4 = new long[]{17237966L, 20085926L, 23461869L, 27467051L, 32222765L, 101478192L, 118705641L, 139126526L, 163353618L, 192120413L, 226305341L, 266960817L, 825529841L, 971366784L, 1144556172L, 1350385115L, 1595184608L, 1886539115L, 2233536926L, 2647074163L, 1244014982L, 598555262L, 294588684L, 148182403L, 76120369L, 39902677L, 21329967L, 11619067L, 6445637L, 3639219L, 2089996L, 1220217L};
        SEGMENTS_QUADRUPLING_FROM_REF_SIZE_8 = new long[]{6333006L, 7437876L, 8753429L, 10321069L, 12190537L, 37874373L, 44596145L, 52597103L, 62128040L, 73490002L, 87044486L, 266960817L, 315348276L, 372980187L, 441670897L, 523597560L, 621373710L, 738137712L, 2233536926L, 2647074163L, 1244014982L, 598555262L, 294588684L, 148182403L, 76120369L, 39902677L, 21329967L, 11619067L, 6445637L, 3639219L, 2089996L, 1220217L};
        SEGMENTS_QUADRUPLING_FROM = Unsafe.ARRAY_OBJECT_INDEX_SCALE == 4 ? SEGMENTS_QUADRUPLING_FROM_REF_SIZE_4 : SEGMENTS_QUADRUPLING_FROM_REF_SIZE_8;
        ALLOC_CAPACITIES_REF_SIZE_4 = new byte[]{42, 43, 44, 45, 46, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 59, 60, 61, 62, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63};
        ALLOC_CAPACITIES_REF_SIZE_8 = new byte[]{41, 42, 43, 44, 45, 47, 48, 49, 50, 51, 52, 54, 55, 56, 57, 58, 59, 60, 62, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63};
        ALLOC_CAPACITIES = Unsafe.ARRAY_OBJECT_INDEX_SCALE == 4 ? ALLOC_CAPACITIES_REF_SIZE_4 : ALLOC_CAPACITIES_REF_SIZE_8;
        HASH__SEGMENT_ARRAY_OFFSET_SHIFT = 11 - UnsafeUtils.ARRAY_OBJECT_INDEX_SHIFT;
        SEGMENT_STRUCTURE_MODIFICATION_STAMP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SmoothieMap.class, "segmentStructureModStamp");
        MOD_COUNT_FIELD_OFFSET = UnsafeUtils.getFieldOffset(SmoothieMap.class, "modCount");
    }

    static class InflatedSegment<K, V>
    extends InterleavedSegments.IntermediateCapacitySegment<K, V> {
        private static final long SIZE_IN_BYTES = ObjectSize.classSizeInBytes(InflatedSegment.class);
        private static final int INFLATED_SEGMENT_DELEGATE_HASH_MAP_INITIAL_CAPACITY = 64;
        private static final float INFLATED_SEGMENT_DELEGATE_HASH_MAP_LOAD_FACTOR = 0.8f;
        private final HashMap<InflatedSegmentQueryContext.Node<K, V>, InflatedSegmentQueryContext.Node<K, V>> delegate;

        InflatedSegment(int segmentOrder, long smoothieMapSize) {
            this.bitSetAndState = BitSetAndState.makeInflatedBitSetAndState(segmentOrder);
            this.setAllDataGroups(0x7F7F7F7F7F7F7F7FL);
            this.delegate = new HashMap(64, 0.8f);
            UnsafeUtils.U.storeFence();
        }

        private InflatedSegment(long bitSetAndState, HashMap<InflatedSegmentQueryContext.Node<K, V>, InflatedSegmentQueryContext.Node<K, V>> delegate) {
            this.bitSetAndState = bitSetAndState;
            this.setAllDataGroups(0x7F7F7F7F7F7F7F7FL);
            this.delegate = delegate;
        }

        long sizeInBytes() {
            long nodeSizeInBytes = 0L;
            if (this.delegate.size() > 0) {
                nodeSizeInBytes = ObjectSize.objectSizeInBytes(this.getEntries().iterator().next());
            }
            return SIZE_IN_BYTES + ObjectSize.hashMapSizeInBytes(this.delegate) + nodeSizeInBytes * (long)this.delegate.size();
        }

        Iterable<? extends KeyValue<K, V>> getEntries() {
            return this.delegate.keySet();
        }

        @Nullable V get(SmoothieMap<K, V> smoothie, Object key, long hash) {
            return ((SmoothieMap)smoothie).getInflatedSegmentQueryContext().get(this.delegate, key, hash);
        }

        @Nullable K getInternalKey(SmoothieMap<K, V> smoothie, Object key, long hash) {
            return ((SmoothieMap)smoothie).getInflatedSegmentQueryContext().getInternalKey(this.delegate, key, hash);
        }

        @Nullable V computeIfPresent(SmoothieMap<K, V> smoothie, K key, long hash, BiFunction<? super K, ? super V, ? extends @Nullable V> remappingFunction) {
            boolean entryRemoved;
            HashMap<InflatedSegmentQueryContext.Node<K, V>, InflatedSegmentQueryContext.Node<K, V>> delegate;
            InflatedSegmentQueryContext context = ((SmoothieMap)smoothie).getInflatedSegmentQueryContext();
            @Nullable Object computeIfPresentResult = context.computeIfPresent(delegate = this.delegate, key, hash, remappingFunction);
            boolean bl = entryRemoved = computeIfPresentResult == InflatedSegmentQueryContext.COMPUTE_IF_PRESENT_ENTRY_REMOVED;
            if (!entryRemoved) {
                return (V)computeIfPresentResult;
            }
            this.onEntryRemoval(smoothie, hash, delegate);
            return null;
        }

        private void onEntryRemoval(SmoothieMap<K, V> smoothie, long hash, HashMap<InflatedSegmentQueryContext.Node<K, V>, InflatedSegmentQueryContext.Node<K, V>> delegate) {
            if (InflatedSegment.shouldDeflateSmall(delegate.size())) {
                ((SmoothieMap)smoothie).deflateSmall(hash, this);
            } else if (this.shouldBeSplit(smoothie, BitSetAndState.segmentOrder(this.bitSetAndState))) {
                ((SmoothieMap)smoothie).splitInflated(hash, this);
            }
        }

        private static boolean shouldDeflateSmall(int delegateSize) {
            return delegateSize <= 47;
        }

        private boolean shouldBeSplit(SmoothieMap<K, V> smoothie, int segmentOrder) {
            int averageSegmentOrder_lastComputed = smoothie.averageSegmentOrder_lastComputed;
            if (segmentOrder != 30) {
                if (segmentOrder > SmoothieMap.maxSplittableSegmentOrder(averageSegmentOrder_lastComputed)) {
                    return false;
                }
                averageSegmentOrder_lastComputed = smoothie.computeAverageSegmentOrder(((SmoothieMap)smoothie).size);
                int maxSplittableSegmentOrder = SmoothieMap.maxSplittableSegmentOrder(averageSegmentOrder_lastComputed);
                return segmentOrder <= maxSplittableSegmentOrder;
            }
            return false;
        }

        @Nullable V removeOrReplace(SmoothieMap<K, V> smoothie, K key, long hash, @Nullable V matchValue, @Nullable V replacementValue) {
            boolean entryRemoved;
            boolean removedOrReplaced;
            InflatedSegmentQueryContext context = ((SmoothieMap)smoothie).getInflatedSegmentQueryContext();
            HashMap<InflatedSegmentQueryContext.Node<K, V>, InflatedSegmentQueryContext.Node<K, V>> delegate = this.delegate;
            Object removedOrReplacedVal = matchValue == null ? (replacementValue == null ? context.remove(delegate, key, hash) : context.replace(delegate, key, hash, replacementValue)) : ((removedOrReplaced = context.removeOrReplaceEntry(delegate, key, hash, matchValue, replacementValue)) ? matchValue : null);
            boolean bl = entryRemoved = replacementValue == null && removedOrReplacedVal != null;
            if (entryRemoved) {
                this.onEntryRemoval(smoothie, hash, delegate);
            }
            return removedOrReplacedVal;
        }

        @Nullable V put(SmoothieMap<K, V> smoothie, K key, long hash, V value, boolean onlyIfAbsent) {
            boolean entryInserted;
            HashMap<InflatedSegmentQueryContext.Node<K, V>, InflatedSegmentQueryContext.Node<K, V>> delegate;
            InflatedSegmentQueryContext context = ((SmoothieMap)smoothie).getInflatedSegmentQueryContext();
            @Nullable V replacedOrInternalVal = context.put(delegate = this.delegate, key, hash, value, onlyIfAbsent);
            boolean bl = entryInserted = replacedOrInternalVal == null;
            if (entryInserted) {
                this.onEntryInsertion(smoothie, hash);
            }
            return replacedOrInternalVal;
        }

        private void onEntryInsertion(SmoothieMap<K, V> smoothie, long hash) {
            int segmentOrder = BitSetAndState.segmentOrder(this.bitSetAndState);
            if (this.shouldBeSplit(smoothie, segmentOrder)) {
                ((SmoothieMap)smoothie).splitInflated(hash, this);
            }
        }

        boolean trySplit(int segmentOrder, SmoothieMap<K, V> smoothie, long hash) {
            if (this.shouldBeSplit(smoothie, segmentOrder)) {
                ((SmoothieMap)smoothie).splitInflated(hash, this);
                return true;
            }
            return false;
        }

        void putDuringInflation(SmoothieMap<K, V> smoothie, K key, long hash, V value) {
            InflatedSegmentQueryContext context = ((SmoothieMap)smoothie).getInflatedSegmentQueryContext();
            context.putDuringInflation(this.delegate, key, hash, value);
        }

        @Nullable V computeIfAbsent(SmoothieMap<K, V> smoothie, K key, long hash, Function<? super K, ? extends @Nullable V> mappingFunction) {
            InflatedSegmentQueryContext.Node nodeWithKeyAndHash;
            HashMap<InflatedSegmentQueryContext.Node<K, V>, InflatedSegmentQueryContext.Node<K, V>> delegate;
            InflatedSegmentQueryContext context = ((SmoothieMap)smoothie).getInflatedSegmentQueryContext();
            @Nullable InflatedSegmentQueryContext.Node<K, V> internalNode = context.computeIfAbsent(delegate = this.delegate, nodeWithKeyAndHash = context.getNodeForKey(key, hash), mappingFunction);
            if (internalNode != null) {
                boolean entryInserted;
                boolean bl = entryInserted = internalNode == nodeWithKeyAndHash;
                if (entryInserted) {
                    this.onEntryInsertion(smoothie, hash);
                }
                return internalNode.getValue();
            }
            return null;
        }

        @Nullable V compute(SmoothieMap<K, V> smoothie, K key, long hash, BiFunction<? super K, ? super @Nullable V, ? extends @Nullable V> remappingFunction) {
            InflatedSegmentQueryContext.Node nodeWithKeyAndHash;
            HashMap<InflatedSegmentQueryContext.Node<K, V>, InflatedSegmentQueryContext.Node<K, V>> delegate;
            InflatedSegmentQueryContext context = ((SmoothieMap)smoothie).getInflatedSegmentQueryContext();
            @Nullable InflatedSegmentQueryContext.Node<K, V> internalNode = context.compute(delegate = this.delegate, nodeWithKeyAndHash = context.getNodeForKey(key, hash), remappingFunction);
            if (internalNode != null) {
                boolean entryInserted;
                boolean bl = entryInserted = internalNode == nodeWithKeyAndHash;
                if (entryInserted) {
                    this.onEntryInsertion(smoothie, hash);
                }
                return internalNode.getValue();
            }
            boolean entryRemoved = nodeWithKeyAndHash.clearKeyIfNonNull();
            if (entryRemoved) {
                this.onEntryRemoval(smoothie, hash, delegate);
            }
            return null;
        }

        @Nullable V merge(SmoothieMap<K, V> smoothie, K key, long hash, V value, BiFunction<? super V, ? super V, ? extends @Nullable V> remappingFunction) {
            InflatedSegmentQueryContext.Node nodeWithKeyAndHash;
            HashMap<InflatedSegmentQueryContext.Node<K, V>, InflatedSegmentQueryContext.Node<K, V>> delegate;
            InflatedSegmentQueryContext context = ((SmoothieMap)smoothie).getInflatedSegmentQueryContext();
            @Nullable InflatedSegmentQueryContext.Node<K, V> internalNode = context.merge(delegate = this.delegate, nodeWithKeyAndHash = context.getNodeForKey(key, hash), value, remappingFunction);
            if (internalNode != null) {
                boolean entryInserted;
                boolean bl = entryInserted = internalNode == nodeWithKeyAndHash;
                if (entryInserted) {
                    this.onEntryInsertion(smoothie, hash);
                }
                return internalNode.getValue();
            }
            this.onEntryRemoval(smoothie, hash, delegate);
            return null;
        }

        @Override
        @Deprecated
        @DoNotCall
        final void clearHashTableAndAllocArea() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        @DoNotCall
        final void copyEntriesDuringInflate(SmoothieMap<K, V> map, InflatedSegment<K, V> intoSegment) {
            throw new UnsupportedOperationException();
        }

        @Override
        public InflatedSegment<K, V> clone() {
            HashMap delegateClone = (HashMap)this.delegate.clone();
            return new InflatedSegment<K, V>(this.bitSetAndState, delegateClone);
        }

        @Override
        boolean clear(int segmentIndex, SmoothieMap<K, V> map) {
            int delegateSize = this.delegate.size();
            if (delegateSize > 0) {
                ((SmoothieMap)map).replaceInflatedWithEmptyOrdinary(segmentIndex, this);
                ((SmoothieMap)map).size -= delegateSize;
                return true;
            }
            return false;
        }

        @Override
        int hashCode(SmoothieMap<K, V> map) {
            int h = 0;
            for (InflatedSegmentQueryContext.Node<K, V> node : this.delegate.keySet()) {
                h += map.keyHashCodeForAggregateHashCodes(node.getKey()) ^ map.valueHashCodeForAggregateHashCodes(node.getValue());
            }
            return h;
        }

        @Override
        void forEach(BiConsumer<? super K, ? super V> action) {
            this.delegate.keySet().forEach((? super T node) -> action.accept((Object)node.getKey(), (Object)node.getValue()));
        }

        @Override
        void forEachKey(Consumer<? super K> action) {
            this.delegate.keySet().forEach((? super T node) -> action.accept((Object)node.getKey()));
        }

        @Override
        void forEachValue(Consumer<? super V> action) {
            this.delegate.keySet().forEach((? super T node) -> action.accept((Object)node.getValue()));
        }

        @Override
        boolean forEachWhile(BiPredicate<? super K, ? super V> predicate) {
            for (InflatedSegmentQueryContext.Node<K, V> node : this.delegate.keySet()) {
                if (predicate.test(node.getKey(), node.getValue())) continue;
                return false;
            }
            return true;
        }

        @Override
        void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            this.delegate.keySet().forEach((? super T node) -> node.setValue(function.apply((Object)node.getKey(), (Object)node.getValue())));
        }

        @Override
        boolean containsValue(SmoothieMap<K, V> map, V queriedValue) {
            return this.delegate.keySet().stream().allMatch(node -> {
                Object internalVal = node.getValue();
                boolean valuesIdentical = queriedValue == internalVal;
                return valuesIdentical || map.valuesEqual(queriedValue, internalVal);
            });
        }

        @Override
        int removeIf(SmoothieMap<K, V> map, BiPredicate<? super K, ? super V> filter, int modCount) {
            throw new UnsupportedOperationException("TODO");
        }

        @Override
        void aggregateStats(SmoothieMap<K, V> map, OrdinarySegmentStats ordinarySegmentStats) {
            throw new IllegalStateException("must not be called on an inflated segment");
        }

        @Override
        String debugToString() {
            return "InflatedSegment: " + this.delegate.toString();
        }

        @Override
        @Nullable Segment.DebugHashTableSlot<K, V>[] debugHashTable(SmoothieMap<K, V> map) {
            throw new IllegalStateException("must not be called on an inflated segment");
        }
    }

    static abstract class Segment<K, V>
    extends InterleavedSegment_BitSetAndStateArea<K, V>
    implements Cloneable {
        static final int MIN_LEFTOVER_ALLOC_CAPACITY_AFTER_SHRINKING = 4;
        static final int MIN_LEFTOVER_ALLOC_CAPACITY_AFTER_DEFLATION = 1;
        static final int LOG_HASH_TABLE_SIZE = 6;
        static final int HASH__BASE_GROUP_INDEX_BITS = 3;
        static final int TAG_HASH_BITS = 8;
        private static final long TAG_HASH_BIT_MASK = 255L;

        Segment() {
        }

        static long tagBits(long hash) {
            return hash >> 3 & 0xFFL;
        }

        static <K> K readKeyAtOffset(Object segment, long allocOffset) {
            Object key = UnsafeUtils.U.getObject(segment, allocOffset);
            return (K)key;
        }

        static void checkAllocIndex(Object segment, @NonNegative long allocIndex) {
            if (segment == null) {
                throw new ConcurrentModificationException();
            }
            long bitSetAndState = Segment.getBitSetAndState(segment);
            int allocCapacity = BitSetAndState.allocCapacity(bitSetAndState);
            if (allocIndex >= (long)allocCapacity) {
                throw new ConcurrentModificationException("allocIndex: " + allocIndex + ", allocCapacity: " + allocCapacity);
            }
        }

        static <K> K readKeyCheckedAtIndex(Object segment, @NonNegative long allocIndex, long isFullCapacitySegment) {
            Segment.checkAllocIndex(segment, allocIndex);
            long allocOffset = InterleavedSegments.allocOffset(allocIndex, isFullCapacitySegment);
            Object key = UnsafeUtils.U.getObject(segment, allocOffset);
            return (K)key;
        }

        static <V> V readValueAtOffset(Object segment, long allocOffset) {
            Object value = UnsafeUtils.U.getObject(segment, Segments.valueOffsetFromAllocOffset(allocOffset));
            return (V)value;
        }

        static <V> V readValueCheckedAtIndex(Object segment, @NonNegative long allocIndex, long isFullCapacitySegment) {
            Segment.checkAllocIndex(segment, allocIndex);
            long allocOffset = InterleavedSegments.allocOffset(allocIndex, isFullCapacitySegment);
            Object value = UnsafeUtils.U.getObject(segment, Segments.valueOffsetFromAllocOffset(allocOffset));
            return (V)value;
        }

        static void writeValueAtOffset(Object segment, long allocOffset, Object value) {
            UnsafeUtils.U.putObject(segment, Segments.valueOffsetFromAllocOffset(allocOffset), value);
        }

        static void writeKeyAndValueAtIndex(Object segment, long isFullCapacitySegment, int allocIndex, Object key, Object value) {
            long allocOffset = InterleavedSegments.allocOffset(allocIndex, isFullCapacitySegment);
            UnsafeUtils.U.putObject(segment, allocOffset, key);
            UnsafeUtils.U.putObject(segment, Segments.valueOffsetFromAllocOffset(allocOffset), value);
        }

        static void eraseKeyAndValueAtIndex(Object segment, long isFullCapacitySegment, int allocIndex) {
            long allocOffset = InterleavedSegments.allocOffset(allocIndex, isFullCapacitySegment);
            Segment.eraseKeyAndValueAtOffset(segment, allocOffset);
        }

        static void eraseKeyAndValueAtOffset(Object segment, long allocOffset) {
            UnsafeUtils.U.putObject(segment, allocOffset, null);
            UnsafeUtils.U.putObject(segment, Segments.valueOffsetFromAllocOffset(allocOffset), null);
        }

        static <K, V> void writeEntry(Object segment, long isFullCapacitySegment, K key, byte tag, V value, long groupIndex, long dataGroup, int slotIndexWithinGroup, int allocIndex) {
            InterleavedSegments.writeTagAndData(segment, isFullCapacitySegment, groupIndex, slotIndexWithinGroup, tag, HashTable.makeData(dataGroup, allocIndex));
            Segment.writeKeyAndValueAtIndex(segment, isFullCapacitySegment, allocIndex, key, value);
        }

        @RarelyCalledAmortizedPerSegment
        abstract void copyEntriesDuringInflate(SmoothieMap<K, V> var1, InflatedSegment<K, V> var2);

        abstract void setAllDataGroups(long var1);

        abstract void clearHashTableAndAllocArea();

        public Segment<K, V> clone() {
            try {
                return (Segment)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        boolean clear(int segmentIndex, SmoothieMap<K, V> map) {
            long bitSetAndState = this.bitSetAndState;
            int segmentSize = BitSetAndState.segmentSize(bitSetAndState);
            if (segmentSize > 0) {
                ((SmoothieMap)map).size -= segmentSize;
                ((SmoothieMap)map).modCount++;
                this.clearHashTableAndAllocArea();
                this.bitSetAndState = BitSetAndState.clearBitSet(bitSetAndState);
                this.clearOutboundOverflowCountsPerGroup();
                return true;
            }
            return false;
        }

        @Deprecated
        @DoNotCall
        public final int hashCode() {
            throw new UnsupportedOperationException();
        }

        abstract void aggregateStats(SmoothieMap<K, V> var1, OrdinarySegmentStats var2);

        @Deprecated
        abstract String debugToString();

        @Deprecated
        abstract @Nullable DebugHashTableSlot<K, V>[] debugHashTable(SmoothieMap<K, V> var1);

        static {
            Utils.verifyEqual(6, Integer.numberOfTrailingZeros(64));
            Utils.verifyEqual(3, Integer.numberOfTrailingZeros(8));
        }

        static class DebugHashTableSlot<K, V> {
            final byte tagByte;
            final byte dataByte;
            final int allocIndex;
            final @Nullable K key;
            final long hash;
            final byte tagByteFromKey;
            final @Nullable V value;

            DebugHashTableSlot(SmoothieMap<K, V> map, Segment<K, V> segment, int allocIndex, long valueOffset, byte tagByte, int dataByte) {
                this.tagByte = tagByte;
                this.dataByte = (byte)dataByte;
                this.allocIndex = allocIndex;
                long isFullCapacitySegment = segment instanceof InterleavedSegments.FullCapacitySegment ? 1L : 0L;
                long allocOffset = InterleavedSegments.allocOffset(allocIndex, isFullCapacitySegment);
                this.key = UnsafeUtils.U.getObject(segment, allocOffset);
                if (this.key != null) {
                    this.hash = map.keyHashCode(this.key);
                    this.tagByteFromKey = (byte)Segment.tagBits(this.hash);
                } else {
                    this.hash = 0L;
                    this.tagByteFromKey = 0;
                }
                this.value = UnsafeUtils.U.getObject(segment, valueOffset);
            }

            public String toString() {
                return String.format("%8s,%2d,%8s,%s", Integer.toBinaryString(Byte.toUnsignedInt(this.tagByte)), this.allocIndex, Integer.toBinaryString(Byte.toUnsignedInt(this.tagByteFromKey)), this.key);
            }
        }
    }

    static final class MutableEntryInInflatedSegment<K, V>
    extends AbstractEntry<K, V> {
        private final SmoothieMap<K, V> smoothie;
        private final InflatedSegmentQueryContext.Node<K, V> node;
        private final int modCountCopy;

        MutableEntryInInflatedSegment(SmoothieMap<K, V> smoothie, InflatedSegmentQueryContext.Node<K, V> node) {
            this.smoothie = smoothie;
            this.node = node;
            this.modCountCopy = ((SmoothieMap)smoothie).modCount;
        }

        @Override
        public K getKey() {
            return this.node.getKey();
        }

        @Override
        public V getValue() {
            return this.node.getValue();
        }

        @Override
        public V setValue(V value) {
            if (this.modCountCopy != ((SmoothieMap)this.smoothie).modCount) {
                throw new ConcurrentModificationException();
            }
            InflatedSegmentQueryContext.Node<K, V> node = this.node;
            V oldValue = node.getValue();
            node.setValue(value);
            return oldValue;
        }
    }

    static final class MutableEntryInOrdinarySegment<K, V>
    extends AbstractEntry<K, V> {
        private final SmoothieMap<K, V> smoothie;
        private final K key;
        private V value;
        private final Segment<K, V> segment;
        private final int allocIndex;
        private final int modCountCopy;

        MutableEntryInOrdinarySegment(MutableEntryIterator<K, V> iterator, K key, V value) {
            this.smoothie = iterator.smoothie;
            this.key = key;
            this.value = value;
            this.segment = Utils.nonNullOrThrowCme(iterator.prevSegment);
            this.allocIndex = iterator.prevIterAllocIndex;
            this.modCountCopy = ((SmoothieMap)this.smoothie).modCount;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            Utils.checkNonNull(value);
            Utils.checkModCount(this.modCountCopy, ((SmoothieMap)this.smoothie).modCount);
            Segment<K, V> segment = this.segment;
            int allocIndex = this.allocIndex;
            Segment.checkAllocIndex(segment, allocIndex);
            long isFullCapacitySegment = segment instanceof InterleavedSegments.FullCapacitySegment ? 1L : 0L;
            long allocOffset = InterleavedSegments.allocOffset(allocIndex, isFullCapacitySegment);
            Segment.writeValueAtOffset(segment, allocOffset, value);
            V oldValue = this.getValue();
            this.value = value;
            return oldValue;
        }
    }

    static final class MutableEntryIterator<K, V>
    extends MutableSmoothieIterator<K, V, Map.Entry<K, V>> {
        MutableEntryIterator(SmoothieMap<K, V> smoothie) {
            super(smoothie);
        }

        @Override
        Map.Entry<K, V> nextElementInOrdinarySegment(int allocIndex) {
            Segment segment = this.getCurrentSegmentAndUpdatePrevState(allocIndex);
            Segment.checkAllocIndex(segment, allocIndex);
            long isFullCapacitySegment = segment instanceof InterleavedSegments.FullCapacitySegment ? 1L : 0L;
            long allocOffset = InterleavedSegments.allocOffset(allocIndex, isFullCapacitySegment);
            Object key = Segment.readKeyAtOffset(segment, allocOffset);
            Object value = Segment.readValueAtOffset(segment, allocOffset);
            this.advanceOrdinarySegmentIteration(this.bitSet, allocIndex);
            return new MutableEntryInOrdinarySegment(this, key, value);
        }

        @Override
        Map.Entry<K, V> nextElementInInflatedSegment() {
            Iterator inflatedSegmentIterator = this.getInflatedSegmentIteratorAndUpdatePrevState();
            InflatedSegmentQueryContext.Node inflatedSegmentNode = this.nextInflatedSegmentEntry(inflatedSegmentIterator);
            this.advanceInflatedSegmentIteration(inflatedSegmentIterator);
            return new MutableEntryInInflatedSegment(this.smoothie, inflatedSegmentNode);
        }
    }

    static final class MutableValueIterator<K, V>
    extends MutableSmoothieIterator<K, V, V> {
        MutableValueIterator(SmoothieMap<K, V> smoothie) {
            super(smoothie);
        }

        @Override
        V nextElementInOrdinarySegment(int allocIndex) {
            return this.nextValueInOrdinarySegment(allocIndex);
        }

        @Override
        V nextElementInInflatedSegment() {
            return this.nextValueInInflatedSegment();
        }
    }

    static final class ImmutableValueIterator<K, V>
    extends SmoothieIterator<K, V, V> {
        ImmutableValueIterator(SmoothieMap<K, V> smoothie) {
            super(smoothie);
        }

        @Override
        V nextElementInOrdinarySegment(int allocIndex) {
            return this.nextValueInOrdinarySegment(allocIndex);
        }

        @Override
        V nextElementInInflatedSegment() {
            return this.nextValueInInflatedSegment();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() operation is not supported by this Iterator. Use SmoothieMap.removeIf(), or SmoothieMap.mutableValueIterator(), or SmoothieMap.valuesWithMutableIterator() view.");
        }
    }

    static final class MutableKeyIterator<K, V>
    extends MutableSmoothieIterator<K, V, K> {
        MutableKeyIterator(SmoothieMap<K, V> smoothie) {
            super(smoothie);
        }

        @Override
        K nextElementInOrdinarySegment(int allocIndex) {
            return this.nextKeyInOrdinarySegment(allocIndex);
        }

        @Override
        K nextElementInInflatedSegment() {
            return this.nextKeyInInflatedSegment();
        }
    }

    static final class ImmutableKeyIterator<K, V>
    extends SmoothieIterator<K, V, K> {
        ImmutableKeyIterator(SmoothieMap<K, V> smoothie) {
            super(smoothie);
        }

        @Override
        K nextElementInOrdinarySegment(int allocIndex) {
            return this.nextKeyInOrdinarySegment(allocIndex);
        }

        @Override
        K nextElementInInflatedSegment() {
            return this.nextKeyInInflatedSegment();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() operation is not supported by this Iterator. Use SmoothieMap.removeIf(), or SmoothieMap.mutableKeyIterator(), or SmoothieMap.keySetWithMutableIterator() view.");
        }
    }

    static abstract class MutableSmoothieIterator<K, V, E>
    extends SmoothieIterator<K, V, E> {
        private static final int PREV_ITER_ALLOC_INDEX__NO_ELEMENT = -2;
        private int currentSegmentIndex;
        private int prevSegmentIndex;
        @Nullable Segment<K, V> prevSegment;
        int prevIterAllocIndex = -2;
        @Nullable Iterator<InflatedSegmentQueryContext.Node<K, V>> prevInflatedSegmentIterator;

        MutableSmoothieIterator(SmoothieMap<K, V> smoothie) {
            super(smoothie);
        }

        @Override
        void currentSegmentIndexHook(int currentSegmentIndex) {
            this.currentSegmentIndex = currentSegmentIndex;
        }

        @Override
        final Segment<K, V> getCurrentSegmentAndUpdatePrevState(int allocIndex) {
            boolean changingPrevSegment;
            this.prevIterAllocIndex = allocIndex;
            Segment segment = this.currentSegment;
            boolean bl = changingPrevSegment = segment != this.prevSegment;
            if (changingPrevSegment) {
                if (this.smoothie.doShrink) {
                    this.shrinkPrevSegmentIfNeeded();
                    this.prevSegmentIndex = this.currentSegmentIndex;
                }
                this.prevSegment = segment;
                this.prevInflatedSegmentIterator = null;
            }
            return segment;
        }

        @Override
        @RarelyCalledAmortizedPerSegment
        final Iterator<InflatedSegmentQueryContext.Node<K, V>> getInflatedSegmentIteratorAndUpdatePrevState() {
            boolean changingPrevSegment;
            @Nullable Iterator inflatedSegmentIterator = this.inflatedSegmentIterator;
            if (inflatedSegmentIterator == null) {
                throw new NoSuchElementException();
            }
            this.prevIterAllocIndex = -1;
            Segment segment = this.currentSegment;
            boolean bl = changingPrevSegment = segment != this.prevSegment;
            if (changingPrevSegment) {
                if (this.smoothie.doShrink) {
                    this.shrinkPrevSegmentIfNeeded();
                    this.prevSegmentIndex = this.currentSegmentIndex;
                }
                this.prevSegment = segment;
                this.prevInflatedSegmentIterator = inflatedSegmentIterator;
            }
            return inflatedSegmentIterator;
        }

        private void shrinkPrevSegmentIfNeeded() {
            @Nullable Segment prevSegment = this.prevSegment;
            if (prevSegment == null) {
                return;
            }
            if (prevSegment instanceof InflatedSegment) {
                int prevSegmentSize = ((InflatedSegment)prevSegment).delegate.size();
                if (!InflatedSegment.shouldDeflateSmall(prevSegmentSize)) {
                    return;
                }
                int prevSegmentOrder = BitSetAndState.segmentOrder(prevSegment.bitSetAndState);
                int prevSegment_firstIndex = SmoothieMap.firstSegmentIndexByIndexAndOrder(this.prevSegmentIndex, prevSegmentOrder);
                this.smoothie.deflateSmallWithSegmentIndex((InflatedSegment)prevSegment, prevSegment_firstIndex);
                ++this.expectedModCount;
                prevSegment = SmoothieMap.segmentCheckedByIndex(this.segmentsArray, prevSegment_firstIndex);
            }
            this.shrinkIteratedSegmentsRecursively(prevSegment, this.prevSegmentIndex);
        }

        private void shrinkIteratedSegmentsRecursively(Segment<K, V> segment, int segmentIndex) {
            int siblingSegmentIndex;
            long bitSetAndState;
            int segmentOrder;
            while ((segmentIndex = SmoothieMap.firstSegmentIndexByIndexAndOrder(segmentIndex, segmentOrder = BitSetAndState.segmentOrder(bitSetAndState = segment.bitSetAndState))) >= (siblingSegmentIndex = SmoothieMap.siblingSegmentIndex(segmentIndex, segmentOrder))) {
                int modCountChange = this.smoothie.tryShrink3(segment, bitSetAndState, segmentOrder, segmentIndex);
                if (modCountChange == 0) {
                    return;
                }
                this.expectedModCount += modCountChange;
                segmentIndex = siblingSegmentIndex;
                segment = SmoothieMap.segmentCheckedByIndex(this.segmentsArray, segmentIndex);
            }
            return;
        }

        @Override
        public final void remove() {
            int prevIterAllocIndex = this.prevIterAllocIndex;
            if (prevIterAllocIndex == -2) {
                throw new IllegalStateException("next() hasn't been called yet on this Iterator, or remove() has already been called on this Iterator since the last call to next()");
            }
            this.prevIterAllocIndex = -2;
            if (prevIterAllocIndex >= 0) {
                Segment<K, V> prevSegment = Utils.verifyNonNull(this.prevSegment);
                this.smoothie.removeDuringIterationFromOrdinarySegment(prevSegment, prevIterAllocIndex);
            } else {
                Iterator<InflatedSegmentQueryContext.Node<K, V>> inflatedSegmentIterator = Utils.verifyNonNull(this.prevInflatedSegmentIterator);
                this.smoothie.decrementSize();
                inflatedSegmentIterator.remove();
            }
            ++this.expectedModCount;
        }
    }

    static abstract class SmoothieIterator<K, V, E>
    implements Iterator<E> {
        static final int ITER_ALLOC_INDEX__NO_ORDINARY_SEGMENT = -1;
        final SmoothieMap<K, V> smoothie;
        int expectedModCount;
        final Object[] segmentsArray;
        private final int segmentsArrayOrder;
        Segment<K, V> currentSegment;
        @Nullable Iterator<InflatedSegmentQueryContext.Node<K, V>> inflatedSegmentIterator;
        private int nextSegmentIndex;
        private @Nullable Segment<K, V> nextSegment;
        long bitSet;
        int iterAllocIndex;

        SmoothieIterator(SmoothieMap<K, V> smoothie) {
            this.smoothie = smoothie;
            this.expectedModCount = ((SmoothieMap)smoothie).modCount;
            Object[] segmentsArray = ((SmoothieMap)smoothie).getNonNullSegmentsArrayOrThrowIse();
            this.segmentsArray = segmentsArray;
            this.segmentsArrayOrder = SmoothieMap.order(segmentsArray.length);
            Segment firstSegment = SmoothieMap.segmentCheckedByIndex(segmentsArray, 0);
            this.initCurrentSegment(0, firstSegment);
        }

        @EnsuresNonNull(value={"currentSegment"})
        private void initCurrentSegment(int currentSegmentIndex, Segment<K, V> currentSegment) {
            boolean currentSegmentIsOrdinary;
            this.currentSegmentIndexHook(currentSegmentIndex);
            this.currentSegment = currentSegment;
            long currentSegment_bitSetAndState = currentSegment.bitSetAndState;
            this.findNextSegment(currentSegmentIndex, currentSegment);
            boolean bl = currentSegmentIsOrdinary = !BitSetAndState.isInflatedBitSetAndState(currentSegment_bitSetAndState);
            if (currentSegmentIsOrdinary) {
                long bitSet = BitSetAndState.extractBitSetForIteration(currentSegment_bitSetAndState);
                this.advanceOrdinarySegmentIteration(bitSet, 64);
            } else {
                this.iterAllocIndex = -1;
                Iterator<InflatedSegmentQueryContext.Node<K, V>> inflatedSegmentIterator = ((InflatedSegment)currentSegment).delegate.keySet().iterator();
                this.inflatedSegmentIterator = inflatedSegmentIterator;
                this.advanceInflatedSegmentIteration(inflatedSegmentIterator);
            }
        }

        void currentSegmentIndexHook(int currentSegmentIndex) {
        }

        private void findNextSegment(int currentSegmentIndex, Segment<K, V> currentSegment) {
            int nextSegmentIndex;
            this.nextSegmentIndex = nextSegmentIndex = SmoothieMap.nextSegmentIndex(this.segmentsArray.length, this.segmentsArrayOrder, currentSegmentIndex, currentSegment);
            this.nextSegment = nextSegmentIndex >= 0 ? SmoothieMap.segmentCheckedByIndex(this.segmentsArray, nextSegmentIndex) : null;
        }

        final void advanceOrdinarySegmentIteration(long bitSet, int prevAllocIndex) {
            if (bitSet != 0L) {
                int iterAllocIndexStep = Long.numberOfLeadingZeros(bitSet) + 1;
                this.iterAllocIndex = prevAllocIndex - iterAllocIndexStep;
                this.bitSet = bitSet << iterAllocIndexStep;
            } else {
                this.advanceSegment();
            }
        }

        @RarelyCalledAmortizedPerSegment
        final void advanceInflatedSegmentIteration(Iterator<InflatedSegmentQueryContext.Node<K, V>> inflatedSegmentIterator) {
            if (inflatedSegmentIterator.hasNext()) {
                return;
            }
            this.inflatedSegmentIterator = null;
            this.advanceSegment();
        }

        private void advanceSegment() {
            int nextSegmentIndex = this.nextSegmentIndex;
            if (nextSegmentIndex < 0) {
                this.iterAllocIndex = -1;
                return;
            }
            @Nullable Segment<K, V> nextSegment = this.nextSegment;
            this.initCurrentSegment(nextSegmentIndex, nextSegment);
        }

        final void checkModCount() {
            Utils.checkModCount(this.expectedModCount, ((SmoothieMap)this.smoothie).modCount);
        }

        @RarelyCalledAmortizedPerSegment
        final InflatedSegmentQueryContext.Node<K, V> nextInflatedSegmentEntry(Iterator<InflatedSegmentQueryContext.Node<K, V>> inflatedSegmentIterator) {
            try {
                return inflatedSegmentIterator.next();
            }
            catch (NoSuchElementException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        public final E next() {
            this.checkModCount();
            int allocIndex = this.iterAllocIndex;
            if (allocIndex >= 0) {
                return this.nextElementInOrdinarySegment(allocIndex);
            }
            return this.nextElementInInflatedSegment();
        }

        abstract E nextElementInOrdinarySegment(int var1);

        @RarelyCalledAmortizedPerSegment
        abstract E nextElementInInflatedSegment();

        @Override
        public final boolean hasNext() {
            if (this.iterAllocIndex >= 0) {
                return true;
            }
            return this.inflatedSegmentIterator != null;
        }

        Segment<K, V> getCurrentSegmentAndUpdatePrevState(int allocIndex) {
            return this.currentSegment;
        }

        @RarelyCalledAmortizedPerSegment
        Iterator<InflatedSegmentQueryContext.Node<K, V>> getInflatedSegmentIteratorAndUpdatePrevState() {
            @Nullable Iterator<InflatedSegmentQueryContext.Node<K, V>> inflatedSegmentIterator = this.inflatedSegmentIterator;
            if (inflatedSegmentIterator == null) {
                throw new NoSuchElementException();
            }
            return inflatedSegmentIterator;
        }

        final K nextKeyInOrdinarySegment(int allocIndex) {
            Segment<K, V> segment = this.getCurrentSegmentAndUpdatePrevState(allocIndex);
            long isFullCapacitySegment = segment instanceof InterleavedSegments.FullCapacitySegment ? 1L : 0L;
            Object key = Segment.readKeyCheckedAtIndex(segment, allocIndex, isFullCapacitySegment);
            this.advanceOrdinarySegmentIteration(this.bitSet, allocIndex);
            return key;
        }

        @RarelyCalledAmortizedPerSegment
        final K nextKeyInInflatedSegment() {
            Iterator<InflatedSegmentQueryContext.Node<K, V>> inflatedSegmentIterator = this.getInflatedSegmentIteratorAndUpdatePrevState();
            InflatedSegmentQueryContext.Node<K, V> inflatedSegmentNode = this.nextInflatedSegmentEntry(inflatedSegmentIterator);
            K key = inflatedSegmentNode.getKey();
            this.advanceInflatedSegmentIteration(inflatedSegmentIterator);
            return key;
        }

        final V nextValueInOrdinarySegment(int allocIndex) {
            Segment<K, V> segment = this.getCurrentSegmentAndUpdatePrevState(allocIndex);
            long isFullCapacitySegment = segment instanceof InterleavedSegments.FullCapacitySegment ? 1L : 0L;
            Object value = Segment.readValueCheckedAtIndex(segment, allocIndex, isFullCapacitySegment);
            this.advanceOrdinarySegmentIteration(this.bitSet, allocIndex);
            return value;
        }

        @RarelyCalledAmortizedPerSegment
        final V nextValueInInflatedSegment() {
            Iterator<InflatedSegmentQueryContext.Node<K, V>> inflatedSegmentIterator = this.getInflatedSegmentIteratorAndUpdatePrevState();
            InflatedSegmentQueryContext.Node<K, V> inflatedSegmentNode = this.nextInflatedSegmentEntry(inflatedSegmentIterator);
            V value = inflatedSegmentNode.getValue();
            this.advanceInflatedSegmentIteration(inflatedSegmentIterator);
            return value;
        }
    }

    static class MapViewWithMutableIterators<K, V>
    implements Map<K, V> {
        final SmoothieMap<K, V> s;
        private @MonotonicNonNull KeySetWithMutableIterator<K, V> keySet;
        private @MonotonicNonNull ValuesWithMutableIterator<K, V> values;

        MapViewWithMutableIterators(SmoothieMap<K, V> smoothie) {
            this.s = smoothie;
        }

        @Override
        @EnsuresNonNull(value={"keySet"})
        public final Set<K> keySet() {
            @MonotonicNonNull KeySetWithMutableIterator<K, V> ks = this.keySet;
            return ks != null ? ks : (this.keySet = new KeySetWithMutableIterator<K, V>(this.s));
        }

        @Override
        @EnsuresNonNull(value={"values"})
        public final Collection<V> values() {
            @MonotonicNonNull ValuesWithMutableIterator<K, V> vs = this.values;
            return vs != null ? vs : (this.values = new ValuesWithMutableIterator<K, V>(this.s));
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.s.entrySet();
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.s.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.s.containsValue(value);
        }

        @Override
        public @Nullable V get(Object key) {
            return this.s.get(key);
        }

        @Override
        public @Nullable V remove(Object key) {
            return this.s.remove(key);
        }

        @Override
        public @Nullable V put(K key, V value) {
            return this.s.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            this.s.putAll(m);
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public V getOrDefault(Object key, V defaultValue) {
            return this.s.getOrDefault(key, defaultValue);
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> c) {
            this.s.forEach(c);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            this.s.replaceAll(function);
        }

        @Override
        public @Nullable V putIfAbsent(K key, V value) {
            return this.s.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.s.remove(key, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            return this.s.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            return this.s.replace(key, value);
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> f) {
            return this.s.computeIfAbsent((K)key, f);
        }

        @Override
        public @Nullable V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> f) {
            return this.s.computeIfPresent((K)k, (BiFunction<? super K, ? extends V, ? extends V>)f);
        }

        @Override
        public @Nullable V compute(K key, BiFunction<? super K, ? super V, ? extends V> f) {
            return this.s.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)f);
        }

        @Override
        public @Nullable V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> f) {
            return this.s.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)f);
        }

        @Override
        public int hashCode() {
            return this.s.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this.s.equals(obj);
        }

        public String toString() {
            return this.s.toString();
        }
    }

    static class EntrySet<K, V>
    extends AbstractMapView<Map.Entry<K, V>, K, V>
    implements ObjSet<Map.Entry<K, V>> {
        EntrySet(SmoothieMap<K, V> smoothie) {
            super(smoothie);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.smoothie.containsEntry(e.getKey(), e.getValue());
        }

        @Override
        public @Nullable Map.Entry<K, V> getInternal(Map.Entry<K, V> kvEntry) {
            throw new UnsupportedOperationException("SmoothieMap doesn't hold entries internally");
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                return this.smoothie.remove(e.getKey(), e.getValue());
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new MutableEntryIterator(this.smoothie);
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            int characteristics = 1;
            return Spliterators.spliterator(this.iterator(), this.smoothie.size, characteristics);
        }

        @Override
        public boolean equals(Object o) {
            return this.smoothie.equalsForSetViews(this, o);
        }

        @Override
        public int hashCode() {
            return this.smoothie.hashCode();
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<K, V>> action) {
            super.forEach(action);
        }

        @Override
        public boolean forEachWhile(Predicate<? super Map.Entry<K, V>> predicate) {
            Utils.checkNonNull(predicate);
            for (Map.Entry<K, V> e : this) {
                if (predicate.test(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            Utils.checkNonNull(c);
            if (this.sizeAsLong() > (long)c.size() && this.smoothie.keyEquivalence().equals(Equivalence.defaultEquality()) && this.smoothie.valueEquivalence().equals(Equivalence.defaultEquality())) {
                Iterator<?> it = c.iterator();
                while (it.hasNext()) {
                    if (!this.remove(it.next())) continue;
                    it.forEachRemaining(entry -> {
                        boolean removed = this.remove(entry);
                    });
                    return true;
                }
                return false;
            }
            SimpleMutableEntry entry2 = new SimpleMutableEntry();
            return this.smoothie.removeIf((? super K k, ? super V v) -> c.contains(entry2.with(k, v)));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Utils.checkNonNull(c);
            SimpleMutableEntry entry = new SimpleMutableEntry();
            return this.smoothie.removeIf((? super K k, ? super V v) -> !c.contains(entry.with(k, v)));
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry<K, V>> filter) {
            Utils.checkNonNull(filter);
            SimpleMutableEntry entry = new SimpleMutableEntry();
            return this.smoothie.removeIf((? super K k, ? super V v) -> filter.test(entry.with(k, v)));
        }
    }

    static final class ValuesWithMutableIterator<K, V>
    extends Values<K, V> {
        ValuesWithMutableIterator(SmoothieMap<K, V> smoothie) {
            super(smoothie);
        }

        @Override
        public Iterator<V> iterator() {
            return new MutableValueIterator(this.smoothie);
        }
    }

    static class Values<K, V>
    extends AbstractMapView<V, K, V> {
        public Values(SmoothieMap<K, V> smoothie) {
            super(smoothie);
        }

        @Override
        public boolean contains(Object o) {
            return this.smoothie.containsValue(o);
        }

        @Override
        public boolean remove(Object queriedValue) {
            Utils.checkNonNull(queriedValue);
            MutableValueIterator it = new MutableValueIterator(this.smoothie);
            while (it.hasNext()) {
                boolean valuesIdentical;
                Object internalVal = it.next();
                boolean bl = valuesIdentical = queriedValue == internalVal;
                if (!valuesIdentical && !this.smoothie.valuesEqual(queriedValue, internalVal)) continue;
                it.remove();
                return true;
            }
            return false;
        }

        @Override
        public Iterator<V> iterator() {
            return this.immutableIterator();
        }

        Iterator<V> immutableIterator() {
            return new ImmutableValueIterator(this.smoothie);
        }

        @Override
        public Spliterator<V> spliterator() {
            int characteristics = 0;
            return Spliterators.spliterator(this.immutableIterator(), this.smoothie.size, characteristics);
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            Utils.checkNonNull(action);
            int modCount = this.smoothie.getModCountOpaque();
            Object[] segmentsArray = this.smoothie.getNonNullSegmentsArrayOrThrowIse();
            int segmentArrayLength = segmentsArray.length;
            int segmentsArrayOrder = SmoothieMap.order(segmentArrayLength);
            int segmentIndex = 0;
            while (segmentIndex >= 0) {
                Segment segment = SmoothieMap.segmentCheckedByIndex(segmentsArray, segmentIndex);
                segment.forEachValue(action);
                segmentIndex = SmoothieMap.nextSegmentIndex(segmentArrayLength, segmentsArrayOrder, segmentIndex, segment);
            }
            this.smoothie.checkModCountOrThrowCme(modCount);
        }

        @Override
        public boolean forEachWhile(Predicate<? super V> predicate) {
            Utils.checkNonNull(predicate);
            boolean interrupted = false;
            int modCount = this.smoothie.getModCountOpaque();
            Object[] segmentsArray = this.smoothie.getNonNullSegmentsArrayOrThrowIse();
            int segmentArrayLength = segmentsArray.length;
            int segmentsArrayOrder = SmoothieMap.order(segmentArrayLength);
            int segmentIndex = 0;
            while (segmentIndex >= 0) {
                Segment segment = SmoothieMap.segmentCheckedByIndex(segmentsArray, segmentIndex);
                if (!segment.forEachValueWhile(predicate)) {
                    interrupted = true;
                    break;
                }
                segmentIndex = SmoothieMap.nextSegmentIndex(segmentArrayLength, segmentsArrayOrder, segmentIndex, segment);
            }
            this.smoothie.checkModCountOrThrowCme(modCount);
            return !interrupted;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            Utils.checkNonNull(c);
            return this.smoothie.removeIf((? super K k, ? super V v) -> c.contains(v));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Utils.checkNonNull(c);
            return this.smoothie.removeIf((? super K k, ? super V v) -> !c.contains(v));
        }

        @Override
        public boolean removeIf(Predicate<? super V> filter) {
            Utils.checkNonNull(filter);
            return this.smoothie.removeIf((? super K k, ? super V v) -> filter.test((Object)v));
        }
    }

    static final class KeySetWithMutableIterator<K, V>
    extends KeySet<K, V> {
        KeySetWithMutableIterator(SmoothieMap<K, V> smoothie) {
            super(smoothie);
        }

        @Override
        public Iterator<K> iterator() {
            return new MutableKeyIterator(this.smoothie);
        }
    }

    static class KeySet<K, V>
    extends AbstractMapView<K, K, V>
    implements ObjSet<K> {
        KeySet(SmoothieMap<K, V> smoothie) {
            super(smoothie);
        }

        @Override
        public boolean contains(Object o) {
            return this.smoothie.containsKey(o);
        }

        @Override
        public @Nullable K getInternal(K k) {
            return this.smoothie.getInternalKey((Object)k);
        }

        @Override
        public boolean remove(Object key) {
            return this.smoothie.remove(key) != null;
        }

        @Override
        public Iterator<K> iterator() {
            return this.immutableIterator();
        }

        Iterator<K> immutableIterator() {
            return new ImmutableKeyIterator(this.smoothie);
        }

        @Override
        public Spliterator<K> spliterator() {
            int characteristics = 1;
            return Spliterators.spliterator(this.immutableIterator(), this.smoothie.size, characteristics);
        }

        @Override
        public boolean equals(Object o) {
            return this.smoothie.equalsForSetViews(this, o);
        }

        @Override
        public int hashCode() {
            int h = 0;
            int modCount = this.smoothie.getModCountOpaque();
            Object[] segmentsArray = this.smoothie.getNonNullSegmentsArrayOrThrowIse();
            int segmentArrayLength = segmentsArray.length;
            int segmentsArrayOrder = SmoothieMap.order(segmentArrayLength);
            int segmentIndex = 0;
            while (segmentIndex >= 0) {
                Segment segment = SmoothieMap.segmentCheckedByIndex(segmentsArray, segmentIndex);
                h += segment.keySetHashCode(this);
                segmentIndex = SmoothieMap.nextSegmentIndex(segmentArrayLength, segmentsArrayOrder, segmentIndex, segment);
            }
            this.smoothie.checkModCountOrThrowCme(modCount);
            return h;
        }

        @Override
        public final void forEach(Consumer<? super K> action) {
            Utils.checkNonNull(action);
            int modCount = this.smoothie.getModCountOpaque();
            Object[] segmentsArray = this.smoothie.getNonNullSegmentsArrayOrThrowIse();
            int segmentArrayLength = segmentsArray.length;
            int segmentsArrayOrder = SmoothieMap.order(segmentArrayLength);
            int segmentIndex = 0;
            while (segmentIndex >= 0) {
                Segment segment = SmoothieMap.segmentCheckedByIndex(segmentsArray, segmentIndex);
                segment.forEachKey(action);
                segmentIndex = SmoothieMap.nextSegmentIndex(segmentArrayLength, segmentsArrayOrder, segmentIndex, segment);
            }
            this.smoothie.checkModCountOrThrowCme(modCount);
        }

        @Override
        public boolean forEachWhile(Predicate<? super K> predicate) {
            Utils.checkNonNull(predicate);
            boolean interrupted = false;
            int modCount = this.smoothie.getModCountOpaque();
            Object[] segmentsArray = this.smoothie.getNonNullSegmentsArrayOrThrowIse();
            int segmentArrayLength = segmentsArray.length;
            int segmentsArrayOrder = SmoothieMap.order(segmentArrayLength);
            int segmentIndex = 0;
            while (segmentIndex >= 0) {
                Segment segment = SmoothieMap.segmentCheckedByIndex(segmentsArray, segmentIndex);
                if (!segment.forEachKeyWhile(predicate)) {
                    interrupted = true;
                    break;
                }
                segmentIndex = SmoothieMap.nextSegmentIndex(segmentArrayLength, segmentsArrayOrder, segmentIndex, segment);
            }
            this.smoothie.checkModCountOrThrowCme(modCount);
            return !interrupted;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (this.sizeAsLong() > (long)c.size() && this.smoothie.keyEquivalence().equals(Equivalence.defaultEquality())) {
                Iterator<?> it = c.iterator();
                while (it.hasNext()) {
                    if (!this.remove(it.next())) continue;
                    it.forEachRemaining(key -> {
                        boolean removed = this.remove(key);
                    });
                    return true;
                }
                return false;
            }
            return this.smoothie.removeIf((? super K k, ? super V v) -> c.contains(k));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Utils.checkNonNull(c);
            return this.smoothie.removeIf((? super K k, ? super V v) -> !c.contains(k));
        }

        @Override
        public boolean removeIf(Predicate<? super K> filter) {
            Utils.checkNonNull(filter);
            return this.smoothie.removeIf((? super K k, ? super V v) -> filter.test((Object)k));
        }
    }

    private static abstract class AbstractMapView<T, K, V>
    extends AbstractCollection<T>
    implements ObjCollection<T> {
        final SmoothieMap<K, V> smoothie;

        private AbstractMapView(SmoothieMap<K, V> smoothie) {
            this.smoothie = smoothie;
        }

        @Override
        public int size() {
            return this.smoothie.size();
        }

        @Override
        public long sizeAsLong() {
            return this.smoothie.sizeAsLong();
        }

        @Override
        public void clear() {
            this.smoothie.clear();
        }
    }

    private static class SegmentsArrayLengthAndNumSegments {
        final int segmentsArrayLength;
        final int numSegments;

        private SegmentsArrayLengthAndNumSegments(int segmentsArrayLength, int numSegments) {
            this.segmentsArrayLength = segmentsArrayLength;
            this.numSegments = numSegments;
        }
    }
}

