/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.timeandspace.collect.Equivalence;
import io.timeandspace.smoothie.DefaultHashFunction;
import io.timeandspace.smoothie.EquivalenceBasedHashFunction;
import io.timeandspace.smoothie.OptimizationObjective;
import io.timeandspace.smoothie.SmoothieMap;
import io.timeandspace.smoothie.SmoothieMapWithCustomKeyAndValueEquivalences;
import io.timeandspace.smoothie.SmoothieMapWithCustomKeyEquivalence;
import io.timeandspace.smoothie.SmoothieMapWithCustomKeyHashFunction;
import io.timeandspace.smoothie.SmoothieMapWithCustomValueEquivalence;
import io.timeandspace.smoothie.Utils;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Contract;

public final class SmoothieMapBuilder<K, V> {
    static final long UNKNOWN_SIZE = Long.MAX_VALUE;
    private static final double MAX_EXPECTED_SIZE_ERROR_FRACTION = 0.05;
    private boolean allocateIntermediateCapacitySegments;
    private boolean splitBetweenTwoNewSegments;
    private boolean doShrink;
    private Equivalence<K> keyEquivalence = Equivalence.defaultEquality();
    private @Nullable Supplier<ToLongFunction<K>> keyHashFunctionFactory = null;
    private Equivalence<V> valueEquivalence = Equivalence.defaultEquality();
    private long expectedSize = Long.MAX_VALUE;
    private long minPeakSize = Long.MAX_VALUE;

    @Contract(value=" -> new", pure=true)
    static <K, V> SmoothieMapBuilder<K, V> create() {
        return new SmoothieMapBuilder<K, V>();
    }

    private SmoothieMapBuilder() {
        this.defaultOptimizationConfiguration();
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public SmoothieMapBuilder<K, V> optimizeFor(OptimizationObjective optimizationObjective) {
        Utils.checkNonNull((Object)optimizationObjective);
        switch (optimizationObjective) {
            case LOW_GARBAGE: {
                this.allocateIntermediateCapacitySegments = false;
                this.splitBetweenTwoNewSegments = false;
                this.doShrink = false;
                break;
            }
            case FOOTPRINT: {
                this.allocateIntermediateCapacitySegments = true;
                this.splitBetweenTwoNewSegments = true;
                this.doShrink = true;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown OptimizationObjective: " + (Object)((Object)optimizationObjective)));
            }
        }
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value=" -> this")
    public SmoothieMapBuilder<K, V> defaultOptimizationConfiguration() {
        this.allocateIntermediateCapacitySegments = true;
        this.splitBetweenTwoNewSegments = false;
        this.doShrink = true;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public SmoothieMapBuilder<K, V> allocateIntermediateCapacitySegments(boolean allocateIntermediateCapacitySegments) {
        if (!allocateIntermediateCapacitySegments) {
            this.splitBetweenTwoNewSegments(false);
        }
        this.allocateIntermediateCapacitySegments = allocateIntermediateCapacitySegments;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public SmoothieMapBuilder<K, V> splitBetweenTwoNewSegments(boolean splitBetweenTwoNewSegments) {
        if (splitBetweenTwoNewSegments) {
            this.allocateIntermediateCapacitySegments(true);
        }
        this.splitBetweenTwoNewSegments = splitBetweenTwoNewSegments;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public SmoothieMapBuilder<K, V> doShrink(boolean doShrink) {
        this.doShrink = doShrink;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public SmoothieMapBuilder<K, V> keyEquivalence(Equivalence<K> keyEquivalence) {
        Utils.checkNonNull(keyEquivalence);
        this.keyEquivalence = keyEquivalence;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value=" -> this")
    public SmoothieMapBuilder<K, V> defaultKeyEquivalence() {
        this.keyEquivalence = Equivalence.defaultEquality();
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public SmoothieMapBuilder<K, V> keyHashFunction(ToLongFunction<K> hashFunction) {
        Utils.checkNonNull(hashFunction);
        this.keyHashFunctionFactory = () -> hashFunction;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public SmoothieMapBuilder<K, V> keyHashFunctionFactory(Supplier<ToLongFunction<K>> hashFunctionFactory) {
        Utils.checkNonNull(hashFunctionFactory);
        this.keyHashFunctionFactory = hashFunctionFactory;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value=" -> this")
    public SmoothieMapBuilder<K, V> defaultKeyHashFunction() {
        this.keyHashFunctionFactory = null;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public SmoothieMapBuilder<K, V> valueEquivalence(Equivalence<V> valueEquivalence) {
        Utils.checkNonNull(valueEquivalence);
        this.valueEquivalence = valueEquivalence;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value=" -> this")
    public SmoothieMapBuilder<K, V> defaultValueEquivalence() {
        this.valueEquivalence = Equivalence.defaultEquality();
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public SmoothieMapBuilder<K, V> expectedSize(long expectedSize) {
        Utils.checkNonNegative(expectedSize, "expected size");
        this.expectedSize = expectedSize;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value=" -> this")
    public SmoothieMapBuilder<K, V> unknownExpectedSize() {
        this.expectedSize = Long.MAX_VALUE;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public SmoothieMapBuilder<K, V> minPeakSize(long minPeakSize) {
        Utils.checkNonNegative(minPeakSize, "minimum peak size");
        this.minPeakSize = minPeakSize;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value=" -> this")
    public SmoothieMapBuilder<K, V> unknownMinPeakSize() {
        this.minPeakSize = Long.MAX_VALUE;
        return this;
    }

    @Contract(value=" -> new")
    public SmoothieMap<K, V> build() {
        boolean isDefaultKeyEquivalence = this.keyEquivalence.equals(Equivalence.defaultEquality());
        boolean isDefaultValueEquivalence = this.valueEquivalence.equals(Equivalence.defaultEquality());
        if (this.keyHashFunctionFactory == null && isDefaultKeyEquivalence && isDefaultValueEquivalence) {
            return new SmoothieMap(this);
        }
        if (this.keyHashFunctionFactory != null && isDefaultKeyEquivalence && isDefaultValueEquivalence) {
            return new SmoothieMapWithCustomKeyHashFunction(this);
        }
        if (!isDefaultKeyEquivalence && isDefaultValueEquivalence) {
            return new SmoothieMapWithCustomKeyEquivalence(this);
        }
        if (this.keyHashFunctionFactory == null && isDefaultKeyEquivalence) {
            Utils.verifyThat(!isDefaultValueEquivalence);
            return new SmoothieMapWithCustomValueEquivalence(this);
        }
        return new SmoothieMapWithCustomKeyAndValueEquivalences(this);
    }

    boolean allocateIntermediateCapacitySegments() {
        return this.allocateIntermediateCapacitySegments;
    }

    boolean splitBetweenTwoNewSegments() {
        return this.splitBetweenTwoNewSegments;
    }

    boolean doShrink() {
        return this.doShrink;
    }

    Equivalence<K> keyEquivalence() {
        return this.keyEquivalence;
    }

    ToLongFunction<K> keyHashFunction() {
        if (this.keyHashFunctionFactory != null) {
            return this.keyHashFunctionFactory.get();
        }
        if (this.keyEquivalence.equals(Equivalence.defaultEquality())) {
            return DefaultHashFunction.instance();
        }
        return new EquivalenceBasedHashFunction<K>(this.keyEquivalence);
    }

    Equivalence<V> valueEquivalence() {
        return this.valueEquivalence;
    }

    private void checkSizes() {
        if (this.expectedSize == Long.MAX_VALUE || this.minPeakSize == Long.MAX_VALUE) {
            return;
        }
        if (this.minPeakSize < (long)((double)this.expectedSize * 0.95)) {
            throw new IllegalStateException("minPeakSize[" + this.minPeakSize + "] is less than expectedSize[" + this.expectedSize + "] * " + 0.95);
        }
    }

    long expectedSize() {
        this.checkSizes();
        return this.expectedSize;
    }

    long minPeakSize() {
        this.checkSizes();
        return this.minPeakSize != Long.MAX_VALUE ? this.minPeakSize : this.expectedSize;
    }
}

