/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.collect.Equivalence;
import io.timeandspace.smoothie.ObjectSize;
import io.timeandspace.smoothie.SmoothieMapBuilder;
import io.timeandspace.smoothie.SmoothieMapWithCustomKeyEquivalence;

final class SmoothieMapWithCustomKeyAndValueEquivalences<K, V>
extends SmoothieMapWithCustomKeyEquivalence<K, V> {
    private static final long SIZE_IN_BYTES = ObjectSize.classSizeInBytes(SmoothieMapWithCustomKeyAndValueEquivalences.class);
    private final Equivalence<V> valueEquivalence;

    SmoothieMapWithCustomKeyAndValueEquivalences(SmoothieMapBuilder<K, V> builder) {
        super(builder);
        this.valueEquivalence = builder.valueEquivalence();
    }

    @Override
    boolean valuesEqual(Object queriedValue, V internalValue) {
        return this.valueEquivalence.equivalent(queriedValue, internalValue);
    }

    @Override
    public Equivalence<V> valueEquivalence() {
        return this.valueEquivalence;
    }

    @Override
    int valueHashCodeForAggregateHashCodes(Object value) {
        return this.valueEquivalence.hash(value);
    }

    @Override
    long smoothieMapClassSizeInBytes() {
        return SIZE_IN_BYTES;
    }
}

