/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.collect.Equivalence;
import io.timeandspace.smoothie.ObjectSize;
import io.timeandspace.smoothie.SmoothieMapBuilder;
import io.timeandspace.smoothie.SmoothieMapWithCustomKeyHashFunction;

class SmoothieMapWithCustomKeyEquivalence<K, V>
extends SmoothieMapWithCustomKeyHashFunction<K, V> {
    private static final long SIZE_IN_BYTES = ObjectSize.classSizeInBytes(SmoothieMapWithCustomKeyEquivalence.class);
    private final Equivalence<K> keyEquivalence;

    SmoothieMapWithCustomKeyEquivalence(SmoothieMapBuilder<K, V> builder) {
        super(builder);
        this.keyEquivalence = builder.keyEquivalence();
    }

    @Override
    boolean keysEqual(Object queriedKey, K internalKey) {
        return this.keyEquivalence.equivalent(queriedKey, internalKey);
    }

    @Override
    public Equivalence<K> keyEquivalence() {
        return this.keyEquivalence;
    }

    @Override
    int keyHashCodeForAggregateHashCodes(Object key) {
        return this.keyEquivalence.hash(key);
    }

    @Override
    long smoothieMapClassSizeInBytes() {
        return SIZE_IN_BYTES;
    }
}

