/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.smoothie;

import io.timeandspace.smoothie.UnsafeUtils;
import io.timeandspace.smoothie.Utils;
import java.nio.ByteOrder;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.value.qual.IntVal;
import sun.misc.Unsafe;

public final class SwissTable<K, V>
extends AbstractMap<K, V> {
    private static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final int CONTROL_BITS = 7;
    private static final long CONTROL_BITS_MASK = 127L;
    private static final int GROUP_SLOTS = 8;
    private static final long ARRAY_LONG_BASE_OFFSET_AS_LONG = Unsafe.ARRAY_LONG_BASE_OFFSET;
    private static final long TABLE_SLOT_INDEX_SCALE = UnsafeUtils.ARRAY_OBJECT_INDEX_SCALE_AS_LONG * 2L;
    private static final long TABLE_VALUE_BASE_OFFSET = UnsafeUtils.ARRAY_OBJECT_BASE_OFFSET_AS_LONG + UnsafeUtils.ARRAY_OBJECT_INDEX_SCALE_AS_LONG;
    private static final long MOST_SIGNIFICANT_BYTE_BITS = -9187201950435737472L;
    private static final long LEAST_SIGNIFICANT_BYTE_BITS = 0x101010101010101L;
    private static final @IntVal(value={255L}) byte EMPTY_CONTROL = -1;
    private static final @IntVal(value={128L}) byte DELETED_CONTROL = -128;
    private static final long EMPTY_CONTROL_GROUP = -1L;
    private static final int MAX_CAPACITY = 0x40000000;
    private static final int DEFAULT_EXPECTED_SIZE = 10;
    private long[] controls;
    private int lookupMask;
    private Object[] table;
    private int size;
    private int numDeletedSlots;
    private int modCount;

    private static int nextPowerOfTwo(int n) {
        int highestOneBit = Integer.highestOneBit(n);
        if (n == highestOneBit) {
            return highestOneBit;
        }
        int nextPowerOfTwo = highestOneBit * 2;
        if (nextPowerOfTwo < 0) {
            throw new IllegalArgumentException();
        }
        return nextPowerOfTwo;
    }

    private static long clearLowestSetBit(long bitMask) {
        return bitMask & bitMask - 1L;
    }

    private static int extractMatchingEmpty(long controlsGroup, int trailingZeros) {
        return (int)(controlsGroup >>> trailingZeros - 1 & 1L);
    }

    private static long match(long controlsGroup, long hashControlBits) {
        long x = controlsGroup ^ 0x101010101010101L * hashControlBits;
        return x - 0x101010101010101L & (x ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L;
    }

    private static long matchEmpty(long controlsGroup) {
        return controlsGroup & controlsGroup << 1 & 0x8080808080808080L;
    }

    private static long matchEmptyOrDeleted(long controlsGroup) {
        return controlsGroup & 0x8080808080808080L;
    }

    private static long matchFull(long controlsGroup) {
        return (controlsGroup ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L;
    }

    public SwissTable() {
        this(10);
    }

    public SwissTable(int expectedSize) {
        int capacity = SwissTable.nextPowerOfTwo(expectedSize);
        if (expectedSize > SwissTable.maxNumNonEmptySlotsBeforeRehash(capacity) && capacity < 0x40000000) {
            capacity *= 2;
        }
        this.init(capacity);
    }

    private void init(int capacity) {
        this.lookupMask = capacity - 1;
        this.controls = new long[(capacity + 8) / 8];
        this.table = new Object[capacity * 2];
        Arrays.fill(this.controls, -1L);
    }

    @Override
    public int size() {
        return this.size;
    }

    private int capacity() {
        return this.lookupMask + 1;
    }

    private int maxNumNonEmptySlotsBeforeRehash() {
        return SwissTable.maxNumNonEmptySlotsBeforeRehash(this.capacity());
    }

    private static int maxNumNonEmptySlotsBeforeRehash(int capacity) {
        return (capacity >>> 2) * 3;
    }

    protected long keyHashCode(Object key) {
        long x = (long)key.hashCode() * -7046029254386353131L;
        return x ^ x >>> 57;
    }

    private boolean keysEqual(Object queriedKey, K internalKey) {
        return queriedKey.equals(internalKey);
    }

    private long firstSlotIndex(long hash) {
        return hash >>> 7 & (long)this.lookupMask;
    }

    private static long hashControlBits(long hash) {
        return hash & 0x7FL;
    }

    private static long readControlsGroup(long[] controls, long groupFirstSlotIndex) {
        long controlsGroup = UnsafeUtils.U.getLong(controls, ARRAY_LONG_BASE_OFFSET_AS_LONG + groupFirstSlotIndex);
        if (LITTLE_ENDIAN) {
            return controlsGroup;
        }
        return Long.reverseBytes(controlsGroup);
    }

    private static <K> K readKey(Object[] table, long slotIndex) {
        return (K)UnsafeUtils.U.getObject(table, UnsafeUtils.ARRAY_OBJECT_BASE_OFFSET_AS_LONG + TABLE_SLOT_INDEX_SCALE * slotIndex);
    }

    private static <V> V readValue(Object[] table, long slotIndex) {
        return (V)UnsafeUtils.U.getObject(table, TABLE_VALUE_BASE_OFFSET + TABLE_SLOT_INDEX_SCALE * slotIndex);
    }

    private static void writeValue(Object[] table, long slotIndex, Object value) {
        UnsafeUtils.U.putObject(table, TABLE_VALUE_BASE_OFFSET + TABLE_SLOT_INDEX_SCALE * slotIndex, value);
    }

    private static void writeEntry(Object[] table, long slotIndex, Object key, Object value) {
        long offset = UnsafeUtils.ARRAY_OBJECT_BASE_OFFSET_AS_LONG + TABLE_SLOT_INDEX_SCALE * slotIndex;
        UnsafeUtils.U.putObject(table, offset, key);
        UnsafeUtils.U.putObject(table, offset + UnsafeUtils.ARRAY_OBJECT_INDEX_SCALE_AS_LONG, value);
    }

    private void writeControlByte(long slotIndex, byte controlByte) {
        UnsafeUtils.U.putByte(this.controls, ARRAY_LONG_BASE_OFFSET_AS_LONG + slotIndex, controlByte);
        if (slotIndex < 8L) {
            long secondarySlotIndex = (long)this.capacity() + slotIndex;
            UnsafeUtils.U.putByte(this.controls, ARRAY_LONG_BASE_OFFSET_AS_LONG + secondarySlotIndex, controlByte);
        }
    }

    private long addSlotIndex(long slotIndex, long addition) {
        return slotIndex + addition & (long)this.lookupMask;
    }

    private long lowestMatchIndex(long groupFirstSlotIndex, long groupBitMask) {
        return this.addSlotIndex(groupFirstSlotIndex, (long)Long.numberOfTrailingZeros(groupBitMask) >>> 3);
    }

    private long lowestMatchIndexFromTrailingZeros(long groupFirstSlotIndex, int trailingZeros) {
        return this.addSlotIndex(groupFirstSlotIndex, (long)trailingZeros >>> 3);
    }

    @Override
    public @Nullable V get(Object key) {
        Utils.checkNonNull(key);
        long hash = this.keyHashCode(key);
        long hashControlBits = SwissTable.hashControlBits(hash);
        long groupFirstSlotIndex = this.firstSlotIndex(hash);
        long[] controls = this.controls;
        Object[] table = this.table;
        long slotIndexStep = 0L;
        while (true) {
            long controlsGroup = SwissTable.readControlsGroup(controls, groupFirstSlotIndex);
            long bitMask = SwissTable.match(controlsGroup, hashControlBits);
            while (bitMask != 0L) {
                boolean keysIdentical;
                long matchSlotIndex = this.lowestMatchIndex(groupFirstSlotIndex, bitMask);
                K internalKey = SwissTable.readKey(table, matchSlotIndex);
                boolean bl = keysIdentical = internalKey == key;
                if (keysIdentical || this.keysEqual(key, internalKey)) {
                    return SwissTable.readValue(table, matchSlotIndex);
                }
                bitMask = SwissTable.clearLowestSetBit(bitMask);
            }
            if (SwissTable.matchEmpty(controlsGroup) != 0L) {
                return null;
            }
            groupFirstSlotIndex = this.addSlotIndex(groupFirstSlotIndex, slotIndexStep += 8L);
        }
    }

    @Override
    public @Nullable V put(K key, V value) {
        Utils.checkNonNull(key);
        long hash = this.keyHashCode(key);
        return this.putInternal(key, hash, value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private @Nullable V putInternal(K key, long hash, V value) {
        long initialGroupFirstSlotIndex;
        long hashControlBits = SwissTable.hashControlBits(hash);
        long groupFirstSlotIndex = initialGroupFirstSlotIndex = this.firstSlotIndex(hash);
        long[] controls = this.controls;
        Object[] table = this.table;
        long slotIndexStep = 0L;
        while (true) {
            long controlsGroup = SwissTable.readControlsGroup(controls, groupFirstSlotIndex);
            long bitMask = SwissTable.match(controlsGroup, hashControlBits);
            while (bitMask != 0L) {
                boolean keysIdentical;
                long matchSlotIndex = this.lowestMatchIndex(groupFirstSlotIndex, bitMask);
                K internalKey = SwissTable.readKey(table, matchSlotIndex);
                boolean bl = keysIdentical = internalKey == key;
                if (keysIdentical || this.keysEqual(key, internalKey)) {
                    V internalVal = SwissTable.readValue(table, matchSlotIndex);
                    SwissTable.writeValue(table, matchSlotIndex, value);
                    return internalVal;
                }
                bitMask = SwissTable.clearLowestSetBit(bitMask);
            }
            long emptyBitMask = SwissTable.matchEmpty(controlsGroup);
            if (emptyBitMask != 0L) {
                int replacingEmptySlot;
                long insertionSlotIndex;
                int numDeletedSlots = this.numDeletedSlots;
                if (numDeletedSlots == 0) {
                    insertionSlotIndex = this.lowestMatchIndex(groupFirstSlotIndex, emptyBitMask);
                    replacingEmptySlot = 1;
                } else if (slotIndexStep == 0L) {
                    long emptyOrDeletedBitMask = SwissTable.matchEmptyOrDeleted(controlsGroup);
                    int trailingZeros = Long.numberOfTrailingZeros(emptyOrDeletedBitMask);
                    insertionSlotIndex = this.lowestMatchIndexFromTrailingZeros(groupFirstSlotIndex, trailingZeros);
                    replacingEmptySlot = SwissTable.extractMatchingEmpty(controlsGroup, trailingZeros);
                } else {
                    groupFirstSlotIndex = initialGroupFirstSlotIndex;
                    slotIndexStep = 0L;
                    while (true) {
                        long emptyOrDeletedBitMask;
                        if ((emptyOrDeletedBitMask = SwissTable.matchEmptyOrDeleted(controlsGroup = SwissTable.readControlsGroup(controls, groupFirstSlotIndex))) != 0L) {
                            int trailingZeros = Long.numberOfTrailingZeros(emptyOrDeletedBitMask);
                            insertionSlotIndex = this.lowestMatchIndexFromTrailingZeros(groupFirstSlotIndex, trailingZeros);
                            replacingEmptySlot = SwissTable.extractMatchingEmpty(controlsGroup, trailingZeros);
                            break;
                        }
                        groupFirstSlotIndex = this.addSlotIndex(groupFirstSlotIndex, slotIndexStep += 8L);
                    }
                }
                this.insert(key, hash, value, insertionSlotIndex, replacingEmptySlot);
                return null;
            }
            groupFirstSlotIndex = this.addSlotIndex(groupFirstSlotIndex, slotIndexStep += 8L);
        }
    }

    private void insertDuringRehash(K key, V value) {
        long hash = this.keyHashCode(key);
        long hashControlBits = SwissTable.hashControlBits(hash);
        long groupFirstSlotIndex = this.firstSlotIndex(hash);
        long[] controls = this.controls;
        Object[] table = this.table;
        long slotIndexStep = 0L;
        while (true) {
            long controlsGroup;
            long bitMask;
            if ((bitMask = SwissTable.matchEmpty(controlsGroup = SwissTable.readControlsGroup(controls, groupFirstSlotIndex))) != 0L) {
                long insertionSlotIndex = this.lowestMatchIndex(groupFirstSlotIndex, bitMask);
                this.writeControlByte(insertionSlotIndex, (byte)hashControlBits);
                SwissTable.writeEntry(table, insertionSlotIndex, key, value);
                return;
            }
            groupFirstSlotIndex = this.addSlotIndex(groupFirstSlotIndex, slotIndexStep += 8L);
        }
    }

    private void insert(K key, long hash, V value, long insertionSlotIndex, int replacingEmptySlot) {
        boolean enoughNonEmptySlots;
        int maxNumNonEmptySlotsBeforeRehash = this.maxNumNonEmptySlotsBeforeRehash();
        boolean bl = enoughNonEmptySlots = this.size + this.numDeletedSlots + replacingEmptySlot <= maxNumNonEmptySlotsBeforeRehash;
        if (enoughNonEmptySlots) {
            this.doInsert(key, hash, value, insertionSlotIndex, replacingEmptySlot);
        } else {
            this.rehash();
            if (this.putInternal(key, hash, value) != null) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private void doInsert(K key, long hash, V value, long insertionSlotIndex, int replacingEmptySlot) {
        this.writeControlByte(insertionSlotIndex, (byte)SwissTable.hashControlBits(hash));
        SwissTable.writeEntry(this.table, insertionSlotIndex, key, value);
        int replacingDeletedSlot = 1 - replacingEmptySlot;
        this.numDeletedSlots -= replacingDeletedSlot;
        ++this.size;
        ++this.modCount;
    }

    private void rehash() {
        int modCount = this.modCount;
        int oldCapacity = this.capacity();
        long[] oldControls = this.controls;
        Object[] oldTable = this.table;
        this.init(oldCapacity * 2);
        for (int groupIndex = 0; groupIndex < oldCapacity / 8; ++groupIndex) {
            long controlsGroup = oldControls[groupIndex];
            long groupFirstSlotIndex = (long)groupIndex * 8L;
            long bitMask = SwissTable.matchFull(controlsGroup);
            while (bitMask != 0L) {
                long slotIndex = this.lowestMatchIndex(groupFirstSlotIndex, bitMask);
                K key = SwissTable.readKey(oldTable, slotIndex);
                V value = SwissTable.readValue(oldTable, slotIndex);
                this.insertDuringRehash(key, value);
                bitMask = SwissTable.clearLowestSetBit(bitMask);
            }
        }
        Utils.checkModCount(modCount, this.modCount);
    }
}

