/*
 * Decompiled with CFR 0.152.
 */
package io.tlf.jme.jfx;

import com.jme3.input.event.InputEvent;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.event.MouseButtonEvent;
import io.tlf.jme.jfx.JavaFxUI;
import io.tlf.jme.jfx.JmeMemoryInputHandler;
import java.util.Map;
import java.util.function.Function;
import javafx.scene.Node;
import javafx.scene.control.TextInputControl;

public class JmeFxEventConsumeAllowedFunction
implements Function<InputEvent, Boolean> {
    private final Map<Integer, KeyInputEvent> jmeKeyInputEvents;
    private final Map<Integer, MouseButtonEvent> jmeMouseButtonEvents;

    public JmeFxEventConsumeAllowedFunction(JmeMemoryInputHandler inputHandler) {
        this.jmeKeyInputEvents = inputHandler.getJmeKeyInputEvents();
        this.jmeMouseButtonEvents = inputHandler.getJmeMouseButtonEvents();
    }

    @Override
    public Boolean apply(InputEvent event) {
        if (event instanceof MouseButtonEvent) {
            return this.checkMouseEvent((MouseButtonEvent)event);
        }
        if (event instanceof KeyInputEvent) {
            return this.checkKeyEvent((KeyInputEvent)event);
        }
        return true;
    }

    private Boolean checkMouseEvent(MouseButtonEvent event) {
        if (event.isReleased() && this.jmeMouseButtonEvents.get(event.getButtonIndex()) != null) {
            return false;
        }
        return true;
    }

    private Boolean checkKeyEvent(KeyInputEvent event) {
        if (event.isReleased() && this.jmeKeyInputEvents.get(event.getKeyCode()) != null) {
            return false;
        }
        Node node = (Node)JavaFxUI.getInstance().getScene().focusOwnerProperty().get();
        if (node instanceof TextInputControl && node.isVisible()) {
            return true;
        }
        return false;
    }
}

