/*
 * Decompiled with CFR 0.152.
 */
package io.tlf.jme.jfx;

import com.jme3.input.RawInputListener;
import com.jme3.input.event.JoyAxisEvent;
import com.jme3.input.event.JoyButtonEvent;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.input.event.TouchEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class JmeMemoryInputHandler
implements RawInputListener {
    private static final Logger LOGGER = Logger.getLogger(JmeMemoryInputHandler.class.getName());
    private final Map<Integer, KeyInputEvent> jmeKeyInputEvents = new HashMap<Integer, KeyInputEvent>();
    private final Map<Integer, MouseButtonEvent> jmeMouseButtonEvents = new HashMap<Integer, MouseButtonEvent>();

    public void beginInput() {
    }

    public void endInput() {
    }

    public void onJoyAxisEvent(JoyAxisEvent evt) {
    }

    public void onJoyButtonEvent(JoyButtonEvent evt) {
    }

    public void onMouseMotionEvent(MouseMotionEvent evt) {
    }

    public void onMouseButtonEvent(MouseButtonEvent evt) {
        MouseButtonEvent existingEvent = this.jmeMouseButtonEvents.get(evt.getButtonIndex());
        if (evt.isPressed()) {
            if (existingEvent == null) {
                this.jmeMouseButtonEvents.put(evt.getButtonIndex(), evt);
            }
        } else if (evt.isReleased() && existingEvent != null) {
            this.jmeMouseButtonEvents.remove(evt.getButtonIndex());
        }
    }

    public void onKeyEvent(KeyInputEvent evt) {
        if (evt.getKeyCode() == 0) {
            return;
        }
        KeyInputEvent existingEvent = this.jmeKeyInputEvents.get(evt.getKeyCode());
        if (evt.isPressed()) {
            if (existingEvent == null) {
                this.jmeKeyInputEvents.put(evt.getKeyCode(), evt);
            }
        } else if (evt.isReleased() && !evt.isRepeating() && existingEvent != null) {
            this.jmeKeyInputEvents.remove(evt.getKeyCode());
        }
    }

    public void onTouchEvent(TouchEvent evt) {
    }

    public Map<Integer, KeyInputEvent> getJmeKeyInputEvents() {
        return this.jmeKeyInputEvents;
    }

    public Map<Integer, MouseButtonEvent> getJmeMouseButtonEvents() {
        return this.jmeMouseButtonEvents;
    }
}

