/*
 * Decompiled with CFR 0.152.
 */
package io.tlf.jme.jfx.injfx.input;

import com.jme3.input.KeyInput;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.lwjgl.GlfwKeyMap;
import io.tlf.jme.jfx.injfx.JmeOffscreenSurfaceContext;
import io.tlf.jme.jfx.injfx.input.JfxInput;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.lwjgl.glfw.GLFW;

public class JfxKeyInput
extends JfxInput
implements KeyInput {
    private static final Map<KeyCode, Integer> KEY_CODE_TO_JME = new HashMap<KeyCode, Integer>();
    private final EventHandler<KeyEvent> processKeyPressed = this::processKeyPressed;
    private final EventHandler<KeyEvent> processKeyReleased = this::processKeyReleased;
    private final LinkedList<KeyInputEvent> keyInputEvents = new LinkedList();

    public JfxKeyInput(JmeOffscreenSurfaceContext context) {
        super(context);
    }

    @Override
    public void bind(Node node) {
        super.bind(node);
        node.addEventHandler(KeyEvent.KEY_PRESSED, this.processKeyPressed);
        node.addEventHandler(KeyEvent.KEY_RELEASED, this.processKeyReleased);
    }

    @Override
    public void unbind() {
        if (this.hasNode()) {
            Node node = this.getNode();
            node.removeEventHandler(KeyEvent.KEY_PRESSED, this.processKeyPressed);
            node.removeEventHandler(KeyEvent.KEY_RELEASED, this.processKeyReleased);
        }
        super.unbind();
    }

    private void processKeyReleased(KeyEvent keyEvent) {
        this.onKeyEvent(keyEvent, false);
    }

    private void processKeyPressed(KeyEvent keyEvent) {
        this.onKeyEvent(keyEvent, true);
    }

    private void onKeyEvent(KeyEvent keyEvent, boolean pressed) {
        int code = this.convertKeyCode(keyEvent.getCode());
        String character = keyEvent.getText();
        char keyChar = character.isEmpty() ? (char)'\u0000' : character.charAt(0);
        KeyInputEvent event = new KeyInputEvent(code, keyChar, pressed, false);
        event.setTime(this.getInputTimeNanos());
        EXECUTOR.addToExecute(() -> this.keyInputEvents.add(event));
    }

    @Override
    protected void updateImpl() {
        RawInputListener listener = this.getListener();
        while (!this.keyInputEvents.isEmpty()) {
            listener.onKeyEvent(this.keyInputEvents.poll());
        }
    }

    private int convertKeyCode(KeyCode keyCode) {
        Integer code = KEY_CODE_TO_JME.get(keyCode);
        return code == null ? 0 : code;
    }

    public String getKeyName(int key) {
        int glfwKey = GlfwKeyMap.fromJmeKeyCode((int)key);
        return GLFW.glfwGetKeyName((int)glfwKey, (int)0);
    }

    static {
        KEY_CODE_TO_JME.put(KeyCode.ESCAPE, 1);
        KEY_CODE_TO_JME.put(KeyCode.DIGIT0, 11);
        KEY_CODE_TO_JME.put(KeyCode.DIGIT1, 2);
        KEY_CODE_TO_JME.put(KeyCode.DIGIT2, 3);
        KEY_CODE_TO_JME.put(KeyCode.DIGIT3, 4);
        KEY_CODE_TO_JME.put(KeyCode.DIGIT4, 5);
        KEY_CODE_TO_JME.put(KeyCode.DIGIT5, 6);
        KEY_CODE_TO_JME.put(KeyCode.DIGIT6, 7);
        KEY_CODE_TO_JME.put(KeyCode.DIGIT7, 8);
        KEY_CODE_TO_JME.put(KeyCode.DIGIT8, 9);
        KEY_CODE_TO_JME.put(KeyCode.DIGIT9, 10);
        KEY_CODE_TO_JME.put(KeyCode.MINUS, 12);
        KEY_CODE_TO_JME.put(KeyCode.EQUALS, 13);
        KEY_CODE_TO_JME.put(KeyCode.BACK_SPACE, 14);
        KEY_CODE_TO_JME.put(KeyCode.TAB, 15);
        KEY_CODE_TO_JME.put(KeyCode.Q, 16);
        KEY_CODE_TO_JME.put(KeyCode.W, 17);
        KEY_CODE_TO_JME.put(KeyCode.E, 18);
        KEY_CODE_TO_JME.put(KeyCode.R, 19);
        KEY_CODE_TO_JME.put(KeyCode.T, 20);
        KEY_CODE_TO_JME.put(KeyCode.U, 22);
        KEY_CODE_TO_JME.put(KeyCode.I, 23);
        KEY_CODE_TO_JME.put(KeyCode.O, 24);
        KEY_CODE_TO_JME.put(KeyCode.P, 25);
        KEY_CODE_TO_JME.put(KeyCode.OPEN_BRACKET, 26);
        KEY_CODE_TO_JME.put(KeyCode.CLOSE_BRACKET, 27);
        KEY_CODE_TO_JME.put(KeyCode.ENTER, 28);
        KEY_CODE_TO_JME.put(KeyCode.CONTROL, 29);
        KEY_CODE_TO_JME.put(KeyCode.A, 30);
        KEY_CODE_TO_JME.put(KeyCode.S, 31);
        KEY_CODE_TO_JME.put(KeyCode.D, 32);
        KEY_CODE_TO_JME.put(KeyCode.F, 33);
        KEY_CODE_TO_JME.put(KeyCode.G, 34);
        KEY_CODE_TO_JME.put(KeyCode.H, 35);
        KEY_CODE_TO_JME.put(KeyCode.J, 36);
        KEY_CODE_TO_JME.put(KeyCode.Y, 21);
        KEY_CODE_TO_JME.put(KeyCode.K, 37);
        KEY_CODE_TO_JME.put(KeyCode.L, 38);
        KEY_CODE_TO_JME.put(KeyCode.SEMICOLON, 39);
        KEY_CODE_TO_JME.put(KeyCode.QUOTE, 40);
        KEY_CODE_TO_JME.put(KeyCode.DEAD_GRAVE, 41);
        KEY_CODE_TO_JME.put(KeyCode.SHIFT, 42);
        KEY_CODE_TO_JME.put(KeyCode.BACK_SLASH, 43);
        KEY_CODE_TO_JME.put(KeyCode.Z, 44);
        KEY_CODE_TO_JME.put(KeyCode.X, 45);
        KEY_CODE_TO_JME.put(KeyCode.C, 46);
        KEY_CODE_TO_JME.put(KeyCode.V, 47);
        KEY_CODE_TO_JME.put(KeyCode.B, 48);
        KEY_CODE_TO_JME.put(KeyCode.N, 49);
        KEY_CODE_TO_JME.put(KeyCode.M, 50);
        KEY_CODE_TO_JME.put(KeyCode.COMMA, 51);
        KEY_CODE_TO_JME.put(KeyCode.PERIOD, 52);
        KEY_CODE_TO_JME.put(KeyCode.SLASH, 53);
        KEY_CODE_TO_JME.put(KeyCode.MULTIPLY, 55);
        KEY_CODE_TO_JME.put(KeyCode.SPACE, 57);
        KEY_CODE_TO_JME.put(KeyCode.CAPS, 58);
        KEY_CODE_TO_JME.put(KeyCode.F1, 59);
        KEY_CODE_TO_JME.put(KeyCode.F2, 60);
        KEY_CODE_TO_JME.put(KeyCode.F3, 61);
        KEY_CODE_TO_JME.put(KeyCode.F4, 62);
        KEY_CODE_TO_JME.put(KeyCode.F5, 63);
        KEY_CODE_TO_JME.put(KeyCode.F6, 64);
        KEY_CODE_TO_JME.put(KeyCode.F7, 65);
        KEY_CODE_TO_JME.put(KeyCode.F8, 66);
        KEY_CODE_TO_JME.put(KeyCode.F9, 67);
        KEY_CODE_TO_JME.put(KeyCode.F10, 68);
        KEY_CODE_TO_JME.put(KeyCode.NUM_LOCK, 69);
        KEY_CODE_TO_JME.put(KeyCode.SCROLL_LOCK, 70);
        KEY_CODE_TO_JME.put(KeyCode.NUMPAD7, 71);
        KEY_CODE_TO_JME.put(KeyCode.NUMPAD8, 72);
        KEY_CODE_TO_JME.put(KeyCode.NUMPAD9, 73);
        KEY_CODE_TO_JME.put(KeyCode.SUBTRACT, 74);
        KEY_CODE_TO_JME.put(KeyCode.NUMPAD4, 75);
        KEY_CODE_TO_JME.put(KeyCode.NUMPAD5, 76);
        KEY_CODE_TO_JME.put(KeyCode.NUMPAD6, 77);
        KEY_CODE_TO_JME.put(KeyCode.ADD, 78);
        KEY_CODE_TO_JME.put(KeyCode.NUMPAD1, 79);
        KEY_CODE_TO_JME.put(KeyCode.NUMPAD2, 80);
        KEY_CODE_TO_JME.put(KeyCode.NUMPAD3, 81);
        KEY_CODE_TO_JME.put(KeyCode.NUMPAD0, 82);
        KEY_CODE_TO_JME.put(KeyCode.DECIMAL, 83);
        KEY_CODE_TO_JME.put(KeyCode.F11, 87);
        KEY_CODE_TO_JME.put(KeyCode.F12, 88);
        KEY_CODE_TO_JME.put(KeyCode.F13, 100);
        KEY_CODE_TO_JME.put(KeyCode.F14, 101);
        KEY_CODE_TO_JME.put(KeyCode.F15, 102);
        KEY_CODE_TO_JME.put(KeyCode.KANA, 112);
        KEY_CODE_TO_JME.put(KeyCode.CONVERT, 121);
        KEY_CODE_TO_JME.put(KeyCode.NONCONVERT, 123);
        KEY_CODE_TO_JME.put(KeyCode.CIRCUMFLEX, 144);
        KEY_CODE_TO_JME.put(KeyCode.AT, 145);
        KEY_CODE_TO_JME.put(KeyCode.COLON, 146);
        KEY_CODE_TO_JME.put(KeyCode.UNDERSCORE, 147);
        KEY_CODE_TO_JME.put(KeyCode.STOP, 149);
        KEY_CODE_TO_JME.put(KeyCode.DIVIDE, 181);
        KEY_CODE_TO_JME.put(KeyCode.PAUSE, 197);
        KEY_CODE_TO_JME.put(KeyCode.HOME, 199);
        KEY_CODE_TO_JME.put(KeyCode.UP, 200);
        KEY_CODE_TO_JME.put(KeyCode.PAGE_UP, 201);
        KEY_CODE_TO_JME.put(KeyCode.LEFT, 203);
        KEY_CODE_TO_JME.put(KeyCode.RIGHT, 205);
        KEY_CODE_TO_JME.put(KeyCode.END, 207);
        KEY_CODE_TO_JME.put(KeyCode.DOWN, 208);
        KEY_CODE_TO_JME.put(KeyCode.PAGE_DOWN, 209);
        KEY_CODE_TO_JME.put(KeyCode.INSERT, 210);
        KEY_CODE_TO_JME.put(KeyCode.DELETE, 211);
        KEY_CODE_TO_JME.put(KeyCode.ALT, 56);
        KEY_CODE_TO_JME.put(KeyCode.META, 157);
    }
}

