/*
 * Decompiled with CFR 0.152.
 */
package io.tlf.jme.jfx.injme;

import com.sun.javafx.embed.EmbeddedSceneDSInterface;
import com.sun.javafx.embed.EmbeddedSceneDTInterface;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.HostDragStartListener;
import io.tlf.jme.jfx.injme.JmeFxContainerInternal;
import io.tlf.jme.jfx.injme.input.JmeFXInputListener;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Clipboard;
import javafx.scene.input.TransferMode;

public class JmeFxDnDHandler
implements HostDragStartListener {
    private static final Logger LOGGER = Logger.getLogger(JmeFxDnDHandler.class.getName());
    private JmeFxContainerInternal container;
    private EmbeddedSceneDTInterface dropTarget;
    private EmbeddedSceneDSInterface dragSource;
    private TransferMode transferMode;
    private ImageView dragImage;

    public JmeFxDnDHandler(JmeFxContainerInternal container) {
        this.container = container;
    }

    private void createDragImageProxy(Object image, Object offset) {
        if (!(image instanceof ByteBuffer)) {
            return;
        }
        try {
            ByteBuffer imageData = (ByteBuffer)image;
            imageData.position(0);
            int width = imageData.getInt();
            int height = imageData.getInt();
            byte[] pixels = new byte[imageData.remaining()];
            imageData.get(pixels);
            WritableImage resultImage = new WritableImage(width, height);
            PixelWriter writer = resultImage.getPixelWriter();
            writer.setPixels(0, 0, width, height, (PixelFormat)PixelFormat.getByteBgraInstance(), pixels, 0, width * 4);
            this.dragImage = new ImageView((Image)resultImage);
            this.dragImage.setStyle("dragimage:true;");
            this.dragImage.setMouseTransparent(true);
            this.dragImage.setVisible(true);
            if (offset instanceof ByteBuffer) {
                ByteBuffer offsetBuffer = (ByteBuffer)offset;
                offsetBuffer.position(0);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, null, e);
        }
    }

    public void dragStarted(EmbeddedSceneDSInterface dragSource, TransferMode transferMode) {
        JmeFxContainerInternal container = this.getContainer();
        Group rootNode = container.getRootNode();
        JmeFXInputListener inputListener = container.getInputListener();
        EmbeddedSceneInterface sceneInterface = container.getSceneInterface();
        if (rootNode == null) {
            LOGGER.warning("The root node is null.");
            return;
        }
        if (inputListener == null) {
            LOGGER.warning("The input listener is null.");
            return;
        }
        if (sceneInterface == null) {
            LOGGER.warning("The scene interface is null.");
            return;
        }
        if (this.dragImage != null) {
            rootNode.getChildren().remove((Object)this.dragImage);
            this.dragImage = null;
        }
        try {
            Object dragImage = dragSource.getData("application/x-java-drag-image");
            Object offset = dragSource.getData("application/x-java-drag-image-offset");
            if (dragImage != null) {
                this.createDragImageProxy(dragImage, offset);
            }
            inputListener.setMouseDNDListener(this);
            assert (transferMode == TransferMode.COPY) : "Only Copy is supported currently";
            Clipboard clipboard = Clipboard.getSystemClipboard();
            this.dragSource = dragSource;
            this.dropTarget = sceneInterface.createDropTarget();
            this.dropTarget.handleDragEnter(0, 0, 0, 0, TransferMode.COPY, dragSource);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, null, e);
        }
    }

    private ImageView getDragImage() {
        return this.dragImage;
    }

    private JmeFxContainerInternal getContainer() {
        return this.container;
    }

    private EmbeddedSceneDSInterface getDragSource() {
        return this.dragSource;
    }

    private EmbeddedSceneDTInterface getDropTarget() {
        return this.dropTarget;
    }

    public void mouseUpdate(int x, int y, boolean mousePressed) {
        EmbeddedSceneDSInterface dragSource = this.getDragSource();
        EmbeddedSceneDTInterface dropTarget = this.getDropTarget();
        if (dragSource == null) {
            LOGGER.warning("The drag source is null.");
            return;
        }
        if (dropTarget == null) {
            LOGGER.warning("The drop target is null.");
            return;
        }
        JmeFxContainerInternal container = this.getContainer();
        Group rootNode = container.getRootNode();
        JmeFXInputListener inputListener = container.getInputListener();
        EmbeddedSceneInterface sceneInterface = container.getSceneInterface();
        if (rootNode == null) {
            LOGGER.warning("The root node is null.");
            return;
        }
        if (inputListener == null) {
            LOGGER.warning("The input listener is null.");
            return;
        }
        if (sceneInterface == null) {
            LOGGER.warning("The scene interface is null.");
            return;
        }
        ObservableList children = rootNode.getChildren();
        ImageView dragImage = this.getDragImage();
        try {
            if (mousePressed) {
                if (dragImage != null) {
                    dragImage.relocate((double)x, (double)y);
                    if (!children.contains((Object)dragImage)) {
                        children.add((Object)dragImage);
                    }
                }
                this.transferMode = dropTarget.handleDragOver(x, y, x, y, TransferMode.COPY);
            } else {
                if (dragImage != null) {
                    dragImage.setVisible(false);
                }
                if (this.transferMode != null) {
                    this.transferMode = dropTarget.handleDragOver(x, y, x, y, TransferMode.COPY);
                    TransferMode acceptedMode = dropTarget.handleDragDrop(x, y, x, y, TransferMode.COPY);
                    dragSource.dragDropEnd(acceptedMode);
                } else {
                    dropTarget.handleDragLeave();
                    dragSource.dragDropEnd(null);
                }
                inputListener.setMouseDNDListener(null);
                this.dragSource = null;
                this.dropTarget = null;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, null, e);
        }
    }
}

