/*
 * Decompiled with CFR 0.152.
 */
package io.tlf.jme.jfx.injme;

import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.EmbeddedStageInterface;
import com.sun.javafx.embed.HostDragStartListener;
import com.sun.javafx.embed.HostInterface;
import io.tlf.jme.jfx.injme.JmeFxContainerInternal;
import io.tlf.jme.jfx.injme.JmeFxDnDHandler;
import java.util.logging.Logger;

public class JmeFxHostInterface
implements HostInterface {
    private static final Logger LOGGER = Logger.getLogger(JmeFxHostInterface.class.getName());
    private final JmeFxContainerInternal container;

    public JmeFxHostInterface(JmeFxContainerInternal container) {
        this.container = container;
    }

    private JmeFxContainerInternal getContainer() {
        return this.container;
    }

    public boolean grabFocus() {
        return true;
    }

    public void repaint() {
        this.getContainer().requestRedraw();
    }

    public boolean requestFocus() {
        return this.getContainer().requestFocus();
    }

    public void setCursor(CursorFrame cursorFrame) {
        this.getContainer().requestShowingCursor(cursorFrame);
    }

    public void setEmbeddedScene(EmbeddedSceneInterface sceneInterface) {
        JmeFxContainerInternal container = this.getContainer();
        EmbeddedSceneInterface currentSceneInterface = container.getSceneInterface();
        if (currentSceneInterface != null) {
            // empty if block
        }
        container.setSceneInterface(sceneInterface);
        if (sceneInterface == null) {
            return;
        }
        float scaleFactor = container.getPixelScaleFactor();
        sceneInterface.setPixelScaleFactors(scaleFactor, scaleFactor);
        int width = container.getSceneWidth();
        int height = container.getSceneHeight();
        if (width > 0 && height > 0) {
            sceneInterface.setSize(width, height);
        }
        sceneInterface.setDragStartListener((HostDragStartListener)new JmeFxDnDHandler(container));
    }

    public void setEmbeddedStage(EmbeddedStageInterface stageInterface) {
        JmeFxContainerInternal container = this.getContainer();
        EmbeddedStageInterface currentStageInterface = container.getStageInterface();
        if (currentStageInterface != null) {
            // empty if block
        }
        container.setStageInterface(stageInterface);
        if (stageInterface == null) {
            return;
        }
        int width = container.getSceneWidth();
        int height = container.getSceneHeight();
        if (width > 0 && height > 0) {
            stageInterface.setSize(width, height);
        }
        stageInterface.setFocused(true, 0);
    }

    public void setEnabled(boolean enabled) {
        this.getContainer().requestEnabled(enabled);
    }

    public void setPreferredSize(int width, int height) {
        this.getContainer().requestPreferredSize(width, height);
    }

    public boolean traverseFocusOut(boolean forward) {
        return true;
    }

    public void ungrabFocus() {
    }
}

