/*
 * Decompiled with CFR 0.152.
 */
package io.tlf.jme.jfx.injme.util;

import com.jme3.app.Application;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.lwjgl.LwjglWindow;
import com.jme3.util.BufferUtils;
import java.nio.IntBuffer;
import org.lwjgl.glfw.GLFW;

public class JmeWindowUtils {
    private static final ThreadLocal<IntBuffer> LOCAL_FIRST_INT_BUFFER = ThreadLocal.withInitial(() -> BufferUtils.createIntBuffer((int)1));
    private static final ThreadLocal<IntBuffer> LOCAL_SECOND_INT_BUFFER = ThreadLocal.withInitial(() -> BufferUtils.createIntBuffer((int)1));

    public static int getX(JmeContext context) {
        LwjglWindow lwjglContext = (LwjglWindow)context;
        long windowHandle = lwjglContext.getWindowHandle();
        IntBuffer x = LOCAL_FIRST_INT_BUFFER.get();
        IntBuffer y = LOCAL_SECOND_INT_BUFFER.get();
        x.clear();
        y.clear();
        GLFW.glfwGetWindowPos((long)windowHandle, (IntBuffer)x, (IntBuffer)y);
        return x.get(0);
    }

    public static int getY(JmeContext context) {
        LwjglWindow lwjglContext = (LwjglWindow)context;
        long windowHandle = lwjglContext.getWindowHandle();
        IntBuffer x = LOCAL_FIRST_INT_BUFFER.get();
        IntBuffer y = LOCAL_SECOND_INT_BUFFER.get();
        x.clear();
        y.clear();
        GLFW.glfwGetWindowPos((long)windowHandle, (IntBuffer)x, (IntBuffer)y);
        return y.get(0);
    }

    public static int getWidth(JmeContext context) {
        LwjglWindow lwjglContext = (LwjglWindow)context;
        long windowHandle = lwjglContext.getWindowHandle();
        IntBuffer width = LOCAL_FIRST_INT_BUFFER.get();
        IntBuffer height = LOCAL_SECOND_INT_BUFFER.get();
        width.clear();
        height.clear();
        GLFW.glfwGetWindowSize((long)windowHandle, (IntBuffer)width, (IntBuffer)height);
        return width.get(0);
    }

    public static int getHeight(JmeContext context) {
        LwjglWindow lwjglContext = (LwjglWindow)context;
        long windowHandle = lwjglContext.getWindowHandle();
        IntBuffer width = LOCAL_FIRST_INT_BUFFER.get();
        IntBuffer height = LOCAL_SECOND_INT_BUFFER.get();
        width.clear();
        height.clear();
        GLFW.glfwGetWindowSize((long)windowHandle, (IntBuffer)width, (IntBuffer)height);
        return height.get(0);
    }

    public static boolean isFullscreen(JmeContext jmeContext) {
        AppSettings settings = jmeContext.getSettings();
        return settings.isFullscreen();
    }

    public static void requestFocus(Application application) {
        LwjglWindow lwjglContext = (LwjglWindow)application.getContext();
        GLFW.glfwShowWindow((long)lwjglContext.getWindowHandle());
    }
}

