/*
 * Decompiled with CFR 0.152.
 */
package io.tmio.embeddedcassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import io.tmio.embeddedcassandra.EmbeddedCassandraConfig;
import io.tmio.embeddedcassandra.EmbeddedCassandraConfig$;
import io.tmio.embeddedcassandra.EmbeddedCassandraSupport;
import java.io.File;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.commons.io.FileUtils;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;

public abstract class EmbeddedCassandraSupport$class {
    public static Object withRunningCassandra(EmbeddedCassandraSupport $this, EmbeddedCassandraConfig config, Function0 body) {
        $this.start(config);
        try {
            return body.apply();
        }
        finally {
            $this.stop();
        }
    }

    public static EmbeddedCassandraConfig withRunningCassandra$default$1(EmbeddedCassandraSupport $this) {
        return new EmbeddedCassandraConfig(EmbeddedCassandraConfig$.MODULE$.$lessinit$greater$default$1(), EmbeddedCassandraConfig$.MODULE$.$lessinit$greater$default$2(), EmbeddedCassandraConfig$.MODULE$.$lessinit$greater$default$3());
    }

    public static void start(EmbeddedCassandraSupport $this, EmbeddedCassandraConfig config) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Starting Embedded Cassandra");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        EmbeddedCassandraSupport$class.configure($this, config);
        EmbeddedCassandraServerHelper.startEmbeddedCassandra((File)EmbeddedCassandraSupport$class.configFile($this, config), (String)config.dataFolder(), (long)config.startupTimeout());
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Started Embedded Cassandra");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static void stop(EmbeddedCassandraSupport $this) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Stopping Embedded Cassandra");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Stopped Embedded Cassandra");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static String clusterName(EmbeddedCassandraSupport $this) {
        return DatabaseDescriptor.getClusterName();
    }

    public static String host(EmbeddedCassandraSupport $this) {
        return DatabaseDescriptor.getRpcAddress().getHostName();
    }

    public static int rpcPort(EmbeddedCassandraSupport $this) {
        return DatabaseDescriptor.getRpcPort();
    }

    public static int nativeTransportPort(EmbeddedCassandraSupport $this) {
        return DatabaseDescriptor.getNativeTransportPort();
    }

    /*
     * WARNING - void declaration
     */
    public static Object runInSession(EmbeddedCassandraSupport $this, Function0 body) {
        Object object;
        Cluster cluster = Cluster.builder().addContactPoint($this.host()).withPort($this.nativeTransportPort()).build();
        Session session = cluster.connect();
        try {
            object = ((Function1)body.apply()).apply((Object)session);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        cluster.close();
        return object;
    }

    private static String configFileContents(EmbeddedCassandraSupport $this, EmbeddedCassandraConfig config) {
        Option option;
        block4: {
            String string;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)config.yamlResource());
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String resource = (String)some.x();
                    string = Source$.MODULE$.fromFile(resource, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                string = Source$.MODULE$.fromInputStream($this.getClass().getResourceAsStream("/cu-cassandra.yaml"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
            }
            return string;
        }
        throw new MatchError((Object)option);
    }

    private static void configure(EmbeddedCassandraSupport $this, EmbeddedCassandraConfig config) {
        File cassandraDirectory = new File(config.dataFolder());
        FileUtils.deleteDirectory((File)cassandraDirectory);
        cassandraDirectory.mkdirs();
        File ymlFile = EmbeddedCassandraSupport$class.configFile($this, config);
        FileUtils.writeStringToFile((File)ymlFile, (String)EmbeddedCassandraSupport$class.configFileContents($this, config), (String)"UTF-8");
    }

    private static File configFile(EmbeddedCassandraSupport $this, EmbeddedCassandraConfig config) {
        File cassandraDirectory = new File(config.dataFolder());
        return new File(cassandraDirectory, "cassandra.yml");
    }

    public static void $init$(EmbeddedCassandraSupport $this) {
    }
}

