/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tuweni.config.Configuration;
import org.apache.tuweni.config.Schema;
import org.apache.tuweni.toml.Toml;

final class TomlSerializer {
    private static final String LINE_SPLITTER = "\\r?\\n";
    private final Configuration configuration;
    private final Schema schema;
    private final Map<String, List<String>> tableMap;
    private final Map<String, String> keyMap;

    TomlSerializer(Configuration configuration, Schema schema) {
        HashMap<String, List<String>> tableMap = new HashMap<String, List<String>>();
        HashMap<String, String> keyMap = new HashMap<String, String>();
        configuration.keySet().forEach(configKey -> {
            List keyPath;
            try {
                keyPath = Toml.parseDottedKey((String)configKey);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Configuration key '" + configKey + "' is not valid in TOML");
            }
            String tableKey = Toml.joinKeyPath(keyPath.subList(0, keyPath.size() - 1));
            ArrayList<String> keys = (ArrayList<String>)tableMap.get(tableKey);
            if (keys == null) {
                keys = new ArrayList<String>();
                tableMap.put(tableKey, keys);
            }
            keys.add((String)configKey);
            keyMap.put((String)configKey, (String)keyPath.get(keyPath.size() - 1));
        });
        this.configuration = configuration;
        this.schema = schema;
        this.tableMap = tableMap;
        this.keyMap = keyMap;
    }

    void writeTo(Appendable appendable) throws IOException {
        List tableKeys = this.tableMap.keySet().stream().sorted().collect(Collectors.toList());
        Iterator iterator = tableKeys.iterator();
        while (iterator.hasNext()) {
            String tableKey = (String)iterator.next();
            if (!tableKey.isEmpty()) {
                this.writeDocumentation(tableKey, appendable);
            }
            if (!tableKey.isEmpty()) {
                appendable.append('[');
                appendable.append(tableKey);
                appendable.append(']');
                appendable.append(System.lineSeparator());
            }
            List<String> configKeys = this.tableMap.get(tableKey);
            configKeys.sort(Comparator.naturalOrder());
            for (String configKey : configKeys) {
                String leafName = this.keyMap.get(configKey);
                Object obj = this.configuration.get(configKey);
                if (obj == null) {
                    throw new IllegalStateException("Configuration key '" + configKey + "' was unexpectedly null");
                }
                Object defaultValue = this.schema.getDefault(configKey);
                if (obj instanceof Integer) {
                    obj = ((Integer)obj).longValue();
                }
                if (defaultValue instanceof Integer) {
                    defaultValue = ((Integer)defaultValue).longValue();
                }
                this.writeDocumentation(configKey, appendable);
                String leafKey = Toml.joinKeyPath(Collections.singletonList(leafName));
                if (defaultValue != null) {
                    appendable.append('#');
                    appendable.append(leafKey);
                    appendable.append(" = ");
                    this.writeValue(defaultValue, appendable);
                    appendable.append(System.lineSeparator());
                }
                if (obj.equals(defaultValue)) continue;
                appendable.append(leafKey);
                appendable.append(" = ");
                this.writeValue(obj, appendable);
                appendable.append(System.lineSeparator());
            }
            if (!iterator.hasNext()) continue;
            appendable.append(System.lineSeparator());
        }
    }

    private void writeValue(Object obj, Appendable appendable) throws IOException {
        if (obj instanceof String) {
            appendable.append('\"');
            appendable.append(Toml.tomlEscape((String)((String)obj)));
            appendable.append('\"');
        } else if (obj instanceof List) {
            List list = (List)obj;
            this.writeList(list, appendable);
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            this.writeMap(map, appendable);
        } else {
            appendable.append(obj.toString());
        }
    }

    private void writeList(List<Object> list, Appendable appendable) throws IOException {
        appendable.append('[');
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj == null) {
                throw new IllegalStateException("Unexpected null in list property");
            }
            this.writeValue(obj, appendable);
            if (!iterator.hasNext()) continue;
            appendable.append(", ");
        }
        appendable.append(']');
    }

    private void writeMap(Map<String, Object> map, Appendable appendable) throws IOException {
        appendable.append('{');
        Iterator iterator = map.keySet().stream().sorted().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object obj = map.get(key);
            if (obj == null) {
                throw new IllegalStateException("Unexpected null in map property");
            }
            appendable.append(Toml.joinKeyPath(Collections.singletonList(key)));
            appendable.append(" = ");
            this.writeValue(obj, appendable);
            if (!iterator.hasNext()) continue;
            appendable.append(", ");
        }
        appendable.append('}');
    }

    private void writeDocumentation(String key, Appendable appendable) throws IOException {
        String description = this.schema.description(Configuration.canonicalKey(key));
        if (description == null) {
            return;
        }
        for (String line : description.split(LINE_SPLITTER, -1)) {
            appendable.append("## ");
            appendable.append(line);
            appendable.append(System.lineSeparator());
        }
    }
}

