/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.kademlia;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.tuweni.kademlia.KademliaRoutingTable;
import org.apache.tuweni.kademlia.KademliaRoutingTableKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\u0018\u0000 5*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u000245BI\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\t\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u001b\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u0017\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\u00020\u001e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016J\u0013\u0010$\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010 J\u000b\u0010%\u001a\u00028\u0000\u00a2\u0006\u0002\u0010&J\u0015\u0010'\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\u001eH\u0016J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+H\u0096\u0002J\u0013\u0010,\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010-J\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000/2\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0006J\u0014\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000/2\u0006\u00103\u001a\u00020\u0006R\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00066"}, d2={"Lorg/apache/tuweni/kademlia/KademliaRoutingTable;", "T", "", "selfId", "", "k", "", "maxReplacements", "nodeId", "Lkotlin/Function1;", "distanceToSelf", "([BIILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "buckets", "", "Lorg/apache/tuweni/kademlia/KademliaRoutingTable$Bucket;", "[Lorg/apache/tuweni/kademlia/KademliaRoutingTable$Bucket;", "distanceCache", "Lcom/google/common/cache/Cache;", "idBitSize", "size", "getSize", "()I", "add", "node", "(Ljava/lang/Object;)Ljava/lang/Object;", "bucketFor", "(Ljava/lang/Object;)Lorg/apache/tuweni/kademlia/KademliaRoutingTable$Bucket;", "clear", "", "contains", "", "element", "(Ljava/lang/Object;)Z", "containsAll", "elements", "", "evict", "getRandom", "()Ljava/lang/Object;", "idForNode", "(Ljava/lang/Object;)[B", "isEmpty", "iterator", "", "logDistToSelf", "(Ljava/lang/Object;)I", "nearest", "", "targetId", "limit", "peersOfDistance", "value", "Bucket", "Companion", "kademlia"})
@SourceDebugExtension(value={"SMAP\nKademliaRoutingTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KademliaRoutingTable.kt\norg/apache/tuweni/kademlia/KademliaRoutingTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,341:1\n1#2:342\n12990#3,3:343\n13579#3:346\n13580#3:350\n13579#3,2:351\n3792#3:353\n4307#3,2:354\n766#4:347\n857#4,2:348\n*S KotlinDebug\n*F\n+ 1 KademliaRoutingTable.kt\norg/apache/tuweni/kademlia/KademliaRoutingTable\n*L\n156#1:343,3\n180#1:346\n180#1:350\n235#1:351,2\n250#1:353\n250#1:354,2\n181#1:347\n181#1:348,2\n*E\n"})
public final class KademliaRoutingTable<T>
implements Set<T>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] selfId;
    @NotNull
    private final Function1<T, byte[]> nodeId;
    @NotNull
    private final Function1<T, Integer> distanceToSelf;
    private final int idBitSize;
    @NotNull
    private final Bucket<T>[] buckets;
    @NotNull
    private final Cache<T, Integer> distanceCache;

    public KademliaRoutingTable(@NotNull byte[] selfId, int k, int maxReplacements, @NotNull Function1<? super T, byte[]> nodeId, @NotNull Function1<? super T, Integer> distanceToSelf) {
        Intrinsics.checkNotNullParameter((Object)selfId, (String)"selfId");
        Intrinsics.checkNotNullParameter(nodeId, (String)"nodeId");
        Intrinsics.checkNotNullParameter(distanceToSelf, (String)"distanceToSelf");
        this.selfId = selfId;
        this.nodeId = nodeId;
        this.distanceToSelf = distanceToSelf;
        if (!(!(this.selfId.length == 0))) {
            boolean $i$a$-require-KademliaRoutingTable$42 = false;
            String $i$a$-require-KademliaRoutingTable$42 = "self id must not be empty";
            throw new IllegalArgumentException($i$a$-require-KademliaRoutingTable$42.toString());
        }
        if (!(k > 0)) {
            boolean bl = false;
            String string = "k value must be positive";
            throw new IllegalArgumentException(string.toString());
        }
        this.idBitSize = this.selfId.length * 8;
        int n = 0;
        int n2 = this.idBitSize + 1;
        Bucket[] bucketArray = new Bucket[n2];
        KademliaRoutingTable kademliaRoutingTable = this;
        while (n < n2) {
            int n3 = n++;
            bucketArray[n3] = new Bucket(k, maxReplacements);
        }
        kademliaRoutingTable.buckets = bucketArray;
        Cache cache = CacheBuilder.newBuilder().maximumSize((1L + (long)this.idBitSize) * (long)k).weakKeys().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"newBuilder().maximumSize\u2026) * k).weakKeys().build()");
        this.distanceCache = cache;
    }

    public /* synthetic */ KademliaRoutingTable(final byte[] byArray, int n, int n2, final Function1 function1, Function1 function12, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        if ((n3 & 0x10) != 0) {
            function12 = new Function1<T, Integer>(){

                @NotNull
                public final Integer invoke(T it) {
                    return KademliaRoutingTableKt.xorDist((byte[])function1.invoke(it), byArray);
                }
            };
        }
        this(byArray, n, n2, function1, function12);
    }

    /*
     * WARNING - void declaration
     */
    public int getSize() {
        void $this$fold$iv;
        Bucket<T>[] bucketArray = this.buckets;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int j = 0; j < n; ++j) {
            void bucket;
            void element$iv;
            void var8_8 = element$iv = $this$fold$iv[j];
            int acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc + bucket.size();
        }
        return accumulator$iv;
    }

    @Override
    public boolean isEmpty() {
        Bucket<T> bucket;
        block1: {
            Bucket<T>[] bucketArray = this.buckets;
            int n = bucketArray.length;
            for (int j = 0; j < n; ++j) {
                Bucket<T> bucket2;
                Bucket<T> bucket3 = bucket2 = bucketArray[j];
                boolean bl = false;
                if (!(!bucket3.isEmpty())) continue;
                bucket = bucket2;
                break block1;
            }
            bucket = null;
        }
        return bucket == null;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])this.buckets), (Function1)iterator.1.INSTANCE).iterator();
    }

    @Override
    public boolean contains(Object element) {
        return this.bucketFor(element).contains(element);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Set peers = CollectionsKt.toMutableSet((Iterable)elements);
        Bucket<T>[] $this$forEach$iv = this.buckets;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Bucket<T> element$iv;
            Bucket<T> bucket = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            Iterable iterable = peers;
            Set set = peers;
            boolean $i$f$filter = false;
            void var13_13 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv;
                Object peer = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                if (!bucket.contains(peer)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            set.removeAll((List)destination$iv$iv);
            if (!peers.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final List<T> nearest(@NotNull byte[] targetId, int limit) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        List results = new ArrayList();
        for (Bucket<T> bucket : this.buckets) {
            ArrayList bucketView = new ArrayList(bucket);
            for (Object node : bucketView) {
                byte[] nodeId = this.idForNode(node);
                KademliaRoutingTableKt.orderedInsert(results, node, (Function2)new Function2<T, T, Integer>(targetId, this, nodeId){
                    final /* synthetic */ byte[] $targetId;
                    final /* synthetic */ KademliaRoutingTable<T> this$0;
                    final /* synthetic */ byte[] $nodeId;
                    {
                        this.$targetId = $targetId;
                        this.this$0 = $receiver;
                        this.$nodeId = $nodeId;
                        super(2);
                    }

                    @NotNull
                    public final Integer invoke(T a, T t) {
                        return KademliaRoutingTableKt.xorDistCmp(this.$targetId, KademliaRoutingTable.access$idForNode(this.this$0, a), this.$nodeId);
                    }
                });
                if (results.size() <= limit) continue;
                results.remove(CollectionsKt.getLastIndex((List)results));
            }
        }
        return results;
    }

    @Nullable
    public final T add(T node) {
        return this.bucketFor(node).add(node);
    }

    public final boolean evict(T node) {
        return this.bucketFor(node).evict(node);
    }

    @Override
    public final void clear() {
        Bucket<T>[] $this$forEach$iv = this.buckets;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            Bucket<T> element$iv;
            Bucket<T> bucket = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            bucket.clear();
        }
    }

    @NotNull
    public final List<T> peersOfDistance(int value) {
        return CollectionsKt.toList((Iterable)this.buckets[value]);
    }

    /*
     * WARNING - void declaration
     */
    public final T getRandom() {
        void $this$filterTo$iv$iv;
        Bucket<T>[] $this$filter$iv = this.buckets;
        boolean $i$f$filter = false;
        Bucket<T>[] bucketArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl = false;
            if (!(!it.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (T)CollectionsKt.random((Collection)((Collection)CollectionsKt.random((Collection)((List)destination$iv$iv), (Random)((Random)Random.Default))), (Random)((Random)Random.Default));
    }

    public final int logDistToSelf(T node) {
        if (node == null) {
            return 0;
        }
        Object object = this.distanceCache.get(node, () -> KademliaRoutingTable.logDistToSelf$lambda$8(this, node));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"distanceCache.get(node) { distanceToSelf(node) }");
        return ((Number)object).intValue();
    }

    private final byte[] idForNode(T node) {
        byte[] id = (byte[])this.nodeId.invoke(node);
        if (!(id.length == this.selfId.length)) {
            boolean $i$a$-require-KademliaRoutingTable$idForNode$32 = false;
            String $i$a$-require-KademliaRoutingTable$idForNode$32 = "id obtained for node is not the correct length";
            throw new IllegalArgumentException($i$a$-require-KademliaRoutingTable$idForNode$32.toString());
        }
        if (!(!Arrays.equals(id, this.selfId))) {
            boolean bl = false;
            String string = "id obtained for node is the same as self";
            throw new IllegalArgumentException(string.toString());
        }
        return id;
    }

    private final Bucket<T> bucketFor(T node) {
        return this.buckets[this.logDistToSelf(node)];
    }

    @Override
    public boolean add(T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends T> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    private static final Integer logDistToSelf$lambda$8(KademliaRoutingTable this$0, Object $node) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (Integer)this$0.distanceToSelf.invoke($node);
    }

    @JvmStatic
    @NotNull
    public static final <T> KademliaRoutingTable<T> create(@NotNull byte[] selfId, int k, @NotNull Function<T, byte[]> nodeId, @NotNull Function<T, Integer> distanceToSelf) {
        return Companion.create(selfId, k, nodeId, distanceToSelf);
    }

    @JvmStatic
    @NotNull
    public static final <T> KademliaRoutingTable<T> create(@NotNull byte[] selfId, int k, int maxReplacements, @NotNull Function<T, byte[]> nodeId, @NotNull Function<T, Integer> distanceToSelf) {
        return Companion.create(selfId, k, maxReplacements, nodeId, distanceToSelf);
    }

    public static final /* synthetic */ byte[] access$idForNode(KademliaRoutingTable $this, Object node) {
        return $this.idForNode(node);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006B%\b\u0002\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u000e\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0001H\u0096\u0003\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u0019H\u0096\u0001J\u0013\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u001b\u001a\u00028\u00012\u0006\u0010\u001c\u001a\u00020\u0004H\u0096\u0003\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00028\u0001H\u0096\u0001\u00a2\u0006\u0002\u0010\u001fJ\t\u0010 \u001a\u00020\u0014H\u0096\u0001J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\"H\u0096\u0003J\u0016\u0010#\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00028\u0001H\u0096\u0001\u00a2\u0006\u0002\u0010\u001fJ\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00010%H\u0096\u0001J\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00010%2\u0006\u0010\u001c\u001a\u00020\u0004H\u0096\u0001J\u001f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0096\u0001R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u0004X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006)"}, d2={"Lorg/apache/tuweni/kademlia/KademliaRoutingTable$Bucket;", "E", "", "k", "", "maxReplacements", "(II)V", "entries", "", "(Ljava/util/List;II)V", "replacementCache", "size", "getSize", "()I", "add", "node", "(Ljava/lang/Object;)Ljava/lang/Object;", "clear", "", "contains", "", "element", "(Ljava/lang/Object;)Z", "containsAll", "elements", "", "evict", "get", "index", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "subList", "fromIndex", "toIndex", "kademlia"})
    @SourceDebugExtension(value={"SMAP\nKademliaRoutingTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KademliaRoutingTable.kt\norg/apache/tuweni/kademlia/KademliaRoutingTable$Bucket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,341:1\n1#2:342\n*E\n"})
    private static final class Bucket<E>
    implements List<E>,
    KMappedMarker {
        @NotNull
        private final List<E> entries;
        private final int k;
        private final int maxReplacements;
        @NotNull
        private final List<E> replacementCache;

        private Bucket(List<E> entries, int k, int maxReplacements) {
            this.entries = entries;
            this.k = k;
            this.maxReplacements = maxReplacements;
            this.replacementCache = new ArrayList();
            if (!(this.k > 0)) {
                boolean bl = false;
                String string = "k value must be positive";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public int getSize() {
            return this.entries.size();
        }

        @Override
        public boolean contains(Object element) {
            return this.entries.contains(element);
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.entries.containsAll(elements);
        }

        @Override
        public E get(int index) {
            return this.entries.get(index);
        }

        @Override
        public int indexOf(Object element) {
            return this.entries.indexOf(element);
        }

        @Override
        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return this.entries.iterator();
        }

        @Override
        public int lastIndexOf(Object element) {
            return this.entries.lastIndexOf(element);
        }

        @Override
        @NotNull
        public ListIterator<E> listIterator() {
            return this.entries.listIterator();
        }

        @Override
        @NotNull
        public ListIterator<E> listIterator(int index) {
            return this.entries.listIterator(index);
        }

        @Override
        @NotNull
        public List<E> subList(int fromIndex, int toIndex) {
            return this.entries.subList(fromIndex, toIndex);
        }

        public Bucket(int k, int maxReplacements) {
            List list = Collections.synchronizedList(new ArrayList());
            Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(mutableListOf())");
            this(list, k, maxReplacements);
        }

        @Nullable
        public final synchronized E add(E node) {
            boolean bl;
            this.replacementCache.remove(node);
            int n = this.entries.size();
            for (int i2 = 0; i2 < n; ++i2) {
                if (!Intrinsics.areEqual(this.entries.get(i2), node)) continue;
                this.entries.remove(i2);
                this.entries.add(0, node);
                return null;
            }
            boolean bl2 = bl = this.entries.size() <= this.k;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (this.entries.size() == this.k) {
                boolean bl3 = bl = this.replacementCache.size() <= this.maxReplacements;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                if (this.replacementCache.size() == this.maxReplacements) {
                    this.replacementCache.remove(0);
                }
                this.replacementCache.add(node);
                return (E)CollectionsKt.last(this.entries);
            }
            this.entries.add(0, node);
            return null;
        }

        public final synchronized boolean evict(E node) {
            if (!this.entries.remove(node)) {
                return false;
            }
            if (!this.replacementCache.isEmpty()) {
                E replacement = this.replacementCache.remove(CollectionsKt.getLastIndex(this.replacementCache));
                this.entries.add(0, replacement);
            }
            return true;
        }

        @Override
        public final synchronized void clear() {
            this.entries.clear();
            this.replacementCache.clear();
        }

        @Override
        public boolean add(E element) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> elements) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean addAll(Collection<? extends E> elements) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean remove(Object element) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean removeAll(Collection<? extends Object> elements) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void replaceAll(UnaryOperator<E> p0) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean retainAll(Collection<? extends Object> elements) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public E set(int index, E element) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void sort(Comparator<? super E> p0) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JL\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00070\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\t0\u000bH\u0007JT\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00070\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\t0\u000bH\u0007\u00a8\u0006\u000e"}, d2={"Lorg/apache/tuweni/kademlia/KademliaRoutingTable$Companion;", "", "()V", "create", "Lorg/apache/tuweni/kademlia/KademliaRoutingTable;", "T", "selfId", "", "k", "", "nodeId", "Ljava/util/function/Function;", "distanceToSelf", "maxReplacements", "kademlia"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> KademliaRoutingTable<T> create(@NotNull byte[] selfId, int k, @NotNull Function<T, byte[]> nodeId, @NotNull Function<T, Integer> distanceToSelf) {
            Intrinsics.checkNotNullParameter((Object)selfId, (String)"selfId");
            Intrinsics.checkNotNullParameter(nodeId, (String)"nodeId");
            Intrinsics.checkNotNullParameter(distanceToSelf, (String)"distanceToSelf");
            return new KademliaRoutingTable(selfId, k, 0, new Function1<T, byte[]>(nodeId){

                @NotNull
                public final byte[] invoke(T p0) {
                    return (byte[])((Function)this.receiver).apply(p0);
                }
            }, new Function1<T, Integer>(distanceToSelf){

                @NotNull
                public final Integer invoke(T p0) {
                    return (Integer)((Function)this.receiver).apply(p0);
                }
            }, 4, null);
        }

        @JvmStatic
        @NotNull
        public final <T> KademliaRoutingTable<T> create(@NotNull byte[] selfId, int k, int maxReplacements, @NotNull Function<T, byte[]> nodeId, @NotNull Function<T, Integer> distanceToSelf) {
            Intrinsics.checkNotNullParameter((Object)selfId, (String)"selfId");
            Intrinsics.checkNotNullParameter(nodeId, (String)"nodeId");
            Intrinsics.checkNotNullParameter(distanceToSelf, (String)"distanceToSelf");
            return new KademliaRoutingTable(selfId, k, maxReplacements, (Function1)new Function1<T, byte[]>(nodeId){

                @NotNull
                public final byte[] invoke(T p0) {
                    return (byte[])((Function)this.receiver).apply(p0);
                }
            }, (Function1)new Function1<T, Integer>(distanceToSelf){

                @NotNull
                public final Integer invoke(T p0) {
                    return (Integer)((Function)this.receiver).apply(p0);
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

