/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.net.tls;

import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.tuweni.net.tls.ClientFingerprintTrustManager;
import org.apache.tuweni.net.tls.DelegatingTrustManagerFactory;
import org.apache.tuweni.net.tls.FileBackedFingerprintRepository;
import org.apache.tuweni.net.tls.FingerprintRepository;
import org.apache.tuweni.net.tls.ServerFingerprintTrustManager;
import org.apache.tuweni.net.tls.SingleTrustManagerFactory;
import org.jetbrains.annotations.Nullable;

public final class TrustManagerFactories {
    private TrustManagerFactories() {
    }

    public static TrustManagerFactory recordServerFingerprints(Path knownServersFile) {
        Objects.requireNonNull(knownServersFile);
        return TrustManagerFactories.recordServerFingerprints(new FileBackedFingerprintRepository(knownServersFile));
    }

    public static TrustManagerFactory recordServerFingerprints(FingerprintRepository repository) {
        Objects.requireNonNull(repository);
        return TrustManagerFactories.recordServerFingerprints(repository, true);
    }

    public static TrustManagerFactory recordServerFingerprints(Path knownServersFile, boolean skipCASigned) {
        Objects.requireNonNull(knownServersFile);
        return TrustManagerFactories.recordServerFingerprints((FingerprintRepository)new FileBackedFingerprintRepository(knownServersFile), skipCASigned);
    }

    public static TrustManagerFactory recordServerFingerprints(FingerprintRepository repository, boolean skipCASigned) {
        Objects.requireNonNull(repository);
        return TrustManagerFactories.wrap((X509TrustManager)ServerFingerprintTrustManager.record(repository), skipCASigned);
    }

    public static TrustManagerFactory recordServerFingerprints(Path knownServersFile, TrustManagerFactory tmf) {
        Objects.requireNonNull(knownServersFile);
        Objects.requireNonNull(tmf);
        return TrustManagerFactories.recordServerFingerprints((FingerprintRepository)new FileBackedFingerprintRepository(knownServersFile), tmf);
    }

    public static TrustManagerFactory recordServerFingerprints(FingerprintRepository repository, TrustManagerFactory tmf) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tmf);
        return TrustManagerFactories.wrap((X509TrustManager)ServerFingerprintTrustManager.record(repository), tmf);
    }

    public static TrustManagerFactory trustServerOnFirstUse(Path knownServersFile) {
        Objects.requireNonNull(knownServersFile);
        return TrustManagerFactories.trustServerOnFirstUse(new FileBackedFingerprintRepository(knownServersFile));
    }

    public static TrustManagerFactory trustServerOnFirstUse(FingerprintRepository repository) {
        Objects.requireNonNull(repository);
        return TrustManagerFactories.trustServerOnFirstUse(repository, true);
    }

    public static TrustManagerFactory trustServerOnFirstUse(Path knownServersFile, boolean acceptCASigned) {
        Objects.requireNonNull(knownServersFile);
        return TrustManagerFactories.trustServerOnFirstUse((FingerprintRepository)new FileBackedFingerprintRepository(knownServersFile), acceptCASigned);
    }

    public static TrustManagerFactory trustServerOnFirstUse(FingerprintRepository repository, boolean acceptCASigned) {
        Objects.requireNonNull(repository);
        return TrustManagerFactories.wrap((X509TrustManager)ServerFingerprintTrustManager.tofu(repository), acceptCASigned);
    }

    public static TrustManagerFactory trustServerOnFirstUse(Path knownServersFile, TrustManagerFactory tmf) {
        Objects.requireNonNull(knownServersFile);
        Objects.requireNonNull(tmf);
        return TrustManagerFactories.trustServerOnFirstUse((FingerprintRepository)new FileBackedFingerprintRepository(knownServersFile), tmf);
    }

    public static TrustManagerFactory trustServerOnFirstUse(FingerprintRepository repository, TrustManagerFactory tmf) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tmf);
        return TrustManagerFactories.wrap((X509TrustManager)ServerFingerprintTrustManager.tofu(repository), tmf);
    }

    public static TrustManagerFactory allowlistServers(Path knownServersFile) {
        Objects.requireNonNull(knownServersFile);
        return TrustManagerFactories.allowlistServers(new FileBackedFingerprintRepository(knownServersFile));
    }

    public static TrustManagerFactory allowlistServers(FingerprintRepository repository) {
        Objects.requireNonNull(repository);
        return TrustManagerFactories.allowlistServers(repository, true);
    }

    public static TrustManagerFactory allowlistServers(Path knownServersFile, boolean acceptCASigned) {
        Objects.requireNonNull(knownServersFile);
        return TrustManagerFactories.allowlistServers((FingerprintRepository)new FileBackedFingerprintRepository(knownServersFile), acceptCASigned);
    }

    public static TrustManagerFactory allowlistServers(FingerprintRepository repository, boolean acceptCASigned) {
        Objects.requireNonNull(repository);
        return TrustManagerFactories.wrap((X509TrustManager)ServerFingerprintTrustManager.allowlist(repository), acceptCASigned);
    }

    public static TrustManagerFactory allowlistServers(Path knownServersFile, TrustManagerFactory tmf) {
        Objects.requireNonNull(knownServersFile);
        Objects.requireNonNull(tmf);
        return TrustManagerFactories.allowlistServers((FingerprintRepository)new FileBackedFingerprintRepository(knownServersFile), tmf);
    }

    public static TrustManagerFactory allowlistServers(FingerprintRepository repository, TrustManagerFactory tmf) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tmf);
        return TrustManagerFactories.wrap((X509TrustManager)ServerFingerprintTrustManager.allowlist(repository), tmf);
    }

    public static TrustManagerFactory recordClientFingerprints(Path knownClientsFile) {
        Objects.requireNonNull(knownClientsFile);
        return TrustManagerFactories.recordClientFingerprints(new FileBackedFingerprintRepository(knownClientsFile));
    }

    public static TrustManagerFactory recordClientFingerprints(FingerprintRepository repository) {
        Objects.requireNonNull(repository);
        return TrustManagerFactories.recordClientFingerprints(repository, true);
    }

    public static TrustManagerFactory recordClientFingerprints(Path knownClientsFile, boolean skipCASigned) {
        Objects.requireNonNull(knownClientsFile);
        return TrustManagerFactories.recordClientFingerprints((FingerprintRepository)new FileBackedFingerprintRepository(knownClientsFile), skipCASigned);
    }

    public static TrustManagerFactory recordClientFingerprints(FingerprintRepository repository, boolean skipCASigned) {
        Objects.requireNonNull(repository);
        return TrustManagerFactories.wrap((X509TrustManager)ClientFingerprintTrustManager.record(repository), skipCASigned);
    }

    public static TrustManagerFactory recordClientFingerprints(Path knownClientsFile, TrustManagerFactory tmf) {
        Objects.requireNonNull(knownClientsFile);
        Objects.requireNonNull(tmf);
        return TrustManagerFactories.recordClientFingerprints((FingerprintRepository)new FileBackedFingerprintRepository(knownClientsFile), tmf);
    }

    public static TrustManagerFactory recordClientFingerprints(FingerprintRepository repository, TrustManagerFactory tmf) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tmf);
        return TrustManagerFactories.wrap((X509TrustManager)ClientFingerprintTrustManager.record(repository), tmf);
    }

    public static TrustManagerFactory trustClientOnFirstAccess(Path knownClientsFile) {
        Objects.requireNonNull(knownClientsFile);
        return TrustManagerFactories.trustClientOnFirstAccess(new FileBackedFingerprintRepository(knownClientsFile));
    }

    public static TrustManagerFactory trustClientOnFirstAccess(FingerprintRepository repository) {
        Objects.requireNonNull(repository);
        return TrustManagerFactories.trustClientOnFirstAccess(repository, true);
    }

    public static TrustManagerFactory trustClientOnFirstAccess(Path knownClientsFile, boolean acceptCASigned) {
        Objects.requireNonNull(knownClientsFile);
        return TrustManagerFactories.trustClientOnFirstAccess((FingerprintRepository)new FileBackedFingerprintRepository(knownClientsFile), acceptCASigned);
    }

    public static TrustManagerFactory trustClientOnFirstAccess(FingerprintRepository repository, boolean acceptCASigned) {
        Objects.requireNonNull(repository);
        return TrustManagerFactories.wrap((X509TrustManager)ClientFingerprintTrustManager.tofa(repository), acceptCASigned);
    }

    public static TrustManagerFactory trustClientOnFirstAccess(Path knownClientsFile, TrustManagerFactory tmf) {
        Objects.requireNonNull(knownClientsFile);
        Objects.requireNonNull(tmf);
        return TrustManagerFactories.trustClientOnFirstAccess((FingerprintRepository)new FileBackedFingerprintRepository(knownClientsFile), tmf);
    }

    public static TrustManagerFactory trustClientOnFirstAccess(FingerprintRepository repository, TrustManagerFactory tmf) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tmf);
        return TrustManagerFactories.wrap((X509TrustManager)ClientFingerprintTrustManager.tofa(repository), tmf);
    }

    public static TrustManagerFactory allowlistClients(Path knownClientsFile) {
        Objects.requireNonNull(knownClientsFile);
        return TrustManagerFactories.allowlistClients(new FileBackedFingerprintRepository(knownClientsFile));
    }

    public static TrustManagerFactory allowlistClients(FingerprintRepository repository) {
        Objects.requireNonNull(repository);
        return TrustManagerFactories.allowlistClients(repository, true);
    }

    public static TrustManagerFactory allowlistClients(Path knownClientsFile, boolean acceptCASigned) {
        Objects.requireNonNull(knownClientsFile);
        return TrustManagerFactories.allowlistClients((FingerprintRepository)new FileBackedFingerprintRepository(knownClientsFile), acceptCASigned);
    }

    public static TrustManagerFactory allowlistClients(FingerprintRepository repository, boolean acceptCASigned) {
        Objects.requireNonNull(repository);
        return TrustManagerFactories.wrap((X509TrustManager)ClientFingerprintTrustManager.allowlist(repository), acceptCASigned);
    }

    public static TrustManagerFactory allowlistClients(Path knownClientsFile, TrustManagerFactory tmf) {
        Objects.requireNonNull(knownClientsFile);
        Objects.requireNonNull(tmf);
        return TrustManagerFactories.allowlistClients((FingerprintRepository)new FileBackedFingerprintRepository(knownClientsFile), tmf);
    }

    public static TrustManagerFactory allowlistClients(FingerprintRepository repository, TrustManagerFactory tmf) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(tmf);
        return TrustManagerFactories.wrap((X509TrustManager)ClientFingerprintTrustManager.allowlist(repository), tmf);
    }

    private static TrustManagerFactory wrap(X509TrustManager trustManager, boolean acceptCASigned) {
        return TrustManagerFactories.wrap(trustManager, acceptCASigned ? TrustManagerFactories.defaultTrustManagerFactory() : null);
    }

    private static TrustManagerFactory wrap(X509TrustManager trustManager, @Nullable TrustManagerFactory delegate) {
        if (delegate != null) {
            return new DelegatingTrustManagerFactory(delegate, trustManager);
        }
        return new SingleTrustManagerFactory(trustManager);
    }

    private static TrustManagerFactory defaultTrustManagerFactory() {
        TrustManagerFactory delegate;
        try {
            delegate = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            delegate.init((KeyStore)null);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        return delegate;
    }
}

