/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.bytes.MutableBytes32;
import org.apache.tuweni.units.bigints.UInt256Value;
import org.jetbrains.annotations.Nullable;

public final class UInt256
implements UInt256Value<UInt256> {
    private static final int MAX_CONSTANT = 64;
    private static final BigInteger BI_MAX_CONSTANT = BigInteger.valueOf(64L);
    private static UInt256[] CONSTANTS = new UInt256[65];
    public static final UInt256 MIN_VALUE;
    public static final UInt256 MAX_VALUE;
    public static final UInt256 ZERO;
    public static final UInt256 ONE;
    private static final int INTS_SIZE = 8;
    private static final long LONG_MASK = 0xFFFFFFFFL;
    private static final BigInteger P_2_256;
    private final int[] ints;
    private Integer hashCode;

    public static UInt256 valueOf(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Argument must be positive");
        }
        if (value <= 64L) {
            return CONSTANTS[(int)value];
        }
        return new UInt256(value);
    }

    public static UInt256 valueOf(BigInteger value) {
        if (value.signum() < 0) {
            throw new IllegalArgumentException("Argument must be positive");
        }
        if (value.bitLength() > 256) {
            throw new IllegalArgumentException("Argument is too large to represent a UInt256");
        }
        if (value.compareTo(BI_MAX_CONSTANT) <= 0) {
            return CONSTANTS[value.intValue()];
        }
        int[] ints = new int[8];
        for (int i = 7; i >= 0; --i) {
            ints[i] = value.intValue();
            value = value.shiftRight(32);
        }
        return new UInt256(ints);
    }

    public static UInt256 fromBytes(Bytes bytes) {
        if (bytes instanceof UInt256) {
            return (UInt256)bytes;
        }
        if (bytes instanceof Bytes32) {
            byte[] array = bytes.toArrayUnsafe();
            return new UInt256(new int[]{Byte.toUnsignedInt(array[0]) << 24 | Byte.toUnsignedInt(array[1]) << 16 | Byte.toUnsignedInt(array[2]) << 8 | Byte.toUnsignedInt(array[3]), Byte.toUnsignedInt(array[4]) << 24 | Byte.toUnsignedInt(array[5]) << 16 | Byte.toUnsignedInt(array[6]) << 8 | Byte.toUnsignedInt(array[7]), Byte.toUnsignedInt(array[8]) << 24 | Byte.toUnsignedInt(array[9]) << 16 | Byte.toUnsignedInt(array[10]) << 8 | Byte.toUnsignedInt(array[11]), Byte.toUnsignedInt(array[12]) << 24 | Byte.toUnsignedInt(array[13]) << 16 | Byte.toUnsignedInt(array[14]) << 8 | Byte.toUnsignedInt(array[15]), Byte.toUnsignedInt(array[16]) << 24 | Byte.toUnsignedInt(array[17]) << 16 | Byte.toUnsignedInt(array[18]) << 8 | Byte.toUnsignedInt(array[19]), Byte.toUnsignedInt(array[20]) << 24 | Byte.toUnsignedInt(array[21]) << 16 | Byte.toUnsignedInt(array[22]) << 8 | Byte.toUnsignedInt(array[23]), Byte.toUnsignedInt(array[24]) << 24 | Byte.toUnsignedInt(array[25]) << 16 | Byte.toUnsignedInt(array[26]) << 8 | Byte.toUnsignedInt(array[27]), Byte.toUnsignedInt(array[28]) << 24 | Byte.toUnsignedInt(array[29]) << 16 | Byte.toUnsignedInt(array[30]) << 8 | Byte.toUnsignedInt(array[31])});
        }
        return new UInt256(Bytes32.leftPad((Bytes)bytes));
    }

    public static UInt256 fromHexString(String str) {
        return new UInt256(Bytes32.fromHexStringLenient((CharSequence)str));
    }

    private UInt256(Bytes32 bytes) {
        this.ints = new int[8];
        int i = 0;
        int j = 0;
        while (i < 8) {
            this.ints[i] = bytes.getInt(j);
            ++i;
            j += 4;
        }
    }

    private UInt256(long value) {
        this.ints = new int[8];
        this.ints[6] = (int)(value >>> 32 & 0xFFFFFFFFL);
        this.ints[7] = (int)(value & 0xFFFFFFFFL);
    }

    private UInt256(int[] ints) {
        this.ints = ints;
    }

    public boolean isZero() {
        if (this == ZERO) {
            return true;
        }
        for (int i = 7; i >= 0; --i) {
            if (this.ints[i] == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public UInt256 add(UInt256 value) {
        if (value.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return value;
        }
        int[] result = new int[8];
        boolean constant = true;
        long sum = ((long)this.ints[7] & 0xFFFFFFFFL) + ((long)value.ints[7] & 0xFFFFFFFFL);
        result[7] = (int)(sum & 0xFFFFFFFFL);
        if (result[7] < 0 || result[7] > 64) {
            constant = false;
        }
        for (int i = 6; i >= 0; --i) {
            sum = ((long)this.ints[i] & 0xFFFFFFFFL) + ((long)value.ints[i] & 0xFFFFFFFFL) + (sum >>> 32);
            result[i] = (int)(sum & 0xFFFFFFFFL);
            constant &= result[i] == 0;
        }
        if (constant) {
            return CONSTANTS[result[7]];
        }
        return new UInt256(result);
    }

    @Override
    public UInt256 add(long value) {
        if (value == 0L) {
            return this;
        }
        if (value > 0L && this.isZero()) {
            return UInt256.valueOf(value);
        }
        int[] result = new int[8];
        boolean constant = true;
        long sum = ((long)this.ints[7] & 0xFFFFFFFFL) + (value & 0xFFFFFFFFL);
        result[7] = (int)(sum & 0xFFFFFFFFL);
        if (result[7] < 0 || result[7] > 64) {
            constant = false;
        }
        sum = ((long)this.ints[6] & 0xFFFFFFFFL) + (value >>> 32) + (sum >>> 32);
        result[6] = (int)(sum & 0xFFFFFFFFL);
        constant &= result[6] == 0;
        long signExtent = value >> 63 & 0xFFFFFFFFL;
        for (int i = 5; i >= 0; --i) {
            sum = ((long)this.ints[i] & 0xFFFFFFFFL) + signExtent + (sum >>> 32);
            result[i] = (int)(sum & 0xFFFFFFFFL);
            constant &= result[i] == 0;
        }
        if (constant) {
            return CONSTANTS[result[7]];
        }
        return new UInt256(result);
    }

    @Override
    public UInt256 addMod(UInt256 value, UInt256 modulus) {
        if (modulus.isZero()) {
            throw new ArithmeticException("addMod with zero modulus");
        }
        return UInt256.valueOf(this.toUnsignedBigInteger().add(value.toUnsignedBigInteger()).mod(modulus.toUnsignedBigInteger()));
    }

    @Override
    public UInt256 addMod(long value, UInt256 modulus) {
        if (modulus.isZero()) {
            throw new ArithmeticException("addMod with zero modulus");
        }
        return UInt256.valueOf(this.toUnsignedBigInteger().add(BigInteger.valueOf(value)).mod(modulus.toUnsignedBigInteger()));
    }

    @Override
    public UInt256 addMod(long value, long modulus) {
        if (modulus == 0L) {
            throw new ArithmeticException("addMod with zero modulus");
        }
        if (modulus < 0L) {
            throw new ArithmeticException("addMod unsigned with negative modulus");
        }
        return UInt256.valueOf(this.toUnsignedBigInteger().add(BigInteger.valueOf(value)).mod(BigInteger.valueOf(modulus)));
    }

    @Override
    public UInt256 subtract(UInt256 value) {
        if (value.isZero()) {
            return this;
        }
        int[] result = new int[8];
        boolean constant = true;
        long sum = ((long)this.ints[7] & 0xFFFFFFFFL) + ((long)(~value.ints[7]) & 0xFFFFFFFFL) + 1L;
        result[7] = (int)(sum & 0xFFFFFFFFL);
        if (result[7] < 0 || result[7] > 64) {
            constant = false;
        }
        for (int i = 6; i >= 0; --i) {
            sum = ((long)this.ints[i] & 0xFFFFFFFFL) + ((long)(~value.ints[i]) & 0xFFFFFFFFL) + (sum >>> 32);
            result[i] = (int)(sum & 0xFFFFFFFFL);
            constant &= result[i] == 0;
        }
        if (constant) {
            return CONSTANTS[result[7]];
        }
        return new UInt256(result);
    }

    @Override
    public UInt256 subtract(long value) {
        return this.add(-value);
    }

    @Override
    public UInt256 multiply(UInt256 value) {
        if (this.isZero() || value.isZero()) {
            return ZERO;
        }
        if (value.equals(ONE)) {
            return this;
        }
        if (this.equals(ONE)) {
            return value;
        }
        return UInt256.multiply(this.ints, value.ints);
    }

    private static UInt256 multiply(int[] x, int[] y) {
        int[] result = new int[16];
        long carry = 0L;
        int j = 7;
        int k = 15;
        while (j >= 0) {
            long product = ((long)y[j] & 0xFFFFFFFFL) * ((long)x[7] & 0xFFFFFFFFL) + carry;
            result[k] = (int)product;
            carry = product >>> 32;
            --j;
            --k;
        }
        result[7] = (int)carry;
        for (int i = 6; i >= 0; --i) {
            carry = 0L;
            int j2 = 7;
            int k2 = 8 + i;
            while (j2 >= 0) {
                long product = ((long)y[j2] & 0xFFFFFFFFL) * ((long)x[i] & 0xFFFFFFFFL) + ((long)result[k2] & 0xFFFFFFFFL) + carry;
                result[k2] = (int)product;
                carry = product >>> 32;
                --j2;
                --k2;
            }
            result[i] = (int)carry;
        }
        boolean constant = true;
        for (int i = 8; i < 15; ++i) {
            constant &= result[i] == 0;
        }
        if (constant && result[15] >= 0 && result[15] <= 64) {
            return CONSTANTS[result[15]];
        }
        return new UInt256(Arrays.copyOfRange(result, 8, 16));
    }

    @Override
    public UInt256 multiply(long value) {
        if (value == 0L || this.isZero()) {
            return ZERO;
        }
        if (value == 1L) {
            return this;
        }
        if (value < 0L) {
            throw new ArithmeticException("multiply unsigned by negative");
        }
        UInt256 other = new UInt256(value);
        if (this.equals(ONE)) {
            return other;
        }
        return UInt256.multiply(this.ints, other.ints);
    }

    @Override
    public UInt256 multiplyMod(UInt256 value, UInt256 modulus) {
        if (modulus.isZero()) {
            throw new ArithmeticException("multiplyMod with zero modulus");
        }
        if (this.isZero() || value.isZero()) {
            return ZERO;
        }
        if (value.equals(ONE)) {
            return this.mod(modulus);
        }
        return UInt256.valueOf(this.toUnsignedBigInteger().multiply(value.toUnsignedBigInteger()).mod(modulus.toUnsignedBigInteger()));
    }

    @Override
    public UInt256 multiplyMod(long value, UInt256 modulus) {
        if (modulus.isZero()) {
            throw new ArithmeticException("multiplyMod with zero modulus");
        }
        if (value == 0L || this.isZero()) {
            return ZERO;
        }
        if (value == 1L) {
            return this.mod(modulus);
        }
        if (value < 0L) {
            throw new ArithmeticException("multiplyMod unsigned by negative");
        }
        return UInt256.valueOf(this.toUnsignedBigInteger().multiply(BigInteger.valueOf(value)).mod(modulus.toUnsignedBigInteger()));
    }

    @Override
    public UInt256 multiplyMod(long value, long modulus) {
        if (modulus == 0L) {
            throw new ArithmeticException("multiplyMod with zero modulus");
        }
        if (modulus < 0L) {
            throw new ArithmeticException("multiplyMod unsigned with negative modulus");
        }
        if (value == 0L || this.isZero()) {
            return ZERO;
        }
        if (value == 1L) {
            return this.mod(modulus);
        }
        if (value < 0L) {
            throw new ArithmeticException("multiplyMod unsigned by negative");
        }
        return UInt256.valueOf(this.toUnsignedBigInteger().multiply(BigInteger.valueOf(value)).mod(BigInteger.valueOf(modulus)));
    }

    @Override
    public UInt256 divide(UInt256 value) {
        if (value.isZero()) {
            throw new ArithmeticException("divide by zero");
        }
        if (value.equals(ONE)) {
            return this;
        }
        return UInt256.valueOf(this.toUnsignedBigInteger().divide(value.toUnsignedBigInteger()));
    }

    @Override
    public UInt256 divide(long value) {
        if (value == 0L) {
            throw new ArithmeticException("divide by zero");
        }
        if (value < 0L) {
            throw new ArithmeticException("divide unsigned by negative");
        }
        if (value == 1L) {
            return this;
        }
        if (UInt256.isPowerOf2(value)) {
            return this.shiftRight(UInt256.log2(value));
        }
        return UInt256.valueOf(this.toUnsignedBigInteger().divide(BigInteger.valueOf(value)));
    }

    public UInt256 sdiv0(UInt256 divisor) {
        if (divisor.isZero()) {
            return ZERO;
        }
        BigInteger result = this.toSignedBigInteger().divide(divisor.toSignedBigInteger());
        Bytes resultBytes = Bytes.wrap((byte[])result.toByteArray());
        if (resultBytes.size() > 32) {
            resultBytes = resultBytes.slice(resultBytes.size() - 32, 32);
        }
        return UInt256.fromBytes((Bytes)Bytes32.leftPad((Bytes)resultBytes, (byte)(result.signum() < 0 ? (byte)-1 : 0)));
    }

    @Override
    public UInt256 divideCeil(UInt256 value) {
        return this.divide(value).add(this.mod(value).isZero() ? 0L : 1L);
    }

    @Override
    public UInt256 divideCeil(long value) {
        return this.divide(value).add(this.mod(value).isZero() ? 0L : 1L);
    }

    @Override
    public UInt256 pow(UInt256 exponent) {
        return UInt256.valueOf(this.toUnsignedBigInteger().modPow(exponent.toUnsignedBigInteger(), P_2_256));
    }

    @Override
    public UInt256 pow(long exponent) {
        return UInt256.valueOf(this.toUnsignedBigInteger().modPow(BigInteger.valueOf(exponent), P_2_256));
    }

    @Override
    public UInt256 mod(UInt256 modulus) {
        if (modulus.isZero()) {
            throw new ArithmeticException("mod by zero");
        }
        return UInt256.valueOf(this.toUnsignedBigInteger().mod(modulus.toUnsignedBigInteger()));
    }

    @Override
    public UInt256 mod(long modulus) {
        if (modulus == 0L) {
            throw new ArithmeticException("mod by zero");
        }
        if (modulus < 0L) {
            throw new ArithmeticException("mod by negative");
        }
        if (UInt256.isPowerOf2(modulus)) {
            int log2 = UInt256.log2(modulus);
            int d = log2 / 32;
            int s = log2 % 32;
            assert (d == 0 || d == 1);
            int[] result = new int[8];
            result[7 - d] = this.ints[7 - d] & ~(-1 << s);
            if (d != 0) {
                result[7] = this.ints[7];
            }
            return new UInt256(result);
        }
        return UInt256.valueOf(this.toUnsignedBigInteger().mod(BigInteger.valueOf(modulus)));
    }

    @Override
    public UInt256 mod0(UInt256 modulus) {
        if (modulus.equals(ZERO)) {
            return ZERO;
        }
        return this.mod(modulus);
    }

    public UInt256 smod0(UInt256 modulus) {
        Bytes resultBytes;
        if (modulus.equals(ZERO)) {
            return ZERO;
        }
        BigInteger bi = this.toSignedBigInteger();
        BigInteger result = bi.abs().mod(modulus.toSignedBigInteger().abs());
        if (bi.signum() < 0) {
            result = result.negate();
        }
        if ((resultBytes = Bytes.wrap((byte[])result.toByteArray())).size() > 32) {
            resultBytes = resultBytes.slice(resultBytes.size() - 32, 32);
        }
        return UInt256.fromBytes((Bytes)Bytes32.leftPad((Bytes)resultBytes, (byte)(result.signum() < 0 ? (byte)-1 : 0)));
    }

    @Override
    public UInt256 mod0(long modulus) {
        if (modulus == 0L) {
            return ZERO;
        }
        if (modulus < 0L) {
            throw new ArithmeticException("mod by negative");
        }
        return this.mod(modulus);
    }

    public UInt256 and(UInt256 value) {
        int[] result = new int[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = this.ints[i] & value.ints[i];
        }
        return new UInt256(result);
    }

    public UInt256 and(Bytes32 bytes) {
        int[] result = new int[8];
        int i = 7;
        int j = 28;
        while (i >= 0) {
            int other = (bytes.get(j) & 0xFF) << 24;
            other |= (bytes.get(j + 1) & 0xFF) << 16;
            other |= (bytes.get(i + 2) & 0xFF) << 8;
            result[i] = this.ints[i] & (other |= bytes.get(i + 3) & 0xFF);
            --i;
            j -= 4;
        }
        return new UInt256(result);
    }

    public UInt256 or(UInt256 value) {
        int[] result = new int[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = this.ints[i] | value.ints[i];
        }
        return new UInt256(result);
    }

    public UInt256 or(Bytes32 bytes) {
        int[] result = new int[8];
        int i = 7;
        int j = 28;
        while (i >= 0) {
            result[i] = this.ints[i] | (bytes.get(j) & 0xFF) << 24;
            int n = i;
            result[n] = result[n] | (bytes.get(j + 1) & 0xFF) << 16;
            int n2 = i;
            result[n2] = result[n2] | (bytes.get(j + 2) & 0xFF) << 8;
            int n3 = i--;
            result[n3] = result[n3] | bytes.get(j + 3) & 0xFF;
            j -= 4;
        }
        return new UInt256(result);
    }

    public UInt256 xor(UInt256 value) {
        int[] result = new int[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = this.ints[i] ^ value.ints[i];
        }
        return new UInt256(result);
    }

    public UInt256 xor(Bytes32 bytes) {
        int[] result = new int[8];
        int i = 7;
        int j = 28;
        while (i >= 0) {
            result[i] = this.ints[i] ^ (bytes.get(j) & 0xFF) << 24;
            int n = i;
            result[n] = result[n] ^ (bytes.get(j + 1) & 0xFF) << 16;
            int n2 = i;
            result[n2] = result[n2] ^ (bytes.get(j + 2) & 0xFF) << 8;
            int n3 = i--;
            result[n3] = result[n3] ^ bytes.get(j + 3) & 0xFF;
            j -= 4;
        }
        return new UInt256(result);
    }

    public UInt256 not() {
        int[] result = new int[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = ~this.ints[i];
        }
        return new UInt256(result);
    }

    public UInt256 shiftRight(int distance) {
        if (distance == 0) {
            return this;
        }
        if (distance >= 256) {
            return ZERO;
        }
        int[] result = new int[8];
        int d = distance / 32;
        int s = distance % 32;
        int resIdx = 8;
        if (s == 0) {
            int i = 8 - d;
            while (i > 0) {
                result[--resIdx] = this.ints[--i];
            }
        } else {
            for (int i = 7 - d; i >= 0; --i) {
                int leftSide = this.ints[i] >>> s;
                int rightSide = i == 0 ? 0 : this.ints[i - 1] << 32 - s;
                result[--resIdx] = leftSide | rightSide;
            }
        }
        return new UInt256(result);
    }

    public UInt256 shiftLeft(int distance) {
        if (distance == 0) {
            return this;
        }
        if (distance >= 256) {
            return ZERO;
        }
        int[] result = new int[8];
        int d = distance / 32;
        int s = distance % 32;
        int resIdx = 0;
        if (s == 0) {
            int i = d;
            while (i < 8) {
                result[resIdx++] = this.ints[i++];
            }
        } else {
            for (int i = d; i < 8; ++i) {
                int leftSide = this.ints[i] << s;
                int rightSide = i == 7 ? 0 : this.ints[i + 1] >>> 32 - s;
                result[resIdx++] = leftSide | rightSide;
            }
        }
        return new UInt256(result);
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof UInt256) {
            UInt256 other = (UInt256)object;
            for (int i = 0; i < 8; ++i) {
                if (this.ints[i] == other.ints[i]) continue;
                return false;
            }
            return true;
        }
        if (object instanceof Bytes) {
            Bytes other = (Bytes)object;
            if (this.size() != other.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == other.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    int computeHashcode() {
        int result = 1;
        for (int i = 0; i < this.size(); ++i) {
            result = 31 * result + this.get(i);
        }
        return result;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.computeHashcode();
        }
        return this.hashCode;
    }

    @Override
    public boolean fitsInt() {
        for (int i = 0; i < 7; ++i) {
            if (this.ints[i] == 0) continue;
            return false;
        }
        return this.ints[7] >= 0;
    }

    @Override
    public int intValue() {
        if (!this.fitsInt()) {
            throw new ArithmeticException("Value does not fit a 4 byte int");
        }
        return this.ints[7];
    }

    @Override
    public boolean fitsLong() {
        for (int i = 0; i < 6; ++i) {
            if (this.ints[i] == 0) continue;
            return false;
        }
        return this.ints[6] >= 0;
    }

    public byte get(int i) {
        int whichInt = i / 4;
        int whichIndex = 3 - i % 4;
        return (byte)(this.ints[whichInt] >> 8 * whichIndex & 0xFF);
    }

    public Bytes32 copy() {
        return this.toBytes();
    }

    public long toLong() {
        if (!this.fitsLong()) {
            throw new ArithmeticException("Value does not fit a 8 byte long");
        }
        return (long)this.ints[6] << 32 | (long)this.ints[7] & 0xFFFFFFFFL;
    }

    public String toString() {
        return this.toHexString();
    }

    @Override
    public UInt256 toUInt256() {
        return this;
    }

    private byte[] toByteArray() {
        return new byte[]{(byte)(this.ints[0] >> 24), (byte)(this.ints[0] >> 16), (byte)(this.ints[0] >> 8), (byte)this.ints[0], (byte)(this.ints[1] >> 24), (byte)(this.ints[1] >> 16), (byte)(this.ints[1] >> 8), (byte)this.ints[1], (byte)(this.ints[2] >> 24), (byte)(this.ints[2] >> 16), (byte)(this.ints[2] >> 8), (byte)this.ints[2], (byte)(this.ints[3] >> 24), (byte)(this.ints[3] >> 16), (byte)(this.ints[3] >> 8), (byte)this.ints[3], (byte)(this.ints[4] >> 24), (byte)(this.ints[4] >> 16), (byte)(this.ints[4] >> 8), (byte)this.ints[4], (byte)(this.ints[5] >> 24), (byte)(this.ints[5] >> 16), (byte)(this.ints[5] >> 8), (byte)this.ints[5], (byte)(this.ints[6] >> 24), (byte)(this.ints[6] >> 16), (byte)(this.ints[6] >> 8), (byte)this.ints[6], (byte)(this.ints[7] >> 24), (byte)(this.ints[7] >> 16), (byte)(this.ints[7] >> 8), (byte)this.ints[7]};
    }

    public Bytes slice(int i, int length) {
        return this.toBytes().slice(i, length);
    }

    public MutableBytes32 mutableCopy() {
        return MutableBytes32.wrap((byte[])this.toByteArray());
    }

    @Override
    public Bytes32 toBytes() {
        return Bytes32.wrap((byte[])this.toByteArray());
    }

    @Override
    public Bytes toMinimalBytes() {
        int i;
        for (i = 0; i < 8 && this.ints[i] == 0; ++i) {
        }
        if (i == 8) {
            return Bytes.EMPTY;
        }
        int firstIntBytes = 4 - Integer.numberOfLeadingZeros(this.ints[i]) / 8;
        int totalBytes = firstIntBytes + (8 - (i + 1)) * 4;
        MutableBytes bytes = MutableBytes.create((int)totalBytes);
        int j = 0;
        switch (firstIntBytes) {
            case 4: {
                bytes.set(j++, (byte)(this.ints[i] >>> 24));
            }
            case 3: {
                bytes.set(j++, (byte)(this.ints[i] >>> 16 & 0xFF));
            }
            case 2: {
                bytes.set(j++, (byte)(this.ints[i] >>> 8 & 0xFF));
            }
            case 1: {
                bytes.set(j++, (byte)(this.ints[i] & 0xFF));
            }
        }
        ++i;
        while (i < 8) {
            bytes.setInt(j, this.ints[i]);
            ++i;
            j += 4;
        }
        return bytes;
    }

    public int numberOfLeadingZeros() {
        for (int i = 0; i < 8; ++i) {
            if (this.ints[i] == 0) continue;
            return i * 32 + Integer.numberOfLeadingZeros(this.ints[i]);
        }
        return 256;
    }

    public int bitLength() {
        for (int i = 0; i < 8; ++i) {
            if (this.ints[i] == 0) continue;
            return 256 - i * 32 - Integer.numberOfLeadingZeros(this.ints[i]);
        }
        return 0;
    }

    @Override
    public UInt256 max() {
        return MAX_VALUE;
    }

    private static boolean isPowerOf2(long n) {
        assert (n > 0L);
        return (n & n - 1L) == 0L;
    }

    private static int log2(long v) {
        assert (v > 0L);
        return 63 - Long.numberOfLeadingZeros(v);
    }

    static {
        UInt256.CONSTANTS[0] = new UInt256(Bytes32.ZERO);
        for (int i = 1; i <= 64; ++i) {
            UInt256.CONSTANTS[i] = new UInt256(i);
        }
        MIN_VALUE = UInt256.valueOf(0L);
        MAX_VALUE = new UInt256(Bytes32.ZERO.not());
        ZERO = UInt256.valueOf(0L);
        ONE = UInt256.valueOf(1L);
        P_2_256 = BigInteger.valueOf(2L).pow(256);
    }
}

