package io.toolforge.spi.service;

import io.toolforge.spi.model.Account;
import io.toolforge.spi.model.AccountCursor;
import io.toolforge.spi.model.AccountId;
import io.toolforge.spi.model.AccountListOrdering;
import io.toolforge.spi.model.AccountPage;
import io.toolforge.spi.model.AccountReference;
import io.toolforge.spi.model.ApiKey;
import io.toolforge.spi.model.ApiKeyCursor;
import io.toolforge.spi.model.ApiKeyDefinition;
import io.toolforge.spi.model.ApiKeyId;
import io.toolforge.spi.model.ApiKeyPage;
import io.toolforge.spi.model.ErrorMessage;
import java.io.InputStream;
import io.toolforge.spi.model.NewApiKey;
import io.toolforge.spi.model.PrefixQuery;
import io.toolforge.spi.model.Username;

import javax.ws.rs.*;
import javax.ws.rs.core.Response;


import java.io.InputStream;
import java.util.Map;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/accounts")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-03-23T19:13:01.140351-05:00[America/Chicago]")
public interface AccountsApi {

    @POST
    @Path("/{accountReference}/apiKeys")
    @Consumes({ "application/json" })
    @Produces({ "application/json", "application/problem+json" })
    NewApiKey createAccountApiKey(@PathParam("accountReference") AccountReference accountReference,@Valid ApiKeyDefinition apiKeyDefinition);

    @DELETE
    @Path("/{accountReference}/apiKeys/{apiKeyId}")
    @Produces({ "application/problem+json" })
    void deleteAccountApiKey(@PathParam("accountReference") AccountReference accountReference,@PathParam("apiKeyId") ApiKeyId apiKeyId);

    @GET
    @Path("/{accountReference}")
    @Produces({ "application/json", "application/problem+json" })
    Account getAccount(@PathParam("accountReference") AccountReference accountReference);

    @GET
    @Path("/{accountReference}/apiKeys/{apiKeyId}")
    @Produces({ "application/json", "application/problem+json" })
    ApiKey getAccountApiKey(@PathParam("accountReference") AccountReference accountReference,@PathParam("apiKeyId") ApiKeyId apiKeyId);

    @GET
    @Path("/by/id/{accountId}")
    @Produces({ "application/json", "application/problem+json" })
    Account getAccountById(@PathParam("accountId") AccountId accountId);

    @GET
    @Path("/by/username/{username}")
    @Produces({ "application/json", "application/problem+json" })
    Account getAccountByUsername(@PathParam("username") Username username);

    @GET
    @Path("/{accountReference}/picture")
    @Produces({ "image/jpeg", "application/problem+json" })
    InputStream getAccountPicture(@PathParam("accountReference") AccountReference accountReference);

    @GET
    @Path("/{accountReference}/apiKeys")
    @Produces({ "application/json", "application/problem+json" })
    ApiKeyPage listAccountApiKeys(@PathParam("accountReference") AccountReference accountReference,@QueryParam("limit") @Min(0) @Max(10) @DefaultValue("10")   Integer limit,@QueryParam("cursor")   ApiKeyCursor cursor);

    @GET
    @Produces({ "application/json" })
    AccountPage listAccounts(@QueryParam("q")   PrefixQuery q,@QueryParam("limit") @Min(0) @Max(100) @DefaultValue("10")   Integer limit,@QueryParam("cursor")   AccountCursor cursor,@QueryParam("order")   AccountListOrdering order);
}
