package io.toolforge.spi.service;

import io.toolforge.spi.model.AccountReference;
import io.toolforge.spi.model.Container;
import io.toolforge.spi.model.ContainerCursor;
import io.toolforge.spi.model.ContainerDefinition;
import io.toolforge.spi.model.ContainerId;
import io.toolforge.spi.model.ContainerInstallation;
import io.toolforge.spi.model.ContainerPage;
import io.toolforge.spi.model.ContainerTransfer;
import io.toolforge.spi.model.ContainerUpdate;
import io.toolforge.spi.model.ContainerVersion;
import io.toolforge.spi.model.ContainerVersionCursor;
import io.toolforge.spi.model.ContainerVersionId;
import io.toolforge.spi.model.ContainerVersionPage;
import io.toolforge.spi.model.ContainerVersionPushLogEntries;
import io.toolforge.spi.model.ErrorMessage;
import io.toolforge.spi.model.InstalledContainer;
import io.toolforge.spi.model.KeywordQuery;
import io.toolforge.spi.model.Manifest;

import javax.ws.rs.*;
import javax.ws.rs.core.Response;


import java.io.InputStream;
import java.util.Map;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/containers")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-03-23T19:13:01.140351-05:00[America/Chicago]")
public interface ContainersApi {

    @POST
    @Consumes({ "application/json" })
    @Produces({ "application/json", "application/problem+json" })
    Container createContainer(@Valid ContainerDefinition containerDefinition);

    @POST
    @Path("/{containerId}/versions/{containerVersion}/deprecate")
    @Produces({ "application/json", "application/problem+json" })
    ContainerVersion deprecateContainerVersion(@PathParam("containerId") ContainerId containerId,@PathParam("containerVersion") ContainerVersionId containerVersion);

    @GET
    @Path("/by/owner/{owner}/slug/{slug}")
    @Produces({ "application/json", "application/problem+json" })
    Container findContainerByOwnerSlug(@PathParam("owner") AccountReference owner,@PathParam("slug") String slug);

    @GET
    @Path("/{containerId}")
    @Produces({ "application/json", "application/problem+json" })
    Container getContainer(@PathParam("containerId") ContainerId containerId);

    @GET
    @Path("/{containerId}/logs/push")
    @Produces({ "application/json", "application/problem+json" })
    ContainerVersionPushLogEntries getContainerPushLogs(@PathParam("containerId") ContainerId containerId);

    @GET
    @Path("/{containerId}/versions/{containerVersion}")
    @Produces({ "application/json", "application/problem+json" })
    ContainerVersion getContainerVersion(@PathParam("containerId") ContainerId containerId,@PathParam("containerVersion") ContainerVersionId containerVersion);

    @POST
    @Path("/{containerId}/install")
    @Consumes({ "application/json" })
    @Produces({ "application/json", "application/problem+json" })
    InstalledContainer installContainer(@PathParam("containerId") ContainerId containerId,@Valid ContainerInstallation containerInstallation);

    @GET
    @Path("/{containerId}/versions")
    @Produces({ "application/json", "application/problem+json" })
    ContainerVersionPage listContainerVersions(@PathParam("containerId") ContainerId containerId,@QueryParam("limit") @DefaultValue("10")   Integer limit,@QueryParam("cursor")   ContainerVersionCursor cursor);

    @GET
    @Produces({ "application/json" })
    ContainerPage listContainers(@QueryParam("q")   KeywordQuery q,@QueryParam("owner")   AccountReference owner,@QueryParam("limit") @Min(0) @Max(100) @DefaultValue("10")   Integer limit,@QueryParam("cursor")   ContainerCursor cursor);

    @POST
    @Path("/{containerId}/versions/{containerVersion}/release")
    @Produces({ "application/json", "application/problem+json" })
    ContainerVersion releaseContainerVersion(@PathParam("containerId") ContainerId containerId,@PathParam("containerVersion") ContainerVersionId containerVersion);

    @POST
    @Path("/{containerId}/transfer")
    @Consumes({ "application/json" })
    @Produces({ "application/json", "application/problem+json" })
    Container transferContainer(@PathParam("containerId") ContainerId containerId,@Valid ContainerTransfer containerTransfer);

    @PATCH
    @Path("/{containerId}")
    @Consumes({ "application/json" })
    @Produces({ "application/json", "application/problem+json" })
    Container updateContainer(@PathParam("containerId") ContainerId containerId,@Valid ContainerUpdate containerUpdate);

    @POST
    @Path("/{containerId}/validate/manifest")
    @Consumes({ "application/yaml" })
    @Produces({ "application/problem+json" })
    void validateContainerManifest(@PathParam("containerId") ContainerId containerId,@Valid Manifest manifest);
}
