package io.toolforge.spi.service;

import io.toolforge.spi.model.AccountReference;
import io.toolforge.spi.model.Blob;
import io.toolforge.spi.model.BlobId;
import io.toolforge.spi.model.ErrorMessage;
import io.toolforge.spi.model.Execution;
import io.toolforge.spi.model.ExecutionCursor;
import io.toolforge.spi.model.ExecutionId;
import io.toolforge.spi.model.ExecutionPage;
import io.toolforge.spi.model.ExecutionState;
import io.toolforge.spi.model.ExecutionTransfer;
import io.toolforge.spi.model.ExecutionUpdate;
import java.io.InputStream;
import io.toolforge.spi.model.KeywordQuery;
import io.toolforge.spi.model.LogCursor;
import io.toolforge.spi.model.LogPage;
import io.toolforge.spi.model.Secret;
import io.toolforge.spi.model.SecretCursor;
import io.toolforge.spi.model.SecretDefinition;
import io.toolforge.spi.model.SecretId;
import io.toolforge.spi.model.SecretPage;
import io.toolforge.spi.model.SecretTransfer;
import io.toolforge.spi.model.SecretUpdate;
import io.toolforge.spi.model.Tool;
import io.toolforge.spi.model.ToolCursor;
import io.toolforge.spi.model.ToolId;
import io.toolforge.spi.model.ToolInvocation;
import io.toolforge.spi.model.ToolListOrdering;
import io.toolforge.spi.model.ToolPage;
import io.toolforge.spi.model.ToolTransfer;
import io.toolforge.spi.model.ToolUpdate;
import io.toolforge.spi.model.Workspace;
import io.toolforge.spi.model.WorkspaceCursor;
import io.toolforge.spi.model.WorkspaceId;
import io.toolforge.spi.model.WorkspacePage;

import javax.ws.rs.*;
import javax.ws.rs.core.Response;


import java.io.InputStream;
import java.util.Map;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/workspaces")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-03-23T19:13:01.140351-05:00[America/Chicago]")
public interface WorkspacesApi {

    @POST
    @Path("/{workspaceId}/executions/{executionId}/cancel")
    @Produces({ "application/json", "application/problem+json" })
    Execution cancelExecution(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("executionId") ExecutionId executionId);

    @POST
    @Path("/{workspaceId}/blobs")
    @Produces({ "application/json" })
    Blob createBlob(@PathParam("workspaceId") WorkspaceId workspaceId,@Valid InputStream body);

    @POST
    @Path("/{workspaceId}/secrets")
    @Consumes({ "application/json" })
    @Produces({ "application/json", "application/problem+json" })
    Secret createWorkspaceSecret(@PathParam("workspaceId") WorkspaceId workspaceId,@Valid SecretDefinition secretDefinition);

    @DELETE
    @Path("/{workspaceId}/executions/{executionId}")
    @Produces({ "application/problem+json" })
    void deleteExecution(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("executionId") ExecutionId executionId);

    @DELETE
    @Path("/{workspaceId}/secrets/{secretId}")
    @Produces({ "application/problem+json" })
    void deleteWorkspaceSecret(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("secretId") SecretId secretId);

    @POST
    @Path("/{workspaceId}/tools/{toolId}/execute")
    @Consumes({ "application/json" })
    @Produces({ "application/json", "application/problem+json" })
    Execution executeWorkspaceTool(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("toolId") ToolId toolId,@Valid ToolInvocation toolInvocation);

    @GET
    @Path("/{workspaceId}/secrets/by/name/{name}")
    @Produces({ "application/json", "application/problem+json" })
    Secret findWorkspaceSecretByName(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("name") String name);

    @GET
    @Path("/{workspaceId}/blobs/{blobId}")
    @Produces({ "application/json", "application/problem+json" })
    Blob getBlob(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("blobId") BlobId blobId);

    @GET
    @Path("/{workspaceId}/executions/{executionId}")
    @Produces({ "application/json", "application/problem+json" })
    Execution getExecution(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("executionId") ExecutionId executionId);

    @GET
    @Path("/{workspaceId}/executions/{executionId}/inputs/{name}")
    @Produces({ "*/*", "application/problem+json" })
    InputStream getExecutionInputData(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("executionId") ExecutionId executionId,@PathParam("name") String name);

    @GET
    @Path("/{workspaceId}/executions/{executionId}/outputs/{name}")
    @Produces({ "*/*", "application/json", "application/problem+json" })
    InputStream getExecutionOutputData(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("executionId") ExecutionId executionId,@PathParam("name") String name);

    @GET
    @Path("/{workspaceId}/executions/{executionId}/outputs/{name}.{extension}")
    @Produces({ "*/*", "application/json", "application/problem+json" })
    InputStream getExecutionOutputExtensionData(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("executionId") ExecutionId executionId,@PathParam("name") String name,@PathParam("extension") String extension);

    @GET
    @Path("/{workspaceId}")
    @Produces({ "application/json", "application/problem+json" })
    Workspace getWorkspace(@PathParam("workspaceId") WorkspaceId workspaceId);

    @GET
    @Path("/{workspaceId}/secrets/{secretId}")
    @Produces({ "application/json", "application/problem+json" })
    Secret getWorkspaceSecret(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("secretId") SecretId secretId);

    @GET
    @Path("/{workspaceId}/tools/{toolId}")
    @Produces({ "application/json", "application/problem+json" })
    Tool getWorkspaceTool(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("toolId") ToolId toolId);

    @GET
    @Path("/{workspaceId}/executions/{executionId}/logs")
    @Produces({ "application/json", "application/problem+json" })
    LogPage listExecutionLogs(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("executionId") ExecutionId executionId,@QueryParam("limit") @DefaultValue("10")   Integer limit,@QueryParam("cursor")   LogCursor cursor);

    @GET
    @Path("/{workspaceId}/executions")
    @Produces({ "application/json" })
    ExecutionPage listExecutions(@PathParam("workspaceId") WorkspaceId workspaceId,@QueryParam("q")   KeywordQuery q,@QueryParam("owner")   AccountReference owner,@QueryParam("state")   ExecutionState state,@QueryParam("limit") @Min(0) @Max(100) @DefaultValue("10")   Integer limit,@QueryParam("cursor")   ExecutionCursor cursor);

    @GET
    @Path("/{workspaceId}/secrets")
    @Produces({ "application/json" })
    SecretPage listWorkspaceSecrets(@PathParam("workspaceId") WorkspaceId workspaceId,@QueryParam("q")   KeywordQuery q,@QueryParam("owner")   AccountReference owner,@QueryParam("limit") @Min(0) @Max(100) @DefaultValue("10")   Integer limit,@QueryParam("cursor")   SecretCursor cursor);

    @GET
    @Path("/{workspaceId}/tools")
    @Produces({ "application/json", "application/problem+json" })
    ToolPage listWorkspaceTools(@PathParam("workspaceId") WorkspaceId workspaceId,@QueryParam("q")   KeywordQuery q,@QueryParam("owner")   AccountReference owner,@QueryParam("order")   ToolListOrdering order,@QueryParam("limit") @Min(0) @Max(100) @DefaultValue("10")   Integer limit,@QueryParam("cursor")   ToolCursor cursor);

    @GET
    @Produces({ "application/json" })
    WorkspacePage listWorkspaces(@QueryParam("q")   KeywordQuery q,@QueryParam("owner")   AccountReference owner,@QueryParam("limit") @Min(0) @Max(100) @DefaultValue("10")   Integer limit,@QueryParam("cursor")   WorkspaceCursor cursor);

    @POST
    @Path("/{workspaceId}/executions/{executionId}/transfer")
    @Consumes({ "application/json" })
    @Produces({ "application/json", "application/problem+json" })
    Execution transferExecution(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("executionId") ExecutionId executionId,@Valid ExecutionTransfer executionTransfer);

    @POST
    @Path("/{workspaceId}/secrets/{secretId}/transfer")
    @Consumes({ "application/json" })
    @Produces({ "application/json", "application/problem+json" })
    Secret transferWorkspaceSecret(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("secretId") SecretId secretId,@Valid SecretTransfer secretTransfer);

    @POST
    @Path("/{workspaceId}/tools/{toolId}/transfer")
    @Consumes({ "application/json" })
    @Produces({ "application/json", "application/problem+json" })
    Tool transferWorkspaceTool(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("toolId") ToolId toolId,@Valid ToolTransfer toolTransfer);

    @PATCH
    @Path("/{workspaceId}/executions/{executionId}")
    @Consumes({ "application/json" })
    @Produces({ "application/json", "application/problem+json" })
    Execution updateExecution(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("executionId") ExecutionId executionId,@Valid ExecutionUpdate executionUpdate);

    @PATCH
    @Path("/{workspaceId}/secrets/{secretId}")
    @Consumes({ "application/json" })
    @Produces({ "application/json", "application/problem+json" })
    Secret updateWorkspaceSecret(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("secretId") SecretId secretId,@Valid SecretUpdate secretUpdate);

    @PATCH
    @Path("/{workspaceId}/tools/{toolId}")
    @Consumes({ "application/json" })
    @Produces({ "application/json", "application/problem+json" })
    Tool updateWorkspaceTool(@PathParam("workspaceId") WorkspaceId workspaceId,@PathParam("toolId") ToolId toolId,@Valid ToolUpdate toolUpdate);
}
